#   include	"config.h"

#   include	"bmintern.h"
#   include	<string.h>
#   include	<tiffio.h>
#   include	<appDebugon.h>

BitmapFileType	bmTiffFile=
    {
    bmWriteTiffFile,
    bmCanWriteTiffFile,
    bmReadTiffFile,
    "tiff",
    "*.tiff",
    "tiffFile",
    "Tagged Image Format ( *.tiff )",
    };

BitmapFileType	bmTifFile=
    {
    bmWriteTiffFile,
    bmCanWriteTiffFile,
    bmReadTiffFile,
    "tif",
    "*.tif",
    "tifFile",
    "Tagged Image Format ( *.tif )",
    };

BitmapFileType	bmBmpFile=
    {
    bmWriteBmpFile,
    bmCanWriteBmpFile,
    bmReadBmpFile,
    "bmp",
    "*.bmp",
    "bmpFile",
    "Microsoft Bitmap ( *.bmp )",
    };

BitmapFileType	bmIcoFile=
    {
    bmWriteIcoFile,
    bmCanWriteIcoFile,
    bmReadIcoFile,
    "ico",
    "*.ico",
    "icoFile",
    "Microsoft Icon ( *.ico )",
    };

BitmapFileType	bmXwdFile=
    {
    NULL, /* bmWriteXwdFile, */
    NULL, /* bmCanWriteXwdFile, */
    bmReadXwdFile,
    "xwd",
    "*.xwd",
    "xwdFile",
    "X-Window Dump ( *.xwd )",
    };

BitmapFileType	bmJpgFile=
    {
    bmWriteJpegFile,
    bmCanWriteJpegFile,
    bmReadJpegFile,
    "jpg",
    "*.jpg",
    "jpgFile",
    "JPEG ( *.jpg )",
    };

BitmapFileType	bmJpegFile=
    {
    bmWriteJpegFile,
    bmCanWriteJpegFile,
    bmReadJpegFile,
    "jpeg",
    "*.jpeg",
    "jpegFile",
    "JPEG ( *.jpeg )",
    };

BitmapFileType	bmGifFile=
    {
    bmWriteGifFile,
    bmCanWriteGifFile,
    bmReadGifFile,
    "gif",
    "*.gif",
    "gifFile",
    "Compuserve GIF ( *.gif )",
    };

BitmapFileType	bmEpsFile=
    {
    bmWriteEpsFile,
    bmCanWriteEpsFile,
    NULL, /* bmReadEpsFile, */
    "eps",
    "*.eps",
    "epsFile",
    "Encapsulated Postscript ( *.eps )",
    };

BitmapFileType	bmXbmFile=
    {
    bmWriteXbmFile,
    bmCanWriteXbmFile,
    bmReadXbmFile,
    "xbm",
    "*.xbm",
    "xbmFile",
    "X-Windows bitmap ( *.xbm )",
    };

BitmapFileType	bmPngFile=
    {
    bmWritePngFile,
    bmCanWritePngFile,
    bmReadPngFile,
    "png",
    "*.png",
    "pngFile",
    "Portable Network Graphics ( *.png )",
    };

BitmapFileType	bmPcxFile=
    {
    bmWritePcxFile,
    bmCanWritePcxFile,
    bmReadPcxFile,
    "pcx",
    "*.pcx",
    "pcxFile",
    "Zsoft PC Paintbrush ( *.pcx )",
    };

BitmapFileType	bmXpmFile=
    {
    bmWriteXpmFile,
    bmCanWriteXpmFile,
    bmReadXpmFile,
    "xpm",
    "*.xpm",
    "xpmFile",
    "X11 Pixmap ( *.xpm )",
    };

BitmapFileType	bmPgmFile=
    {
    bmWritePbmFile,
    bmCanWritePbmFile,
    bmReadPbmFile,
    "pgm",
    "*.pgm",
    "pgmFile",
    "Portable Gray Map ( *.pgm )",
    };

BitmapFileType	bmPbmFile=
    {
    bmWritePbmFile,
    bmCanWritePbmFile,
    bmReadPbmFile,
    "pbm",
    "*.pbm",
    "pbmFile",
    "Portable Bitmap ( *.pbm )",
    };

BitmapFileType	bmSgiFile=
    {
    bmWriteSgiFile,
    NULL,
    bmReadSgiFile,
    "sgi",
    "*.sgi",
    "sgiFile",
    "SGI Image File ( *.sgi )",
    };

BitmapFileType * bmFileTypes[]=
    {
    &bmTiffFile,
    &bmTifFile,
    &bmBmpFile,
    &bmIcoFile,
    &bmXwdFile,
    &bmGifFile,
    &bmEpsFile,
    &bmJpegFile,
    &bmJpgFile,
    &bmXbmFile,
    &bmPngFile,
    &bmPcxFile,
    &bmXpmFile,
    &bmPgmFile,
    &bmPbmFile,
    };

BitmapFileFormat	bmFileFormats[]=
    {
	{ "TIFF  No compression", "tiffPlainFile",
			    COMPRESSION_NONE,		&bmTiffFile },
	{ "TIFF  CCITT run length", "tiffCcittRleFile",
			    COMPRESSION_CCITTRLE,	&bmTiffFile },
	{ "TIFF  Fax 3 format", "tiffFax3File",
			    COMPRESSION_CCITTFAX3,	&bmTiffFile },
	{ "TIFF  Fax 4 format", "tiffFax4File",
			    COMPRESSION_CCITTFAX4,	&bmTiffFile },
	{ "TIFF  Lempel-Ziv & Welch", "tiffLzwFile",
			    COMPRESSION_LZW,		&bmTiffFile },
	{ "TIFF  NeXT 2-bit RLE", "tiffNextFile",
			    COMPRESSION_NEXT,		&bmTiffFile },
	{ "TIFF  Run length, aligned", "tiffRleFile",
			    COMPRESSION_CCITTRLEW,	&bmTiffFile },
	{ "TIFF  Packbits", "tiffPackbitsFile",
			    COMPRESSION_PACKBITS,	&bmTiffFile },
	{ "TIFF  Thunderscan", "tiffThunderFile",
			    COMPRESSION_THUNDERSCAN,	&bmTiffFile },
	{ "TIFF  JPEG", "tiffJpegFile",
			    COMPRESSION_JPEG,		&bmTiffFile },
	{ "BMP  Microsoft Windows 3.x bitmap", "bmp3File",
			    40,				&bmBmpFile },
	{ "XWD  X/11 Window dump", "xwd11File",
			    11,				&bmXwdFile },
	{ "XWD  X/10 Window dump", "xwd10File",
			    10,				&bmXwdFile },
	{ "GIF  Compuserve GIF", "gif87File",
			    87,				&bmGifFile },
	{ "EPS  Encapsulated Postscript", "eps1File",
			    1,				&bmEpsFile },
	{ "JPG  Independent JPEG Group (.jpg)", "jpg1File",
			    1,				&bmJpgFile },
	{ "JPEG  Independent JPEG Group (.jpeg)", "jpeg1File",
			    1,				&bmJpegFile },
	{ "XBM  X/11 Bitmap File", "xbm11File",
			    11,				&bmXbmFile },
	{ "PNG  Portable Network Graphics", "png1File",
			    0,				&bmPngFile },
	{ "ICO  Microsoft 3.x Windows Icon", "ico3File",
			    40,				&bmIcoFile },
	{ "PCX  Zsoft PC Paintbrush file", "pcx1File",
			    0,				&bmPcxFile },
	{ "XPM  X11 Pixmap File", "xpm1File",
			    0,				&bmXpmFile },
	{ "PGM  Gray Map (Text)", "pgm2File",
			    2,				&bmPgmFile },
	{ "PGM  Gray Map (Raw)", "pgm5File",
			    5,				&bmPgmFile },
	{ "PBM  Bitmap (Text)", "pgm1File",
			    1,				&bmPbmFile },
	{ "PBM  Bitmap (Raw)", "pgm4File",
			    4,				&bmPbmFile },
	/*
	{ "SGI Image File", "sgiFile",
			    0,				&bmSgiFile },
	*/
    };

int	bmNumberOfFileFormats= sizeof(bmFileFormats)/sizeof(BitmapFileFormat);
int	bmNumberOfFileTypes= sizeof(bmFileTypes)/sizeof(BitmapFileType *);

