#   include	"config.h"

#   include	"bmintern.h"
#   include	<appDebugon.h>

/************************************************************************/
/*  Replace 'White' in a bitmap with 'Transparent'			*/
/************************************************************************/
static unsigned char	firstBytes[256];
static unsigned char	secondBytes[256];

int bmWhiteToTransparent(	BitmapDescription *		bdOut,
				const BitmapDescription *	bdIn,
				unsigned char **		pBufOut,
				const unsigned char *		bufIn,
				int				ignoredInt )
    {
    BitmapDescription		bd= *bdIn;
    unsigned char *		bufOut;
    int				row, col;
    const unsigned char *	from;
    unsigned char *		to;

    switch( bdIn->bdColorEncoding )
	{
	case BMcoBLACKWHITE:
	    if  ( bdIn->bdSamplesPerPixel != 1 )
		{ LDEB(bdIn->bdSamplesPerPixel); return -1;	}
	    bd.bdSamplesPerPixel= 2;
	    bd.bdHasAlpha= 1;

	    switch( bdIn->bdBitsPerSample )
		{
		case 1:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	(  row & 0x80 )     	|
						( ~row & 0x80 ) >> 1	|
						(  row & 0x40 ) >> 1	|
						( ~row & 0x40 ) >> 2	|
						(  row & 0x20 ) >> 2	|
						( ~row & 0x20 ) >> 3	|
						(  row & 0x10 ) >> 3	|
						( ~row & 0x10 ) >> 4	;

			secondBytes[row]=	(  row & 0x08 ) << 4	|
						( ~row & 0x08 ) << 3	|
						(  row & 0x04 ) << 3	|
						( ~row & 0x04 ) << 2	|
						(  row & 0x02 ) << 2	|
						( ~row & 0x02 ) << 1	|
						(  row & 0x01 ) << 1	|
						( ~row & 0x01 )     	;
			}
		    break;
		case 2:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	(  row & 0xc0 )     	|
						( ~row & 0xc0 ) >> 2	|
						(  row & 0x60 ) >> 2	|
						( ~row & 0x60 ) >> 4	;

			secondBytes[row]=	(  row & 0x0c ) << 4	|
						( ~row & 0x0c ) << 2	|
						(  row & 0x06 ) << 2	|
						( ~row & 0x06 )     	;
			}
		case 4:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	(  row & 0xf0 )     	|
						( ~row & 0xf0 ) >> 4	;

			secondBytes[row]=	(  row & 0x0f ) << 4	|
						( ~row & 0x0f )     	;
			}
		    break;
		case 8:
		    for ( row= 0; row < 256; row++ )
			{
			firstBytes[row]=	 row;
			secondBytes[row]=	~row;
			}
		    break;
		default:
		    LDEB(bdIn->bdBitsPerSample); return -1;
		    break;
		}
	    break;
	case BMcoWHITEBLACK:
	    if  ( bdIn->bdSamplesPerPixel != 1 )
		{ LDEB(bdIn->bdSamplesPerPixel); return -1;	}
	    bd.bdSamplesPerPixel= 2;
	    bd.bdHasAlpha= 1;
	    break;
	case BMcoRGB:
	    if  ( bdIn->bdSamplesPerPixel != 3 )
		{ LDEB(bdIn->bdSamplesPerPixel); return -1;	}
	    bd.bdSamplesPerPixel= 4;
	    bd.bdHasAlpha= 1;
	    break;
	default:
	    LDEB(bdIn->bdColorEncoding); return -1;
	}

    bd.bdBitsPerPixel= bd.bdSamplesPerPixel* bd.bdBitsPerSample;
    bd.bdBytesPerRow= ( bd.bdPixelsWide* bd.bdBitsPerPixel+ 7 )/8;
    bd.bdBufferLength= bd.bdBytesPerRow* bd.bdPixelsHigh;
    bufOut= malloc( bd.bdBufferLength );
    if  ( ! bufOut )
	{ LLDEB(bd.bdBufferLength,bufOut); return -1;	}

    switch( bdIn->bdColorEncoding )
	{
	case BMcoBLACKWHITE:
	    switch( bdIn->bdBitsPerSample )
		{
		case 1: case 2: case 4: case 8:
		    for ( row= 0; row < bdIn->bdPixelsHigh; row++ )
			{
			from= bufIn + row* bdIn->bdBytesPerRow;
			to  = bufOut+ row* bd.   bdBytesPerRow;

			for ( col= 0; col < bdIn->bdBytesPerRow; col++ )
			    {
			    *(to++)=	firstBytes[*from];
			    *(to++)=	secondBytes[*from];
			    from++;
			    }
			}
		    break;
		default:
		    LDEB(bdIn->bdBitsPerSample); return -1;
		}
	    break;
	case BMcoWHITEBLACK:
	    switch( bdIn->bdBitsPerSample )
		{
		case 1: case 2: case 4: case 8:
		    for ( row= 0; row < bdIn->bdPixelsHigh; row++ )
			{
			from= bufIn + row* bdIn->bdBytesPerRow;
			to  = bufOut+ row* bd.   bdBytesPerRow;

			for ( col= 0; col < bdIn->bdBytesPerRow; col++ )
			    {
			    *(to++)=	firstBytes[*from];
			    *(to++)=	secondBytes[*from];
			    from++;
			    }
			}
		    break;
		default:
		    LDEB(bdIn->bdBitsPerSample); return -1;
		}
	    break;
	case BMcoRGB:
	    LDEB(bdIn->bdColorEncoding); return -1;
	    break;
	default:
	    LDEB(bdIn->bdColorEncoding); return -1;
	}

    *bdOut= bd; *pBufOut= bufOut;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Make a completely transparent image					*/
/*									*/
/************************************************************************/

int bmTransparentImage(		BitmapDescription *		bdOut,
				unsigned char **		pBufOut,
				int				colorEncoding,
				int				wide,
				int				high )
    {
    BitmapDescription		bd;
    unsigned char *		buffer;

    switch( colorEncoding )
	{
	case BMcoRGB8PALETTE:
	    bd.bdPixelsWide= wide;
	    bd.bdPixelsHigh= high;
	    bd.bdHasAlpha= 1;
	    bd.bdUnit= BMunINCH;
	    bd.bdXResolution= 72;
	    bd.bdYResolution= 72;

	    bd.bdBitsPerSample= 8;
	    bd.bdSamplesPerPixel= 3;
	    bd.bdBitsPerPixel= 4;
	    bd.bdColorEncoding= BMcoRGB8PALETTE;
	    bd.bdColorCount= 3;
	    bd.bdRGB8Palette= (RGB8Color *)0;
	    bd.bdBytesPerRow= bd.bdPixelsWide;
	    bd.bdBufferLength= bd.bdPixelsHigh* bd.bdBytesPerRow;

	    if  ( bd.bdHasAlpha )
		{
		bd.bdSamplesPerPixel= 4;
		bd.bdBitsPerPixel *= 2;
		bd.bdBytesPerRow *= 2;
		bd.bdBufferLength *= 2;
		}

	    buffer= (unsigned char *)malloc( bd.bdBufferLength );
	    if  ( ! buffer )
		{ LXDEB(bd.bdBufferLength,buffer); return -1; }

	    bd.bdRGB8Palette= (RGB8Color *)
				    malloc( 256* sizeof( RGB8Color ) );
	    if  ( ! bd.bdRGB8Palette )
		{
		LLDEB(256,bd.bdRGB8Palette);
		free( buffer ); return -1;
		}

	    /*  transparent */
	    bd.bdRGB8Palette[0].rgb8Red= 255;
	    bd.bdRGB8Palette[0].rgb8Green= 255;
	    bd.bdRGB8Palette[0].rgb8Blue= 255;
	    bd.bdRGB8Palette[0].rgb8Alpha= 0;

	    /*  white */
	    bd.bdRGB8Palette[1].rgb8Red= 255;
	    bd.bdRGB8Palette[1].rgb8Green= 255;
	    bd.bdRGB8Palette[1].rgb8Blue= 255;
	    bd.bdRGB8Palette[1].rgb8Alpha= 255;

	    /*  black */
	    bd.bdRGB8Palette[2].rgb8Red= 0;
	    bd.bdRGB8Palette[2].rgb8Green= 0;
	    bd.bdRGB8Palette[2].rgb8Blue= 0;
	    bd.bdRGB8Palette[2].rgb8Alpha= 0;

	    memset( buffer, 0, bd.bdBufferLength );

	    break;

	default:
	    LDEB(colorEncoding); return -1;
	}

    *bdOut= bd; *pBufOut= buffer;
    return 0;
    }
