#   include	"config.h"

#   include	"bmintern.h"
#   include	<string.h>
#   include	<appDebugon.h>

/************************************************************************/
/*  Translation back and forth between color encoding and string.	*/
/************************************************************************/
const char *	bmcoStrings[]=
    {
    "black on white",
    "white on black",
    "RGB",
    "RGB palette",
    0
    };

const char *	bmcoIntToString( int colorEncodingInt )
    {
    if  ( colorEncodingInt >= 0						&&
	  colorEncodingInt < sizeof( bmcoStrings )/sizeof(char *) -1	)
	{ return bmcoStrings[colorEncodingInt]; }

    LDEB(colorEncodingInt); return (char *)0;
    }

int		bmcoStringToInt( const char * colorEncodingString )
    {
    int	i;

    for ( i= 0; i < sizeof( bmcoStrings )/sizeof(char *) -1; i++ )
	{
	if  ( ! strcmp( colorEncodingString, bmcoStrings[i] ) )
	    { return i;	}
	}

    SDEB(colorEncodingString); return -1;
    }

/************************************************************************/
/*  Translation back and forth between resolution unit and string.	*/
/************************************************************************/
const char *	bmunStrings[]=
    {
    "cm",
    "inch",
    "point",
    0
    };

const char *	bmunIntToString( int unitInt )
    {
    if  ( unitInt >= 0						&&
	  unitInt < sizeof( bmcoStrings )/sizeof(char *) -1	)
	{ return bmunStrings[unitInt]; }

    LDEB(unitInt); return (char *)0;
    }

int		bmunStringToInt( const char * unitString )
    {
    int	i;

    for ( i= 0; i < sizeof( bmunStrings )/sizeof(char *) -1; i++ )
	{
	if  ( ! strcmp( unitString, bmunStrings[i] ) )
	    { return i;	}
	}

    SDEB(unitString); return -1;
    }

/************************************************************************/
/*  Initialise a BitmapDescription.					*/
/************************************************************************/
void bmInitDescription	( BitmapDescription *	bd )
    {
    bd->bdBufferLength= 0;
    bd->bdBytesPerRow= 0;
    bd->bdPixelsWide= 0;
    bd->bdPixelsHigh= 0;
    bd->bdBitsPerSample= 0;
    bd->bdSamplesPerPixel= 0;
    bd->bdBitsPerPixel= 0;
    bd->bdXResolution= 0;
    bd->bdYResolution= 0;
    bd->bdUnit= BMunILLEGALVALUE;
    bd->bdColorEncoding= BMcoILLEGALVALUE;

    bd->bdHasAlpha= 0;

    /********************************************/
    /*  Or any other member of the union.	*/
    /********************************************/
    bd->bdColorCount= 0;
    bd->bdRGB8Palette= (RGB8Color *)0;
    }

/************************************************************************/
/*  Clean a BitmapDescription.						*/
/************************************************************************/
void bmCleanDescription	( BitmapDescription *	bd )
    {
    switch( bd->bdColorEncoding )
	{
	case BMcoRGB8PALETTE:
	    if  ( bd->bdRGB8Palette )
		{ free( bd->bdRGB8Palette );	}
	    break;
	default:
	    break;
	}
    }


/************************************************************************/
/*  Copy a BitmapDescription.						*/
/************************************************************************/
int bmCopyDescription	(	BitmapDescription *		to,
				const BitmapDescription *	from )
    {
    switch( from->bdColorEncoding )
	{
	case BMcoRGB8PALETTE:
	    *to= *from;
	    to->bdRGB8Palette= malloc( to->bdColorCount* sizeof(RGB8Color) );
	    if  ( ! to->bdRGB8Palette )
		{ XDEB(to->bdRGB8Palette); return -1;	}

	    memcpy( to->bdRGB8Palette, from->bdRGB8Palette, 
				    from->bdColorCount* sizeof( RGB8Color ) );
	    break;
	default:
	    *to= *from;
	    break;
	}

    return 0;
    }

/************************************************************************/
/*  Byte masks								*/
/************************************************************************/
unsigned char	Bmc1Masks[8]=
    { 0x80, 0x40, 0x20, 0x10, 0x8, 0x4, 0x2, 0x1 };

unsigned char	Bmc7Masks[8]=
    { 0x7f, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xfe };

