/************************************************************************/
/*									*/
/*  Simple io streams, recursive use for hexadecimal data.		*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	"sioHex.h"
#   include	<appDebugon.h>


/************************************************************************/
/*									*/
/*  Exchange of hexed binary little endian data.			*/
/*									*/
/************************************************************************/


static int sioHexClose( void *	voids )
    { return 0;	}

static int sioInHexReadBytes(	void *		voidsis,
				unsigned char *	buffer,
				int		count )
    {
    SimpleInputStream *	sis= (SimpleInputStream *)voidsis;
    int			done= 0;

    while( done < count )
	{
	int		c;

	c= sioInGetCharacter( sis );

	while( c == ' ' || c == '\r' || c == '\n' )
	    { c= sioInGetCharacter( sis );	}

	switch( c )
	    {
	    case '0': case '1': case '2': case '3': case '4':
	    case '5': case '6': case '7': case '8': case '9':
		buffer[0]= c- '0'; break;
	    case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
		buffer[0]= c- 'a'+ 10; break;
	    case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
		buffer[0]= c- 'A'+ 10; break;
	    case EOF:
		return done;
	    default:
		sioInUngetLastRead( sis ); return done;
	    }

	c= sioInGetCharacter( sis );

	buffer[0] *= 16;

	while( c == ' ' || c == '\r' || c == '\n' )
	    { c= sioInGetCharacter( sis );	}

	switch( c )
	    {
	    case '0': case '1': case '2': case '3': case '4':
	    case '5': case '6': case '7': case '8': case '9':
		buffer[0] += c- '0'; break;
	    case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
		buffer[0] += c- 'a'+ 10; break;
	    case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
		buffer[0] += c- 'A'+ 10; break;
	    default:
		CDEB(c); return -1;
	    }

	buffer++; done++;
	}

    return done;
    }


SimpleInputStream * sioInHexOpen(	SimpleInputStream *	sisHex )
    {
    SimpleInputStream *	sis;

    sis= sioInOpen( (void *)sisHex,
			    sioInHexReadBytes, (SIOinSEEK)0, sioHexClose );

    if  ( ! sis )
	{ XDEB(sis); return (SimpleInputStream *)0; }

    return sis;
    }

static int sioOutHexWriteBytes(	void *			voidsos,
				const unsigned char *	buffer,
				int			count )
    {
    SimpleOutputStream *	sos= (SimpleOutputStream *)voidsos;
    int				done= 0;
    char *			hexDigits= "0123456789abcdef";

    while( done < count )
	{
	sioOutPutCharacter( hexDigits[ ( (*buffer) >> 4 ) & 0x0f ], sos );
	sioOutPutCharacter( hexDigits[ ( (*buffer) >> 0 ) & 0x0f ], sos );

	buffer++; done++;
	}

    return count;
    }

static int sioHexSeek(		void *			voidsos,
				long			pos )
    {
    SimpleOutputStream *	sos= (SimpleOutputStream *)voidsos;

    if  ( sioOutSeek( sos, 2* pos ) )
	{ LDEB(0); return -1;	}

    return 0;
    }

SimpleOutputStream * sioOutHexOpen(	SimpleOutputStream *	sosHex )
    {
    SimpleOutputStream *	sos;

    sos= sioOutOpen( (void *)sosHex, sioOutHexWriteBytes,
						sioHexSeek, sioHexClose );

    if  ( ! sos )
	{ XDEB(sos); return (SimpleOutputStream *)0; }

    return sos;
    }
