#   ifndef	APP_PS_H
#   define	APP_PS_H

#   include	<stdio.h>
#   include	<appGeo.h>
#   include	<docFont.h>
#   include	<psFont.h>

/************************************************************************/
/*									*/
/*  The state of a printing job.					*/
/*									*/
/************************************************************************/

typedef struct NupTransform
    {
    double		ntAxx;
    double		ntAxy;
    double		ntAyx;
    double		ntAyy;
    double		ntTx;
    double		ntTy;
    } NupTransform;

typedef struct PrintingState
    {
    FILE *			psFile;

    int				psCurrentPhysicalFont;
    int				psPagesPrinted;
    int				psSheetsPrinted;

    NupTransform		psTransform;
    NupTransform		psCurrentTransform;
    DocumentGeometry		psPrinterGeometry;
    char *			psOrientation;

    int				psNup;
    NupTransform *		psNupTransforms;

    int				psInLink;
    int				psLinkParticulesDone;
    int				psLinkRectLeft;

    int				psCurrentColor;
#   define			PScolorNONE	-1
#   define			PScolorTEXT	1
#   define			PScolorLINK	2

    const char *		psLinkFile;
    int				psLinkFileSize;
    const char *		psLinkMark;
    int				psLinkMarkSize;
    } PrintingState;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void appPsBoundingBoxComment(  const PrintingState *	ps,
			    const DocumentGeometry *	dg,
			    const char *		comment,
			    const char *		orientationComment );

extern int appPsSetNup(		PrintingState *			ps,
				const DocumentGeometry *	dg,
				int				nup,
				int				horizontal );

extern void appPsPrintString(	FILE *			f,
				const unsigned char *	s,
				int			len );

extern void appPsSetFont(	FILE *		f,
				const char *	prefix,
				TextAttribute	ta );

extern int appPsRememberAfi(	AfmFontInfo *		afi,
				TextAttribute		ta,
				const char *		prefix,
				int			appearsInText,
				PostScriptFont **	pFontList,
				int *			pCount );

extern void appPsInitPrintingState(	PrintingState *	ps );
extern void appPsCleanPrintingState(	PrintingState *	ps );

extern void appPsSetLinkColor( PrintingState *   ps );
extern void appPsSetTextColor( PrintingState *   ps );

extern void appPsStartPage(	PrintingState *			ps,
				int				documentPage,
				const DocumentGeometry *	dg );

extern void appPsFinishPage(	PrintingState *		ps,
				int			documentPage,
				int			asLast );

extern int appPsGetNupFactor(	double *			pFac,
				int *				pRotate,
				int *				pYShift,
				const DocumentGeometry *	dgPage,
				const DocumentGeometry *	dgSheet,
				int				nup,
				int				horizontal );

extern void appPsFontNames(	FILE *				f,
				PostScriptFont *		psf,
				int				fontCount,
				int				allFonts );

extern void appPsWriteEpsHeader(	FILE *			f,
					const char *		creator,
					const char *		title,
					int			pointsWide,
					int			pointsHigh );

extern void appPsSetRectfillEmulation(		FILE *	f );
extern void appPsSetSelectfontEmulation(	FILE *	f );

#   endif	/*  APP_PS_H  */
