/************************************************************************/
/*  Utility functions for printing.					*/
/************************************************************************/

#   include	"config.h"

#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<string.h>

#   include	"utilPrinter.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Find out what printers are available on the system.			*/
/*									*/
/*  1)  BSD/Linux style.						*/
/*  2)  SysV style.							*/
/*									*/
/************************************************************************/

static int utilPrinterGetLprPrinters(	const char *		command,
					char *			scratch,
					int *			pPrinterCount,
					PrintDestination **	pDestinations )
    {
    int				l;
    FILE *			f;
    int				found= 0;

    PrintDestination *		pd= *pDestinations;
    PrintDestination *		fresh;
    int				count= *pPrinterCount;

    f= popen( command, "r" );

    if  ( ! f )
	{ return 0;	}

    while( fgets( scratch, 250, f ) )
	{
	l= strlen( scratch );
	if  ( l > 0 && scratch[l-1] == '\n' )
	    { scratch[l-1]= '\0';	}

	if  ( scratch[0] == '\t' || scratch[l-2] != ':' )
	    { continue;	}

	scratch[l-2]= '\0';

	fresh= (PrintDestination *)realloc( pd,
				    (count+ 1)*sizeof( PrintDestination ) );
	if  ( ! fresh )
	    { XDEB(fresh); return -1;	}
	*pDestinations= pd= fresh;

	fresh += count;

	fresh->pdCommand= (char *)malloc( l+ 23 );
	if  ( ! fresh->pdCommand )
	    { LXDEB(l,fresh->pdCommand); return -1;	}
#	if 0
	Has the advantage that there is no maximum on the filesize.
	Has the disadvantage that it does not work on SuSE Linux 6.0
	sprintf( fresh->pdCommand, "lpr -r -s -P '%s' '%s'",
							scratch, "%f" );
#	else
	sprintf( fresh->pdCommand, "lpr -r -P '%s' '%s'",
							scratch, "%f" );
#	endif
	fresh->pdPrintKind= APPprinterTMPFILE;
	fresh->pdPrinterName= strdup( scratch );
	if  ( ! fresh->pdPrinterName )
	    { LXDEB(l,fresh->pdPrinterName); return -1;	}

	fresh->pdCommandLength= strlen( fresh->pdCommand );
	fresh->pdPercentCount= 1;

	found++; count++;
	}

    pclose( f );

    *pPrinterCount= count;

    return found;
    }

int utilPrinterGetPrinters(	int *			pPrinterCount,
				int *			pDefaultPrinter,
				PrintDestination **	pDestinations,
				const char *		customCommand,
				const char *		customName )
    {
    PrintDestination *		pd= (PrintDestination *)0;
    PrintDestination *		fresh;
    int				count= 0;
    int				defaultPrinter= -1;
    char *			defaultPrinterName= (char *)0;

    FILE *			f;
    char			scratch[250+1];
    int				l;

    char *			s;

    /*  1  */
    if  ( utilPrinterGetLprPrinters(  "( lpc status ) 2>/dev/null",
					    scratch, &count, &pd ) < 1	&&
	  utilPrinterGetLprPrinters(  "( /usr/sbin/lpc status ) 2>/dev/null",
					    scratch, &count, &pd ) < 1	)
	{ /* nothing.. sys5? */;	}

    /*  2  */
    f= popen( "( lpstat -a ) 2>/dev/null", "r" );
    if  ( f )
	{
	char *	firstLpPrinter= (char *)0;

	while( fgets( scratch, 250, f ) )
	    {
	    s= strchr( scratch, ' ' );
	    if  ( ! s )
		{ continue;	}
	    *s= '\0'; l= s- scratch;

	    fresh= (PrintDestination *)realloc( pd,
				    (count+ 1)*sizeof( PrintDestination ) );
	    if  ( ! fresh )
		{ XDEB(fresh); return -1;	}
	    pd= fresh;

	    fresh += count;

	    fresh->pdCommand= (char *)malloc( l+ 12 );
	    if  ( ! fresh->pdCommand )
		{ LXDEB(l,fresh->pdCommand); return -1;	}
	    sprintf( fresh->pdCommand, "lp -s -d '%s'", scratch );
	    fresh->pdPrintKind= APPprinterPIPE;
	    fresh->pdPrinterName= (char *)malloc( l+ 1 );
	    if  ( ! fresh->pdPrinterName )
		{ LXDEB(l,fresh->pdPrinterName); return -1;	}

	    fresh->pdCommandLength= strlen( fresh->pdCommand );
	    fresh->pdPercentCount= 0;

	    strcpy( fresh->pdPrinterName, scratch );
	    if  ( ! firstLpPrinter )
		{ firstLpPrinter= fresh->pdPrinterName;	}

	    count++;
	    }

	pclose( f );

	defaultPrinterName= getenv( "LPDEST" );
	if  ( ! defaultPrinterName )
	    { defaultPrinterName= firstLpPrinter;	}
	}

    if  ( defaultPrinterName )
	{
	for ( l= 0; l < count; l++ )
	    {
	    if  ( ! strcmp( defaultPrinterName, pd[l].pdPrinterName ) )
		{ defaultPrinter= l; break;	}
	    }
	}

    if  ( customName || customCommand )
	{
	if  ( ! customName )
	    { XDEB(customName);	}
	if  ( ! customCommand )
	    { XDEB(customCommand);	}
	}

    if  ( customName && customCommand )
	{
	const char *	p;

	fresh= (PrintDestination *)realloc( pd,
				(count+ 1)*sizeof( PrintDestination ) );
	if  ( ! fresh )
	    { XDEB(fresh); return -1;	}
	pd= fresh;

	fresh += count;

	fresh->pdCommand= strdup( customCommand );
	fresh->pdPrinterName= strdup( customName );

	fresh->pdCommandLength= strlen( customCommand );
	fresh->pdPercentCount= 0;

	p= customCommand;
	while( *p )
	    {
	    if  ( p[0] == '%' && p[1] == 'f' )
		{ fresh->pdPercentCount++;	}
	    p++;
	    }

	if  ( fresh->pdPercentCount > 0 )
	    { fresh->pdPrintKind= APPprinterTMPFILE;	}
	else{ fresh->pdPrintKind= APPprinterPIPE;	}

	if  ( fresh->pdCommand && fresh->pdPrinterName )
	    { defaultPrinter= count++;				}
	else{ XXDEB(fresh->pdCommand,fresh->pdPrinterName);	}
	}

    *pPrinterCount= count;
    *pDefaultPrinter= defaultPrinter;
    *pDestinations= pd;

    return 0;
    }
