/************************************************************************/
/*									*/
/*  Various definitions relating to document geometry.			*/
/*									*/
/************************************************************************/

#   ifndef	APP_GEO_H
#   define	APP_GEO_H

typedef struct DocumentRectangle
    {
    int		drX0;
    int		drY0;
    int		drX1;
    int		drY1;
    } DocumentRectangle;

typedef struct DocumentGeometry
    {
    int			dgPageWideTwips;
    int			dgPageHighTwips;

    int			dgLeftMarginTwips;
    int			dgTopMarginTwips;
    int			dgRightMarginTwips;
    int			dgBottomMarginTwips;

    int			dgHeaderPositionTwips;
    int			dgFooterPositionTwips;

    int			dgGutterTwips;
    } DocumentGeometry;

/************************************************************************/
/*									*/
/*  Update masks for document geometry.					*/
/*									*/
/*  NOTE: This range is continued in Ted/docBuf.h for the section and	*/
/*	document properties. Adding a bit here may make it necessary to	*/
/*	shift the masks there as well.					*/
/*									*/
/************************************************************************/

#   define	DGupdNONE		(0)

#   define	DGupdPAGE_WIDTH		(1<<0)
#   define	DGupdPAGE_HEIGHT	(1<<1)

#   define	DGupdLEFT_MARGIN	(1<<2)
#   define	DGupdRIGHT_MARGIN	(1<<3)
#   define	DGupdTOP_MARGIN		(1<<4)
#   define	DGupdBOTTOM_MARGIN	(1<<5)

#   define	DGupdHEADER_POSITION	(1<<6)
#   define	DGupdFOOTER_POSITION	(1<<7)

#   define	DGupdGUTTER		(1<<8)

#   define	DGupdPAGE_SIZE		( DGupdPAGE_WIDTH |\
					  DGupdPAGE_HEIGHT )

#   define	DGupdMARGINS		( DGupdLEFT_MARGIN |\
					  DGupdRIGHT_MARGIN |\
					  DGupdTOP_MARGIN |\
					  DGupdBOTTOM_MARGIN )

#   define	DGupdHEADFOOT_POSITIONS	( DGupdHEADER_POSITION |\
					  DGupdFOOTER_POSITION )

#   define	DGupdALL		( DGupdPAGE_SIZE |\
					  DGupdMARGINS |\
					  DGupdHEADFOOT_POSITIONS |\
					  DGupdGUTTER )

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitRectangle(	DocumentRectangle *		dr );

extern void docUnionRectangle(	DocumentRectangle *		dr,
				const DocumentRectangle *	dr1,
				const DocumentRectangle *	dr2	);

extern int docIntersectRectangle(	DocumentRectangle *		dr,
					const DocumentRectangle *	dr1,
					const DocumentRectangle *	dr2 );

extern void appInitDocumentGeometry(	DocumentGeometry *	dg );

extern void appSetDocumentGeometry(	DocumentGeometry *		dgTo,
					const DocumentGeometry *	dgFrom,
					unsigned int *			pCh,
					unsigned int			msk );

#   endif
