#   include	"config.h"
#   include	"appGeo.h"

void docInitRectangle(	DocumentRectangle *		dr )
    { dr->drX0= dr->drY0= dr->drX1= dr->drY1= 0; return; }

void docUnionRectangle(	DocumentRectangle *		dr,
			const DocumentRectangle *	dr1,
			const DocumentRectangle *	dr2 )
    {
    if  ( dr1->drX0 < dr2->drX0 )
	{ dr->drX0= dr1->drX0;	}
    else{ dr->drX0= dr2->drX0;	}

    if  ( dr1->drY0 < dr2->drY0 )
	{ dr->drY0= dr1->drY0;	}
    else{ dr->drY0= dr2->drY0;	}

    if  ( dr1->drX1 < dr2->drX1 )
	{ dr->drX1= dr2->drX1;	}
    else{ dr->drX1= dr1->drX1;	}

    if  ( dr1->drY1 < dr2->drY1 )
	{ dr->drY1= dr2->drY1;	}
    else{ dr->drY1= dr1->drY1;	}
    }

int docIntersectRectangle(	DocumentRectangle *		dr,
				const DocumentRectangle *	dr1,
				const DocumentRectangle *	dr2 )
    {
    DocumentRectangle	res= *dr1;

    if  ( dr1->drX1 < dr2->drX0 )
	{ return 0;	}

    if  ( dr2->drX1 < dr1->drX0 )
	{ return 0;	}

    if  ( dr1->drY1 < dr2->drY0 )
	{ return 0;	}

    if  ( dr2->drY1 < dr1->drY0 )
	{ return 0;	}

    if  ( ! dr )
	{ return 1;	}

    if  ( dr1->drX0 < dr2->drX0 )
	{ res.drX0= dr2->drX0;	}
    else{ res.drX0= dr1->drX0;	}

    if  ( dr1->drY0 < dr2->drY0 )
	{ res.drY0= dr2->drY0;	}
    else{ res.drY0= dr1->drY0;	}

    if  ( dr1->drX1 < dr2->drX1 )
	{ res.drX1= dr1->drX1;	}
    else{ res.drX1= dr2->drX1;	}

    if  ( dr1->drY1 < dr2->drY1 )
	{ res.drY1= dr1->drY1;	}
    else{ res.drY1= dr2->drY1;	}

    *dr= res; return 1;
    }

void appInitDocumentGeometry(	DocumentGeometry *	dg )
    {
    dg->dgPageWideTwips= 12240;
    dg->dgPageHighTwips= 15840;

    dg->dgLeftMarginTwips= 1800;
    dg->dgTopMarginTwips= 1440;
    dg->dgRightMarginTwips= 1800;
    dg->dgBottomMarginTwips= 1440;

    dg->dgHeaderPositionTwips= 720;
    dg->dgFooterPositionTwips= 720;

    dg->dgGutterTwips= 0;
    }

/************************************************************************/
/*									*/
/*  Copy a document Geometry. Because of the approximative character of	*/
/*  unit conversions in the conversion back and forth between string	*/
/*  and number, a certain inaccuracy is used to decide whether values	*/
/*  changed or not.							*/
/*									*/
/************************************************************************/

static void appGeoSetNumber(	int *		pTarget,
				int		value,
				unsigned int *	pChanged,
				unsigned int	mask )
    {
    int		d= *pTarget- value;
    int		g;

    if  ( *pTarget == value )
	{ return;	}

    if  ( *pTarget > 200 )
	{
	g= *pTarget/200;

	if  ( d <= g && d >= -g )
	    { return;	}
	}
    else{
	if  ( value > 200 )
	    {
	    g= value/200;

	    if  ( d <= g && d >= -g )
		{ return;	}
	    }
	}

    *pTarget= value; *pChanged |= mask;
    }

void appSetDocumentGeometry(	DocumentGeometry *		dgTo,
				const DocumentGeometry *	dgFr,
				unsigned int *			pChanged,
				unsigned int			updMask )
    {
    unsigned int		changed= 0;

    if  ( updMask & DGupdPAGE_WIDTH )
	{
	appGeoSetNumber( &(dgTo->dgPageWideTwips),
					    dgFr->dgPageWideTwips,
					    &changed, DGupdPAGE_WIDTH );
	}
    if  ( updMask & DGupdPAGE_HEIGHT )
	{
	appGeoSetNumber( &(dgTo->dgPageHighTwips),
					    dgFr->dgPageHighTwips,
					    &changed, DGupdPAGE_HEIGHT );
	}
    if  ( updMask & DGupdLEFT_MARGIN )
	{
	appGeoSetNumber( &(dgTo->dgLeftMarginTwips),
					    dgFr->dgLeftMarginTwips,
					    &changed, DGupdLEFT_MARGIN );
	}
    if  ( updMask & DGupdRIGHT_MARGIN )
	{
	appGeoSetNumber( &(dgTo->dgRightMarginTwips),
					    dgFr->dgRightMarginTwips,
					    &changed, DGupdRIGHT_MARGIN );
	}
    if  ( updMask & DGupdTOP_MARGIN )
	{
	appGeoSetNumber( &(dgTo->dgTopMarginTwips),
					    dgFr->dgTopMarginTwips,
					    &changed, DGupdTOP_MARGIN );
	}
    if  ( updMask & DGupdBOTTOM_MARGIN )
	{
	appGeoSetNumber( &(dgTo->dgBottomMarginTwips),
					    dgFr->dgBottomMarginTwips,
					    &changed, DGupdBOTTOM_MARGIN );
	}
    if  ( updMask & DGupdHEADER_POSITION )
	{
	appGeoSetNumber( &(dgTo->dgHeaderPositionTwips),
					    dgFr->dgHeaderPositionTwips,
					    &changed, DGupdHEADER_POSITION );
	}
    if  ( updMask & DGupdFOOTER_POSITION )
	{
	appGeoSetNumber( &(dgTo->dgFooterPositionTwips),
					    dgFr->dgFooterPositionTwips,
					    &changed, DGupdFOOTER_POSITION );
	}
    if  ( updMask & DGupdGUTTER )
	{
	appGeoSetNumber( &(dgTo->dgGutterTwips),
					    dgFr->dgGutterTwips,
					    &changed, DGupdGUTTER );
	}

    *pChanged= changed;

    return;
    }

