#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>

#   include	<appWinMeta.h>
#   include	<appPs.h>
#   include	<sioEndian.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	<appDebugon.h>

#   ifndef	M_PI
#	define	M_PI	3.14159265358979323846
#   endif

# if 0
#    define	WMFDEB(x)	(x)
# else
#    define	WMFDEB(x)	/*nothing*/
# endif

int appMetaInitDeviceContext(	DeviceContext *		dc,
				int			objectCount,
				int			xExt,
				int			yExt,
				int			twipsWide,
				int			twipsHigh )
    {
    dc->dcDrawBorders= 1;
    dc->dcFillInsides= 1;
    dc->dcString= (unsigned char *)0;

    dc->dcFillHatched= 0;
    dc->dcFillPattern= 0;

    docInitFontList( &(dc->x_dcFontList) );
    appInitDrawingData( &(dc->dcDrawingData) );

    dc->dcPen.lpStyle= PS_SOLID;
    dc->dcPen.lpWidth= 1;
    dc->dcPen.lpColor.rgb8Red= 0;
    dc->dcPen.lpColor.rgb8Green= 0;
    dc->dcPen.lpColor.rgb8Blue= 0;

    dc->dcBrush.lbStyle= BS_SOLID;
    dc->dcBrush.lbColor.rgb8Red= 255;
    dc->dcBrush.lbColor.rgb8Green= 255;
    dc->dcBrush.lbColor.rgb8Blue= 255;

    dc->dcBkColor.rgb8Red= 255;
    dc->dcBkColor.rgb8Green= 255;
    dc->dcBkColor.rgb8Blue= 255;

    dc->dcTextColor.rgb8Red= 0;
    dc->dcTextColor.rgb8Green= 0;
    dc->dcTextColor.rgb8Blue= 0;

    dc->dcBkMode= BKMODE_OPAQUE;

    dc->dcExtraTextSpacing= 0;
    dc->dcJustificationAmount= 0;
    dc->dcJustificationSpaces= 0;
    dc->dcTextAlignment= TA_LEFT|TA_TOP;

    dc->dcTransform.dctOrgX= 0;
    dc->dcTransform.dctOrgY= 0;
    dc->dcTransform.dctExtX= xExt;
    dc->dcTransform.dctExtY= yExt;
    dc->dcTransform.dctPushed= (DeviceCoordinateTransform *)0;

    dc->dcTwipsWide= twipsWide;
    dc->dcTwipsHigh= twipsHigh;

    dc->dcObjects= (MetaFileObject *)0;
    dc->dcObjectCount= 0;

    if  ( objectCount > 0 )
	{
	int		ob;

	dc->dcObjects= (MetaFileObject *)
			    malloc( objectCount* sizeof(MetaFileObject) );
	if  ( ! dc->dcObjects )
	    { XDEB(dc->dcObjects); return -1;	}

	for ( ob= 0; ob < objectCount; ob++ )
	    { dc->dcObjects[ob].mfoType= MFtypeFREE;	}

	dc->dcObjectCount= objectCount;
	}

    dc->dcPoints= (APP_POINT *)0;
    dc->dcAfi= (AfmFontInfo *)0;

    dc->dcRedSet= -1;
    dc->dcGreenSet= -1;
    dc->dcBlueSet= -1;
    dc->dcPenSet.lpStyle= -1;

    docInitTextAttribute( &(dc->dcTextAttributeSet) );

    return 0;
    }

void appMetaCleanObject( MetaFileObject *	mfo )
    {
    AppBitmapImage *	abi;

    switch( mfo->mfoType )
	{
	case MFtypeFREE:
	    return;
	case MFtypeBRUSH:
	    return;
	case MFtypePEN:
	    return;
	case MFtypeFONT:
	    return;
	case MFtypePALETTE:
	    return;
	case MFtypePATTERNBRUSH:
	    abi= &(mfo->mfoPatternBrush.pbAbi);
	    appCleanBitmapImage( abi );
	    appInitBitmapImage( abi );
	    return;

	default:
	    LDEB(mfo->mfoType);
	    return;
	}
    }

void appMetaCleanDeviceContext(	DeviceContext *		dc )
    {
    int		ob;

    if  ( dc->dcString )
	{ free( dc->dcString );	}

    docCleanFontList( &(dc->x_dcFontList) );
    appCleanDrawingData( &(dc->dcDrawingData) );

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType != MFtypeFREE )
	    { appMetaCleanObject( dc->dcObjects+ ob );	}
	}

    if  ( dc->dcObjects )
	{ free( dc->dcObjects );	}

    if  ( dc->dcPoints )
	{ free( dc->dcPoints );	}

    while( dc->dcTransform.dctPushed )
	{
	DeviceCoordinateTransform *	toFree= dc->dcTransform.dctPushed;

	dc->dcTransform= *dc->dcTransform.dctPushed;

	free( toFree );
	}

    return;
    }

int appMetaGetColor(		SimpleInputStream *	sis,
				RGB8Color *		rgb8 )
    {
    rgb8->rgb8Red= sioInGetCharacter( sis );
    rgb8->rgb8Green= sioInGetCharacter( sis );
    rgb8->rgb8Blue= sioInGetCharacter( sis );

    (void) sioInGetCharacter( sis );

    return 0;
    }

int appMetaCreateBrushIndirect(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    LogicalBrush *	lb;
    char *		hatch="";
    char *		style="";

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypeBRUSH;

    lb= &(dc->dcObjects[ob].mfoLogicalBrush);
    lb->lbTilePixmap= (APP_BITMAP_IMAGE)0;
    lb->lbStyle= sioEndianGetLeInt16( sis );
    
    switch( lb->lbStyle )
	{
	case BS_SOLID:
	    style= "SOLID";
	    appMetaGetColor( sis, &(lb->lbColor) );
	    lb->lbHatch= sioEndianGetLeInt16( sis );
	    break;
	case BS_HOLLOW:
	    style= "HOLLOW";
	    appMetaGetColor( sis, &(lb->lbColor) );
	    lb->lbHatch= sioEndianGetLeInt16( sis );
	    break;
	case BS_HATCHED:
	    style= "HATCHED";
	    appMetaGetColor( sis, &(lb->lbColor) );
	    lb->lbHatch= sioEndianGetLeInt16( sis );
	    break;
	case BS_PATTERN:
	    style= "PATTERN";
	    appMetaGetColor( sis, &(lb->lbColor) );
	    lb->lbHatch= sioEndianGetLeInt16( sis );
	    break;
	default:
	    LDEB(dc->dcObjects[ob].mfoLogicalBrush.lbStyle);
	}

    switch( lb->lbHatch )
	{
	case HS_HORIZONTAL:	hatch= "HORIZONTAL";	break;
	case HS_VERTICAL:	hatch= "VERTICAL";	break;
	case HS_FDIAGONAL:	hatch= "FDIAGONAL";	break;
	case HS_BDIAGONAL:	hatch= "BDIAGONAL";	break;
	case HS_CROSS:		hatch= "CROSS";		break;
	case HS_DIAGCROSS:	hatch= "DIAGCROSS";	break;
	default:
	    break;
	}

    WMFDEB(appDebug("CreateBrushIndirect(%s,%s) ob=%d\n",
						    style, hatch, ob ));

    style= style; hatch= hatch; /* use them */

    return 0;
    }

int appMetaCreatePalette(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    int			done;
    int			count;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypePALETTE;

    (void) sioEndianGetLeInt16( sis );
    count= sioEndianGetLeInt16( sis );
    /*
    if  ( 2* count != recordSize- 5 )
	{ LLDEB(count,recordSize);	}
    */
    for ( done= 5; done < recordSize; done++ )
	{ (void) sioEndianGetLeInt16( sis ); }

    WMFDEB(appDebug("CreatePalette(...) ob=%d\n", ob ));

    return 0;
    }

int appMetaCreatePatternBrush(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    int			got;
    int			done= 3;
    AppBitmapImage *	abi;

    PatternBrush *	pb;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}

    dc->dcObjects[ob].mfoType= MFtypePATTERNBRUSH;

    pb= &(dc->dcObjects[ob].mfoPatternBrush);

    pb->pbType= 0;
    pb->pbUsage= 0;
    abi= &(pb->pbAbi);
    appInitBitmapImage( abi );
    pb->pbTilePixmap= (APP_BITMAP_IMAGE)0;

    pb->pbType= sioEndianGetLeInt16( sis ); done++;
    pb->pbUsage= sioEndianGetLeInt16( sis ); done++;

    if  ( pb->pbUsage != 0 )
	{
	LLDEB(pb->pbType,pb->pbUsage);
	for ( done= done; done < recordSize; done++ )
	    { (void) sioEndianGetLeInt16( sis ); }
	WMFDEB(appDebug("CreatePatternBrush(...) ob=%d???? \n", ob ));
	return 0;
	}

    switch( pb->pbType )
	{
	case 3:
	case 5:
	    got= bmBmpReadDib( &(abi->abiBitmap), &(abi->abiBuffer), sis );
	    if  ( got < 0 || got > 2* ( recordSize- done ) )
		{
		LLDEB(got,recordSize-done );

		appCleanBitmapImage( abi );
		appInitBitmapImage( abi );
		return -1;
		}
	    done += got;
	    break;
	default:
	    LLDEB(pb->pbType,pb->pbUsage);
	    for ( done= done; done < recordSize; done++ )
		{ (void) sioEndianGetLeInt16( sis ); }
	    WMFDEB(appDebug("CreatePatternBrush(...) ob=%d???? \n", ob ));
	    return 0;
	}

    while( done < recordSize )
	{ (void) sioEndianGetLeInt16( sis ); done++;	}

    WMFDEB(appDebug("CreatePatternBrush(...) ob=%d\n", ob ));

    return 0;
    }

int appMetaCreatePenIndirect(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int			ob;
    int			ignore;
    int			done;

    int			x;
    int			y;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypePEN;

    dc->dcObjects[ob].mfoLogicalPen.lpStyle= sioEndianGetLeInt16( sis );
    x= sioEndianGetLeInt16( sis );
    y= sioEndianGetLeInt16( sis );
    dc->dcObjects[ob].mfoLogicalPen.lpWidth= x;
    appMetaGetColor( sis, &dc->dcObjects[ob].mfoLogicalPen.lpColor );

    WMFDEB(appDebug("CreatePenIndirect( style=%d,x,y=%d,%d) ob=%d\n",
				dc->dcObjects[ob].mfoLogicalPen.lpStyle,
				x,y, ob ));

    for ( done= 8; done < recordSize; done++ )
	{ ignore= sioEndianGetLeInt16( sis ); }

    return 0;
    }

int appMetaCreateFontIndirect(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    LogicalFont *	lf;
    DocumentFont *	df;

    char *		familyStyle= "fnil";

    int			count;
    int			done;
    int			ob;
    int			i;

    for ( ob= 0; ob < dc->dcObjectCount; ob++ )
	{
	if  ( dc->dcObjects[ob].mfoType == MFtypeFREE )
	    { break;	}
	}
    dc->dcObjects[ob].mfoType= MFtypeFONT;

    lf= &(dc->dcObjects[ob].mfoLogicalFont);

    lf->lfHeight= sioEndianGetLeInt16( sis );
    lf->lfWidth= sioEndianGetLeInt16( sis );
    lf->lfEscapement= sioEndianGetLeInt16( sis );
    lf->lfOrientation= sioEndianGetLeInt16( sis );
    lf->lfWeight= sioEndianGetLeInt16( sis );

    lf->lfItalic= sioInGetCharacter( sis );
    lf->lfUnderline= sioInGetCharacter( sis );
    lf->lfStrikeOut= sioInGetCharacter( sis );
    lf->lfCharSet= sioInGetCharacter( sis );
    lf->lfOutPrecision= sioInGetCharacter( sis );
    lf->lfClipPrecision= sioInGetCharacter( sis );
    lf->lfQuality= sioInGetCharacter( sis );
    lf->lfPitchAndFamily= sioInGetCharacter( sis );

    count= 0;
    for ( done= 12; done < recordSize; done++ )
	{
	lf->lfFaceName[count++]= sioInGetCharacter( sis );
	lf->lfFaceName[count++]= sioInGetCharacter( sis );
	}

    lf->lfFaceName[count]= '\0';

    {
    DeviceCoordinateTransform *	dct= &(dc->dcTransform);

    if  ( lf->lfHeight < 0 )
	{ done= ( dc->dcTwipsHigh* -lf->lfHeight )/ dct->dctExtY; }
    else{ done= ( dc->dcTwipsHigh*  lf->lfHeight )/ dct->dctExtY; }
    }

    lf->lfTextAttribute.taFontNumber= 0;
    lf->lfTextAttribute.taFontSizeHalfPoints= ( done+ 5 )/ 10;
    lf->lfTextAttribute.taFontIsBold= lf->lfWeight > 500;
    lf->lfTextAttribute.taFontIsSlanted= lf->lfItalic != 0;
    lf->lfTextAttribute.taIsUnderlined= lf->lfUnderline != 0;

    switch( lf->lfPitchAndFamily & 0xf0 )
	{
	case FF_ROMAN:		familyStyle= "froman";	break;
	case FF_SWISS:		familyStyle= "fswiss";	break;
	case FF_MODERN:		familyStyle= "fmodern";	break;
	case FF_SCRIPT:		familyStyle= "fscript";	break;
	case FF_DECORATIVE:	familyStyle= "fdecor";	break;
	case 0x60:		familyStyle= "ftech";	break;

	case FF_DONTCARE:
	default:
	    break;
	}

    df= dc->x_dcFontList.dflFonts;
    for ( i= 0; i < dc->x_dcFontList.dflCount; df++, i++ )
	{
	if  ( df->dfDocFamilyNumber < 0	 )
	    { continue;	}

	if  ( lf->lfFaceName[0]			&&
	      ! df->dfName			)
	    { continue;	}

	if  ( ! lf->lfFaceName[0]		&&
	      ! df->dfName			)
	    { break;	}

	if  ( ! strcmp( df->dfName, lf->lfFaceName ) )
	    { break;	}
	}

    if  ( i >= dc->x_dcFontList.dflCount )
	{
	df= docInsertFont( &(dc->x_dcFontList), -1,
						familyStyle, lf->lfFaceName );
	if  ( ! df )
	    { SXDEB(lf->lfFaceName,df); return -1;	}
	}

    lf->lfTextAttribute.taFontNumber= df->dfDocFamilyNumber;

    lf->lfPrivateFont= -1;

    WMFDEB(appDebug("CreateFontIndirect(h=%d,w=%d,..\"%s\") ob=%d\n",
			    lf->lfHeight,
			    lf->lfWidth,
			    lf->lfFaceName, ob ));

    return 0;
    }

int appMeta_ExtTextOut(		SimpleInputStream *	sis,
				int			recordSize,
				int *			pX0,
				int *			pY0,
				int *			pCount,
				int *			pStyle,
				int *			pX1,
				int *			pY1,
				int *			pH1,
				int *			pW1,
				DeviceContext *		dc )
    {
    int			x0;
    int			y0;
    int			count;
    int			style;

    int			h1;
    int			w1;
    int			y1;
    int			x1;

    int			done;

    int			ignore;
    int			i;

    unsigned char *	str;

    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );
    count= sioEndianGetLeInt16( sis );
    style= sioEndianGetLeInt16( sis );

    done= 7;

    if  ( style )
	{
	h1= sioEndianGetLeInt16( sis );
	w1= sioEndianGetLeInt16( sis );
	y1= sioEndianGetLeInt16( sis );
	x1= sioEndianGetLeInt16( sis );

	done += 4;
	}
    else{ h1= w1= y1= x1= 0;	}

    str= (unsigned char *)realloc( dc->dcString, count+ 2 );
    if  ( ! str )
	{ LXDEB(count,str); return -1;	}
    dc->dcString= str;

    for ( i= 0; i < count; i += 2 )
	{
	str[i+0]= sioInGetCharacter( sis );
	str[i+1]= sioInGetCharacter( sis );
	done++;
	}
    str[count]= '\0';

    for ( ; done < recordSize; done++ )
	{ ignore= sioEndianGetLeInt16( sis ); }

    WMFDEB(appDebug( "ExtTextOut( x=%d, y= %d, opts= %d, rect=[%d+%d,%d+%d], ",
					    x0, y0, style, x1, w1, y1, h1 ));
    WMFDEB(appDebug( "\"%s\", count= %d, .... )\n", str, count ));

    *pX0= x0;
    *pY0= y0;
    *pCount= count;
    *pStyle= style;
    *pX1= x1;
    *pY1= y1;
    *pH1= h1;
    *pW1= w1;

    return 0;
    }

int appMeta_TextOut(	SimpleInputStream *	sis,
			int			recordSize,
			int *			pX0,
			int *			pY0,
			int *			pCount,
			DeviceContext *		dc )
    {
    int			x0;
    int			y0;
    int			count;

    int			i;

    unsigned char *	str;

    count= sioEndianGetLeInt16( sis );

    str= (unsigned char *)realloc( dc->dcString, count+ 2 );
    if  ( ! str )
	{ LXDEB(count,str); return -1;	}
    dc->dcString= str;

    for ( i= 0; i < count; i += 2 )
	{
	str[i+0]= sioInGetCharacter( sis );
	str[i+1]= sioInGetCharacter( sis );
	}
    str[count]= '\0';

    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(appDebug("TextOut( \"%s\", x=%d, y= %d )\n", str, x0, y0 ));

    *pX0= x0;
    *pY0= y0;
    *pCount= count;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Manage the current coordinate transform.				*/
/*									*/
/************************************************************************/

int appMetaOffsetWindowOrg(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int		x0;
    int		y0;

    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(appDebug("OffsetWindowOrg(yWinOrg+=%d,xWinOrg+=%d)\n", y0,x0 ));

    dc->dcTransform.dctOrgY += y0;
    dc->dcTransform.dctOrgX += x0;

    return 0;
    }

int appMetaSetWindowOrg(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int		x0;
    int		y0;

    y0= sioEndianGetLeInt16( sis );
    x0= sioEndianGetLeInt16( sis );

    WMFDEB(appDebug("SetWindowOrg(yWinOrg=%d,xWinOrg=%d)\n", y0,x0 ));

    dc->dcTransform.dctOrgY= y0;
    dc->dcTransform.dctOrgX= x0;

    return 0;
    }

int appMetaSetWindowExt(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int		w;
    int		h;

    h= sioEndianGetLeInt16( sis );
    w= sioEndianGetLeInt16( sis );

    WMFDEB(appDebug("SetWindowExt(yExt=%d,xExt=%d)\n", h, w ));

    dc->dcTransform.dctExtY= h;
    dc->dcTransform.dctExtX= w;

    return 0;
    }

int appMetaSaveDC(		DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    DeviceCoordinateTransform *	dct;

    WMFDEB(appDebug("SaveDC()\n" ));

    dct= malloc( sizeof(DeviceCoordinateTransform) );
    if  ( ! dct )
	{ XDEB(dct); return -1;	}

    *dct= dc->dcTransform;
    dc->dcTransform.dctPushed= dct;

    return 0;
    }

int appMetaRestoreDC(		DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    int		ignore= sioEndianGetLeInt16( sis );

    WMFDEB(appDebug("RestoreDC(%d)\n", ignore ));

    if  ( ignore >= 0 )
	{ LDEB(ignore);	}

    if  ( dc->dcTransform.dctPushed )
	{
	DeviceCoordinateTransform *	toFree= dc->dcTransform.dctPushed;

	dc->dcTransform= *dc->dcTransform.dctPushed;

	free( toFree );
	}
    else{ XDEB(dc->dcTransform.dctPushed);	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Remember text alighnment.						*/
/*									*/
/************************************************************************/

int appMetaSetTextAlign(	DeviceContext *		dc,
				int			recordSize,
				SimpleInputStream *	sis )
    {
    switch( recordSize )
	{
	case 4:
	    dc->dcTextAlignment= sioEndianGetLeInt16( sis );
	    break;
	case 5:
	    dc->dcTextAlignment= sioEndianGetLeInt32( sis );
	    break;
	default:
	    LDEB(recordSize); return -1;
	}

    WMFDEB(appDebug("SetTextAlign( 0x%x: ", dc->dcTextAlignment ));

    switch( dc->dcTextAlignment & 0x01 )
	{
	case TA_NOUPDATECP:	WMFDEB(appDebug(" NOUPDATECP" )); break;
	case TA_UPDATECP:	WMFDEB(appDebug(" UPDATECP" )); break;
	default:
	    WMFDEB(appDebug(" 0x%x", dc->dcTextAlignment & 0x01 ));
	    break;
	}

    switch( dc->dcTextAlignment & 0x07 )
	{
	case TA_LEFT:	WMFDEB(appDebug(" LEFT" )); break;
	case TA_RIGHT:	WMFDEB(appDebug(" RIGHT" )); break;
	case TA_CENTER:	WMFDEB(appDebug(" CENTER" )); break;
	default:
	    WMFDEB(appDebug(" 0x%x", dc->dcTextAlignment & 0x07 ));
	    break;
	}

    switch( dc->dcTextAlignment & 0x18 )
	{
	case TA_TOP:		WMFDEB(appDebug(" TOP" )); break;
	case TA_BOTTOM:		WMFDEB(appDebug(" BOTTOM" )); break;
	case TA_BASELINE:	WMFDEB(appDebug(" BASELINE" )); break;
	default:
	    WMFDEB(appDebug(" 0x%x", dc->dcTextAlignment & 0x18 ));
	    break;
	}

    WMFDEB(appDebug(" )\n" ));

    return 0;
    }

/************************************************************************/
/*									*/
/*  Extract a bitmap from the metafile stream.				*/
/*									*/
/************************************************************************/

int appMetaBitmapImage(		AppBitmapImage **	pAbi,
				SimpleInputStream *	sis,
				int			expectBytes )
    {
    AppBitmapImage *	abi;
    int			done;

    abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );
    if  ( ! abi )
	{ XDEB(abi); return -1;	}
    appInitBitmapImage( abi );

    done= bmBmpReadDib( &abi->abiBitmap, &abi->abiBuffer, sis );
    if  ( done < 0 || done > expectBytes )
	{
	LLDEB(done,expectBytes);
	appCleanBitmapImage( abi ); free( abi );
	return -1;
	}

    while( done < expectBytes )
	{ sioInGetCharacter( sis ); done++;	}

    *pAbi= abi; return 0;
    }

int appMeta_GetCounts(	SimpleInputStream *	sis,
			int			recordSize,
			int *			pCount,
			int **			pCounts,
			DeviceContext *		dc )
    {
    int			count;
    int			i;

    static int *	counts;

    count= sioEndianGetLeInt16( sis );

    counts= (int *)realloc( counts, count* sizeof(int) );
    if  ( ! counts )
	{ LXDEB(count,counts); return -1;	}

    for ( i= 0; i < count; i++ )
	{ counts[i]= sioEndianGetLeInt16( sis ); }

    *pCount= count; *pCounts= counts; return 0;
    }

int appMetaSaveBitmapMetafile(	const BitmapDescription *	bd,
				const unsigned char *		buffer,
				SimpleOutputStream *		sos )
    {
    int			done;
    int			bytesWritten= 0;
    long		bltArgCountPos= -1L;
    long		bltArgCount;

    long		fileSize= 0L;
    long		headerOffset= 0L;
    long		recordSize;
    long		maxRecordSize= 0L;

    sioEndianPutLeInt16( 1, sos );		/*  fileType		*/
    sioEndianPutLeInt16( 9, sos );		/*  headerSize		*/
    sioEndianPutLeInt16( 768, sos );		/*  windowsVersion	*/
    sioEndianPutLeInt32( fileSize, sos );	/*  fileSize		*/
    sioEndianPutLeInt16( 0, sos );		/*  objectCount		*/
    sioEndianPutLeInt32( maxRecordSize, sos );	/*  maxRecordSize	*/
    sioEndianPutLeInt16( 0, sos );		/*  parameterCount	*/

    bytesWritten += 2+ 2+ 2+ 4+ 2+ 4+ 2;

    recordSize= 2+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SaveDC, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SetMapMode, sos );
    sioEndianPutLeInt16( MM_ANISOTROPIC, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SetWindowOrg, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( 0, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_SetWindowExt, sos );
    sioEndianPutLeInt16( bd->bdPixelsHigh, sos );
    sioEndianPutLeInt16( bd->bdPixelsWide, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    bltArgCountPos= bytesWritten;
    recordSize= 2+ 1+ 2+ ( 1+ 1+ 1+ 1 )+ ( 1+ 1+ 1+ 1 );
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_StretchBlt, sos );
    sioEndianPutLeInt32( 0xcc0020, sos );
    sioEndianPutLeInt16( bd->bdPixelsHigh, sos );
    sioEndianPutLeInt16( bd->bdPixelsWide, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( bd->bdPixelsHigh, sos );
    sioEndianPutLeInt16( bd->bdPixelsWide, sos );
    sioEndianPutLeInt16( 0, sos );
    sioEndianPutLeInt16( 0, sos );

    done= bmBmpSaveDib( bd, buffer, bytesWritten+ 2* recordSize, (void *)sos );
    if  ( done < 0 || done % 2 )
	{ LDEB(done); return -1;	}

    recordSize += done/ 2;
    bltArgCount= recordSize;

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( WINMETA_RestoreDC, sos );
    sioEndianPutLeInt16( -1, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    recordSize= 2+ 1;
    sioEndianPutLeInt32( recordSize, sos );
    sioEndianPutLeInt16( 0, sos );

    bytesWritten += 2* recordSize;
    if  ( maxRecordSize < recordSize )
	{ maxRecordSize=  recordSize;	}

    fileSize= bytesWritten;

    if  ( sioOutSeek( sos, headerOffset ) )
	{ LDEB(headerOffset); return -1; }

    sioEndianPutLeInt16( 1, sos );		/*  fileType		*/
    sioEndianPutLeInt16( 9, sos );		/*  headerSize		*/
    sioEndianPutLeInt16( 768, sos );		/*  windowsVersion	*/
    sioEndianPutLeInt32( fileSize, sos );	/*  fileSize		*/
    sioEndianPutLeInt16( 0, sos );		/*  objectCount		*/
    sioEndianPutLeInt32( maxRecordSize, sos );	/*  maxRecordSize	*/
    sioEndianPutLeInt16( 0, sos );		/*  parameterCount	*/

    if  ( sioOutSeek( sos, bltArgCountPos ) )
	{ LDEB(headerOffset); return -1; }

    sioEndianPutLeInt32( bltArgCount, sos );

    if  ( sioOutSeek( sos, fileSize ) )
	{ LDEB(headerOffset); return -1; }

    return 0;
    }
