/************************************************************************/
/*									*/
/*  Choose a paper format common functionality.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>

#   include	<appGeoString.h>
#   include	<appPaper.h>

#   include	"appPaperChooser.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Update the text widget.						*/
/*									*/
/************************************************************************/

void appPaperChooserShowWidthHeight(	PaperChooser *		pc,
				const DocumentGeometry *	dg,
				int				unitInt )
    {
    char			scratch[50];

    appGeoRectangleToString( scratch,
		    dg->dgPageWideTwips, dg->dgPageHighTwips, unitInt );

    appStringToTextWidget( pc->pcSizeText, scratch );

    return;
    }

/************************************************************************/
/*									*/
/*  Extract a paper size from the Text widget.				*/
/*									*/
/************************************************************************/

int appPaperChooserGetSize(	unsigned int *		pUpdMask,
				PaperChooser *		pc,
				int			unitType,
				DocumentGeometry *	dg )
    {
    char *		s;
    unsigned int	updMask= 0;
    int			wide= dg->dgPageWideTwips;
    int			high= dg->dgPageHighTwips;

    s= appGetStringFromTextWidget( pc->pcSizeText );

    if  ( appGeoRectangleFromString( s, unitType, &wide, &high )	||
	  wide <= 0							||
	  high <= 0							)
	{
	appFreeStringFromTextWidget( s );

	appRefuseTextValue( pc->pcSizeText );

	return -1;
	}

    appFreeStringFromTextWidget( s );

    if  ( dg->dgPageWideTwips != wide )
	{ dg->dgPageWideTwips=   wide; updMask |= DGupdPAGE_WIDTH;	}
    if  ( dg->dgPageHighTwips != high )
	{ dg->dgPageHighTwips=   high; updMask |= DGupdPAGE_HEIGHT;	}

    *pUpdMask= updMask;

    return 0;
    }


/************************************************************************/
/*									*/
/*  Fill the list of paper sizes.					*/
/*									*/
/************************************************************************/

void appPaperChooserFillMenu(	PaperChooser *		pc,
				const char *		customLabel,
				APP_BUTTON_CALLBACK	callback,
				void *			through )
    {
    const char *	label;
    int			i;
    int			gotSome= 0;

    if  ( ! pc->pcSizeOptions )
	{
	i= 0;
	while( ! appPaperGetInformation( i, (int *)0, (int *)0, &label ) )
	    { i++; }

	pc->pcCustomPaperSize= i++;
	pc->pcSizeOptionCount= i;

	pc->pcSizeOptions= realloc( pc->pcSizeOptions,
				pc->pcSizeOptionCount* sizeof(APP_WIDGET) );
	if  ( ! pc->pcSizeOptions )
	    { LXDEB(pc->pcSizeOptionCount,pc->pcSizeOptions); return;	}

	for ( i= 0; i < pc->pcSizeOptionCount; i++ )
	    { pc->pcSizeOptions[i]= (APP_WIDGET)0;	}
	}

    appEmptyOptionmenu( &(pc->pcOptionmenu) );

    i= 0;
    while( ! appPaperGetInformation( i, (int *)0, (int *)0, &label ) )
	{
	pc->pcSizeOptions[i]= appAddItemToOptionmenu( &(pc->pcOptionmenu),
					label, callback, through );

	if  ( i == 0 )
	    { gotSome= 1;	}

	i++;
	}

    pc->pcSizeOptions[i]= appAddItemToOptionmenu( &(pc->pcOptionmenu),
					    customLabel, callback, through );
    if  ( i == 0 )
	{ gotSome= 1;	}

    if  ( gotSome )
	{
	appSetOptionmenu( &(pc->pcOptionmenu), 0 );
	pc->pcSizeChosen= 0;
	}
    else{
	appSetOptionmenu( &(pc->pcOptionmenu), -1 );
	}

    appOptionmenuRefreshWidth( &(pc->pcOptionmenu) );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt to geometry.							*/
/*									*/
/************************************************************************/

void appPaperChooserAdaptToGeometry(	PaperChooser *		pc,
					int			unitType,
					const DocumentGeometry * dg,
					int			set )
    {
    int		i;

    appPaperChooserShowWidthHeight( pc, dg, unitType );

    if  ( dg->dgPageWideTwips > dg->dgPageHighTwips )
	{
	i= appPaperGetBySize( dg->dgPageHighTwips, dg->dgPageWideTwips );

	pc->pcLandscapeChosen= 1;
	}
    else{
	i= appPaperGetBySize( dg->dgPageWideTwips, dg->dgPageHighTwips );

	pc->pcLandscapeChosen= 0;
	}

    if  ( i < 0 )
	{ i= pc->pcCustomPaperSize;	}

    pc->pcSizeChosen= i;

    appSetOptionmenu( &(pc->pcOptionmenu), pc->pcSizeChosen );

    if  ( pc->pcPortraitRadio && pc->pcLandscapeRadio )
	{ appPageToolShowOrientation( pc );	}

    if  ( set )
	{
	pc->pcLandscapeChosen= pc->pcLandscapeSet;
	pc->pcSizeChosen= pc->pcSizeSet;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  A paper size was chosen in the menu. As far as the paper chooser	*/
/*  is concerned no more needs to be done.				*/
/*									*/
/************************************************************************/

void appPaperSizeChosen(		APP_WIDGET		w,
					PaperChooser *		pc,
					DocumentGeometry *	dg,
					int			unitType )
    {
    int			i= -1;

    int			width;
    int			height;

    for ( i= 0; i < pc->pcSizeOptionCount; i++ )
	{
	if  ( w == pc->pcSizeOptions[i] )
	    { break;	}
	}

    if  ( i < 0 || i >= pc->pcSizeOptionCount )
	{ LLDEB(i,pc->pcSizeOptionCount); return;	}

    pc->pcSizeChosen= i;

    if  ( i == pc->pcCustomPaperSize )
	{
	unsigned		updMask= 0;
	DocumentGeometry	dgScratch;

	if  ( appPaperChooserGetSize( &updMask, pc, unitType, &dgScratch ) )
	    { LDEB(1); return;	}

	width= dgScratch.dgPageWideTwips;
	height= dgScratch.dgPageHighTwips;

	if  ( width > height )
	    { pc->pcLandscapeChosen= 1;	}
	else{ pc->pcLandscapeChosen= 0;	}
	}
    else{
	if  ( appPaperGetInformation( i, &width, &height, (const char **)0 ) )
	    { return;	}

	if  ( pc->pcLandscapeChosen )
	    {
	    int		swap;

	    swap= height; height= width; width= swap;
	    }
	}

    dg->dgPageWideTwips= width;
    dg->dgPageHighTwips= height;

    appPaperChooserShowWidthHeight( pc, dg, unitType );

    return;
    }

/************************************************************************/
/*									*/
/*  The paper size in the text field was activated by the user. As far	*/
/*  as the paper chooser is concerned no more needs to be done.		*/
/*									*/
/************************************************************************/

void appPaperSizeChanged(		PaperChooser *		pc,
					DocumentGeometry *	dg,
					int			unitType )
    {
    DocumentGeometry	dgScratch;
    unsigned int	updMask;

    dgScratch= *dg;

    if  ( appPaperChooserGetSize( &updMask, pc, unitType, &dgScratch ) )
	{ LDEB(1); return;	}

    if  ( pc->pcLandscapeChosen )
	{
	dg->dgPageWideTwips= dgScratch.dgPageHighTwips;
	dg->dgPageHighTwips= dgScratch.dgPageWideTwips;
	}
    else{
	dg->dgPageWideTwips= dgScratch.dgPageWideTwips;
	dg->dgPageHighTwips= dgScratch.dgPageHighTwips;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Show the orientation in the radiogroup.				*/
/*									*/
/************************************************************************/

void appPageToolShowOrientation(	PaperChooser *	pc )
    {
    if  ( ! pc->pcPortraitRadio || ! pc->pcLandscapeRadio )
	{ XXDEB(pc->pcPortraitRadio,pc->pcLandscapeRadio); return;	}

    if  ( pc->pcLandscapeChosen )
	{
	appGuiSetToggleState( pc->pcPortraitRadio,  0 );
	appGuiSetToggleState( pc->pcLandscapeRadio, 1 );
	}
    else{
	appGuiSetToggleState( pc->pcPortraitRadio,  1 );
	appGuiSetToggleState( pc->pcLandscapeRadio, 0 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make the widgets for a paper chooser.				*/
/*									*/
/************************************************************************/

void appMakePaperChooserWidgets(	APP_WIDGET		parent,
					const char *		title,
					PaperChooser *		pc,
					APP_TEXT_ACTIVATE_CALLBACK
								changedCallback,
					void *			through )
    {
    const int	textEnabled= 1;

    appMakeColumnFrameInColumn( &(pc->pcFrame),
				    &(pc->pcVerticalColumn), parent, title );


    appMakeOptionmenuInColumn( &(pc->pcOptionmenu), pc->pcVerticalColumn );

    appMakeTextInColumn( &(pc->pcSizeText), pc->pcVerticalColumn,
							    0, textEnabled );

    appGuiSetGotValueCallbackForText( pc->pcSizeText,
						changedCallback, through );
    
    return;
    }

/************************************************************************/
/*									*/
/*  Add Portrait/Landscape toggles to a paper chooser.			*/
/*									*/
/************************************************************************/

void appPaperChooserAddOrientationToggles( PaperChooser *	pc,
					const char *		portrait,
					const char *		landscape,
					APP_TOGGLE_CALLBACK	callback,
					void *			through )
    {
    const int	heightResizable= 0;

    pc->pcOrientationRow= appMakeRowInColumn( pc->pcVerticalColumn, 2,
							    heightResizable );

    pc->pcPortraitRadio= appMakeToggleInRow( pc->pcOrientationRow,
					    portrait, callback, through, 0 );

    pc->pcLandscapeRadio= appMakeToggleInRow( pc->pcOrientationRow,
					    landscape, callback, through, 1 );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the orientation toggles was activated. As far as the paper	*/
/*  chooser is concerned no more needs to be done.			*/
/*									*/
/*  The contorted logic of this function is dictated by the fact that	*/
/*  GTK invokes callbacks for programmatic changes to the toggle	*/
/*  buttons. This is a curse we have to live with.			*/
/*									*/
/************************************************************************/

void appPaperOrientationChosen(		APP_WIDGET		w,
					void *			voidtbcs,
					int *			pChanged,
					PaperChooser *		pc,
					int			unitType,
					DocumentGeometry *	dg )
    {
    int			change= 0;
    int			set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    if  ( w == pc->pcPortraitRadio )
	{
	if  ( pc->pcLandscapeChosen )
	    {
	    if  ( set )
		{
		pc->pcLandscapeChosen= 0;
		appGuiSetToggleState( pc->pcLandscapeRadio, 0 );
		change= 1;
		}
	    }
	else{
	    if  ( ! set )
		{ appGuiSetToggleState( pc->pcPortraitRadio, 1 );	}
	    }
	}

    if  ( w == pc->pcLandscapeRadio )
	{
	if  ( pc->pcLandscapeChosen )
	    {
	    if  ( ! set )
		{ appGuiSetToggleState( pc->pcLandscapeRadio, 1 );	}
	    }
	else{
	    if  ( set )
		{
		pc->pcLandscapeChosen= 1;
		appGuiSetToggleState( pc->pcPortraitRadio, 0 );
		change= 1;
		}
	    }
	}

    if  ( change )
	{
	int	swap;

	swap= dg->dgPageWideTwips;
	dg->dgPageWideTwips= dg->dgPageHighTwips;
	dg->dgPageHighTwips= swap;

	appPaperChooserShowWidthHeight( pc, dg, unitType );
	}

    *pChanged= change; return;
    }

/************************************************************************/
/*									*/
/*  Initialize a fresh PaperChooser.					*/
/*									*/
/************************************************************************/

void appCleanPaperChooser(	PaperChooser *	pc )
    {
    if  ( pc->pcSizeOptions )
	{ free( pc->pcSizeOptions );	}
    }

void appInitPaperChooser(	PaperChooser *	pc )
    {
    pc->pcFrame= (APP_WIDGET)0;
    pc->pcVerticalColumn= (APP_WIDGET)0;

    pc->pcSizeText= (APP_WIDGET)0;

    pc->pcOrientationRow= (APP_WIDGET)0;
    pc->pcPortraitRadio= (APP_WIDGET)0;
    pc->pcLandscapeRadio= (APP_WIDGET)0;

    pc->pcCustomPaperSize= -1;
    pc->pcSizeChosen= -1;
    pc->pcSizeSet= -1;
    pc->pcLandscapeChosen= 0;
    pc->pcLandscapeSet= 0;

    pc->pcSizeOptions= (APP_WIDGET *)0;
    pc->pcSizeOptionCount= 0;

    return;
    }
