#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	"appFrame.h"
#   include	"appSystem.h"
#   include	<appGeoString.h>

#   ifdef USE_MOTIF

#   include	<X11/IntrinsicP.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/PushB.h>
#   include	<Xm/PushBG.h>
#   include	<Xm/PanedW.h>

/************************************************************************/
/*									*/
/*  Get around Motif's ridiculous resize behavior.			*/
/*									*/
/************************************************************************/

void appOptionmenuSetWidthMotif(	Widget		menu,
					int		newWidth )
    {
    Dimension		marginWidth= 0;

    Widget		pulldown;
    Widget		buttonGadget;

    XtWidgetGeometry	xwg;

    XtVaGetValues( XtParent( menu ),
			XmNmarginWidth,		&marginWidth,
			NULL );

    XtVaGetValues( menu,
			XmNsubMenuId,		&pulldown,
			NULL );

    XtVaSetValues( pulldown,
			XmNwidth,		newWidth-
						2* marginWidth,
			NULL );

    buttonGadget= XmOptionButtonGadget( menu );

    XtQueryGeometry( buttonGadget, NULL, &xwg );

    XtResizeWidget( buttonGadget, newWidth, xwg.height, xwg.border_width );

    return;
    }

void appOptionmenuRefreshWidth(	AppOptionmenu *		aom )
    {
    Dimension		width;

    XtVaGetValues( aom->aomInplace,
			    XmNwidth,		&width,
			    NULL );

    appOptionmenuSetWidthMotif( aom->aomInplace, width );

    return;
    }

void appPixmapOptionmenuSetButtonMargins(	AppOptionmenu *	aom )
    {
    Display *		display= XtDisplay( aom->aomInplace );
    int			screen= DefaultScreen( display );
    int			depth= DefaultDepth( display, screen );

    Widget		buttonGadget;

    APP_BITMAP_IMAGE	pixmap;

    pixmap= XCreatePixmap( display, XtWindow( aom->aomInplace ), 1, 1, depth );

    buttonGadget= XmOptionButtonGadget( aom->aomInplace );
    XtVaSetValues( buttonGadget,
			XmNcascadePixmap,	pixmap,
			XmNmarginRight,		0,
			XmNmarginTop,		0,
			XmNmarginBottom,	2,
			XmNmarginHeight,	2,
			XmNmarginRight,		0,
			NULL );
    return;
    }

/************************************************************************/
/*									*/
/*  Make a pulldown that is usable as a child of a form.		*/
/*									*/
/************************************************************************/

static void appMenuConfigure(	Widget		w,
				void *		through,
				XEvent *	event,
				Boolean *	pRefused )
    {
    XConfigureEvent *		cevent= &(event->xconfigure);

    if  ( cevent->type != ConfigureNotify )
	{ return;	}

    appOptionmenuSetWidthMotif( w, cevent->width );

    *pRefused= 1;

    return;
    }

void appMakeOptionmenuInColumn(		AppOptionmenu *	aom,
					Widget		column )
    {
    Widget			pulldown;
    Widget			menu;

    Widget			labelGadget;
    Widget			buttonGadget;

    Arg				al[20];
    int				ac= 0;

    ac= 0;
    XtSetArg( al[ac], XmNresizeWidth,		False ); ac++;
    XtSetArg( al[ac], XmNskipAdjust,		True ); ac++;

    pulldown= XmCreatePulldownMenu( column, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac], XmNsubMenuId,		pulldown ); ac++;

    XtSetArg( al[ac], XmNmarginHeight,		0 ); ac++;
    XtSetArg( al[ac], XmNmarginWidth,		0 ); ac++;
    XtSetArg( al[ac], XmNspacing,		0 ); ac++;
    XtSetArg( al[ac], XmNskipAdjust,		True ); ac++;
    XtSetArg( al[ac], XmNallowResize,		True ); ac++;
    XtSetArg( al[ac], XmNresizeHeight,		True ); ac++;

    menu= XmCreateOptionMenu( column, WIDGET_NAME, al, ac );
    XtAddEventHandler( menu, StructureNotifyMask, False,
					appMenuConfigure, (void *)0 );

    labelGadget= XmOptionLabelGadget( menu );
    buttonGadget= XmOptionButtonGadget( menu );

    XtUnmanageChild( labelGadget );
    XtManageChild( buttonGadget );

    XtVaSetValues( buttonGadget,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			NULL );

    XtManageChild( menu );

    appMotifTurnOfSashTraversal( column );

    aom->aomPulldown= pulldown; aom->aomInplace= menu; return;
    }

void appMakeOptionmenuInRow(		AppOptionmenu *	aom,
					Widget		row,
					int		column,
					int		colspan )
    {
    Widget			pulldown;
    Widget			menu;

    Widget			labelGadget;
    Widget			buttonGadget;

    Arg				al[20];
    int				ac= 0;

    ac= 0;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNtopOffset,		0 ); ac++;

    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		column ); ac++;

    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		column+ colspan ); ac++;

    XtSetArg( al[ac], XmNresizeWidth,		False ); ac++;

    pulldown= XmCreatePulldownMenu( row, WIDGET_NAME, al, ac );

    ac= 0;
    XtSetArg( al[ac], XmNtopAttachment,		XmATTACH_FORM ); ac++;
    XtSetArg( al[ac], XmNtopOffset,		0 ); ac++;

    XtSetArg( al[ac], XmNleftAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNleftPosition,		column ); ac++;

    XtSetArg( al[ac], XmNrightAttachment,	XmATTACH_POSITION ); ac++;
    XtSetArg( al[ac], XmNrightPosition,		column+ colspan ); ac++;

    XtSetArg( al[ac], XmNsubMenuId,		pulldown ); ac++;

    XtSetArg( al[ac], XmNmarginHeight,		0 ); ac++;
    XtSetArg( al[ac], XmNmarginWidth,		0 ); ac++;
    XtSetArg( al[ac], XmNspacing,		0 ); ac++;

    menu= XmCreateOptionMenu( row, WIDGET_NAME, al, ac );
    XtAddEventHandler( menu, StructureNotifyMask, False,
					appMenuConfigure, (void *)0 );

    labelGadget= XmOptionLabelGadget( menu );
    buttonGadget= XmOptionButtonGadget( menu );

    XtUnmanageChild( labelGadget );
    XtManageChild( buttonGadget );

    XtVaSetValues( buttonGadget,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			NULL );

    XtManageChild( menu );

    aom->aomPulldown= pulldown; aom->aomInplace= menu; return;
    }

/************************************************************************/
/*									*/
/*  Add an option to a pulldown.					*/
/*									*/
/************************************************************************/

APP_WIDGET appAddItemToOptionmenu(	AppOptionmenu *		aom,
					const char *		label,
					XtCallbackProc		callBack,
					void *			target )
    {
    Widget	fresh;

    fresh= XmCreatePushButtonGadget( aom->aomPulldown,
						    (char *)label, NULL, 0 );

    if  ( callBack )
	{ XtAddCallback( fresh, XmNactivateCallback, callBack, target ); }

    XtManageChild( fresh );

    return fresh;
    }

APP_WIDGET appAddPixmapItemToOptionmenu( AppOptionmenu *	aom,
					XtCallbackProc		callBack,
					void *			target )
    {
    Widget	fresh;

    Arg		al[20];
    int		ac= 0;

    XtSetArg( al[ac], XmNlabelType,		XmPIXMAP ); ac++;
    XtSetArg( al[ac], XmNlabelPixmap,	XmUNSPECIFIED_PIXMAP ); ac++;

    fresh= XmCreatePushButton( aom->aomPulldown, WIDGET_NAME, al, ac );

    if  ( callBack )
	{ XtAddCallback( fresh, XmNactivateCallback, callBack, target ); }

    XtManageChild( fresh );

    return fresh;
    }

/************************************************************************/
/*									*/
/*  Select a particular option in an option menu.			*/
/*									*/
/************************************************************************/

void appSetOptionmenu(	AppOptionmenu *	aom,
			int		num )
    {
    WidgetList		children;
    Cardinal		childCount= 0;

    XtVaGetValues( aom->aomPulldown,
		    XmNchildren,	&children,
		    XmNnumChildren,	&childCount,
		    NULL );

    if  ( num >= 0 && num < (int)childCount )
	{
	XtVaSetValues( aom->aomInplace,
			XmNmenuHistory,	children[num],
			NULL );
	}
    else{
	XtVaSetValues( aom->aomInplace,
			XmNmenuHistory,	(Widget)0,
			NULL );
	}

    return;
    }

void appEmptyOptionmenu(	AppOptionmenu *		aom )
    {
    appEmptyParentWidget( aom->aomPulldown );
    }

void appGuiEnableOptionmenu(	AppOptionmenu *		aom,
				int			sensitive )
    {
    XtSetSensitive( aom->aomInplace, sensitive != 0 );
    }

void appInitOptionmenu(		AppOptionmenu *		aom )
    {
    aom->aomPulldown= (APP_WIDGET)0;
    aom->aomInplace= (APP_WIDGET)0;
    }
#   endif
