/************************************************************************/
/*									*/
/*  A Page Layout tool.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	<appFrame.h>
#   include	"appMarginTool.h"

/************************************************************************/
/*									*/
/*  Show the size of the paper in the Text.				*/
/*									*/
/************************************************************************/

void appMarginToolShowMargins(	AppMarginTool *			amt,
				int				unitInt,
				const DocumentGeometry *	dg )
    {
    char			scratch[50];

    appGeoLengthToString( scratch, dg->dgLeftMarginTwips, unitInt );
    appStringToTextWidget( amt->amtLeftMarginText, scratch );

    appGeoLengthToString( scratch, dg->dgTopMarginTwips, unitInt );
    appStringToTextWidget( amt->amtTopMarginText, scratch );

    appGeoLengthToString( scratch, dg->dgRightMarginTwips, unitInt );
    appStringToTextWidget( amt->amtRightMarginText, scratch );

    appGeoLengthToString( scratch, dg->dgBottomMarginTwips, unitInt );
    appStringToTextWidget( amt->amtBottomMarginText, scratch );

    return;
    }

/************************************************************************/
/*									*/
/*  Get one/all margins from the text widgets.				*/
/*									*/
/************************************************************************/

int appMarginToolGetMargins(	unsigned int *		pUpdMask,
				unsigned int		chgMask,
				int			unitType,
				AppMarginTool *		amt,
				DocumentGeometry *	dg )
    {
    int			changed;
    const int		requirePositive= 1;
    unsigned int	updMask= 0;

    if  ( chgMask & DGupdLEFT_MARGIN )
	{
	if  ( appGetLengthFromTextWidget( amt->amtLeftMarginText,
				    &dg->dgLeftMarginTwips, &changed,
				    unitType, requirePositive ) )
	    { return -1;	}
	if  ( changed )
	    { updMask |= DGupdLEFT_MARGIN;	}
	}

    if  ( chgMask & DGupdTOP_MARGIN )
	{
	if  ( appGetLengthFromTextWidget( amt->amtTopMarginText,
				    &dg->dgTopMarginTwips, &changed,
				    unitType, requirePositive ) )
	    { return -1;	}
	if  ( changed )
	    { updMask |= DGupdTOP_MARGIN;	}
	}

    if  ( chgMask & DGupdRIGHT_MARGIN )
	{
	if  ( appGetLengthFromTextWidget( amt->amtRightMarginText,
				    &dg->dgRightMarginTwips, &changed,
				    unitType, requirePositive ) )
	    { return -1;	}
	if  ( changed )
	    { updMask |= DGupdRIGHT_MARGIN;	}
	}

    if  ( chgMask & DGupdBOTTOM_MARGIN )
	{
	if  ( appGetLengthFromTextWidget( amt->amtBottomMarginText,
				    &dg->dgBottomMarginTwips, &changed,
				    unitType, requirePositive ) )
	    { return -1;	}
	if  ( changed )
	    { updMask |= DGupdBOTTOM_MARGIN;	}
	}

    *pUpdMask= updMask; return 0;
    }

/************************************************************************/
/*									*/
/*  Check margins.							*/
/*									*/
/************************************************************************/

int appMarginToolCheckMargins(	const DocumentGeometry * dg )
    {
    if  ( dg->dgLeftMarginTwips+ dg->dgRightMarginTwips >= 
						    dg->dgPageWideTwips )
	{ return -1;	}

    if  ( dg->dgTopMarginTwips+ dg->dgBottomMarginTwips >= 
						    dg->dgPageWideTwips )
	{ return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Make the frame for the margins.					*/
/*									*/
/************************************************************************/

void appMakeMarginToolWidgets(	APP_WIDGET		parent,
				const MarginToolResources * mtr,
				AppMarginTool *		amt,
				APP_TEXT_ACTIVATE_CALLBACK	changed,
				void *			through )
    {
    APP_WIDGET	label;
    APP_WIDGET	row;

    const int	textWidth= 7;
    const int	textEnabled= 1;

    appMakeRowFrameInColumn( &(amt->amtMarginFrame), &(amt->amtInsideWidget),
					    parent, 2, mtr->mtrTitleText );

    appMakeColumnInRow( &(amt->amtLeftColumn), amt->amtInsideWidget, 0 );
    appMakeColumnInRow( &(amt->amtRightColumn), amt->amtInsideWidget, 1 );

    /**********************/

    appMakeLabelAndTextRow( &row, &label, &(amt->amtLeftMarginText),
				amt->amtLeftColumn, mtr->mtrLeftMarginText,
				textWidth, textEnabled );
    appMakeLabelAndTextRow( &row, &label, &(amt->amtRightMarginText),
				amt->amtLeftColumn, mtr->mtrRightMarginText,
				textWidth, textEnabled );

    appMakeLabelAndTextRow( &row, &label, &(amt->amtTopMarginText),
				amt->amtRightColumn, mtr->mtrTopMarginText,
				textWidth, textEnabled );
    appMakeLabelAndTextRow( &row, &label, &(amt->amtBottomMarginText),
				amt->amtRightColumn, mtr->mtrBottomMarginText,
				textWidth, textEnabled );

    if  ( changed )
	{
	appGuiSetGotValueCallbackForText( amt->amtLeftMarginText,
							changed, through );

	appGuiSetGotValueCallbackForText( amt->amtTopMarginText,
							changed, through );

	appGuiSetGotValueCallbackForText( amt->amtRightMarginText,
							changed, through );

	appGuiSetGotValueCallbackForText( amt->amtBottomMarginText,
							changed, through );
	}

    return;
    }
