/************************************************************************/
/*									*/
/*  Primitives for the page on a page layout tool etc.			*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<appDebugon.h>

#   include	<appFrame.h>
#   include	"appUnit.h"
#   include	<appGeoString.h>
#   include	<appPs.h>

/************************************************************************/
/*									*/
/*  Draw a text like pattern between some margins.			*/
/*									*/
/************************************************************************/

static void appDrawTextPattern(	AppDrawingData *		add,
				int				numX1,
				int				numY1,
				int				textX0,
				int				textX1,
				int				textY0,
				int				textY1 )
    {
    int			y;

    y= textY0+ 2;
    while( y < textY1- 1 )
	{
	int	x;
	int	c;

	if  ( y <= numY1 )
	    { x= numX1+ 1;	}
	else{ x= textX0+ 1;	}

	c= (int)( 5+ (75.0* rand() )/ (RAND_MAX+ 1.0 ) );

	while( c > 0 )
	    {
	    int	l;

	    l= (int) ( (1.0* (textX1- textX0)* rand() )/ (RAND_MAX+ 1.0 ) );
	    l= 2+ l/10;

	    if  ( x+ l >= textX1- 1 )
		{
		y += 2;

		if  ( y <= numY1 )
		    { x= numX1+ 1;	}
		else{ x= textX0+ 1;	}

		if  ( y >= textY1- 1 )
		    { break;	}
		}

	    appDrawDrawRectangle( add, x, y, l, 0 );

	    x += l+ 2; c--;
	    }

	y += 4;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Draw the margins of a page.						*/
/*									*/
/************************************************************************/

static void appDrawTextPage(	AppDrawingData *		add,
				int				textX0,
				int				textX1,
				int				textY0,
				int				textY1 )
    {
    appDrawSetForegroundColor( add, &(add->addBackColor) );
    appDrawDrawRectangle( add,
	    textX0- 1, textY0- 1, textX1- textX0+ 1, textY1- textY0+ 1 );

    appDrawSetForegroundBlack( add );
    appDrawTextPattern( add, textX0, textY0,
				    textX0, textX1, textY0, textY1 );

    return;
    }

static void appDrawNupTextPage(	AppDrawingData *		add,
				APP_FONT *			xfs,
				const char *			label,
				int				textX0,
				int				textX1,
				int				textY0,
				int				textY1 )
    {
    if  ( xfs )
	{
	int				numWide;
	int				numHigh;

	int				l= strlen( label );
	int				fontAscent;
	int				fontDescent;

	appDrawTextExtents( &numWide, &fontAscent, &fontDescent,
						    add, xfs, label, l );

	numHigh= fontAscent+ fontDescent;

	appDrawSetForegroundColor( add, &(add->addBackColor) );
	appDrawDrawRectangle( add,
		textX0- 1, textY0- 1, textX1- textX0+ 1, textY1- textY0+ 1 );

	appDrawSetForegroundBlack( add );


	appDrawDrawString( add, textX0+ 2, textY0+ fontAscent+ 3,
								label, l );

	appDrawTextPattern( add, textX0+ numWide+ 2, textY0+ numHigh+ 2,
				    textX0, textX1, textY0, textY1 );
	}
    else{
	appDrawTextPage( add, textX0, textX1, textY0, textY1 );

	}
    }

/************************************************************************/
/*									*/
/*  Draw the plane of the sheet of paper.				*/
/*									*/
/************************************************************************/

static void appDrawPageSheet(	int				sheetX0,
				int				sheetX1,
				int				sheetY0,
				int				sheetY1,
				AppDrawingData *		add )
    {
    appDrawSetForegroundWhite( add );
    appDrawFillRectangle( add, sheetX0, sheetY0,
					sheetX1- sheetX0, sheetY1- sheetY0 );

    appDrawSetForegroundBlack( add );
    appDrawDrawRectangle( add, sheetX0- 1, sheetY0- 1,
					sheetX1- sheetX0, sheetY1- sheetY0 );

    return;
    }

/************************************************************************/
/*									*/
/*  Draw a schematic view of a page.					*/
/*									*/
/*  1)  Perform calculations relative to the centre, to avoid assymetry	*/
/*	from rounding when margins are identical.			*/
/*									*/
/************************************************************************/

void appDrawPageDiagram(	APP_WIDGET			w,
				AppDrawingData *		add,
				double				widgetHighMm,
				const DocumentGeometry *	dg )
    {
    int				wide;
    int				high;
    double			fac;

    int				sheetX0;
    int				sheetX1;
    int				sheetY0;
    int				sheetY1;

    int				pageWidePixels;
    int				pageHighPixels;

    int				textX0;
    int				textX1;
    int				textY0;
    int				textY1;

    appDrawGetSizeOfWidget( &wide, &high, w );

    appDrawSetForegroundColor( add, &(add->addBackColor) );
    appDrawFillRectangle( add, 0, 0, wide, high );

    fac= ( 2.54* high )/( widgetHighMm* 20.0* 72.27 );

    pageWidePixels= fac* dg->dgPageWideTwips;
    pageHighPixels= fac* dg->dgPageHighTwips;

    sheetX0= wide/2- ( pageWidePixels/ 2 );
    sheetY0= high/2- ( pageHighPixels/ 2 );
    sheetX1= wide/2+ ( pageWidePixels/ 2 );
    sheetY1= high/2+ ( pageHighPixels/ 2 );

    appDrawPageSheet( sheetX0, sheetX1, sheetY0, sheetY1, add );

    /*  1  */
    textX0= wide/2- fac* ( dg->dgPageWideTwips/2- dg->dgLeftMarginTwips );
    textX1= wide/2+ fac* ( dg->dgPageWideTwips/2- dg->dgRightMarginTwips );
    textY0= high/2- fac* ( dg->dgPageHighTwips/2- dg->dgTopMarginTwips );
    textY1= high/2+ fac* ( dg->dgPageHighTwips/2- dg->dgBottomMarginTwips );

    appDrawTextPage( add, textX0, textX1, textY0, textY1 );

    return;
    }

/************************************************************************/
/*									*/
/*  Draw a schematic view of the distribution of pages on a sheet of	*/
/*  paper.								*/
/*									*/
/*  1)  When no scaling or moving is required: Use appDrawPageDiagram()	*/
/*	saves work, and is more focused at looking nice.		*/
/*									*/
/************************************************************************/

void appDrawNupDiagram(		APP_WIDGET			w,
				AppDrawingData *		add,
				APP_FONT *			xfs,
				double				widgetHighMm,
				const DocumentGeometry *	dgSheet,
				const DocumentGeometry *	dgPage,
				int				nup,
				int				horizontal )
    {
    int				wide= 0;
    int				high= 0;
    double			fac;

    int				sheetX0;
    int				sheetX1;
    int				sheetY0;
    int				sheetY1;

    int				pageWidePixels;
    int				pageHighPixels;

    int				textX0;
    int				textX1;
    int				textY0;
    int				textY1;

    double			nupFac;
    int				rotate;
    int				yshift;

    int				textWideTwips;
    int				textHighTwips;

    /*  1  */
    if  ( nup == 1						&&
	  dgSheet->dgPageWideTwips == dgPage->dgPageWideTwips	&&
	  dgSheet->dgPageHighTwips == dgPage->dgPageHighTwips	)
	{ appDrawPageDiagram( w, add, widgetHighMm, dgPage ); return;	}

    appDrawGetSizeOfWidget( &wide, &high, w );

    appDrawSetForegroundColor( add, &(add->addBackColor) );
    appDrawFillRectangle( add, 0, 0, wide, high );

    fac= ( 2.54* high )/( widgetHighMm* 20.0* 72.27 );

    pageWidePixels= fac* dgSheet->dgPageWideTwips;
    pageHighPixels= fac* dgSheet->dgPageHighTwips;

    if  ( appPsGetNupFactor( &nupFac, &rotate, &yshift,
					dgPage, dgSheet, nup, horizontal ) )
	{ LDEB(nup); return;	}

    if  ( rotate )
	{
	sheetX0= wide/2- ( pageHighPixels/ 2 );
	sheetY0= high/2- ( pageWidePixels/ 2 );
	sheetX1= wide/2+ ( pageHighPixels/ 2 );
	sheetY1= high/2+ ( pageWidePixels/ 2 );
	}
    else{
	sheetX0= wide/2- ( pageWidePixels/ 2 );
	sheetY0= high/2- ( pageHighPixels/ 2 );
	sheetX1= wide/2+ ( pageWidePixels/ 2 );
	sheetY1= high/2+ ( pageHighPixels/ 2 );
	}

    appDrawPageSheet( sheetX0, sheetX1, sheetY0, sheetY1, add );

    textWideTwips= dgPage->dgPageWideTwips-
				dgPage->dgLeftMarginTwips-
				dgPage->dgRightMarginTwips;
    textHighTwips= dgPage->dgPageHighTwips-
				dgPage->dgTopMarginTwips-
				dgPage->dgBottomMarginTwips;

    if  ( nup == 1 )
	{
	textX0= sheetX0+ fac* nupFac* dgPage->dgLeftMarginTwips;
	textY0= sheetY0+ fac* nupFac* dgPage->dgTopMarginTwips;

	textX1= textX0+ fac* nupFac* textWideTwips;
	textY1= textY0+ fac* nupFac* textHighTwips;

	appDrawTextPage( add, textX0, textX1, textY0, textY1 );

	return;
	}

    if  ( nup == 2 )
	{
	/*  p 1 */
	textX0= sheetX0+ fac* nupFac* dgPage->dgLeftMarginTwips;
	textY0= sheetY0+ fac* nupFac* dgPage->dgTopMarginTwips;

	textX1= textX0+ fac* nupFac* textWideTwips;
	textY1= textY0+ fac* nupFac* textHighTwips;

	appDrawNupTextPage( add, xfs,
			"1", textX0, textX1, textY0, textY1 );

	/*  p 2 */
	textX0= sheetX0+ fac* nupFac* dgPage->dgLeftMarginTwips;
	textY0= sheetY0+ fac* nupFac* dgPage->dgTopMarginTwips;

	if  ( rotate )
	    { textX0 += pageHighPixels/ 2;	}
	else{ textY0 += pageHighPixels/ 2;	}

	textX1= textX0+ fac* nupFac* textWideTwips;
	textY1= textY0+ fac* nupFac* textHighTwips;

	appDrawNupTextPage( add, xfs,
			"2", textX0, textX1, textY0, textY1 );

	return;
	}

    if  ( nup == 4 )
	{
	/*  p 1 */
	textX0= sheetX0+ fac* nupFac* dgPage->dgLeftMarginTwips;
	textY0= sheetY0+ fac* nupFac* dgPage->dgTopMarginTwips;

	textX1= textX0+ fac* nupFac* textWideTwips;
	textY1= textY0+ fac* nupFac* textHighTwips;

	appDrawNupTextPage( add, xfs,
			"1", textX0, textX1, textY0, textY1 );

	/*  p 2 */
	textX0= sheetX0+ fac* nupFac* dgPage->dgLeftMarginTwips;
	textY0= sheetY0+ fac* nupFac* dgPage->dgTopMarginTwips;

	if  ( rotate )
	    {
	    if  ( horizontal )
		{ textX0 += pageHighPixels/ 2;	}
	    else{ textY0 += pageWidePixels/ 2;	}
	    }
	else{
	    if  ( horizontal )
		{ textX0 += pageWidePixels/ 2;	}
	    else{ textY0 += pageHighPixels/ 2;	}
	    }

	textX1= textX0+ fac* nupFac* textWideTwips;
	textY1= textY0+ fac* nupFac* textHighTwips;

	appDrawNupTextPage( add, xfs,
			"2", textX0, textX1, textY0, textY1 );

	/*  p 3 */
	textX0= sheetX0+ fac* nupFac* dgPage->dgLeftMarginTwips;
	textY0= sheetY0+ fac* nupFac* dgPage->dgTopMarginTwips;

	if  ( rotate )
	    {
	    if  ( horizontal )
		{ textY0 += pageWidePixels/ 2;	}
	    else{ textX0 += pageHighPixels/ 2;	}
	    }
	else{
	    if  ( horizontal )
		{ textY0 += pageHighPixels/ 2;	}
	    else{ textX0 += pageWidePixels/ 2;	}
	    }

	textX1= textX0+ fac* nupFac* textWideTwips;
	textY1= textY0+ fac* nupFac* textHighTwips;

	appDrawNupTextPage( add, xfs,
			"3", textX0, textX1, textY0, textY1 );

	/*  p 4 */
	textX0= sheetX0+ fac* nupFac* dgPage->dgLeftMarginTwips;
	textY0= sheetY0+ fac* nupFac* dgPage->dgTopMarginTwips;

	if  ( rotate )
	    {
	    textX0 += pageHighPixels/ 2;
	    textY0 += pageWidePixels/ 2;
	    }
	else{
	    textX0 += pageWidePixels/ 2;
	    textY0 += pageHighPixels/ 2;
	    }

	textX1= textX0+ fac* nupFac* textWideTwips;
	textY1= textY0+ fac* nupFac* textHighTwips;

	appDrawNupTextPage( add, xfs,
			"4", textX0, textX1, textY0, textY1 );

	return;
	}

    LDEB(nup); return;
    }

/************************************************************************/
/*									*/
/*  Make the location for the schematic drawing of the page.		*/
/*									*/
/************************************************************************/

APP_WIDGET appMakePageDrawing(	APP_WIDGET			parent,
				EditApplication *		ea,
				int				mmHigh,
				APP_EVENT_HANDLER		redraw,
				void *				through )
    {
    APP_WIDGET	drawing;

    double	horPixPerMM;
    double	verPixPerMM;
    double	xfac;
    double	yfac;

    const int	wide= -1;
    const int	heightResizable= 1;
    int		high;

    appGetFactors( ea, &horPixPerMM, &verPixPerMM, &xfac, &yfac );

    high= ( mmHigh* verPixPerMM )+ 0.5;

    appGuiMakeDrawingAreaInColumn( &drawing, parent,
				wide, high, heightResizable, redraw, through );
    return drawing;
    }

