/************************************************************************/
/*									*/
/*  A Shading Tool. (Used on the pages of the format tool).		*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<appDebugon.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Make a ShadingTool.							*/
/*									*/
/************************************************************************/

void tedFormatCleanShadingTool(		ShadingTool *		st )
    {
    return;
    }

void tedFormatMakeShadingTool(		ShadingTool *		st,
					APP_WIDGET *		pRow,
					APP_WIDGET		page,
					const char *		text )
    {
    const int	heightResizable= 0;
    APP_WIDGET	row= appMakeRowInColumn( page, 2, heightResizable );

    appMakeLabelInRow( &(st->stLabel), row, 0, 1, text );

    appMakeOptionmenuInRow( &(st->stStyleOptionmenu), row, 1, 1 );

    /*  Shading Styles are not for 2.9 */
    appGuiEnableOptionmenu( &(st->stStyleOptionmenu), 0 );

    *pRow= row; return;
    }

void tedFormatFillShadingTool(		ShadingTool *		st,
					APP_BUTTON_CALLBACK	callBack,
					void *			target )
    {
    int		i;

    for ( i= 0; i < DOCsp_COUNT; i++ )
	{
	st->stStyleItems[i]= appAddPixmapItemToOptionmenu(
				&(st->stStyleOptionmenu), callBack, target );
	}
    }

/************************************************************************/
/*									*/
/*  Set the pixmap for a shading pattern chooser in a format page.	*/
/*									*/
/************************************************************************/

static APP_BITMAP_IMAGE
tedFormatToolMakeShadingPixmap(		APP_WIDGET		w,
					TedFormatTool *		tft,
					AppDrawingData *	parent_add,
					int			style )
    {
    int			wide;
    int			high;

    int			x0;
    int			x1;
    int			y0;
    int			y1;

    int			x;
    int			y;

    int			d= 1;

    const int		marg= 4;

    APP_BITMAP_IMAGE	pixmap;
    AppDrawingData	add;

    if  ( tft->tftShadingPixmaps[style] )
	{ return tft->tftShadingPixmaps[style];	}

    appDrawGetSizeOfWidget( &wide, &high, w );

    high= 26;

    wide -= 2* marg;
    high -= 2* marg;

    wide -= 2;

    x0= 0; x1= x0+ wide;
    y0= 0; y1= y0+ high;

    pixmap= appMakePixmap( parent_add, wide, high );
    tft->tftShadingPixmaps[style]= pixmap;

    appInitDrawingData( &add );
    appCloneDrawingEnvironment( &add, parent_add,
		    1.0, parent_add->addMagnifiedPixelsPerTwip, pixmap );

    appDrawSetForegroundWhite( &add );
    appDrawFillRectangle( &add, x0, y0, wide, high );

    appDrawSetForegroundBlack( &add );

    switch( style )
	{
	case DOCspSOLID:
	    d= wide; break;

	case DOCspBGHORIZ:
	case DOCspBGVERT:
	case DOCspBGFDIAG:
	case DOCspBGBDIAG:
	case DOCspBGCROSS:
	case DOCspBGDCROSS:
	    d= 6; break;

	case DOCspBGDKHORIZ:
	case DOCspBGDKVERT:
	case DOCspBGDKFDIAG:
	case DOCspBGDKBDIAG:
	case DOCspBGDKCROSS:
	case DOCspBGDKDCROSS:
	    d= 4; break;

	default:
	    LDEB(style);
	    break;
	}

    appDrawDrawLine( &add, x0, y0, x1, y0 );
    appDrawDrawLine( &add, x1-1, y0, x1-1, y1 );
    appDrawDrawLine( &add, x1, y1-1, x0, y1-1 );
    appDrawDrawLine( &add, x0, y1, x0, y0 );

    switch( style )
	{
	case DOCspSOLID:
	    break;

	case DOCspBGHORIZ:
	case DOCspBGDKHORIZ:
	    y= y0;
	    while( y < y1 )
		{ appDrawDrawLine( &add, x0, y, x1, y ); y += d; }
	    break;

	case DOCspBGVERT:
	case DOCspBGDKVERT:
	    x= x0;
	    while( x < x1 )
		{ appDrawDrawLine( &add, x, y0, x, y1 ); x += d; }
	    break;

	case DOCspBGFDIAG:
	case DOCspBGDKFDIAG:
	    x= x0- high;
	    while( x < x1 )
		{ appDrawDrawLine( &add, x, y0, x+ high, y1 ); x += d; }
	    break;

	case DOCspBGBDIAG:
	case DOCspBGDKBDIAG:
	    x= x0- high;
	    while( x < x1 )
		{ appDrawDrawLine( &add, x, y1, x+ high, y0 ); x += d; }
	    break;

	case DOCspBGCROSS:
	case DOCspBGDKCROSS:
	    y= y0;
	    while( y < y1 )
		{ appDrawDrawLine( &add, x0, y, x0, y ); y += d; }
	    x= x0;
	    while( x < x1 )
		{ appDrawDrawLine( &add, x, y0, x, y1 ); x += d; }
	    break;

	case DOCspBGDCROSS:
	case DOCspBGDKDCROSS:
	    x= x0- high;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y0, x+ high, y1 );
		appDrawDrawLine( &add, x, y1, x+ high, y0 );
		x += d;
		}
	    break;

	default:
	    LDEB(style);
	    break;
	}

    appCleanDrawingData( &add );

    return pixmap;
    }

void tedFormatFinishShadingTool(	ShadingTool *		st,
					TedFormatTool *		tft )
    {
    int		i;

    appOptionmenuRefreshWidth( &(st->stStyleOptionmenu) );

    for ( i= 0; i < DOCsp_COUNT; i++ )
	{
	APP_BITMAP_IMAGE	pixmap;

	if  ( ! tft->tftPixmapAddAllocated )
	    {
	    appSetDrawingDataForWidget( st->stStyleItems[i], 1.0,
						    &(tft->tftPixmapAdd) );
	    tft->tftPixmapAddAllocated= 1;
	    }

	pixmap= tedFormatToolMakeShadingPixmap( st->stStyleItems[i], tft,
						    &(tft->tftPixmapAdd), i );

#	ifdef USE_MOTIF
	XtVaSetValues( st->stStyleItems[i],
				    XmNlabelPixmap,		pixmap,
				    NULL );
#	endif
	}

    appPixmapOptionmenuSetButtonMargins( &(st->stStyleOptionmenu) );

    return;
    }
