/************************************************************************/
/*									*/
/*  The Row page of the Format Tool.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the row page.						*/
/*									*/
/************************************************************************/


static void tedFormatToolRefreshRowPage( RowTool *	rt )
    {
    const RowProperties *	rp= &(rt->rtPropertiesChosen);
    const CellProperties *	cp;
    const TableRectangle *	tr= &(rt->rtTableRectangle);
    char			scratch[50];

    appIntegerToTextWidget( rt->rtNumberText, tr->trRow0- tr->trRow00+ 1 );

    tedFormatRefreshHeightChooser( &(rt->rtHeightChooser),
							rp->rpHeightTwips );

    appGeoLengthToString( scratch, rp->rpHalfGapWidthTwips, UNITtyPOINTS );
    appStringToTextWidget( rt->rtCellMarginText, scratch );

    appGeoLengthToString( scratch, rp->rpLeftIndentTwips, UNITtyPOINTS );
    appStringToTextWidget( rt->rtLeftIndentText, scratch );

    cp= rp->rpCells;
    tedFormatReflectBorder( &(rt->rtTopBorderTool),
					&(cp[tr->trCol0].cpTopBorder) );
    tedFormatReflectBorder( &(rt->rtBottomBorderTool),
					&(cp[tr->trCol0].cpBottomBorder) );

    appGuiSetToggleState( rt->rtKeepOnPageToggle,
						rp->rpKeepOnPage );
    appGuiSetToggleState( rt->rtIsTableHeaderToggle,
						rp->rpIsTableHeader );
    }

void tedFormatToolRefreshRowTool(	RowTool *		rt,
					InspectorSubject *	is,
					const TableRectangle *	tr,
					const BufferSelection *	bs )
    {
    const RowProperties *	rp;
    const DocumentGeometry *	dg;

    const BufferItem *		rowBi;
    const BufferItem *		sectBi;

    rowBi= bs->bsBegin.bpBi;
    rowBi= rowBi->biParent;
    rowBi= rowBi->biParent;
    sectBi= rowBi->biParent;

    dg= &(sectBi->biSectDocumentGeometry);

    rt->rtPageRight= dg->dgPageWideTwips-
			    dg->dgLeftMarginTwips- dg->dgRightMarginTwips;
    rt->rtPageLeftMargin= dg->dgLeftMarginTwips;

    rp= &(rowBi->biRowProperties);

    if  ( docCopyRowProperties( &(rt->rtPropertiesChosen), rp ) )
	{ LDEB(1); return;	}
    if  ( docCopyRowProperties( &(rt->rtPropertiesSet), rp ) )
	{ LDEB(1); return;	}

    rt->rtTableRectangle= *tr;
    appGuiEnableWidget( is->isPrevButton, tr->trRow0 > tr->trRow00 );
    appGuiEnableWidget( is->isNextButton, tr->trRow1 < tr->trRow11 );

    tedFormatToolRefreshRowPage( rt );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Change' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatChangeRowPushed(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *			rt= (RowTool *)voidrt;
    RowProperties *		rp= &(rt->rtPropertiesChosen);

    TableRectangle		tr;

    int				width;
    int				changed;

    int				res;

    if  ( tedFormatToolGetHeight( &(rp->rpHeightTwips),
						&(rt->rtHeightChooser) ) )
	{ return;	}

    width= rp->rpHalfGapWidthTwips;
    if  ( appGetLengthFromTextWidget( rt->rtCellMarginText, &width, &changed,
							UNITtyPOINTS, 1 ) )
	{ return;	}
    rp->rpHalfGapWidthTwips= width;

    res= tedFormatToolGetRowLeftIndent( rp, rt->rtPageLeftMargin, &width,
							rt->rtLeftIndentText );
    if  ( res != 0 )
	{ return;	}
    rp->rpLeftIndentTwips= width;

    tr= rt->rtTableRectangle;
    docExpandTableRectangleToWholeRows( &tr );

    tedAppSetTableProperties( rt->rtApplication, &tr, rp );

    return;
    }

/************************************************************************/
/*									*/
/*  The row height changed, check it.					*/
/*									*/
/************************************************************************/

static void tedRowHeightChanged(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    int			value;

    if  ( ! tedFormatToolGetHeight( &value, &(rt->rtHeightChooser) ) )
	{
	tedFormatRefreshHeightChooser( &(rt->rtHeightChooser), value );
	}
    }

static void tedRowCellMarginChanged(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    RowProperties *	rp= &(rt->rtPropertiesChosen);

    int			width;

    if  ( ! tedFormatToolGetGapWidth( rp, &width, rt->rtCellMarginText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, width, UNITtyPOINTS );
	appStringToTextWidget( rt->rtCellMarginText, scratch );
	}
    }

static void tedRowLeftIndentChanged(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    RowProperties *	rp= &(rt->rtPropertiesChosen);

    int			value;

    if  ( ! tedFormatToolGetRowLeftIndent( rp, rt->rtPageLeftMargin, &value,
						    rt->rtLeftIndentText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	appStringToTextWidget( rt->rtLeftIndentText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  The 'Revert' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatRevertRowPushed(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *	rt= (RowTool *)voidrt;

    docCopyRowProperties( &(rt->rtPropertiesChosen), &(rt->rtPropertiesSet) );

    tedFormatToolRefreshRowPage( rt );

    return;
    }

static void tedFormatPreviousRow(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= rt->rtTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    docExpandTableRectangleToWholeRows( &tr );

    if  ( docShiftTableRectangleByRows( &tr, -1 ) )
	{ return;	}

    tedAppSetTableSelection( ed, &(td->tdSelectionScope), &tr );

    return;
    }

static void tedFormatSelectRow(		APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= rt->rtTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    docExpandTableRectangleToWholeRows( &tr );

    tedAppSetTableSelection( ed, &(td->tdSelectionScope), &tr );

    return;
    }

static void tedFormatNextRow(		APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= rt->rtTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    docExpandTableRectangleToWholeRows( &tr );

    if  ( docShiftTableRectangleByRows( &tr, +1 ) )
	{ return;	}

    tedAppSetTableSelection( ed, &(td->tdSelectionScope), &tr );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Delete' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatDeleteRow(		APP_WIDGET	w,
					void *		voidrt,
					void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TableRectangle *	tr= &(rt->rtTableRectangle);

    if  ( ! ed )
	{ XDEB(ed); return;	}

    if  ( tedDeleteRowsFromTable( ed, tr->trRow0, tr->trRow1 ) )
	{ LLDEB(tr->trRow0,tr->trRow1); return;	}

    appDocumentChanged( ed, 1 );

    return;
    }

/************************************************************************/
/*									*/
/*  Insert/Append Row buttons have been pushed.				*/
/*									*/
/************************************************************************/

static void tedFormatInsertRow(	APP_WIDGET	w,
				void *		voidrt,
				void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedInsertRowInTable( ed );

    appDocumentChanged( ed, 1 );
    }

static void tedFormatAppendRow(	APP_WIDGET	w,
				void *		voidrt,
				void *		voidpbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    EditApplication *	ea= rt->rtApplication;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppendRowToTable( ed );

    appDocumentChanged( ed, 1 );
    }

static void tedRowHeightChosen(	APP_WIDGET	w,
				void *		voidrt,
				void *		voidtbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;

    int			defaultValue;

    defaultValue= rt->rtPropertiesChosen.rpHeightTwips;
    if  ( defaultValue == 0 )
	{ defaultValue= rt->rtPropertiesSet.rpHeightTwips;	}
    if  ( defaultValue == 0 )
	{ defaultValue= 240;	}

    tedFormatHeightChosen( w, &(rt->rtHeightChooser), defaultValue );

    return;
    }

static void tedRowBorderStyleChosen(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidtbcs )
    {
    RowTool *		rt= (RowTool *)voidrt;
    RowProperties *	rp= &(rt->rtPropertiesChosen);
    CellProperties *	cp= rp->rpCells;
    CellProperties *	cp0= rp->rpCells;
    int			col;

    if  ( ! tedBorderToolGetStyle( &(rt->rtTopBorderTool),
						&(cp->cpTopBorder), w ) )
	{
	cp++;
	for ( col= 1; col < rp->rpCellCount; cp++, col++ )
	    { cp->cpTopBorder.bpStyle= cp0->cpTopBorder.bpStyle; }

	return;
	}

    if  ( ! tedBorderToolGetStyle( &(rt->rtBottomBorderTool),
						&(cp->cpBottomBorder), w ) )
	{
	cp++;
	for ( col= 1; col < rp->rpCellCount; cp++, col++ )
	    { cp->cpBottomBorder.bpStyle= cp0->cpBottomBorder.bpStyle; }

	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  A toggle was activated.						*/
/*									*/
/************************************************************************/

static void tedRowToggleKeepOnPage(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidtbcs )
    {
    RowTool *				rt= (RowTool *)voidrt;
    RowProperties *			rp= &(rt->rtPropertiesChosen);
    int					set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    rp->rpKeepOnPage= set;

    return;
    }

static void tedRowToggleIsTableHeader(	APP_WIDGET	w,
					void *		voidrt,
					void *		voidtbcs )
    {
    RowTool *				rt= (RowTool *)voidrt;
    RowProperties *			rp= &(rt->rtPropertiesChosen);
    int					set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    rp->rpIsTableHeader= set;

    return;
    }

/************************************************************************/
/*									*/
/*  One of the 'Row Border' toggles has been activated.			*/
/*									*/
/************************************************************************/

static void tedRowToggleBorder(	APP_WIDGET	w,
				void *		voidrt,
				void *		voidtbcs )
    {
    RowTool *				rt= (RowTool *)voidrt;
    RowProperties *			rp= &(rt->rtPropertiesChosen);
    CellProperties *			cp;
    int					col;
    int					set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    if  ( w == rt->rtTopBorderTool.btOnOffToggle )
	{
	cp= rp->rpCells;
	for ( col= 0; col < rp->rpCellCount; cp++, col++ )
	    {
	    tedFormatToggleBorder( &(cp->cpTopBorder),
				    &(rt->rtTopBorderTool), col == 0, set );
	    }

	return;
	}

    if  ( w == rt->rtBottomBorderTool.btOnOffToggle )
	{
	cp= rp->rpCells;
	for ( col= 0; col < rp->rpCellCount; cp++, col++ )
	    {
	    tedFormatToggleBorder( &(cp->cpBottomBorder),
				    &(rt->rtBottomBorderTool), col == 0, set );
	    }

	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Make a row tool. I.E. the 'Row' page of the format tool.		*/
/*									*/
/************************************************************************/

void tedFormatFillRowPage(	RowTool *			rt,
				const RowPageResources *	rpr,
				InspectorSubject *			is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources *	isr )
    {
    APP_WIDGET	rowLabel;
    APP_WIDGET	widthLabel;
    APP_WIDGET	leftLabel;

    APP_WIDGET	row;

    const int	textColumns= 10;

    /**************/

    docInitTableRectangle( &(rt->rtTableRectangle) );

    docInitRowProperties( &(rt->rtPropertiesSet) );
    docInitRowProperties( &(rt->rtPropertiesChosen) );

    /**************/
    appMakeLabelAndTextRow( &row, &rowLabel, &(rt->rtNumberText),
			    pageWidget, isr->isrSubjectName, textColumns, 0 );

    /**************/
    tedFormatMakeHeightRow( &row, rt, pageWidget,
			&(rt->rtHeightChooser), tedRowHeightChanged );

    /**************/
    appMakeLabelAndTextRow( &row, &leftLabel, &(rt->rtLeftIndentText),
			    pageWidget, rpr->rprLeftIndent, textColumns, 1 );

    appGuiSetGotValueCallbackForText( rt->rtLeftIndentText,
				tedRowLeftIndentChanged, (void *)rt );

    /**************/
    appMakeLabelAndTextRow( &row, &widthLabel, &(rt->rtCellMarginText),
			    pageWidget, rpr->rprCellMargin, textColumns, 1 );

    appGuiSetGotValueCallbackForText( rt->rtCellMarginText,
				tedRowCellMarginChanged, (void *)rt );

    /**************/
    tedFormatMakeBorderTool( &(rt->rtTopBorderTool), &row, pageWidget,
			rpr->rprTopBorder, tedRowToggleBorder, (void *)rt );

    tedFormatMakeBorderTool( &(rt->rtBottomBorderTool), &row, pageWidget,
			rpr->rprBottomBorder, tedRowToggleBorder, (void *)rt );

    /**************/
    appInspectorMakeToggleRow( &row, pageWidget,
	    &(rt->rtKeepOnPageToggle), &(rt->rtIsTableHeaderToggle),
	    rpr->rprKeepOnPage, rpr->rprIsTableHeader,
	    tedRowToggleKeepOnPage, tedRowToggleIsTableHeader, (void *)rt );

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isPrevButton), &(is->isNextButton),
	    isr->isrPrevButtonText, isr->isrNextButtonText,
	    tedFormatPreviousRow, tedFormatNextRow, (void *)rt );

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isSelectButton), &(is->isDeleteButton),
	    isr->isrSelectButtonText, isr->isrDeleteButtonText,
	    tedFormatSelectRow, tedFormatDeleteRow, (void *)rt );

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isInsertButton), &(is->isAppendButton),
	    isr->isrInsertButtonText, isr->isrAppendButtonText,
	    tedFormatInsertRow, tedFormatAppendRow, (void *)rt );

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isRevertButton), &(is->isApplyButton),
	    isr->isrRevert, isr->isrApplyToSubject,
	    tedFormatRevertRowPushed, tedFormatChangeRowPushed, (void *)rt );

    appGuiEnableWidget( rt->rtIsTableHeaderToggle, 0 );

    return;
    }

void tedFormatFillRowChoosers(		RowTool *			rt,
					const RowPageResources *	rpr )
    {
    tedFormatFillHeightChooser( &(rt->rtHeightChooser),
					    tedRowHeightChosen, (void *)rt,
					    rpr->rprHeightFree,
					    rpr->rprHeightAtLeast,
					    rpr->rprHeightExactly );

    tedFormatFillBorderTool( &(rt->rtTopBorderTool),
					tedRowBorderStyleChosen, (void *)rt );
    tedFormatFillBorderTool( &(rt->rtBottomBorderTool),
					tedRowBorderStyleChosen, (void *)rt );
    }

void tedFormatFinishRowPage( 	RowTool *			rt,
				TedFormatTool *			tft,
				const RowPageResources *	rpr )
    {
    appOptionmenuRefreshWidth( &(rt->rtHeightChooser.hcOptionmenu) );

    tedFormatFinishBorderTool( &(rt->rtTopBorderTool), tft );
    tedFormatFinishBorderTool( &(rt->rtBottomBorderTool), tft );
    }

/************************************************************************/
/*									*/
/*  Get row tool resources.						*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedRowSubjectResourceTable[]=
    {
    APP_RESOURCE( "tableToolRow",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Row" ),
    APP_RESOURCE( "tableToolChangeRow",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply to Row" ),
    APP_RESOURCE( "tableToolRevert",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert" ),
    APP_RESOURCE( "tableToolNextRow",
		offsetof(InspectorSubjectResources,isrNextButtonText),
		"Next Row" ),
    APP_RESOURCE( "tableToolPreviousRow",
		offsetof(InspectorSubjectResources,isrPrevButtonText),
		"Previous Row" ),
    APP_RESOURCE( "tableToolSelectRow",
		offsetof(InspectorSubjectResources,isrSelectButtonText),
		"Select Row" ),
    APP_RESOURCE( "tableToolDeleteRow",
		offsetof(InspectorSubjectResources,isrDeleteButtonText),
		"Delete Row" ),
    APP_RESOURCE( "tableToolInsertRow",
		offsetof(InspectorSubjectResources,isrInsertButtonText),
		"Insert Row" ),
    APP_RESOURCE( "tableToolAppendRow",
		offsetof(InspectorSubjectResources,isrAppendButtonText),
		"Append Row" ),
    };

static AppConfigurableResource TED_TedRowToolResourceTable[]=
    {
    APP_RESOURCE( "tableToolHeightFree",
	    offsetof(RowPageResources,rprHeightFree),
	    "Height Free" ),
    APP_RESOURCE( "tableToolHeightExactly",
	    offsetof(RowPageResources,rprHeightExactly),
	    "Height Exactly" ),
    APP_RESOURCE( "tableToolHeightAtLeast",
	    offsetof(RowPageResources,rprHeightAtLeast),
	    "Height at Least" ),
    /**/
    APP_RESOURCE( "tableToolCellMargin",
	    offsetof(RowPageResources,rprCellMargin),
	    "Cell Margin" ),
    APP_RESOURCE( "tableToolLeftIndent",
	    offsetof(RowPageResources,rprLeftIndent),
	    "Left Margin" ),
    /**/
    APP_RESOURCE( "tableToolRowTopBorder",
	    offsetof(RowPageResources,rprTopBorder),
	    "Top Border" ),
    APP_RESOURCE( "tableToolRowBottomBorder",
	    offsetof(RowPageResources,rprBottomBorder),
	    "Bottom Border" ),
    /**/
    APP_RESOURCE( "formatToolRowKeepOnPage",
	    offsetof(RowPageResources,rprKeepOnPage),
	    "Keep on One Page" ),
    APP_RESOURCE( "formatToolRowIsTableHeader",
	    offsetof(RowPageResources,rprIsTableHeader),
	    "Is Table Header" ),
    };

void tedFormatToolGetRowResourceTable(	EditApplication *		ea,
					RowPageResources *		rpr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)rpr,
				TED_TedRowToolResourceTable,
				sizeof(TED_TedRowToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				TED_TedRowSubjectResourceTable,
				sizeof(TED_TedRowSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
