/************************************************************************/
/*									*/
/*  Paragraph tool:							*/
/*									*/
/************************************************************************/

#   ifndef	TED_PARA_TOOL_H
#   define	TED_PARA_TOOL_H

#   include	"tedBorderTool.h"
#   include	"tedShadingTool.h"
#   include	"tedHeightTool.h"

/************************************************************************/
/*									*/
/*  Resources for the 'Paragraph' page.					*/
/*									*/
/************************************************************************/

typedef struct ParagraphPageResources
    {
    char *		pprParaFirstIndent;
    char *		pprParaLeftIndent;
    char *		pprParaRightIndent;

    char *		pprParaSpaceAbove;
    char *		pprParaSpaceBelow;

    char *		pprOnNewPage;
    char *		pprOnOnePage;

    char *		pprParaLineDistFree;
    char *		pprParaLineDistAtLeast;
    char *		pprParaLineDistExactly;

    char *		pprShadingPattern;

    char *		pprTopBorder;
    char *		pprBottomBorder;

    char *		pprParaAlignment;
    char *		pprParaAlignMenuTexts[DOCia_COUNT];
    } ParagraphPageResources;

/************************************************************************/
/*									*/
/*  A paragraph tool, i.e. the 'Paragraph' page of the format tool.	*/
/*									*/
/************************************************************************/

typedef struct ParagraphTool
    {
    EditApplication *		ptApplication;

    ParagraphProperties		ptPropertiesSet;
    ParagraphProperties		ptPropertiesChosen;

    APP_WIDGET			ptFirstIndentText;
    APP_WIDGET			ptRightIndentText;
    APP_WIDGET			ptLeftIndentText;

    APP_WIDGET			ptOnNewPageToggle;
    APP_WIDGET			ptOnOnePageToggle;

    APP_WIDGET			ptSpaceAboveToggle;
    APP_WIDGET			ptSpaceAboveText;

    APP_WIDGET			ptSpaceBelowToggle;
    APP_WIDGET			ptSpaceBelowText;

    BorderTool			ptTopBorderTool;
    BorderTool			ptBottomBorderTool;

    HeightChooser		ptLineDistChooser;

    AppOptionmenu		ptAlignOptionmenu;
    APP_WIDGET			ptAlignItems[DOCia_COUNT];

    ShadingTool			ptShadingTool;
    } ParagraphTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

void tedFormatToolGetParaResourceTable(	EditApplication *		ea,
					ParagraphPageResources *	ppr,
					InspectorSubjectResources *	isr );

#   endif	/*  TED_PARA_TOOL_H */
