/************************************************************************/
/*  Ted: interaction with the page layout tool.				*/
/************************************************************************/

#   include	"config.h"

#   include	"tedApp.h"
#   include	"tedRuler.h"
#   include	"docPs.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Reformat and redisplay the document because of a major format	*/
/*  change. etc.							*/
/*									*/
/************************************************************************/

void tedRedoDocumentLayout(	EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    AppDrawingData *		add= &(ed->edDrawingData);

    int				scrolledX= 0;
    int				scrolledY= 0;

    int				hasSelection= tedHasSelection( td );

    tedLayoutDocumentTree( td, add );

    appSetShellConstraints( ed );

    if  ( hasSelection )
	{ tedDelimitCurrentSelection( td, add );	}

    appDocSetScrollbarValues( ed );
    appSetShellConstraints( ed );

    if  ( hasSelection )
	{
	tedDocAdaptHorizontalRuler( ed, td->tdSelection.bsBegin.bpBi );

	tedScrollToSelection( ed, &scrolledX, &scrolledY );

	if  ( td->tdObjectSelected )
	    { tedMoveObjectWindows( ed->edDocumentWidget, ed );	}
	}

    appExposeRectangle( add, 0, 0, 0, 0 );

    tedAdaptLeftRuler( ed->edLeftRuler, ed->edLeftRulerWidget,
			ed->edVisibleRect.drY0, ed->edVisibleRect.drY1,
			add->addPageStepPixels );

    return;
    }

/************************************************************************/
/*									*/
/*  Change the document geometry: Callback from the page layout tool	*/
/*  etc.								*/
/*									*/
/************************************************************************/

void tedSetPageLayout(	EditDocument *			ed,
			unsigned int			spUpdMask,
			const DocumentGeometry *	dg )
    {
    AppDrawingData *		add;
    TedDocument *		td;
    BufferDocument *		bd;
    DocumentProperties *	dp;

    unsigned int		changed= 0;

    int				i;

    add= &(ed->edDrawingData);
    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    dp= &(bd->bdProperties);

    appSetDocumentGeometry( &(dp->dpGeometry), dg, &changed,
						    spUpdMask & DGupdALL );

    for ( i= 0; i < bd->bdItem.biChildCount; i++ )
	{
	unsigned int		sectChanged= 0;
	BufferItem *		sectBi=  bd->bdItem.biChildren[i];

	appSetDocumentGeometry( &(sectBi->biSectDocumentGeometry),
						dg, &sectChanged, spUpdMask );

	changed |= sectChanged;
	}

    if  ( changed )
	{
	appDocumentChanged( ed, 1 );

	tedScreenRectangles( add, &(dp->dpGeometry) );

	tedRedoDocumentLayout( ed );

	tedAdaptFormatToolToDocument( ed );
	}

    return;
    }

void tedSetDocumentProperties(	EditApplication *		ea,
				const DocumentProperties *	dpNew,
				unsigned int			updMask )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    AppDrawingData *		add;
    TedDocument *		td;
    BufferDocument *		bd;
    DocumentProperties *	dp;

    unsigned int		changed= DPupdNONE;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    add= &(ed->edDrawingData);
    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    dp= &(bd->bdProperties);

    if  ( docUpdDocProperties( &changed, dp, updMask, dpNew ) )
	{ LDEB(1); return;	}

    if  ( changed )
	{
	appDocumentChanged( ed, 1 );

	tedScreenRectangles( add, &(dp->dpGeometry) );

	tedRedoDocumentLayout( ed );

	tedAdaptFormatToolToDocument( ed );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt the page tool to a document.					*/
/*									*/
/************************************************************************/
void tedAdaptPageToolToDocument(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *		td;
    BufferDocument *		bd;
    DocumentProperties *	dp;

    if  ( ! ea->eaPageTool )
	{ return;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    dp= &(bd->bdProperties);

    appPageToolSetProperties( ea->eaPageTool, &(dp->dpGeometry) );

    appEnablePageTool( ea->eaPageTool, ! ed->edIsReadonly );

    return;
    }

/************************************************************************/
/*									*/
/*  Derive private rectangles from document properties.			*/
/*									*/
/*  1)  HACK: IMAGEABLE AREA OF PRINTER					*/
/*									*/
/************************************************************************/

# define MINMARG	300

void tedScreenRectangles(	AppDrawingData *	add,
				DocumentGeometry *	dg )
    {
    double			xfac= add->addMagnifiedPixelsPerTwip;
    double			yfac= add->addMagnifiedPixelsPerTwip;

    int				leftMarginPixels;
    int				rightMarginPixels;

    /*  1  */
    if  ( dg->dgLeftMarginTwips < MINMARG )
	{ dg->dgLeftMarginTwips= MINMARG;	}
    if  ( dg->dgTopMarginTwips < MINMARG )
	{ dg->dgTopMarginTwips= MINMARG;	}
    if  ( dg->dgRightMarginTwips < MINMARG )
	{ dg->dgRightMarginTwips= MINMARG;	}
    if  ( dg->dgBottomMarginTwips < MINMARG )
	{ dg->dgBottomMarginTwips= MINMARG;	}

    leftMarginPixels= TWIPStoPIXELS( xfac, dg->dgLeftMarginTwips );
    rightMarginPixels= TWIPStoPIXELS( xfac, dg->dgRightMarginTwips );
    add->addBottomMarginPixels= TWIPStoPIXELS( xfac, dg->dgBottomMarginTwips );

    add->addBackRect.drX0= 0;
    add->addBackRect.drY0= 0;
    add->addBackRect.drX1= TWIPStoPIXELS( xfac, dg->dgPageWideTwips );
    add->addBackRect.drY1= TWIPStoPIXELS( yfac, dg->dgPageHighTwips );

    add->addPaperRect.drX0= 0;
    add->addPaperRect.drY0= 0;
    add->addPaperRect.drX1= TWIPStoPIXELS( xfac, dg->dgPageWideTwips );
    add->addPaperRect.drY1= TWIPStoPIXELS( yfac, dg->dgPageHighTwips );

    add->addDocRect.drX0= leftMarginPixels;
    add->addDocRect.drY0= TWIPStoPIXELS( xfac, dg->dgTopMarginTwips );
    add->addDocRect.drX1= add->addBackRect.drX1- rightMarginPixels;
    add->addDocRect.drY1= add->addBackRect.drY1- add->addBottomMarginPixels;

    add->addPageStepPixels= add->addPaperRect.drY1- add->addPaperRect.drY0+
							add->addPageGapPixels;

    return;
    }

/************************************************************************/
/*									*/
/*  (re)Calculate the layout of a whole document.			*/
/*									*/
/*  1)  Make sure that a defective document with an empty font list has	*/
/*	at least one font by supplying 'Helvetica'			*/
/*									*/
/************************************************************************/

int tedLayoutDocumentTree(	TedDocument *		td,
				AppDrawingData *	add )
    {
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);

    DocumentRectangle		drChanged;

    /*  1  */
    if  ( dp->dpFontList.dflCount == 0 )
	{
	LDEB(dp->dpFontList.dflCount);

	if  ( ! docInsertFont( &(dp->dpFontList), 0, "fswiss", "Helvetica" ) )
	    { LDEB(dp->dpFontList.dflCount);	}
	}

    drChanged= add->addBackRect;

    if  ( tedLayoutItem( &(bd->bdItem), bd, DOCinBODY, add, &drChanged ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

