/************************************************************************/
/*									*/
/*  Notes tool:								*/
/*									*/
/************************************************************************/

#   ifndef	TED_NOTES_TOOL_H
#   define	TED_NOTES_TOOL_H

/************************************************************************/
/*									*/
/*  A notes tool, i.e. the 'Notes' page of the format tool.		*/
/*									*/
/************************************************************************/

typedef struct NotesPageResources
    {
    char *		nprFootnotesText;
    char *		nprEndnotesText;

    char *		nprFirstNumberText;
    char *		nprPositionText;
    char *		nprRestartText;
    char *		nprStyleText;

    char *		nprPositionMenuTexts[DPftnPOS__COUNT];
    char *		nprRestartMenuTexts[DPftnRST__COUNT];
    char *		nprNumberStyleMenuTexts[DPftn_NCOUNT];
    } NotesPageResources;

typedef struct NotesTool
    {
    EditApplication *		ntApplication;

    DocumentProperties		ntPropertiesChosen;
    DocumentProperties		ntPropertiesSet;

    APP_WIDGET			ntFootnotesFrame;
    APP_WIDGET			ntFootnotesPaned;
    APP_WIDGET			ntStartFootnoteNumberText;

    AppOptionmenu		ntFootnotePositionOptionmenu;
    APP_WIDGET			ntFootnotePositionOptions[DPftnPOS__COUNT];

    AppOptionmenu		ntFootnoteRestartOptionmenu;
    APP_WIDGET			ntFootnoteRestartOptions[DPftnRST__COUNT];

    AppOptionmenu		ntFootnoteStyleOptionmenu;
    APP_WIDGET			ntFootnoteStyleOptions[DPftn_NCOUNT];

    APP_WIDGET			ntEndnotesFrame;
    APP_WIDGET			ntEndnotesPaned;
    APP_WIDGET			ntStartEndnoteNumberText;

    AppOptionmenu		ntEndnotePositionOptionmenu;
    APP_WIDGET			ntEndnotePositionOptions[DPftnPOS__COUNT];

    AppOptionmenu		ntEndnoteRestartOptionmenu;
    APP_WIDGET			ntEndnoteRestartOptions[DPftnRST__COUNT];

    AppOptionmenu		ntEndnoteStyleOptionmenu;
    APP_WIDGET			ntEndnoteStyleOptions[DPftn_NCOUNT];
    } NotesTool;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void tedFormatToolGetNotesResourceTable( EditApplication *	ea,
					NotesPageResources *		spr,
					InspectorSubjectResources *	isr );

#   endif	/*  TED_NOTES_TOOL_H */
