/************************************************************************/
/*									*/
/*  A tool to manage the style of notes in the document.		*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the 'Notes' page of the format tool.			*/
/*									*/
/************************************************************************/

static void tedSetNotesMenu(	AppOptionmenu *		aom,
				int			val,
				APP_WIDGET *		options )
    {
    int		n= 0;
    int		i;

    for ( i= 0; i < val; i++ )
	{
	if  ( options[i] )
	    { n++;	}
	}

    appSetOptionmenu( aom, n );

    return;
    }

static void tedFormatToolRefreshNotesPage(	NotesTool *	nt )
    {
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);

    appIntegerToTextWidget( nt->ntStartFootnoteNumberText,
					    dp->dpStartFootnoteNumber );
    tedSetNotesMenu( &(nt->ntFootnotePositionOptionmenu),
					    dp->dpFootnotePosition,
					    nt->ntFootnotePositionOptions );
    tedSetNotesMenu( &(nt->ntFootnoteRestartOptionmenu),
					    dp->dpFootnotesRestart,
					    nt->ntFootnoteRestartOptions );
    appSetOptionmenu( &(nt->ntFootnoteStyleOptionmenu),
					    dp->dpFootnoteNumberStyle );

    appIntegerToTextWidget( nt->ntStartEndnoteNumberText,
					    dp->dpStartEndnoteNumber );
    tedSetNotesMenu( &(nt->ntEndnotePositionOptionmenu),
					    dp->dpEndnotePosition,
					    nt->ntEndnotePositionOptions );
    tedSetNotesMenu( &(nt->ntEndnoteRestartOptionmenu),
					    dp->dpEndnotesRestart,
					    nt->ntEndnoteRestartOptions );
    appSetOptionmenu( &(nt->ntEndnoteStyleOptionmenu),
					    dp->dpEndnoteNumberStyle );
    }

void tedFormatToolRefreshNotesTool(	NotesTool *			nt,
					InspectorSubject *		is,
					const DocumentProperties *	dp )
    {
    unsigned int	changed= DPupdNONE;

    if  ( docUpdDocProperties( &changed, &(nt->ntPropertiesChosen),
							DPupdNOTE_PROPS, dp ) )
	{ LDEB(1); return;	}
    if  ( docUpdDocProperties( &changed, &(nt->ntPropertiesSet),
							DPupdNOTE_PROPS, dp ) )
	{ LDEB(1); return;	}

    tedFormatToolRefreshNotesPage( nt );

    return;
    }

/************************************************************************/
/*  Set/Revert buttons have been pushed.				*/
/************************************************************************/

static void tedNotesChangeNotesPushed(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *			nt= (NotesTool *)voidnt;
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);

    if  ( appGetIntegerFromTextWidget( nt->ntStartFootnoteNumberText,
					&(dp->dpStartFootnoteNumber),
					1, 0, INT_MAX, 0 ) )
	{ return;	}

    if  ( appGetIntegerFromTextWidget( nt->ntStartEndnoteNumberText,
					&(dp->dpStartEndnoteNumber),
					1, 0, INT_MAX, 0 ) )
	{ return;	}

    tedSetDocumentProperties( nt->ntApplication, dp, DPupdNOTE_PROPS );

    return;
    }

static void tedFormatRevertNotesPushed(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *	nt= (NotesTool *)voidnt;

    unsigned int	changed= DPupdNONE;

    if  ( docUpdDocProperties( &changed, &(nt->ntPropertiesChosen),
				    DPupdNOTE_PROPS, &(nt->ntPropertiesSet) ) )
	{ LDEB(1); return;	}

    tedFormatToolRefreshNotesPage( nt );

    return;
    }

/************************************************************************/
/*									*/
/*  Make the 'Notes' page of the format tool.				*/
/*									*/
/************************************************************************/

void tedFormatFillNotesPage(	NotesTool *			nt,
				const NotesPageResources *	npr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    APP_WIDGET	rowLabel;

    APP_WIDGET	row= (APP_WIDGET )0;

    const int	textColumns= 6;

    docInitDocumentProperties( &(nt->ntPropertiesSet) );
    docInitDocumentProperties( &(nt->ntPropertiesChosen) );

    /**************/
    appMakeColumnFrameInColumn( &(nt->ntFootnotesFrame),
			    &(nt->ntFootnotesPaned),
			    pageWidget, npr->nprFootnotesText );

    appInspectorMakeMenuRow( &row, &(nt->ntFootnotePositionOptionmenu),
		    &rowLabel, nt->ntFootnotesPaned, npr->nprPositionText );

    appInspectorMakeMenuRow( &row, &(nt->ntFootnoteRestartOptionmenu),
		    &rowLabel, nt->ntFootnotesPaned, npr->nprRestartText );

    appInspectorMakeMenuRow( &row, &(nt->ntFootnoteStyleOptionmenu),
		    &rowLabel, nt->ntFootnotesPaned, npr->nprStyleText );

    appMakeLabelAndTextRow( &row, &rowLabel, &(nt->ntStartFootnoteNumberText),
			nt->ntFootnotesPaned, npr->nprFirstNumberText,
			textColumns, 1 );

    /**************/

    appMakeColumnFrameInColumn( &(nt->ntEndnotesFrame),
			    &(nt->ntEndnotesPaned),
			    pageWidget, npr->nprEndnotesText );


    appInspectorMakeMenuRow( &row, &(nt->ntEndnotePositionOptionmenu),
		    &rowLabel, nt->ntEndnotesPaned, npr->nprPositionText );

    appInspectorMakeMenuRow( &row, &(nt->ntEndnoteRestartOptionmenu),
		    &rowLabel, nt->ntEndnotesPaned, npr->nprRestartText );

    appInspectorMakeMenuRow( &row, &(nt->ntEndnoteStyleOptionmenu),
		    &rowLabel, nt->ntEndnotesPaned, npr->nprStyleText );

    appMakeLabelAndTextRow( &row, &rowLabel, &(nt->ntStartEndnoteNumberText),
			nt->ntEndnotesPaned, npr->nprFirstNumberText,
			textColumns, 1 );

    /**************/

    appInspectorMakeButtonRow( &row, pageWidget,
		&(is->isRevertButton), &(is->isApplyButton),
		isr->isrRevert, isr->isrApplyToSubject,
		tedFormatRevertNotesPushed, tedNotesChangeNotesPushed,
		(void *)nt );

    return;
    }

/************************************************************************/
/*									*/
/*  Finish the Notes page.						*/
/*									*/
/************************************************************************/

static void tedFootnoteStyleChosen(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *			nt= (NotesTool *)voidnt;
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);
    int				n;

    for ( n= 0; n < DPftn_NCOUNT; n++ )
	{
	if  ( w == nt->ntFootnoteStyleOptions[n] )
	    { break;	}
	}

    if  ( n < 0 || n >= DPftn_NCOUNT )
	{ LDEB(n); return;	}

    dp->dpFootnoteNumberStyle= n;

    return;
    }

static void tedEndnoteStyleChosen(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *			nt= (NotesTool *)voidnt;
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);
    int				n;

    for ( n= 0; n < DPftn_NCOUNT; n++ )
	{
	if  ( w == nt->ntEndnoteStyleOptions[n] )
	    { break;	}
	}

    if  ( n < 0 || n >= DPftn_NCOUNT )
	{ LDEB(n); return;	}

    dp->dpEndnoteNumberStyle= n;

    return;
    }

static void tedFootnoteRestartChosen(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *			nt= (NotesTool *)voidnt;
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);
    int				n;

    for ( n= 0; n < DPftnRST__COUNT; n++ )
	{
	if  ( w == nt->ntFootnoteRestartOptions[n] )
	    { break;	}
	}

    if  ( n < 0 || n >= DPftnRST__COUNT )
	{ LDEB(n); return;	}

    dp->dpFootnotesRestart= n;

    return;
    }

static void tedEndnoteRestartChosen(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *			nt= (NotesTool *)voidnt;
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);
    int				n;

    for ( n= 0; n < DPftnRST__COUNT; n++ )
	{
	if  ( w == nt->ntEndnoteRestartOptions[n] )
	    { break;	}
	}

    if  ( n < 0 || n >= DPftnRST__COUNT )
	{ LDEB(n); return;	}

    dp->dpEndnotesRestart= n;

    return;
    }

static void tedFootnotePositionChosen(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *			nt= (NotesTool *)voidnt;
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);
    int				n;

    for ( n= 0; n < DPftnPOS__COUNT; n++ )
	{
	if  ( w == nt->ntFootnotePositionOptions[n] )
	    { break;	}
	}

    if  ( n < 0 || n >= DPftnPOS__COUNT )
	{ LDEB(n); return;	}

    dp->dpFootnotePosition= n;

    return;
    }

static void tedEndnotePositionChosen(	APP_WIDGET	w,
					void *		voidnt,
					void *		voidpbcs )
    {
    NotesTool *			nt= (NotesTool *)voidnt;
    DocumentProperties *	dp= &(nt->ntPropertiesChosen);
    int				n;

    for ( n= 0; n < DPftnPOS__COUNT; n++ )
	{
	if  ( w == nt->ntEndnotePositionOptions[n] )
	    { break;	}
	}

    if  ( n < 0 || n >= DPftnPOS__COUNT )
	{ LDEB(n); return;	}

    dp->dpEndnotePosition= n;

    return;
    }

void tedFormatFillNotesChoosers(	NotesTool *			nt,
					const NotesPageResources *	npr )
    {
    int		i;

    appFillInspectorMenu( DPftn_NCOUNT, DPftnNAR,
		    nt->ntFootnoteStyleOptions, npr->nprNumberStyleMenuTexts,
		    &(nt->ntFootnoteStyleOptionmenu),
		    tedFootnoteStyleChosen, (void *)nt );

    appFillInspectorMenu( DPftn_NCOUNT, DPftnNAR,
		    nt->ntEndnoteStyleOptions, npr->nprNumberStyleMenuTexts,
		    &(nt->ntEndnoteStyleOptionmenu),
		    tedEndnoteStyleChosen, (void *)nt );

    for ( i= 0; i < DPftnPOS__COUNT; i++ )
	{
	nt->ntFootnotePositionOptions[i]= (APP_WIDGET)0;
	nt->ntEndnotePositionOptions[i]= (APP_WIDGET)0;
	}

    for ( i= 0; i < DPftnRST__COUNT; i++ )
	{
	nt->ntFootnoteRestartOptions[i]= (APP_WIDGET)0;
	nt->ntEndnoteRestartOptions[i]= (APP_WIDGET)0;
	}

    nt->ntFootnoteRestartOptions[DPftnRST_CONTINUOUS]=
		appAddItemToOptionmenu( &(nt->ntFootnoteRestartOptionmenu),
				npr->nprRestartMenuTexts[DPftnRST_CONTINUOUS],
				tedFootnoteRestartChosen, (void *)nt );
    nt->ntFootnoteRestartOptions[DPftnRST_PER_SECTION]=
		appAddItemToOptionmenu( &(nt->ntFootnoteRestartOptionmenu),
				npr->nprRestartMenuTexts[DPftnRST_PER_SECTION],
				tedFootnoteRestartChosen, (void *)nt );
    nt->ntFootnoteRestartOptions[DPftnRST_PER_PAGE]=
		appAddItemToOptionmenu( &(nt->ntFootnoteRestartOptionmenu),
				npr->nprRestartMenuTexts[DPftnRST_PER_PAGE],
				tedFootnoteRestartChosen, (void *)nt );

    nt->ntEndnoteRestartOptions[DPftnRST_CONTINUOUS]=
		appAddItemToOptionmenu( &(nt->ntEndnoteRestartOptionmenu),
				npr->nprRestartMenuTexts[DPftnRST_CONTINUOUS],
				tedEndnoteRestartChosen, (void *)nt );
    nt->ntEndnoteRestartOptions[DPftnRST_PER_SECTION]=
		appAddItemToOptionmenu( &(nt->ntEndnoteRestartOptionmenu),
				npr->nprRestartMenuTexts[DPftnRST_PER_SECTION],
				tedEndnoteRestartChosen, (void *)nt );

    nt->ntFootnotePositionOptions[DPftnPOS_BELOW_TEXT]=
		appAddItemToOptionmenu( &(nt->ntFootnotePositionOptionmenu),
				npr->nprPositionMenuTexts[DPftnPOS_BELOW_TEXT],
				tedFootnotePositionChosen, (void *)nt );
    nt->ntFootnotePositionOptions[DPftnPOS_PAGE_BOTTOM]=
		appAddItemToOptionmenu( &(nt->ntFootnotePositionOptionmenu),
				npr->nprPositionMenuTexts[DPftnPOS_PAGE_BOTTOM],
				tedFootnotePositionChosen, (void *)nt );

    nt->ntEndnotePositionOptions[DPftnPOS_SECT_END]=
		appAddItemToOptionmenu( &(nt->ntEndnotePositionOptionmenu),
				npr->nprPositionMenuTexts[DPftnPOS_SECT_END],
				tedEndnotePositionChosen, (void *)nt );
    nt->ntEndnotePositionOptions[DPftnPOS_DOC_END]=
		appAddItemToOptionmenu( &(nt->ntEndnotePositionOptionmenu),
				npr->nprPositionMenuTexts[DPftnPOS_DOC_END],
				tedEndnotePositionChosen, (void *)nt );
    }

void tedFormatFinishNotesPage(		NotesTool *			nt,
					TedFormatTool *			tft,
					const NotesPageResources *	npr )
    {
    appOptionmenuRefreshWidth( &(nt->ntFootnotePositionOptionmenu) );
    appOptionmenuRefreshWidth( &(nt->ntFootnoteRestartOptionmenu) );
    appOptionmenuRefreshWidth( &(nt->ntFootnoteStyleOptionmenu) );

    appOptionmenuRefreshWidth( &(nt->ntEndnotePositionOptionmenu) );
    appOptionmenuRefreshWidth( &(nt->ntEndnoteRestartOptionmenu) );
    appOptionmenuRefreshWidth( &(nt->ntEndnoteStyleOptionmenu) );
    }

/************************************************************************/
/*									*/
/*  Get notes tool resources.						*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedNotesSubjectResourceTable[]=
    {
    APP_RESOURCE( "formatToolNotes",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Notes" ),
    APP_RESOURCE( "formatToolChangeNotes",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply" ),
    APP_RESOURCE( "tableToolRevert",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert" ),
    };

static AppConfigurableResource TED_TedNotesToolResourceTable[]=
    {
    APP_RESOURCE( "formatToolFootnotes",
		offsetof(NotesPageResources,nprFootnotesText),
		"Footnotes" ),
    APP_RESOURCE( "formatToolEndnotes",
		offsetof(NotesPageResources,nprEndnotesText),
		"Endnotes" ),
    /**/
    APP_RESOURCE( "formatToolNotesFirstNumber",
		offsetof(NotesPageResources,nprFirstNumberText),
		"First Number" ),
    APP_RESOURCE( "formatToolNotesPosition",
		offsetof(NotesPageResources,nprPositionText),
		"Position" ),
    APP_RESOURCE( "formatToolNotesRestart",
		offsetof(NotesPageResources,nprRestartText),
		"Numbering" ),
    APP_RESOURCE( "formatToolNotesNumberStyle",
		offsetof(NotesPageResources,nprStyleText),
		"Number Format" ),
    /**/
    APP_RESOURCE( "formatToolNoteNumberStyleNar",
	    offsetof(NotesPageResources,nprNumberStyleMenuTexts[DPftnNAR]),
	    "1, 2, 3" ),
    APP_RESOURCE( "formatToolNoteNumberStyleNalc",
	    offsetof(NotesPageResources,nprNumberStyleMenuTexts[DPftnNALC]),
	    "a, b, c" ),
    APP_RESOURCE( "formatToolNoteNumberStyleNauc",
	    offsetof(NotesPageResources,nprNumberStyleMenuTexts[DPftnNAUC]),
	    "A, B, C" ),
    APP_RESOURCE( "formatToolNoteNumberStyleNrlc",
	    offsetof(NotesPageResources,nprNumberStyleMenuTexts[DPftnNRLC]),
	    "i, ii, iii" ),
    APP_RESOURCE( "formatToolNoteNumberStyleNruc",
	    offsetof(NotesPageResources,nprNumberStyleMenuTexts[DPftnNRUC]),
	    "I, II, III" ),
    APP_RESOURCE( "formatToolNoteNumberStyleNchi",
	    offsetof(NotesPageResources,nprNumberStyleMenuTexts[DPftnNCHI]),
	    "*, +, #, $" ),
    /**/
    APP_RESOURCE( "formatToolNoteNumberingContinuous",
	offsetof(NotesPageResources,nprRestartMenuTexts[DPftnRST_CONTINUOUS]),
	"Continuous" ),
    APP_RESOURCE( "formatToolNoteNumberingPerSection",
	offsetof(NotesPageResources,nprRestartMenuTexts[DPftnRST_PER_SECTION]),
	"Per Section" ),
    APP_RESOURCE( "formatToolNoteNumberingPerPage",
	offsetof(NotesPageResources,nprRestartMenuTexts[DPftnRST_PER_PAGE]),
	"Per Page" ),
    /**/
    APP_RESOURCE( "formatToolNotePositionSectEnd",
	offsetof(NotesPageResources,nprPositionMenuTexts[DPftnPOS_SECT_END]),
	"End of Section" ),
    APP_RESOURCE( "formatToolNotePositionDocEnd",
	offsetof(NotesPageResources,nprPositionMenuTexts[DPftnPOS_DOC_END]),
	"End of Document" ),
    APP_RESOURCE( "formatToolNotePositionBelowText",
	offsetof(NotesPageResources,nprPositionMenuTexts[DPftnPOS_BELOW_TEXT]),
	"Below Text" ),
    APP_RESOURCE( "formatToolNotePositionPageBottom",
	offsetof(NotesPageResources,nprPositionMenuTexts[DPftnPOS_PAGE_BOTTOM]),
	"Page Bottom" ),
    };

void tedFormatToolGetNotesResourceTable( EditApplication *		ea,
					NotesPageResources *		npr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)npr,
				TED_TedNotesToolResourceTable,
				sizeof(TED_TedNotesToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				TED_TedNotesSubjectResourceTable,
				sizeof(TED_TedNotesSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
