/************************************************************************/
/*									*/
/*  Ted: The 'Hyperlink' dialog.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   include	"docFind.h"
#   include	"tedApp.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Management of link related stuff.					*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  Determine the area covered by a field or a bookmark.		*/
/*									*/
/************************************************************************/

static void tedLinkArea(	DocumentRectangle *	drChanged,
				EditDocument *		ed,
				BufferItem *		bi,
				int			startPart,
				int			endPart )
    {
    AppDrawingData *		add= &(ed->edDrawingData);

    BufferSelection		bsNew;

    docInitSelection( &bsNew );

    bsNew.bsBegin.bpBi= bi;
    bsNew.bsBegin.bpStroff= bi->biParaParticules[startPart].tpStroff;
    bsNew.bsEnd.bpBi= bi;
    bsNew.bsEnd.bpStroff= bi->biParaParticules[endPart].tpStroff;

    docFindLineAndParticule( bi, bsNew.bsBegin.bpStroff, &(bsNew.bsBegin), 1 );
    docFindLineAndParticule( bi, bsNew.bsEnd.bpStroff, &(bsNew.bsEnd), 0 );

    tedSelectionCoordinates( &bsNew, add );

    tedSelectionRectangle( drChanged, add, &bsNew );

    return;
    }

/************************************************************************/
/*									*/
/*  Convert the current selection to a field or a bookmark.		*/
/*									*/
/************************************************************************/

static int tedFinishSetField(	EditDocument *		ed,
				const SelectionScope *	ss,
				BufferSelection *	bsField,
				DocumentRectangle *	drChanged,
				int			oldBackY1,
				unsigned int		whenMask )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    BufferItem *		bi;

    int				scrolledX= 0;
    int				scrolledY= 0;

    const int			nearest= 1;

    int				changed= 0;

    bi= docGetSelectionRoot( bd, nearest, ss, bsField );

    docFieldRefreshFlags( bi, bd );

    if  ( whenMask )
	{
	if  ( docRecalculateTextFields( &changed, bd, bi, whenMask ) )
	    { XDEB(whenMask);	}
	}

    tedLayoutItem( bi, bd, ss->ssInHeaderFooter, add, drChanged );

    docFindLineAndParticule( bsField->bsBegin.bpBi,
			bsField->bsBegin.bpStroff, &(bsField->bsBegin), 1 );
    docFindLineAndParticule( bsField->bsEnd.bpBi,
			bsField->bsEnd.bpStroff, &(bsField->bsEnd), 0 );

    if  ( add->addBackRect.drY1 > oldBackY1 )
	{
	appDocSetScrollbarValues( ed );
	appSetShellConstraints( ed );
	}

    tedSetSelection( ed, ss, bsField, &scrolledX, &scrolledY );

    tedExposeRectangle( ed, drChanged, scrolledX, scrolledY );

    tedAdaptToolsToSelection( ed );

    appDocumentChanged( ed, 1 );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Remove the particules that delimit a link or bookmark and adjust	*/
/*  the selection to changed particule numbers.				*/
/*									*/
/*  1)  Determine the rectangle that is to be redrawn.			*/
/*  2)  Delete the particules from the paragraph.			*/
/*  3)  Adjust the selection.						*/
/*  4)  Redraw.								*/
/*									*/
/************************************************************************/

static void tedRemoveFieldParticules(	EditDocument *		ed,
					BufferItem *		bi,
					int			startPart,
					int			endPart )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;
    AppDrawingData *		add= &(ed->edDrawingData);

    DocumentRectangle		drChanged;

    BufferSelection *		bs= &(td->tdSelection);
    SelectionScope *		ss= &(td->tdSelectionScope);

    /*  1  */
    tedLinkArea( &drChanged, ed, bi, startPart, endPart );

    /*  2  */
    docDeleteParticules( bi, endPart, 1 );
    docDeleteParticules( bi, startPart, 1 );

    tedLayoutItem( bi, bd, ss->ssInHeaderFooter, add, &drChanged );

    /*  3  */
    docFindLineAndParticule( bs->bsBegin.bpBi,
				    bs->bsBegin.bpStroff, &(bs->bsBegin), 1 );
    docFindLineAndParticule( bs->bsEnd.bpBi,
				    bs->bsEnd.bpStroff, &(bs->bsEnd), 0 );

    tedSelectionCoordinates( bs, add );

    tedSelectionRectangle( &(td->tdSelectedRectangle), add, bs );

    /*  4  */
    tedExposeRectangle( ed, &drChanged, /*scrolledX,Y*/ 0,0 );

    return;
    }


/************************************************************************/
/*									*/
/*  Run the 'Link Dialog' from the 'Insert Link' menu option.		*/
/*									*/
/************************************************************************/

void tedDocInsertLink(	APP_WIDGET	option,
			void *		voided,
			void *		voidpbcs )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    const BufferPosition *	bp= &(td->tdSelection.bsBegin);

    int				startPart;
    int				endPart;

    const char *		fileName= (const char *)0;
    int				fileSize= 0;
    const char *		markName= (const char *)0;
    int				markSize= 0;

    docGetHyperlinkForPosition( bd, bp, &startPart, &endPart,
				&fileName, &fileSize, &markName, &markSize );

    tedRunLinkDialog( ea, ed, option, fileName, fileSize, markName, markSize );

    tedAdaptToolsToSelection( ed );

    return;
    }

int tedSetHyperlink(	EditDocument *		ed,
			const char *		file,
			const char *		mark,
			int			asRef,
			int			asPageref )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;
    BufferSelection *		bs= &(td->tdSelection);
    SelectionScope *		ss= &(td->tdSelectionScope);

    const BufferPosition *	bp= &(td->tdSelection.bsBegin);
    BufferItem *		bi=bp->bpBi;

    int				startPart;
    int				endPart;

    const char *		fileName= (const char *)0;
    int				fileSize= 0;
    int				newFileSize= strlen( file );
    const char *		markName= (const char *)0;
    int				markSize= 0;
    int				newMarkSize= 0;

    DocumentField *		df;

    char *			adaptedMark= (char *)0;

    int				oldBackY1= add->addBackRect.drY1;
    DocumentRectangle		drChanged;

    drChanged= td->tdSelectedRectangle;
    drChanged.drX1= add->addBackRect.drX1;

    if  ( mark )
	{
	adaptedMark= strdup( mark );
	if  ( ! adaptedMark )
	    { XDEB(adaptedMark); return -1;	}

	docAdaptBookmarkName( &newMarkSize, adaptedMark );
	}

    if  ( docGetHyperlinkForPosition( bd, bp, &startPart, &endPart,
				&fileName, &fileSize, &markName, &markSize ) )
	{
	int			fieldNumber;

	BufferSelection		bsRep;
	BufferSelection		bsHyperlink;
	BufferSelection		bsField;

	int			beginMoved= 0;
	int			endMoved= 0;

	unsigned int		whenMask= FIELDdoNOTHING;

	bsRep= *bs;

	docConstrainSelectionToOneParagraph( &beginMoved, &endMoved, &bsRep );

	bsHyperlink= bsRep;

	if  ( asRef || asPageref )
	    {
	    const FieldKindInformation *	fki;

	    if  ( tedReplaceSelection( &drChanged, &bsRep, ed,
					    (const unsigned char *)"?", 1 ) )
		{ LDEB(1); return -1;	}

	    bsHyperlink= bsRep;

	    if  ( asRef )
		{
		df= docClaimField( &fieldNumber, &(bd->bdFieldList) );
		if  ( ! df )
		    { XDEB(df); return -1;	}

		if  ( docFieldSetRef( df,
				(unsigned char *)adaptedMark, newMarkSize ) )
		    { LDEB(newMarkSize); return -1;	}

		if  ( docSurroundTextSelectionByField( &bsField,
							&bsRep, fieldNumber ) )
		    { LDEB(1); return -1;	}

		df->dfKind= DOCfkREF;
		fki= DOC_FieldKinds+ df->dfKind;
		whenMask |= fki->fkiCalculateWhen;

		docUnionParaSelections( &bsHyperlink, &bsHyperlink, &bsField );
		bsRep= bsField;
		bsRep.bsEnd.bpParticule++;
		bsRep.bsBegin= bsRep.bsEnd;
		}

	    if  ( asRef && asPageref )
		{
		TextParticule *		tp;
		int			partShift= 0;
		int			stroffShift= 0;

		tp= docParaSpecialParticule( bsRep.bsEnd.bpBi, DOCkindTAB,
				    bsRep.bsEnd.bpParticule,
				    bsRep.bsEnd.bpStroff,
				    &partShift, &stroffShift );
		if  ( ! tp )
		    { XDEB(tp); return -1;	}
		
		bsRep.bsEnd.bpParticule += partShift;
		bsRep.bsEnd.bpStroff += stroffShift;
		bsRep.bsBegin= bsRep.bsEnd;

		docUnionParaSelections( &bsHyperlink, &bsHyperlink, &bsRep );
		}

	    if  ( asPageref )
		{
		df= docClaimField( &fieldNumber, &(bd->bdFieldList) );
		if  ( ! df )
		    { XDEB(df); return -1;	}

		if  ( docFieldSetPageref( df,
				(unsigned char *)adaptedMark, newMarkSize ) )
		    { LDEB(newMarkSize); return -1;	}

		if  ( docSurroundTextSelectionByField( &bsField,
							&bsRep, fieldNumber ) )
		    {
		    LLDEB(bsRep.bsBegin.bpParticule,bsRep.bsEnd.bpParticule);
		    docListItem(0,bsRep.bsEnd.bpBi);
		    return -1;
		    }

		df->dfKind= DOCfkPAGEREF;
		fki= DOC_FieldKinds+ df->dfKind;
		whenMask |= fki->fkiCalculateWhen;

		docUnionParaSelections( &bsHyperlink, &bsHyperlink, &bsField );
		bsRep= bsField;
		bsRep.bsEnd.bpParticule++;
		bsRep.bsBegin= bsRep.bsEnd;
		}
	    }

	df= docClaimField( &fieldNumber, &(bd->bdFieldList) );
	if  ( ! df )
	    { XDEB(df); return -1;	}

	if  ( docFieldSetHyperlink( df, (unsigned char *)file, newFileSize,
				(unsigned char *)adaptedMark, newMarkSize ) )
	    { SSDEB(file,adaptedMark); return -1;	}

	/*  4  */
	if  ( docSurroundTextSelectionByField( &bsField,
						&bsHyperlink, fieldNumber ) )
	    { LDEB(1); return -1;	}

	df->dfKind= DOCfkHYPERLINK;

	/*  5  */
	if  ( tedFinishSetField( ed, ss, &bsField,
					    &drChanged, oldBackY1, whenMask ) )
	    { LDEB(fieldNumber); return -1;	}

	if  ( adaptedMark )
	    { free( adaptedMark );	}

	return 0;
	}
    else{
	df= bd->bdFieldList.dflFields;
	df += bi->biParaParticules[startPart].tpObjectNumber;

	if  ( docFieldSetHyperlink( df, (unsigned char *)file, newFileSize,
				(unsigned char *)adaptedMark, newMarkSize ) )
	    { SSDEB(file,adaptedMark); return -1;	}

	appDocumentChanged( ed, 1 );

	if  ( adaptedMark )
	    { free( adaptedMark );	}

	return 0;
	}
    }

int tedRemoveHyperlink(	EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    const BufferPosition *	bp= &(td->tdSelection.bsBegin);
    BufferItem *		bi= bp->bpBi;

    int				startPart;
    int				endPart;

    const char *		fileName= (const char *)0;
    int				fileSize= 0;
    const char *		markName= (const char *)0;
    int				markSize= 0;

    DocumentField *		df;

    if  ( docGetHyperlinkForPosition( bd, bp, &startPart, &endPart,
				&fileName, &fileSize, &markName, &markSize ) )
	{ LDEB(1); return -1;	}
    else{
	int			part;
	TextParticule *		tp;

	tp= bi->biParaParticules+ startPart;
	df= bd->bdFieldList.dflFields+ tp->tpObjectNumber;
	docCleanField( bd, df ); docInitField( df );

	tp= bi->biParaParticules+ startPart+ 1;
	for ( part= startPart+ 1; part < endPart; tp++, part++ )
	    { tp->tpTextAttribute.taShowAsLink= 0; }

	tedRemoveFieldParticules( ed, bi, startPart, endPart );

	appDocumentChanged( ed, 1 );

	return 0;
	}
    }

/************************************************************************/
/*									*/
/*  Run the 'Bookmark Dialog' from the 'Insert Bookmark' menu option.	*/
/*									*/
/************************************************************************/

void tedDocInsertBookmark(	APP_WIDGET	option,
				void *		voided,
				void *		voidpbcs )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    const BufferPosition *	bp= &(td->tdSelection.bsBegin);

    int				startPart;
    int				endPart;

    int				nameProposed= 0;
    char *			savedMark= (char *)0;

    const char *		markName= (const char *)0;
    int				markSize= 0;

    if  ( docGetBookmarkForPosition( bd, bp, &startPart, &endPart,
						    &markName, &markSize ) )
	{
	BufferItem *	bi= td->tdSelection.bsBegin.bpBi;
	int		stroff= td->tdSelection.bsBegin.bpStroff;

	if  ( ! ed->edIsReadonly			&&
	      bi					&&
	      bi == td->tdSelection.bsEnd.bpBi		&&
	      stroff < td->tdSelection.bsEnd.bpStroff	)
	    {
	    unsigned char *	s= bi->biParaString+ stroff;
	    unsigned char *	e;
	    unsigned char *	p;

	    while( ! isalnum( *s )				&&
		   stroff < td->tdSelection.bsEnd.bpStroff	)
		{ s++; stroff++;	}

	    p= e= s;
	    while( stroff < td->tdSelection.bsEnd.bpStroff )
		{
		if  ( isalnum( *e ) )
		    { p= e+ 1;	}

		e++; stroff++;
		}

	    if  ( p- s > 3 )
		{
		savedMark= (char *)malloc( p- s+ 1 );
		if  ( savedMark )
		    {
		    strncpy( savedMark, (char *)s, p- s )[p- s]= '\0';
		    markName= savedMark;
		    nameProposed= 1;

		    docAdaptBookmarkName( &markSize, savedMark );
		    }
		}
	    }
	}

    tedRunBookmarkDialog( ea, ed, option, nameProposed, markName, markSize );

    if  ( savedMark )
	{ free( savedMark );	}

    tedAdaptToolsToSelection( ed );

    return;
    }

int tedSetBookmark(	EditDocument *		ed,
			const char *		mark )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferSelection *		bs= &(td->tdSelection);
    SelectionScope *		ss= &(td->tdSelectionScope);
    BufferDocument *		bd= td->tdDocument;

    const BufferPosition *	bp= &(td->tdSelection.bsBegin);
    BufferItem *		bi= bp->bpBi;

    int				startPart;
    int				endPart;

    const char *		markName= (const char *)0;
    int				markSize= 0;
    int				newMarkSize;

    DocumentField *		df;

    char *			adaptedMark= (char *)0;

    int				oldBackY1= add->addBackRect.drY1;
    DocumentRectangle		drChanged;

    drChanged= td->tdSelectedRectangle;
    drChanged.drX1= add->addBackRect.drX1;

    adaptedMark= strdup( mark );
    if  ( ! adaptedMark )
	{ XDEB(adaptedMark); return -1;	}

    docAdaptBookmarkName( &newMarkSize, adaptedMark );

    if  ( docGetBookmarkForPosition( bd, bp, &startPart, &endPart,
						    &markName, &markSize ) )
	{
	int			fieldNumber;

	BufferSelection		bsRep;
	BufferSelection		bsField;

	int			beginMoved= 0;
	int			endMoved= 0;

	bsRep= *bs;

	docConstrainSelectionToOneParagraph( &beginMoved, &endMoved, &bsRep );

	markSize= strlen( adaptedMark );

	df= docClaimField( &fieldNumber, &(bd->bdFieldList) );
	if  ( ! df )
	    { XDEB(df); return -1;	}

	if  ( docFieldSetBookmark( df,
			    (unsigned char *)adaptedMark, newMarkSize ) )
	    { SDEB(adaptedMark); return -1;	}

	/*  4  */
	if  ( docSurroundTextSelectionByField( &bsField, &bsRep, fieldNumber ) )
	    { LDEB(1); return -1;	}

	df->dfKind= DOCfkBOOKMARK;

	/*  5  */
	if  ( tedFinishSetField( ed, ss, &bsField,
				    &drChanged, oldBackY1, FIELDdoNOTHING ) )
	    { LDEB(fieldNumber); return -1;	}

	return 0;
	}
    else{
	df= bd->bdFieldList.dflFields;
	df += bi->biParaParticules[startPart].tpObjectNumber;

	if  ( docFieldSetBookmark( df,
				(unsigned char *)adaptedMark, newMarkSize ) )
	    { SDEB(adaptedMark); return -1;	}

	appDocumentChanged( ed, 1 );

	return 0;
	}
    }

int tedRemoveBookmark(	EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    const BufferPosition *	bp= &(td->tdSelection.bsBegin);
    BufferItem *		bi= bp->bpBi;

    int				startPart;
    int				endPart;

    const char *		markName= (const char *)0;
    int				markSize= 0;

    DocumentField *		df;

    if  ( docGetBookmarkForPosition( bd, bp, &startPart, &endPart,
						    &markName, &markSize ) )
	{ LDEB(1); return -1;	}
    else{
	TextParticule *		tp;

	tp= bi->biParaParticules+ startPart;
	df= bd->bdFieldList.dflFields+ tp->tpObjectNumber;
	docCleanField( bd, df ); docInitField( df );

	tedRemoveFieldParticules( ed, bi, startPart, endPart );

	appDocumentChanged( ed, 1 );

	return 0;
	}
    }

int tedCopyBookmarkAsLink(	EditDocument *		ed,
				int			asRef,
				int			asPageref,
				const char *		markName )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    const BufferPosition *	bp= &(td->tdSelection.bsBegin);
    BufferItem *		bi= bp->bpBi;

    SelectionScope		ss;
    BufferSelection		bs;

    int				markSize= strlen( markName );

    docInitSelectionScope( &ss );
    docInitSelection( &bs );

    if  ( docFindBookmarkInDocument( &ss, &bs,
					td->tdDocument, markName, markSize ) )
	{ SDEB(markName); return -1;	}

    docFindLineAndParticule( bs.bsBegin.bpBi,
				    bs.bsBegin.bpStroff, &(bs.bsBegin), 1 );
    docFindLineAndParticule( bs.bsEnd.bpBi,
				    bs.bsEnd.bpStroff, &(bs.bsEnd), 0 );

    if  ( tedCopyAsLink( ed, bi, &ss, &bs,
				    asRef, asPageref,
				    ed->edFilename, markName, markSize ) )
	{ LDEB(1);	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Select a particular bookmark in a document.				*/
/*									*/
/************************************************************************/

int tedGoToBookmark(	EditDocument *		ed,
			const char *		markName,
			int			markSize )
    {
    SelectionScope		ssNew;
    BufferSelection		bsNew;

    TedDocument *		td;

    int				scrolledX= 0;
    int				scrolledY= 0;

    int				beginMoved= 0;
    int				endMoved= 0;

    td= (TedDocument *)ed->edPrivateData;

    docInitSelection( &bsNew );
    docInitSelectionScope( &ssNew );

    if  ( docFindBookmarkInDocument( &ssNew, &bsNew,
					td->tdDocument, markName, markSize ) )
	{ SDEB(markName); return -1;	}

    docConstrainSelectionToOneParagraph( &beginMoved, &endMoved, &bsNew );

    docFindLineAndParticule( bsNew.bsBegin.bpBi,
				bsNew.bsBegin.bpStroff, &(bsNew.bsBegin), 1 );
    docFindLineAndParticule( bsNew.bsEnd.bpBi,
				bsNew.bsEnd.bpStroff, &(bsNew.bsEnd), 0 );

    tedSetSelection( ed, &ssNew, &bsNew, &scrolledX, &scrolledY );

    tedAdaptToolsToSelection( ed );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Insert a page number in the document.				*/
/*									*/
/*  1)  Force the header or footer that will receive the page number	*/
/*	to be reformatted the next time that it is drawn.		*/
/*  2)  Replace the current selection with something arbitrary.		*/
/*  3)  Make a 'PAGE' field.						*/
/*  4)  Finish by surround the replacement with the field.		*/
/*  5)  Final bookkeeping and redrawing. As the replecement is a page	*/
/*	number that is recalculated every time the header/footer is	*/
/*	drawn, no field calculation is required.			*/
/*									*/
/************************************************************************/

void tedDocInsertPageNumber(	APP_WIDGET	option,
				void *		voided,
				void *		voidpbcs )
    {
    EditDocument *		ed= (EditDocument *)voided;
    AppDrawingData *		add= &(ed->edDrawingData);
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    BufferSelection		bsRep;
    BufferSelection		bsField;

    int				fieldNumber;

    const char *		fieldInst= "PAGE";

    DocumentField *		df;

    BufferSelection *		bs= &(td->tdSelection);
    SelectionScope *		ss= &(td->tdSelectionScope);

    HeaderFooter *		hf;
    BufferItem *		sectBi;

    int				oldBackY1= add->addBackRect.drY1;
    DocumentRectangle		drChanged;

    drChanged= td->tdSelectedRectangle;
    drChanged.drX1= add->addBackRect.drX1;

    /*  1  */
    if  ( docGetHeaderFooter( &hf, &sectBi, ss, bs, bd, ss->ssInHeaderFooter ) )
	{ LDEB(ss->ssInHeaderFooter); return;	}

    hf->hfPageUsedFor= -1;

    /*  2  */
    if  ( tedReplaceSelection( &drChanged, &bsRep, ed,
					    (const unsigned char *)"?", 1 ) )
	{ LDEB(1); return;	}

    /*  3  */
    df= docClaimField( &fieldNumber, &(bd->bdFieldList) );
    if  ( ! df )
	{ XDEB(df); return;	}

    if  ( docSetFieldInst( df,
			(unsigned char *)fieldInst, strlen( fieldInst ) ) )
	{ SDEB(fieldInst); return;	}

    /*  4  */
    if  ( docSurroundTextSelectionByField( &bsField, &bsRep, fieldNumber ) )
	{ LDEB(1); return;	}

    df->dfKind= DOCfkPAGE;

    /*  5  */
    if  ( tedFinishSetField( ed, ss, &bsField,
				    &drChanged, oldBackY1, FIELDdoNOTHING ) )
	{ LDEB(fieldNumber);	}

    return;
    }
