/************************************************************************/
/*									*/
/*  A tool to manage the headers and footers of a Document/Section.	*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

static void tedFormatToolRefreshHeadFootPage(	HeaderFooterTool *	hft )
    {
    const SectionProperties *	sp= &(hft->hftSectPropertiesChosen);
    const DocumentProperties *	dp= &(hft->hftDocPropertiesChosen);

    int				i;

    appGuiSetToggleState( hft->hftTitlepgToggle, sp->spHasTitlePage );

    appGuiSetToggleState( hft->hftFacingpToggle, dp->dpHasFacingPages );

    for ( i= 0; i < PAGES__COUNT; i++ )
	{
	appGuiEnableWidget( hft->hftPagesItems[i],
					hft->hftPagesOptionsEnabled[i] );
	}

    if  ( hft->hftPagesChosen < 0				||
	  hft->hftPagesChosen >= PAGES__COUNT			||
	  ! hft->hftPagesOptionsEnabled[hft->hftPagesChosen]	)
	{
	for ( i= 0; i < PAGES__COUNT; i++ )
	    {
	    if  ( hft->hftPagesOptionsEnabled[i] )
		{
		appSetOptionmenu( &(hft->hftPagesOptionmenu), i );
		hft->hftPagesChosen= i;
		break;
		}
	    }
	}

    return;
    }

void tedFormatToolRefreshHeaderFooterTool(	HeaderFooterTool *	hft,
						InspectorSubject *	is,
					const BufferSelection *		bs,
					const DocumentProperties *	dpSet )
    {
    unsigned int		changed= DPupdNONE;
    BufferItem *		sectBi;
    const SectionProperties *	spSet;

    sectBi= bs->bsBegin.bpBi;
    while( sectBi && sectBi->biLevel > DOClevSECT )
	{ sectBi= sectBi->biParent;	}

    if  ( ! sectBi )
	{ XDEB(sectBi); return;	}

    hft->hftSectionNumber= sectBi->biNumberInParent;
    spSet= &(sectBi->biSectProperties);

    /**********/

    if  ( docUpdDocProperties( &changed, &(hft->hftDocPropertiesChosen),
						DPupdFACING_PAGES, dpSet ) )
	{ LDEB(1); return;	}
    if  ( docUpdDocProperties( &changed, &(hft->hftDocPropertiesSet),
						DPupdFACING_PAGES, dpSet ) )
	{ LDEB(1); return;	}

    if  ( docUpdSectProperties( &changed, &(hft->hftSectPropertiesChosen),
						SPupdTITLEPG, spSet ) )
	{ LDEB(1); return;	}
    if  ( docUpdSectProperties( &changed, &(hft->hftSectPropertiesSet),
						SPupdTITLEPG, spSet ) )
	{ LDEB(1); return;	}

    /**********/

    hft->hftPagesOptionsEnabled[PAGES_FIRST_PAGE]=
					    spSet->spHasTitlePage;
    hft->hftPagesOptionsEnabled[PAGES_SUBSEQUENT_PAGES]=
					    spSet->spHasTitlePage	&&
					    ! dpSet->dpHasFacingPages;
    hft->hftPagesOptionsEnabled[PAGES_ALL_PAGES]=
					    ! spSet->spHasTitlePage	&&
					    ! dpSet->dpHasFacingPages;
    hft->hftPagesOptionsEnabled[PAGES_ODD_PAGES]=
					    dpSet->dpHasFacingPages;
    hft->hftPagesOptionsEnabled[PAGES_EVEN_PAGES]=
					    dpSet->dpHasFacingPages;

    /**********/

    tedFormatToolRefreshHeadFootPage( hft );

    return;
    }

/************************************************************************/
/*									*/
/*  Set/Revert buttons have been pushed.				*/
/*									*/
/************************************************************************/

static void tedHeadFootChangeDocPushed(		APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;
    DocumentProperties *	dp= &(hft->hftDocPropertiesChosen);

    tedSetDocumentProperties( hft->hftApplication, dp, DPupdFACING_PAGES );

    return;
    }

static void tedHeadFootChangeSectPushed(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;
    SectionProperties *		sp= &(hft->hftSectPropertiesChosen);

    TextAttribute		taNew;

    docInitTextAttribute ( &taNew );

    if  ( tedAppChangeSectionProperties( hft->hftApplication,
							SPupdTITLEPG, sp ) )
	{ LDEB(1);	}

    return;
    }

static void tedHeadFootRevertDocPushed(		APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;
    DocumentProperties *	dp= &(hft->hftDocPropertiesChosen);

    unsigned int		changed= DPupdNONE;

    if  ( docUpdDocProperties( &changed, dp,
			    DPupdFACING_PAGES, &(hft->hftDocPropertiesSet) ) )
	{ LDEB(1); return;	}

    tedFormatToolRefreshHeadFootPage( hft );

    return;
    }

static void tedHeadFootRevertSectPushed(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;
    SectionProperties *		sp= &(hft->hftSectPropertiesChosen);

    unsigned int		changed= SPupdNONE;

    if  ( docUpdSectProperties( &changed, sp,
				SPupdTITLEPG, &(hft->hftSectPropertiesSet) ) )
	{ LDEB(1); return;	}

    tedFormatToolRefreshHeadFootPage( hft );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Titlepg' toggle was pushed.					*/
/*  The 'Facingp' toggle was pushed.					*/
/*									*/
/************************************************************************/

static void tedHeaderFooterToggleTitlepg(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidtbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;
    SectionProperties *		sp= &(hft->hftSectPropertiesChosen);
    int				set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    sp->spHasTitlePage= ( set != 0 );

    return;
    }

static void tedHeaderFooterToggleFacingp(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidtbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;
    DocumentProperties *	dp= &(hft->hftDocPropertiesChosen);
    int				set;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    dp->dpHasFacingPages= ( set != 0 );

    return;
    }

/************************************************************************/
/*									*/
/*  A kind of pages was chosen in the optionmenu.			*/
/*									*/
/************************************************************************/

static void tedHeadFootPagesChosen(	APP_WIDGET	w,
					void *		voidhft,
					void *		voidtbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;

    int				pages= -1;

    for ( pages= 0; pages < PAGES__COUNT; pages++ )
	{
	if  ( hft->hftPagesItems[pages] == w )
	    { break;	}
	}

    if  ( pages >= 0 && pages < PAGES__COUNT )
	{ hft->hftPagesChosen= pages;		}
    else{ LLDEB(pages,PAGES__COUNT);		}

    return;
    }


/************************************************************************/
/*									*/
/*  Delete/Edit Headers/Footers.					*/
/*									*/
/************************************************************************/

static const int TED_HeaderScopes[PAGES__COUNT]=
    {
    DOCinFIRST_HEADER,
    DOCinSECT_HEADER,
    DOCinSECT_HEADER,
    DOCinRIGHT_HEADER,
    DOCinLEFT_HEADER,
    };

static const int TED_FooterScopes[PAGES__COUNT]=
    {
    DOCinFIRST_FOOTER,
    DOCinSECT_FOOTER,
    DOCinSECT_FOOTER,
    DOCinRIGHT_FOOTER,
    DOCinLEFT_FOOTER,
    };

static void tedHeadFootDeleteHeaderPushed(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;

    if  ( hft->hftPagesChosen < 0		||
	  hft->hftPagesChosen >= PAGES__COUNT	)
	{ LLDEB(hft->hftPagesChosen,PAGES__COUNT); return;	}

    tedAppDeleteHeaderFooter( hft->hftApplication,
				    TED_HeaderScopes[hft->hftPagesChosen] );
    return;
    }

static void tedHeadFootEditHeaderPushed(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;

    if  ( hft->hftPagesChosen < 0		||
	  hft->hftPagesChosen >= PAGES__COUNT	)
	{ LLDEB(hft->hftPagesChosen,PAGES__COUNT); return;	}

    tedAppEditHeaderFooter( hft->hftApplication,
				    TED_HeaderScopes[hft->hftPagesChosen] );
    return;
    }

static void tedHeadFootDeleteFooterPushed(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;

    if  ( hft->hftPagesChosen < 0		||
	  hft->hftPagesChosen >= PAGES__COUNT	)
	{ LLDEB(hft->hftPagesChosen,PAGES__COUNT); return;	}

    tedAppDeleteHeaderFooter( hft->hftApplication,
				    TED_FooterScopes[hft->hftPagesChosen] );
    return;
    }

static void tedHeadFootEditFooterPushed(	APP_WIDGET	w,
						void *		voidhft,
						void *		voidpbcs )
    {
    HeaderFooterTool *		hft= (HeaderFooterTool *)voidhft;

    if  ( hft->hftPagesChosen < 0		||
	  hft->hftPagesChosen >= PAGES__COUNT	)
	{ LLDEB(hft->hftPagesChosen,PAGES__COUNT); return;	}

    tedAppEditHeaderFooter( hft->hftApplication,
				    TED_FooterScopes[hft->hftPagesChosen] );
    return;
    }

/************************************************************************/
/*									*/
/*  Make the 'HeaderFooter' page of the format tool.			*/
/*									*/
/************************************************************************/

void tedFormatFillHeaderFooterPage( HeaderFooterTool *		hft,
			    const HeaderFooterPageResources *	hfpr,
			    InspectorSubject *			is,
			    APP_WIDGET				pageWidget,
			    const InspectorSubjectResources *	isr )
    {
    APP_WIDGET	row= (APP_WIDGET )0;

    const int	heightResizable= 0;

    docInitDocumentProperties( &(hft->hftDocPropertiesSet) );
    docInitDocumentProperties( &(hft->hftDocPropertiesChosen) );
    docInitSectionProperties( &(hft->hftSectPropertiesSet) );
    docInitSectionProperties( &(hft->hftSectPropertiesChosen) );

    /**************/

    appMakeColumnFrameInColumn( &(hft->hftSectionFrame),
			    &(hft->hftSectionPaned),
			    pageWidget, hfpr->hfprSectionHeaderText );

    row= appMakeRowInColumn( hft->hftSectionPaned, 1, heightResizable );
    hft->hftTitlepgToggle= appMakeToggleInRow( row, hfpr->hfprTitlepgText,
				tedHeaderFooterToggleTitlepg, (void *)hft, 0 );

    appInspectorMakeButtonRow( &row, hft->hftSectionPaned,
		&(is->isRevertButton), &(is->isApplyButton),
		isr->isrRevert, isr->isrApplyToSubject,
		tedHeadFootRevertSectPushed, tedHeadFootChangeSectPushed,
		(void *)hft );

    /**************/

    appMakeColumnFrameInColumn( &(hft->hftDocumentFrame),
			    &(hft->hftDocumentPaned),
			    pageWidget, hfpr->hfprDocumentHeaderText );

    row= appMakeRowInColumn( hft->hftDocumentPaned, 1, heightResizable );
    hft->hftFacingpToggle= appMakeToggleInRow( row, hfpr->hfprFacingpText,
				tedHeaderFooterToggleFacingp, (void *)hft, 0 );

    appInspectorMakeButtonRow( &row, hft->hftDocumentPaned,
		&(hft->hftRevertDocButton), &(hft->hftChangeDocButton),
		hfpr->hfprRevertDocText, hfpr->hfprChangeDocText,
		tedHeadFootRevertDocPushed, tedHeadFootChangeDocPushed,
		(void *)hft );

    /**************/

    appMakeColumnFrameInColumn( &(hft->hftPagesFrame),
			    &(hft->hftPagesPaned),
			    pageWidget, hfpr->hfprPagesHeaderText );

    appMakeOptionmenuInColumn( &(hft->hftPagesOptionmenu),
						    hft->hftPagesPaned );

    appInspectorMakeButtonRow( &row, hft->hftPagesPaned,
		&(hft->hftDeleteHeaderButton), &(hft->hftEditHeaderButton),
		hfpr->hfprDeleteHeaderText, hfpr->hfprEditHeaderText,
		tedHeadFootDeleteHeaderPushed, tedHeadFootEditHeaderPushed,
		(void *)hft );

    appInspectorMakeButtonRow( &row, hft->hftPagesPaned,
		&(hft->hftDeleteFooterButton), &(hft->hftEditFooterButton),
		hfpr->hfprDeleteFooterText, hfpr->hfprEditFooterText,
		tedHeadFootDeleteFooterPushed, tedHeadFootEditFooterPushed,
		(void *)hft );

    /**************/

    return;
    }

/************************************************************************/
/*									*/
/*  Finish the Header/Footer page.					*/
/*									*/
/************************************************************************/

void tedFormatFillHeaderFooterChoosers( HeaderFooterTool *		hft,
				    const HeaderFooterPageResources *	hfpr )
    {
    appFillInspectorMenu( PAGES__COUNT, PAGES_ALL_PAGES,
			hft->hftPagesItems, hfpr->hfprPagesOptionTexts,
			&(hft->hftPagesOptionmenu),
			tedHeadFootPagesChosen, (void *)hft );

    hft->hftPagesChosen= PAGES_ALL_PAGES;

    return;
    }

void tedFormatFinishHeaderFooterPage( HeaderFooterTool *		hft,
				    TedFormatTool *			tft,
				    const HeaderFooterPageResources *	hfpr )
    {
    appOptionmenuRefreshWidth( &(hft->hftPagesOptionmenu) );

    return;
    }

/************************************************************************/
/*									*/
/*  Get Header/Footer tool resources.					*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedHeaderFooterSubjectResourceTable[]=
    {
    APP_RESOURCE( "formatToolHeaderFooter",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Headers and Footers" ),

    APP_RESOURCE( "formatToolHeadFootChangeSection",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply to Section" ),
    APP_RESOURCE( "formatToolHeadFootRevertSection",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert" ),
    };

static AppConfigurableResource TED_TedHeaderFooterToolResourceTable[]=
    {
    APP_RESOURCE( "formatToolHeadFootSectionHeader",
		offsetof(HeaderFooterPageResources,hfprSectionHeaderText),
		"Section Properties" ),
    APP_RESOURCE( "formatToolHeadFootTitlepgText",
		offsetof(HeaderFooterPageResources,hfprTitlepgText),
		"Different first Page" ),

    APP_RESOURCE( "formatToolHeadFootDocumentHeader",
		offsetof(HeaderFooterPageResources,hfprDocumentHeaderText),
		"Document Properties" ),
    APP_RESOURCE( "formatToolHeadFootFacingpText",
		offsetof(HeaderFooterPageResources,hfprFacingpText),
		"Different odd and even Pages" ),
    APP_RESOURCE( "formatToolHeadFootChangeDocument",
		offsetof(HeaderFooterPageResources,hfprChangeDocText),
		"Apply to Document" ),
    APP_RESOURCE( "formatToolHeadFootRevertDocument",
		offsetof(HeaderFooterPageResources,hfprRevertDocText),
		"Revert" ),

    APP_RESOURCE( "formatToolHeadFootPagesHeader",
		offsetof(HeaderFooterPageResources,hfprPagesHeaderText),
		"Pages in Section" ),

    APP_RESOURCE( "formatToolHeadFootFirstPage",
		offsetof(HeaderFooterPageResources,
				hfprPagesOptionTexts[PAGES_FIRST_PAGE]),
		"First Page" ),
    APP_RESOURCE( "formatToolHeadFootSubsequentPages",
		offsetof(HeaderFooterPageResources,
				hfprPagesOptionTexts[PAGES_SUBSEQUENT_PAGES]),
		"Subsequent Pages" ),
    APP_RESOURCE( "formatToolHeadFootAllPages",
		offsetof(HeaderFooterPageResources,
				hfprPagesOptionTexts[PAGES_ALL_PAGES]),
		"All Pages" ),
    APP_RESOURCE( "formatToolHeadFootOddPages",
		offsetof(HeaderFooterPageResources,
				hfprPagesOptionTexts[PAGES_ODD_PAGES]),
		"Odd Pages" ),
    APP_RESOURCE( "formatToolHeadFootEvenPages",
		offsetof(HeaderFooterPageResources,
				hfprPagesOptionTexts[PAGES_EVEN_PAGES]),
		"Even Pages" ),

    APP_RESOURCE( "formatToolHeadFootDeleteHeader",
		offsetof(HeaderFooterPageResources,hfprDeleteHeaderText),
		"Delete Header" ),
    APP_RESOURCE( "formatToolHeadFootEditHeader",
		offsetof(HeaderFooterPageResources,hfprEditHeaderText),
		"Edit Header" ),
    APP_RESOURCE( "formatToolHeadFootDeleteFooter",
		offsetof(HeaderFooterPageResources,hfprDeleteFooterText),
		"Delete Footer" ),
    APP_RESOURCE( "formatToolHeadFootEditFooter",
		offsetof(HeaderFooterPageResources,hfprEditFooterText),
		"Edit Footer" ),
    };

void tedFormatToolGetHeaderFooterResourceTable( EditApplication *	ea,
					HeaderFooterPageResources *	hfpr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)hfpr,
				TED_TedHeaderFooterToolResourceTable,
				sizeof(TED_TedHeaderFooterToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				TED_TedHeaderFooterSubjectResourceTable,
				sizeof(TED_TedHeaderFooterSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
