/************************************************************************/
/*									*/
/*  Format tool:							*/
/*									*/
/************************************************************************/

#   ifndef	TED_FORMAT_TOOL_H
#   define	TED_FORMAT_TOOL_H

#   include	"tedParaTool.h"
#   include	"tedRowTool.h"
#   include	"tedSectionTool.h"
#   include	"tedPageLayoutTool.h"
#   include	"tedNotesTool.h"
#   include	"tedHeaderFooterTool.h"
#   include	"tedTableTool.h"

/************************************************************************/
/*									*/
/*  Resources for the 'Column' and 'Cell' pages.			*/
/*									*/
/************************************************************************/

typedef struct ColumnPageResources
    {
    char *		cprRow;
    char *		cprColumn;

    char *		cprWidth;
    char *		cprLeftBorder;
    char *		cprRightBorder;

    char *		cprTopBorder;
    char *		cprBottomBorder;
    char *		cprColumnSpan;
    char *		cprShadingPattern;
    char *		cprVerticalAlignment;
    } ColumnPageResources;

/************************************************************************/
/*									*/
/*  A Column tool, i.e. the 'Column' page of the format tool.		*/
/*  A Cell tool, i.e. the 'Cell' page of the format tool.		*/
/*									*/
/************************************************************************/

typedef struct ColumnTool
    {
    EditApplication *		ctApplication;

    TableRectangle		ctTableRectangle;

    int				ctPageRight;
    int				ctPageLeftMargin;

    RowProperties		ctPropertiesSet;
    RowProperties		ctPropertiesChosen;

    APP_WIDGET			ctNumberText;
    APP_WIDGET			ctWidthText;

    BorderTool			ctLeftBorderTool;
    BorderTool			ctRightBorderTool;
    } ColumnTool;

typedef struct CellTool
    {
    EditApplication *		ctApplication;

    TableRectangle		ctTableRectangle;

    CellProperties		ctPropertiesSet;
    CellProperties		ctPropertiesChosen;

    APP_WIDGET			ctRowText;
    APP_WIDGET			ctColumnText;

    BorderTool			ctTopBorderTool;
    BorderTool			ctBottomBorderTool;
    BorderTool			ctLeftBorderTool;
    BorderTool			ctRightBorderTool;

    ShadingTool			ctShadingTool;
    } CellTool;

/************************************************************************/
/*									*/
/*  The different pages in a Format tool:				*/
/*									*/
/************************************************************************/

typedef enum ToolSubjectIndex
    {
    TEDtsiTABLE= 0,
    TEDtsiROW,
    TEDtsiCOLUMN,
    TEDtsiCELL,
    TEDtsiPARA,
    TEDtsiSECT,
    TEDtsiPAGE,
    TEDtsiHEADFOOT,
    TEDtsiNOTES,

    TEDtsiCOUNT

    } ToolSubjectIndex;

/************************************************************************/
/*									*/
/*  Represents a format tool.						*/
/*									*/
/************************************************************************/

typedef struct TedFormatTool
    {
    EditApplication *		tftApplication;

    TableTool			tftTableTool;
    RowTool			tftRowTool;
    ColumnTool			tftColumnTool;
    CellTool			tftCellTool;
    ParagraphTool		tftParagraphTool;
    SectionTool			tftSectionTool;
    PageLayoutTool		tftPageLayoutTool;
    HeaderFooterTool		tftHeaderFooterTool;
    NotesTool			tftNotesTool;

    AppDrawingData		tftPixmapAdd;
    int				tftPixmapAddAllocated;

    APP_BITMAP_IMAGE		tftShadingPixmaps[DOCsp_COUNT];
    APP_BITMAP_IMAGE		tftBorderPixmaps[DOCbs_COUNT];
    } TedFormatTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void tedFormatRefreshHeightChooser(	HeightChooser *	hc,
						int		height );

extern void tedFormatHeightChosen(	APP_WIDGET		w,
					HeightChooser *		hc,
					int			defaultValue );

extern void tedFormatMakeHeightRow(	APP_WIDGET *		pRow,
					void *			through,
					APP_WIDGET		parent,
					HeightChooser *		hc,
					APP_CALLBACK_FUNC	callback );

extern void tedFormatFillParagraphPage(	ParagraphTool *			pt,
					const ParagraphPageResources * ppr,
					InspectorSubject *		is,
					APP_WIDGET			pgW,
					const InspectorSubjectResources * fpr );

extern void tedFormatFinishParagraphPage( ParagraphTool *		pt,
					TedFormatTool *			tft,
					const ParagraphPageResources *	ppr );

extern void tedFormatFinishRowPage( 	RowTool *			rt,
					TedFormatTool *			tft,
					const RowPageResources *	rpr );

extern void tedFormatFillParagraphChoosers( ParagraphTool *		pt,
					const ParagraphPageResources *	ppr );

extern void tedFormatFillHeightChooser(	HeightChooser *		hc,
					APP_CALLBACK_FUNC	callback,
					void *			voidtft,
					const char *		freeText,
					const char *		atLeastText,
					const char *		exactlyText );

extern int tedFormatToolGetHeight(	int *		pHeight,
					HeightChooser *	hc );

extern void tedFormatReflectBorder(	BorderTool *			bt,
					const BorderProperties *	bp );

extern void tedFormatFillRowPage( RowTool *			rt,
				const RowPageResources *	rpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFillRowChoosers(	RowTool *			rt,
					const RowPageResources *	rpr );

extern void tedFormatToolRefreshParagraphTool(	ParagraphTool *		pt,
						InspectorSubject *	is,
						const BufferSelection *	bs );

extern void tedFormatToolRefreshSectionTool(	SectionTool *		st,
						InspectorSubject *	is,
						const BufferSelection *	bs );

extern void tedFormatFillTablePage( TableTool *			tt,
				const TablePageResources *	tpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern int tedFormatToolGetRowLeftIndent( const RowProperties *	rp,
					const int		pageLeftMargin,
					int *			pValue,
					APP_WIDGET		w );

extern int tedFormatToolGetGapWidth(	const RowProperties *	rp,
					int *			pValue,
					APP_WIDGET		w );

extern void tedFormatFillColumnPage(	ColumnTool *		ct,
				const ColumnPageResources *	cpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatToolRefreshColumnTool(	ColumnTool *		ct,
						InspectorSubject *	is,
						const TableRectangle *	tr,
						const BufferSelection *	bs );

extern void tedFormatToolRefreshRowTool(	RowTool *		rt,
						InspectorSubject *	is,
						const TableRectangle *	tr,
						const BufferSelection *	bs );

extern void tedFormatToolRefreshTableTool(	TableTool *		tt,
						InspectorSubject *	is,
						const TableRectangle *	tr,
						const BufferSelection *	bs );

extern void tedFormatToggleBorder(	BorderProperties *	bp,
					BorderTool *		bt,
					int			doStyleMenu,
					int			set );

extern void tedFormatFillSectionPage(	SectionTool *		st,
				const SectionPageResources *	spr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFillSectionChoosers( SectionTool *			st,
					const SectionPageResources *	spr );

extern void tedFormatFinishSectionPage(	SectionTool *			st,
					TedFormatTool *			tft,
					const SectionPageResources *	spr );

extern void tedFormatToolRefreshPageLayoutTool(	PageLayoutTool *	plt,
						InspectorSubject *	is,
						const BufferSelection *	bs,
						const DocumentProperties * dp );

extern void tedFormatFillPageLayoutPage( PageLayoutTool *		plt,
				const PageLayoutPageResources *	plpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFillPageLayoutChoosers(	PageLayoutTool *	plt,
					const PageLayoutPageResources *	plpr );

extern void tedFormatFinishPageLayoutPage(	PageLayoutTool *	plt,
					TedFormatTool *			tft,
					const PageLayoutPageResources *	plpr );

extern void tedFormatToolRefreshNotesTool( NotesTool *			nt,
					InspectorSubject *		is,
					const DocumentProperties *	dp );

extern void tedFormatFillNotesPage( NotesTool *			nt,
				const NotesPageResources *	npr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFillNotesChoosers(	NotesTool *			nt,
					const NotesPageResources *	npr );

extern void tedFormatFinishNotesPage(	NotesTool *			nt,
					TedFormatTool *			tft,
					const NotesPageResources *	npr );

extern int tedFormatValidateDimension(		int *		pNewValue,
						int *		pChanged,
						APP_WIDGET	w,
						int		oldValue );

extern void tedFormatToolRefreshCellTool(	CellTool *		ct,
						InspectorSubject *	is,
						const TableRectangle *	tr,
						const BufferSelection *	bs );

extern void tedFormatFillCellPage( CellTool *			ct,
				const ColumnPageResources *	cpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFinishColumnPage(	ColumnTool *			ct,
					TedFormatTool *			tft,
					const ColumnPageResources *	cpr );

extern void tedFormatFillColumnChoosers( ColumnTool *			ct,
					const ColumnPageResources *	cpr );

extern void tedFormatFinishCellPage(	CellTool *			ct,
					TedFormatTool *			tft,
					const ColumnPageResources *	cpr );

extern void tedFormatFillCellChoosers(	CellTool *			ct,
					const ColumnPageResources *	cpr );

extern void tedFormatMakeBorderTool(	BorderTool *		bt,
					APP_WIDGET *		pRow,
					APP_WIDGET		page,
					const char *		text,
					APP_TOGGLE_CALLBACK	callback,
					void *			through );

extern void tedFormatCleanShadingTool(	ShadingTool *		st );
extern void tedFormatCleanBorderTool(	BorderTool *		bt );

extern void tedFormatMakeShadingTool(	ShadingTool *		st,
					APP_WIDGET *		pRow,
					APP_WIDGET		page,
					const char *		text );

extern void tedFormatFillShadingTool(	ShadingTool *		st,
					APP_BUTTON_CALLBACK	callBack,
					void *			target );

extern void tedFormatFinishShadingTool(	ShadingTool *		st,
					TedFormatTool *		tft );

extern void tedFormatFinishBorderTool(	BorderTool *		bt,
					TedFormatTool *		tft );

extern void tedFormatFillHeaderFooterPage( HeaderFooterTool *		hft,
				const HeaderFooterPageResources *	hfpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr );

extern void tedFormatFillHeaderFooterChoosers( HeaderFooterTool *	hft,
				    const HeaderFooterPageResources *	hfpr );

extern void tedFormatFinishHeaderFooterPage( HeaderFooterTool *		hft,
				    TedFormatTool *			tft,
				    const HeaderFooterPageResources *	hfpr );

#   endif	/*  TED_FORMAT_TOOL_H */
