/************************************************************************/
/*									*/
/*  Format changes to the document/selection.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Change the attributes of the selection.				*/
/*									*/
/*  1)  Adjust the start line for recalculating the layout of the first	*/
/*	paragraph in the selection.					*/
/*  2)  If necessary, split the first particule to change the text	*/
/*	attributes of the second half.					*/
/*  3)  For all paragraphs in the selection upto the last one..		*/
/*  4)  Change the text attributes.					*/
/*									*/
/************************************************************************/

static int tedChangeParaProperties( unsigned int *		pPpChgMask,
				    unsigned int *		pTaChgMask,
				    BufferItem *		paraBi,
				    int				partFrom,
				    int				partUpto,
				    AppDrawingData *		add,
				    DocumentFontList *		dfl,
				    unsigned int		taUpdMask,
				    TextAttribute		taNew,
				    unsigned int		ppUpdMask,
				    const ParagraphProperties *	ppNew )
    {
    unsigned int	ppChgMask= 0;
    unsigned int	taChgMask= 0;

    if  ( taUpdMask )
	{
	TextParticule *		tp= paraBi->biParaParticules+ partFrom;
	int			part;

	tp= paraBi->biParaParticules+ partFrom;
	for ( part= partFrom; part < partUpto; tp++, part++ )
	    {
	    taChgMask |= docAttributeDifference(
				    tp->tpTextAttribute, taNew, taUpdMask );

	    if  ( tedChangeParticuleAttribute( add, tp, dfl,
						    taUpdMask, taNew ) )
		{ XDEB(taUpdMask); return -1;	}
	    }
	}

    if  ( ppUpdMask )
	{
	if  ( docUpdParaProperties( &ppChgMask, paraBi, ppUpdMask, ppNew ) )
	    { XDEB(ppUpdMask); return -1;	}

	if  ( ppChgMask )
	    { tedParaScreenGeometry( paraBi, add );	}
	}

    *pTaChgMask= taChgMask;
    *pPpChgMask= ppChgMask;
    return 0;
    }

static int tedChangeSectionProperties(	unsigned int *		pSpChgMask,
					BufferItem *		sectBi,
					unsigned int		spUpdMask,
					const SectionProperties * spNew,
					DocumentRectangle *	drChanged,
					const DocumentRectangle * drBack )
    {
    unsigned int	spChgMask= SPupdNONE;

    if  ( docUpdSectProperties( &spChgMask,
			    &(sectBi->biSectProperties), spUpdMask, spNew ) )
	{ XDEB(spUpdMask); return -1;	}

    if  ( spChgMask			&&
	  ( SPupdTITLEPG	|
	    SPupdNUMBER_STYLE	|
	    SPupdPAGE_RESTART	|
	    SPupdSTART_PAGE	)	)
	{ docUnionRectangle( drChanged, drChanged, drBack );	}

    if  ( spChgMask			&&
	  ( SPupdNUMBER_STYLE	|
	    SPupdPAGE_RESTART	|
	    SPupdSTART_PAGE	)	)
	{
	sectBi->biSectHeader.hfPageUsedFor= -1;
	sectBi->biSectFirstPageHeader.hfPageUsedFor= -1;
	sectBi->biSectLeftPageHeader.hfPageUsedFor= -1;
	sectBi->biSectRightPageHeader.hfPageUsedFor= -1;

	sectBi->biSectFooter.hfPageUsedFor= -1;
	sectBi->biSectFirstPageFooter.hfPageUsedFor= -1;
	sectBi->biSectLeftPageFooter.hfPageUsedFor= -1;
	sectBi->biSectRightPageFooter.hfPageUsedFor= -1;
	}

    *pSpChgMask |= spChgMask;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Use the new ruler settings, or other geometry properties of a	*/
/*  BufferItem.								*/
/*									*/
/************************************************************************/

static void tedApplyItemFormat(	BufferItem *			bi,
				const BufferDocument *		bd,
				int				inHeaderFooter,
				AppDrawingData *		add,
				DocumentRectangle *		drChanged )
    {
    DocumentRectangle	drLocal;

    drLocal.drX0= add->addBackRect.drX0;
    drLocal.drX1= add->addBackRect.drX1;
    drLocal.drY0= bi->biTopPosition.lpYPixels;
    drLocal.drY1= bi->biBelowPosition.lpYPixels;

    if  ( tedLayoutItem( bi, bd, inHeaderFooter, add, &drLocal ) )
	{ LDEB(1); return;	}

    docUnionRectangle( drChanged, drChanged, &drLocal );

    drLocal.drX0= add->addBackRect.drX0;
    drLocal.drX1= add->addBackRect.drX1;
    drLocal.drY0= bi->biTopPosition.lpYPixels;
    drLocal.drY1= bi->biBelowPosition.lpYPixels;

    docUnionRectangle( drChanged, drChanged, &drLocal );

    return;
    }

/************************************************************************/
/*									*/
/*  Change properties of the current selection.				*/
/*									*/
/************************************************************************/

int tedChangeSelectionProperties( EditDocument *		ed,
				unsigned int			taUpdMask,
				TextAttribute			taNew,
				unsigned int			ppUpdMask,
				const ParagraphProperties *	ppNew,
				unsigned int			spUpdMask,
				const SectionProperties *	spNew )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    int				oldBackY1= add->addBackRect.drY1;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    const BufferSelection *	bs= &(td->tdSelection);
    const SelectionScope *	ss= &(td->tdSelectionScope);
    int				inHeaderFooter= ss->ssInHeaderFooter;
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);
    DocumentFontList *		dfl= &(dp->dpFontList);

    int				part;

    TextParticule *		tp;

    BufferItem *		paraBi= bs->bsBegin.bpBi;
    BufferItem *		sectBi= (BufferItem *)0;

    DocumentRectangle		drChanged;
    
    int				firstParticuleSplit= 0;

    unsigned int		selTaChgMask= 0;
    unsigned int		selPpChgMask= 0;
    unsigned int		selSpChgMask= 0;
    unsigned int		paraTaChgMask;
    unsigned int		paraPpChgMask;
    unsigned int		sectSpChgMask;

    if  ( ! paraBi )
	{ XDEB(paraBi); return -1; }

    if  ( tedHasIBarSelection( td ) )
	{ taUpdMask= 0;	}

    part= bs->bsBegin.bpParticule;

    drChanged= td->tdSelectedRectangle;
    drChanged.drX0= add->addBackRect.drX0;
    drChanged.drX1= add->addBackRect.drX1;

    /*  1  */
    tp= paraBi->biParaParticules+ part;

    /*  2  */
    if  ( (unsigned)bs->bsBegin.bpStroff > tp->tpStroff			&&
	  docAttributeDifference( tp->tpTextAttribute, taNew,
							    taUpdMask )	)
	{
	int		stroff= bs->bsBegin.bpStroff;

	if  ( (unsigned)stroff < tp->tpStroff+ tp->tpStrlen )
	    {
	    TextParticule *	newTp;

	    newTp= docCopyParticule( paraBi, part+ 1, stroff,
			tp->tpStroff+ tp->tpStrlen- stroff, DOCkindTEXT, tp );
	    if  ( ! newTp )
		{ XDEB(newTp); return -1;	}

	    tp= paraBi->biParaParticules+ part;
	    tp->tpStrlen= stroff- tp->tpStroff;
	    tp= newTp; part++;

	    if  ( bs->bsEnd.bpBi == paraBi )
		{ firstParticuleSplit= 1;	}
	    }
	else{ tp++; part++; }
	}

    sectSpChgMask= 0;

    sectBi= paraBi->biParent->biParent->biParent;
    if  ( spUpdMask )
	{
	if  ( tedChangeSectionProperties( &sectSpChgMask, sectBi,
					    spUpdMask, spNew,
					    &drChanged, &(add->addBackRect) ) )
	    { XDEB(spUpdMask); return -1;	}

	selSpChgMask |= sectSpChgMask;
	}

    /*  3  */
    while( paraBi != bs->bsEnd.bpBi )
	{
	int	col;
	int	partUpto= paraBi->biParaParticuleCount;

	col= paraBi->biParent->biNumberInParent;

	if  ( bs->bsCol0 < 0					||
	      bs->bsCol1 < 0					||
	      ( col >= bs->bsCol0 && col <= bs->bsCol1 )	)
	    {
	    /*  4  */
	    if  ( tedChangeParaProperties( &paraPpChgMask, &paraTaChgMask,
				    paraBi, part, partUpto, add, dfl,
				    taUpdMask, taNew, ppUpdMask, ppNew ) )
		{ XXDEB(taUpdMask,ppUpdMask);	}

	    if  ( sectBi != paraBi->biParent->biParent->biParent )
		{
		if  ( sectSpChgMask )
		    {
		    tedApplyItemFormat( sectBi, bd,
					inHeaderFooter, add, &drChanged );
		    }

		sectBi= paraBi->biParent->biParent->biParent;
		if  ( spUpdMask )
		    {
		    if  ( tedChangeSectionProperties( &sectSpChgMask, sectBi,
					    spUpdMask, spNew,
					    &drChanged, &(add->addBackRect) ) )
			{ XDEB(spUpdMask); return -1;	}

		    selSpChgMask |= sectSpChgMask;
		    }
		}

	    if  ( paraPpChgMask || paraTaChgMask )
		{
		tedApplyItemFormat( paraBi, bd,
					    inHeaderFooter, add, &drChanged );

		if  ( paraPpChgMask && paraBi == bs->bsBegin.bpBi )
		    { tedDocAdaptHorizontalRuler( ed, paraBi );	}

		selTaChgMask |= paraTaChgMask;
		selPpChgMask |= paraPpChgMask;
		}
	    }

	paraBi= docNextParagraph( paraBi );
	if  ( ! paraBi )
	    { XDEB(paraBi); return -1;	}

	part= 0; firstParticuleSplit= 0;
	}

    /*  4  */
    if  ( tedChangeParaProperties( &paraPpChgMask, &paraTaChgMask, paraBi,
			part,
			bs->bsEnd.bpParticule+ firstParticuleSplit, add, dfl,
			taUpdMask, taNew, ppUpdMask, ppNew ) )
	{ XXDEB(taUpdMask,ppUpdMask);	}

    part= bs->bsEnd.bpParticule+ firstParticuleSplit;
    tp= paraBi->biParaParticules+ part;

    if  ( sectBi != paraBi->biParent->biParent->biParent )
	{
	if  ( sectSpChgMask )
	    {
	    tedApplyItemFormat( sectBi, bd, inHeaderFooter, add, &drChanged );
	    }

	sectBi= paraBi->biParent->biParent->biParent;
	if  ( spUpdMask )
	    {
	    if  ( tedChangeSectionProperties( &sectSpChgMask, sectBi,
					    spUpdMask, spNew,
					    &drChanged, &(add->addBackRect) ) )
		{ XDEB(spUpdMask); return -1;	}

	    selSpChgMask |= sectSpChgMask;
	    }
	}

    if  ( sectSpChgMask )
	{ tedApplyItemFormat( sectBi, bd, inHeaderFooter, add, &drChanged ); }

    if  ( part < paraBi->biParaParticuleCount				&&
	  docAttributeDifference( tp->tpTextAttribute, taNew,
							    taUpdMask )	)
	{
	int	strend= tp->tpStroff+ tp->tpStrlen;

	if  ( bs->bsEnd.bpStroff < strend )
	    {
	    TextParticule *	newTp;

	    newTp= docCopyParticule( paraBi, part+ 1, bs->bsEnd.bpStroff,
		    strend- bs->bsEnd.bpStroff,
		    DOCkindTEXT, tp );

	    if  ( ! newTp )
		{ XDEB(newTp); return -1;	}

	    tp= paraBi->biParaParticules+ part;
	    tp->tpStrlen= bs->bsEnd.bpStroff- tp->tpStroff;
	    }

	paraTaChgMask |= docAttributeDifference( tp->tpTextAttribute,
							taNew, taUpdMask );

	/*  2  */
	if  ( tedChangeParticuleAttribute( add, tp, dfl, taUpdMask, taNew ) )
	    { LDEB(1);	}
	}

    if  ( paraPpChgMask || paraTaChgMask )
	{
	tedApplyItemFormat( paraBi, bd, inHeaderFooter, add, &drChanged ); 

	if  ( paraPpChgMask && paraBi == bs->bsBegin.bpBi )
	    { tedDocAdaptHorizontalRuler( ed, paraBi );	}

	selPpChgMask |= paraPpChgMask;
	selTaChgMask |= paraTaChgMask;
	}

    if  ( selPpChgMask || selTaChgMask || selSpChgMask )
	{
	int				scrolledX= 0;
	int				scrolledY= 0;

	tedDelimitCurrentSelection( td, add );

	tedScrollToSelection( ed, &scrolledX, &scrolledY );

	tedExposeRectangle( ed, &drChanged, scrolledX, scrolledY );

	if  ( add->addBackRect.drY1 != oldBackY1 )
	    {
	    appDocSetScrollbarValues( ed );
	    appSetShellConstraints( ed );
	    }

	tedAdaptToolsToSelection( ed );

	appDocumentChanged( ed, 1 );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Utility routines around tedChangeSelectionProperties():		*/
/*									*/
/************************************************************************/

int tedAppChangeSectionProperties( EditApplication *		ea,
				unsigned int			spUpdMask,
				const SectionProperties *	spNew )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    TextAttribute		taNew;

    docInitTextAttribute ( &taNew );

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    if  ( tedChangeSelectionProperties( ed,
				    TAupdNONE, taNew,
				    PPupdNONE, (ParagraphProperties *)0,
				    spUpdMask, spNew ) )
	{ XDEB(spUpdMask); return -1;	}

    return 0;
    }

int tedAppChangeParagraphProperties( EditApplication *		ea,
				unsigned int			ppUpdMask,
				const ParagraphProperties *	ppNew )
    {
    EditDocument *		ed= ea->eaCurrentDocument;

    TextAttribute		taNew;

    docInitTextAttribute ( &taNew );

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    if  ( tedChangeSelectionProperties( ed,
				    TAupdNONE, taNew,
				    ppUpdMask, ppNew,
				    SPupdNONE, (SectionProperties *)0 ) )
	{ XDEB(ppUpdMask); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Delete a particular page Header/Footer from the first section of	*/
/*  the selection.							*/
/*									*/
/************************************************************************/

void tedAppDeleteHeaderFooter(		EditApplication *	ea,
					int			which )
    {
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    HeaderFooter *		hf;
    BufferItem *		sectBi;

    SelectionScope		ss;
    BufferSelection		bs;

    int				scrolledX= 0;
    int				scrolledY= 0;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;

    if  ( tedGetSelection( &ss, &bs, td ) )
	{ LDEB(1); return;	}

    if  ( docGetHeaderFooter( &hf, &sectBi, &ss, &bs, bd, which ) )
	{ LDEB(which); return;	}

    if  ( hf->hfItem )
	{
	AppDrawingData *	add= &(ed->edDrawingData);
	DocumentRectangle	drChanged= add->addBackRect;

	if  ( ss.ssInHeaderFooter == which )
	    {
	    int			docX;
	    int			docY;
	    BufferPosition	bp;

	    SelectionScope	ssBody;

	    docInitSelectionScope( &ssBody );
	    ssBody.ssInHeaderFooter= DOCinBODY;

	    docX= bs.bsBegin.bpXPixels;
	    docY= bs.bsBegin.bpBaselinePixels;

	    if  ( tedFindPosition( &(bd->bdItem), add, docX, docY, &bp ) )
		{ LLDEB(docX,docY); return;	}

	    tedSetSelectedPosition( ed, &ssBody, &bp, &scrolledX, &scrolledY );
	    }

	docCleanHeaderFooter( bd, hf );
	docInitHeaderFooter( hf );

	appDocumentChanged( ed, 1 );

	tedExposeRectangle( ed, &drChanged, scrolledX, scrolledY );
	}

    return;
    }

