/************************************************************************/
/*									*/
/*  Ted, Screen drawing and forcing drawing through			*/
/*  appExposeRectangle().						*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>

#   include	"tedApp.h"
#   include	"docDraw.h"

#   include	<appDebugon.h>

#   ifdef USE_MOTIF

#   include	<X11/cursorfont.h>

/************************************************************************/
/*									*/
/*  Create the windows that are used to reshape selected objects.	*/
/*									*/
/************************************************************************/

void tedSetObjectWindows(	EditDocument *		ed,
				const BufferPosition *	bp,
				int			ox,
				int			oy )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    Display *			display= add->addDisplay;
    Window			win= add->addDrawable;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    const BufferItem *		bi= bp->bpBi;
    const TextParticule *	tp= bi->biParaParticules+ bp->bpParticule;
    InsertedObject *		io= bi->biParaObjects+ tp->tpObjectNumber;
    int				wide= io->ioPixelsWide;
    int				high= io->ioPixelsHigh;

    XSetWindowAttributes	xswa;

    static Cursor		moveCursor;
    static Cursor		bottomCursor;
    static Cursor		rightCursor;
    static Cursor		cornerCursor;

    if  ( ! moveCursor )
	{
	moveCursor= XCreateFontCursor( display, XC_fleur );
	bottomCursor= XCreateFontCursor( display, XC_bottom_side );
	rightCursor= XCreateFontCursor( display, XC_right_side );
	cornerCursor= XCreateFontCursor( display, XC_bottom_right_corner );
	}

    if  ( ! td->tdObjectWindow )
	{
	xswa.cursor= moveCursor;
	td->tdObjectWindow= XCreateWindow( display, win,
			    bp->bpXPixels- ox, bp->bpBaselinePixels- high- oy,
			    wide, high,
			    0, CopyFromParent, InputOnly, CopyFromParent,
			    0L, &xswa );

	xswa.cursor= bottomCursor;
	td->tdObjectBottomWindow= XCreateWindow( display, td->tdObjectWindow,
			    wide/ 2- RESIZE_BLOCK/ 2, high- RESIZE_BLOCK,
			    RESIZE_BLOCK, RESIZE_BLOCK,
			    0, CopyFromParent, CopyFromParent, CopyFromParent,
			    CWCursor, &xswa );

	xswa.cursor= rightCursor;
	td->tdObjectRightWindow= XCreateWindow( display, td->tdObjectWindow,
			    wide- RESIZE_BLOCK, high/ 2- RESIZE_BLOCK/ 2,
			    RESIZE_BLOCK, RESIZE_BLOCK,
			    0, CopyFromParent, CopyFromParent, CopyFromParent,
			    CWCursor, &xswa );

	xswa.cursor= cornerCursor;
	td->tdObjectCornerWindow= XCreateWindow( display, td->tdObjectWindow,
			    wide- RESIZE_BLOCK, high- RESIZE_BLOCK,
			    RESIZE_BLOCK, RESIZE_BLOCK,
			    0, CopyFromParent, CopyFromParent, CopyFromParent,
			    CWCursor, &xswa );

	XMapRaised( display, td->tdObjectBottomWindow );
	XMapRaised( display, td->tdObjectRightWindow );
	XMapRaised( display, td->tdObjectCornerWindow );
	}
    else{
	XMoveResizeWindow( display, td->tdObjectWindow,
			    bp->bpXPixels- ox, bp->bpBaselinePixels- high- oy,
			    wide, high );

	XMoveWindow( display, td->tdObjectBottomWindow,
				wide/ 2- RESIZE_BLOCK/ 2, high- RESIZE_BLOCK );
	XMoveWindow( display, td->tdObjectRightWindow,
				wide- RESIZE_BLOCK, high/ 2- RESIZE_BLOCK/ 2 );
	XMoveWindow( display, td->tdObjectCornerWindow,
				wide- RESIZE_BLOCK, high- RESIZE_BLOCK );
	}

    XMapRaised( display, td->tdObjectWindow );

    td->tdObjectSelected= 1;
    }

void tedHideObjectWindows(	EditDocument *	ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    XUnmapWindow( XtDisplay( ed->edDocumentWidget ), td->tdObjectWindow );
    td->tdObjectSelected= 0;
    }

#   endif
