#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>
#   include	<ctype.h>

#   include	<sioStdio.h>

#   include	<appSpellTool.h>

#   include	"tedApp.h"
#   include	"tedRuler.h"
#   include	"docPs.h"

#   include	<appDebugon.h>

#   ifdef USE_MOTIF
#	include	<X11/cursorfont.h>
#   endif

/************************************************************************/
/*									*/
/*  Ted, callbacks for the DrawingArea.					*/
/*									*/
/************************************************************************/

void tedDrawRectangle(	APP_WIDGET		w,
			EditDocument *		ed,
			DocumentRectangle *	drClip,
			int			ox,
			int			oy )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    AppDrawingData *		add= &(ed->edDrawingData);
    AppColors *			ac= &(ed->edColors);

    /*  2,3,4  */
    tedRedrawRectangle( w, td, drClip, add, ac, ox, oy );
    }

/************************************************************************/
/*									*/
/*  Scrolling callbacks.						*/
/*									*/
/************************************************************************/

void tedMoveObjectWindows(	APP_WIDGET		w,
				EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    InsertedObject *		io;

    int				ox= ed->edVisibleRect.drX0;
    int				oy= ed->edVisibleRect.drY0;

    BufferPosition		bp;

    docInitPosition( &bp );

    if  ( tedGetObjectSelection( td, &bp, &io ) )
	{ LDEB(1); return;	}

    tedSetObjectWindows( ed, &bp, ox, oy );
    }

void tedDocHorizontalScrollbarCallback(	APP_WIDGET	w,
					void *		voided,
					void *		voidscbs )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    appDocHorizontalScrollbarCallback( w, voided, voidscbs );

    if  ( td->tdObjectSelected )
	{ tedMoveObjectWindows( w, ed );	}
    }

void tedDocVerticalScrollbarCallback(	APP_WIDGET	w,
					void *		voided,
					void *		voidscbs )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    appDocVerticalScrollbarCallback( w, voided, voidscbs );

    if  ( td->tdObjectSelected )
	{ tedMoveObjectWindows( w, ed );	}
    }

/************************************************************************/
/*									*/
/*  Last phase in building a document window.				*/
/*									*/
/************************************************************************/

int tedFinishDocumentSetup(	EditApplication *	ea,
				EditDocument *		ed )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    AppColors *			ac= &(ed->edColors);

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    const TedAppResources *	tar= (TedAppResources *)ea->eaResourceData;
    const char *		selColorName= tar->tarSelectionColor;
    const char *		xselColorName= tar->tarCopiedSelectionColor;
    /*
    char *			tableColorName= "gray80";
    */

    if  ( appFinishDocumentSetup( ea, ed ) )
	{ LDEB(1); return -1;	}

    if  ( appAllocateColors( add, ac ) )
	{ LDEB(1); return -1;	}

    if  ( ed->edColors.acAllocator.caDepth < 4 )
	{
	if  ( appColorRgb( &(td->tdSelColor), &(ed->edColors), 0, 0, 0 ) )
	    { LDEB(1); return -1;	}

	if  ( appColorRgb( &(td->tdXSelColor), &(ed->edColors), 0, 0, 0 ) )
	    { LDEB(1); return -1;	}

	if  ( appColorRgb( &(td->tdFieldColor), &(ed->edColors), 0, 0, 0 ) )
	    { LDEB(1); return -1;	}

	if  ( appColorRgb( &(td->tdTableColor), &(ed->edColors), 0, 0, 0 ) )
	    { LDEB(1); return -1;	}
	}
    else{
	if  ( appColorNamed( &td->tdSelColor, &ed->edColors, selColorName ) )
	    {
	    if  ( appColorFindRgb( &(td->tdSelColor),
					   &(ed->edColors), 176, 196, 222 ) )
		{ SDEB(selColorName); return -1;	}
	    }

	if  ( appColorNamed( &(td->tdXSelColor),
					    &(ed->edColors), xselColorName ) )
	    {
	    if  ( appColorFindRgb( &(td->tdXSelColor),
					    &(ed->edColors), 176, 176, 176 ) )
		{ SDEB(xselColorName); return -1;	}
	    }

	if  ( appColorRgb( &(td->tdFieldColor), &ed->edColors, 0, 0, 200 ) )
	    {
	    if  ( appColorFindRgb( &(td->tdFieldColor),
					       &(ed->edColors), 0, 0, 255 ) )
		{ LDEB(1); return -1;	}
	    }

	td->tdTableColor= add->addBackColor;
	}

    if  ( tedOpenItemObjects( &(bd->bdItem), &(ed->edColors),
						    &(ed->edDrawingData) ) )
	{ LDEB(1);	}

    if  ( ed->edIsReadonly )
	{ tedMakeDocumentReadonly( ed );	}

    if  ( tedHasSelection( td ) )
	{ tedAdaptToolsToPosition( ed );	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Make the document widget and the rulers.				*/
/*									*/
/*  1)  Calculate the different width of the margins.			*/
/*  2)  Insert a Form in the scrolled window.				*/
/*  3)  Insert the top ruler in the form.				*/
/*  4)  Insert the bottom ruler in the form.				*/
/*  5)  Insert the left ruler in the form.				*/
/*  6)  Insert the right ruler in the form.				*/
/*  7)  Insert the document widget in the form.				*/
/*									*/
/************************************************************************/

void tedFreeDocument(		void *			voidtd,
				int			format,
				AppDrawingData *	add )
    {
    TedDocument *	td= (TedDocument *)voidtd;

    tedCleanCursorBlink( td );

    if  ( td->tdDocument )
	{
	BufferDocument *	bd= td->tdDocument;

	docCloseItemObjects( bd, &(bd->bdItem),
					(void *)add, tedCloseObject );

	docFreeDocument( bd );
	}

    sioMemoryClean( &(td->tdCopiedSelection) );
    sioMemoryClean( &(td->tdCopiedFont) );
    sioMemoryClean( &(td->tdCopiedRuler) );

    appCleanBitmapImage( &(td->tdCopiedImage) );

    free( td );
    }

int tedMakeDocumentWidget(	EditApplication *	ea,
				EditDocument *		ed )
    {
    if  ( appMakeDocumentWidget( ea, ed ) )
	{ LDEB(1); return -1;	}

    if  ( ! ea->eaDocumentCursor )
	{
#	ifdef USE_MOTIF
	ea->eaDocumentCursor= XCreateFontCursor(
			    XtDisplay( ea->eaToplevel.atTopWidget), XC_xterm );
	if  ( ! ea->eaDocumentCursor )
	    { LDEB(ea->eaDocumentCursor);	}
#	endif

#	ifdef USE_GTK
	ea->eaDocumentCursor= gdk_cursor_new( GDK_XTERM );
	if  ( ! ea->eaDocumentCursor )
	    { XDEB(ea->eaDocumentCursor);	}
#	endif
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Find out whether a document uses just one code page.		*/
/*									*/
/************************************************************************/

static int tedDetermineCodepage(	BufferDocument *	bd,
					const AppDrawingData *	add )
    {
    DocumentProperties *	dp= &(bd->bdProperties);

    PostScriptFont *		fontList= (PostScriptFont *)0;
    int				fontCount= 0;
    int				i;

    int				encoding= -1;
    int				multipleEncodings= 0;

    if  ( docPsPrintGetItemFonts( &(bd->bdItem),
				&(dp->dpFontList), &(add->addPhysicalFontList),
				&fontList, &fontCount ) )
	{ LDEB(1); return -1;	}

    for ( i= 0; i < fontCount; i++ )
	{
	AfmFontInfo *	afi= fontList[i].psfAfi;

	if  ( encoding < 0 )
	    { encoding= afi->afiEncoding;	}
	else{
	    if  ( encoding != afi->afiEncoding )
		{ multipleEncodings= 1;	}
	    }
	}

    if  ( fontList )
	{ free( fontList );	}

    if  ( multipleEncodings )
	{ return -1;	}

    switch( encoding )
	{
	case ENCODINGpsISO_8859_1:
	    return 1252;

	case ENCODINGpsISO_8859_2:
	    return 1250;

	default:
	    LDEB(encoding); return -1;
	}

    }

/************************************************************************/
/*									*/
/*  Make a new empty document.						*/
/*									*/
/************************************************************************/

int tedNewDocument(	EditApplication *	ea,
			EditDocument *		ed,
			const char *		filename )
    {
    TedDocument *		td;
    BufferDocument *		bd;

    unsigned int		updMask;
    TextAttribute		taNew;

    char *			familyName;

    char			scratch[120];
    long			now;
    DocumentProperties *	dp;

    td= (TedDocument *)ed->edPrivateData;

    strcpy( scratch, ea->eaDefaultFont );
    if  ( appFontGetAttributes( scratch, &familyName, &updMask, &taNew ) )
	{ SDEB(ea->eaDefaultFont); return -1;	}

    if  ( ! ( updMask & TAupdFONTSIZE ) || taNew.taFontSizeHalfPoints < 4 )
	{
	LDEB(taNew.taFontSizeHalfPoints);
	taNew.taFontSizeHalfPoints= 24; updMask |= TAupdFONTSIZE;
	}

    bd= docNewFile( familyName, 10* taNew.taFontSizeHalfPoints,
					    &(ea->eaDefaultDocumentGeometry) );
    if  ( ! bd )
	{ XDEB(bd); return -1;	}

    ed->edFormat= 0; /* rtf */
    td->tdDocument= bd;
    dp= &(bd->bdProperties);

    if  ( filename )
	{
	const char *	slash= strrchr( filename, '/' );
	const char *	dot;

	if  ( slash )
	    { dot= strrchr( slash+ 1, '.' );	}
	else{ dot= strrchr( filename, '.' );	}

	if  ( dot && ! strcmp( dot, ".rtf" ) )
	    { ed->edFormat= 0;	}
	if  ( dot && ! strcmp( dot, ".txt" ) )
	    { ed->edFormat= 1;	}
	}

    if  ( ea->eaAuthor )
	{ dp->dpAuthor= (unsigned char *)strdup( ea->eaAuthor ); }

    now= time( (long *)0 );
    dp->dpCreatim= *localtime( &now );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Perform the setup of the editing environment for a document.	*/
/*									*/
/*  8)  Determine the code page of the document.			*/
/*  9)  Do not use the 1252 cidepage as an explicit setting: It is	*/
/*	almost certainly returned by a default 'Ted' installation, and	*/
/*	is almost impossible to get rid of.				*/
/*									*/
/************************************************************************/

int tedLayoutDocument(		void *				privateData,
				int				format,
				AppDrawingData *		add,
				const DocumentGeometry *	defDg )
    {
    TedDocument *		td= (TedDocument *)privateData;
    BufferDocument *		bd= td->tdDocument;
    DocumentGeometry *		dg= &(bd->bdProperties.dpGeometry);

    int				changed= 0;

    tedScreenRectangles( add, dg );

    if  ( docRecalculateTextFields( &changed, bd, &(bd->bdItem),
						    FIELDdoDOC_INFO |
						    FIELDdoDOC_COMPLETE ) )
	{ LDEB(1); return -1;	}

    if  ( tedLayoutDocumentTree( td, add ) )
	{ LDEB(1); return -1;	}

    changed= 0;
    if  ( docRecalculateTextFields( &changed, bd, &(bd->bdItem),
						    FIELDdoDOC_FORMATTED ) )
	{ LDEB(1); return -1;	}

    if  ( changed && tedLayoutDocumentTree( td, add ) )
	{ LDEB(1); return -1;	}

    {
    BufferPosition	bp;

    if  ( ! tedFirstPosition( add, bd, &bp ) )
	{
	td->tdSelection.bsBegin=
		    td->tdSelection.bsEnd=
		    td->tdSelection.bsAnchor= bp;

	td->tdCurrentTextAttribute=
		bp.bpBi->biParaParticules[bp.bpParticule].tpTextAttribute;
	td->tdCurrentPhysicalFont=
		bp.bpBi->biParaParticules[bp.bpParticule].tpPhysicalFont;


	td->tdSelection.bsDirection= 0;

	tedSelectionRectangle( &(td->tdSelectedRectangle),
						 add, &(td->tdSelection) );
	}
    else{ docListItem( 0,&(bd->bdItem) );	}
    }

    /*  8  */
    if  ( bd->bdProperties.dpAnsiCodePage < 0 )
	{
	bd->bdProperties.dpAnsiCodePage= tedDetermineCodepage( bd, add );

	/*  9  */
	if  ( bd->bdProperties.dpAnsiCodePage == 1252 )
	    { bd->bdProperties.dpAnsiCodePage= -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Save a document.							*/
/*									*/
/************************************************************************/

int tedSaveDocument(	const void *		privateData,
			int			format,
			const char *		applicationId,
			const char *		documentTitle,
			const char *		filename )
    {
    TedDocument *		td= (TedDocument *)privateData;
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);
    SimpleOutputStream *	sos;
    const int			saveBookmarks= 1;

    long			now;

    sos= sioOutStdioOpen( filename );
    if  ( ! sos )
	{ /* SXDEB(filename,sos); */ return -1;	}

    switch( format )
	{
	case 0:
	    now= time( (long *)0 );
	    dp->dpRevtim= *localtime( &now );

	    if  ( docRtfSaveDocument( sos, bd,
					    (const SelectionScope *)0,
					    (const BufferSelection *)0,
					    saveBookmarks ) )
		{ SDEB(filename); sioOutClose( sos ); return -1;	}
	    break;

	case 1:
	    if  ( docPlainSaveDocument( sos, bd,
					    (const SelectionScope *)0,
					    (const BufferSelection *)0,
					    1, 1 ) )
		{ SDEB(filename); sioOutClose( sos ); return -1;	}
	    break;

	case 2:
	    if  ( docHtmlSaveDocument( sos, bd, filename ) )
		{ SDEB(filename); sioOutClose( sos ); return -1;	}
	    break;

	default:
	    LDEB(format); return -1;
	}

    sioOutClose( sos );
    
    return 0;
    }


/************************************************************************/
/*									*/
/*  Allocate private data for a document.				*/
/*									*/
/************************************************************************/

void * tedMakePrivateData()
    {
    TedDocument *	td;

    td= (TedDocument *)malloc( sizeof(TedDocument) );
    if  ( ! td )
	{ XDEB(td); return (void *)0;	}

    td->tdDocument= (BufferDocument *)0;
    docInitTextAttribute( &(td->tdCurrentTextAttribute) );
    td->tdCurrentPhysicalFont= -1;

    td->tdFormatMenu= (APP_WIDGET)0;
    td->tdFormatMenuButton= (APP_WIDGET)0;
    td->tdFormatOneParaOption= (APP_WIDGET)0;

    td->tdCopyWidget= (APP_WIDGET)0;
    td->tdCutWidget= (APP_WIDGET)0;
    td->tdPasteWidget= (APP_WIDGET)0;

    td->tdInsertMenu= (APP_WIDGET)0;
    td->tdInsertMenuButton= (APP_WIDGET)0;
    td->tdInsPictOption= (APP_WIDGET)0;
    td->tdInsFileOption= (APP_WIDGET)0;
    td->tdInsSymbolOption= (APP_WIDGET)0;
    td->tdInsHyperlinkOption= (APP_WIDGET)0;
    td->tdInsBookmarkOption= (APP_WIDGET)0;
    td->tdInsInsertTableOption= (APP_WIDGET)0;
    td->tdInsInsertPageNumberOption= (APP_WIDGET)0;
    td->tdInsInsertLineBreakOption= (APP_WIDGET)0;
    td->tdInsInsertPageBreakOption= (APP_WIDGET)0;
    td->tdInsInsertSectBreakOption= (APP_WIDGET)0;

    td->tdTableMenu= (APP_WIDGET)0;
    td->tdTableMenuButton= (APP_WIDGET)0;
    td->tdTabInsertTableOption= (APP_WIDGET)0;
    td->tdTabAddRowOption= (APP_WIDGET)0;
    td->tdTabAddColumnOption= (APP_WIDGET)0;

    td->tdSelectTableWidget= (APP_WIDGET)0;
    td->tdSelectRowWidget= (APP_WIDGET)0;
    td->tdSelectColumnOption= (APP_WIDGET)0;
    td->tdDrawTableGridOption= (APP_WIDGET)0;

    td->tdFontMenu= (APP_WIDGET)0;
    td->tdFontMenuButton= (APP_WIDGET)0;
    td->tdFontBoldOption= (APP_WIDGET)0;
    td->tdFontItalicOption= (APP_WIDGET)0;
    td->tdFontUnderlinedOption= (APP_WIDGET)0;
    td->tdFontSuperscriptOption= (APP_WIDGET)0;
    td->tdFontSubscriptOption= (APP_WIDGET)0;

    td->tdToolsMenu= (APP_WIDGET)0;
    td->tdToolsMenuButton= (APP_WIDGET)0;

    docInitSelection( &(td->tdSelection) );
    docInitSelectionScope( &(td->tdSelectionScope) );
    docInitRectangle( &(td->tdSelectedRectangle) );

    td->tdVisibleSelectionCopied= 0;
    td->tdCanReplaceSelection= 0;

    td->tdCopiedSelectionClosed= 0;
    sioMemoryInit( &(td->tdCopiedSelection) );
    sioMemoryInit( &(td->tdCopiedFont) );
    sioMemoryInit( &(td->tdCopiedRuler) );

    appInitBitmapImage( &(td->tdCopiedImage) );

#   ifdef USE_MOTIF
    td->tdHideIBarId= (XtIntervalId)0;
    td->tdShowIBarId= (XtIntervalId)0;
#   endif
#   ifdef USE_GTK
    td->tdHideIBarId= 0;
    td->tdShowIBarId= 0;
#   endif

    td->tdObjectWindow= (APP_ATOM)0;
    td->tdObjectBottomWindow= (APP_ATOM)0;
    td->tdObjectRightWindow= (APP_ATOM)0;
    td->tdObjectCornerWindow= (APP_ATOM)0;
    td->tdObjectSelected= 0;

    td->tdDrawTableGrid= 1;

    return (void *)td;
    }

/************************************************************************/
/*									*/
/*  Keep track of focus.						*/
/*									*/
/************************************************************************/

APP_EVENT_HANDLER( tedObserveFocus, w, voided, event )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    EditApplication *	ea= ed->edApplication;

    int			inout= 0;

    if  ( appDrawGetInoutFromFocusEvent( &inout, w, event ) )
	{ return;	}

    if  ( inout > 0 )
	{
	if  ( ea->eaCurrentDocument != ed )
	    {
	    appSetCurrentDocument( ea, ed );

	    if  ( ea->eaFontsTool )
		{ tedAdaptFontsToolToDocument( ea, ed ); }

	    if  ( ea->eaFindTool )
		{ appFindToolTextReadonly( ea->eaFindTool, ed->edIsReadonly ); }

	    if  ( ea->eaSpellTool )
		{ appEnableSpellTool( ea->eaSpellTool, ! ed->edIsReadonly ); }

	    tedAdaptPageToolToDocument( ea, ed );

	    tedAdaptFormatToolToDocument( ed );
	    }

	if  ( tedHasIBarSelection( td ) )
	    { tedStartCursorBlink( ed );	}
	}

    if  ( inout < 0 )
	{ tedStopCursorBlink( ed ); }
    }

/************************************************************************/
/*									*/
/*  Follow a link.							*/
/*									*/
/*  1)  As a HACK, invoke netscape for all links with a protocol	*/
/*	different from 'file:'.						*/
/*  2)  Theoretically, mailcap/mimecap should have been consulted for	*/
/*	the application corresponding to the extension of the file.	*/
/*									*/
/************************************************************************/

/*  1  */
static int tedCallNetscape(	const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize )
    {
    char *	scratch;
    int		rval= 0;
    int		size;
    char *	to;

    size= 0;
    size += 60+ fileSize+ 1+ markSize;
    size += 4;
    size += 11+ fileSize+ 1+ markSize;
    size += 2+ 1;

    to= scratch= malloc( size );
    if  ( ! scratch )
	{ XDEB(scratch); return -1;	}

    strcpy( to, "netscape -noraise -remote 'openUrl(" );
    to += strlen( to );
    memcpy( to, fileName, fileSize ); to += fileSize;
    if  ( markSize > 0 )
	{
	*(to++)= '#';
	memcpy( to, markName, markSize ); to += markSize;
	}
    strcpy( to, ",new-window)' 2>/dev/null" ); to += strlen( to );

    strcpy( to, " || " ); to += strlen( to );

    strcpy( to, "netscape '" ); to += strlen( to );

    memcpy( to, fileName, fileSize ); to += fileSize;
    if  ( markSize > 0 )
	{
	*(to++)= '#';
	memcpy( to, markName, markSize ); to += markSize;
	}

    strcpy( to, "' &" ); to += strlen( to );

    if  ( system( scratch ) )
	{ SDEB(scratch); rval= -1;	}

    free( scratch );
    return rval;
    }

int tedFollowLink(	APP_WIDGET		relative,
			APP_WIDGET		option,
			EditDocument *		edFrom,
			const char *		fileName,
			int			fileSize,
			const char *		markName,
			int			markSize )
    {
    int			rval= 0;
    EditApplication *	ea= edFrom->edApplication;

    char *		slash= (char *)0;
    EditDocument *	edTo;

    char *		scratch= (char *)0;

    if  ( fileSize > 0 )
	{
	const int	readonly= 1;
	int		absolute= fileName[0] == '/';

	int		protocolSize;

	protocolSize= 0;
	while( protocolSize < fileSize && isalpha( fileName[protocolSize] ) )
	    { protocolSize++;	}

	/*  1  */
	if  ( protocolSize < fileSize && fileName[protocolSize] == ':' )
	    {
	    if  ( protocolSize == 4			&&
		  ! strncmp( fileName, "file", 4 )	)
		{
		fileName += 5;
		fileSize -= 5;
		absolute= fileName[0] == '/';
		}
	    else{
		return tedCallNetscape( fileName, fileSize,
							markName, markSize );
		}
	    }

	if  ( edFrom->edFilename )
	    { slash= strrchr( edFrom->edFilename, '/' ); }

	if  ( absolute || ! slash )
	    {
	    scratch= (char *)malloc( fileSize+ 1 );
	    if  ( ! scratch )
		{ XDEB(scratch); return -1;	}

	    strncpy( scratch, fileName, fileSize )[fileSize]= '\0';

	    edTo= appOpenDocument( ea, relative, option, readonly, scratch );
	    if  ( ! edTo )
		{ SXDEB(scratch,edTo);	}
	    }
	else{
	    int	dir= ( slash- edFrom->edFilename )+ 1;
	    int	len= dir+ fileSize+ 1;

	    scratch= (char *)malloc( len );
	    if  ( ! scratch )
		{ LXDEB(len,scratch); return -1;	}

	    strncpy( scratch, edFrom->edFilename, dir );
	    strncpy( scratch+ dir, fileName, fileSize )[fileSize]= '\0';

	    edTo= appOpenDocument( ea, relative, option, readonly, scratch );
	    if  ( ! edTo )
		{ /* SXDEB(scratch,edTo); */ rval= -1;	}
	    }
	}
    else{ edTo= edFrom;	}

    if  ( edTo && markSize > 0 )
	{ tedGoToBookmark( edTo, markName, markSize );	}

    if  ( scratch )
	{ free( scratch );	}

    return rval;
    }

/************************************************************************/
/*									*/
/*  Print a document to PostScript.					*/
/*									*/
/************************************************************************/

int tedPrintDocument(	FILE *				f,
			const void *			privateData,
			int				format,
			AppDrawingData *		add,
			const char *			title,
			EditApplication *		ea,
			const DocumentGeometry *	dgPaper,
			int				nup,
			int				horizontal,
			int				firstPage,
			int				lastPage )
    {
    TedDocument *		td= (TedDocument *)privateData;
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);

    long			now;

    int				changed= 0;

    now= time( (long *)0 );
    dp->dpPrintim= *localtime( &now );

    if  ( docRecalculateTextFields( &changed, bd, &(bd->bdItem),
						FIELDdoDOC_FORMATTED	|
						FIELDdoDOC_COMPLETE	|
						FIELDdoDOC_INFO		) )
	{ LDEB(1); return -1;	}

    if  ( changed && tedLayoutDocumentTree( td, add ) )
	{ LDEB(1); return -1;	}

    if  ( docPsPrintDocument( f, title, ea->eaApplicationName,
				ea->eaReference,
				add, td->tdDocument,
				nup, horizontal, firstPage, lastPage,
				dgPaper,
				tedLayoutHeaderItem, tedLayoutFooterItem ) )
	{ LDEB(1); return -1;	}

    return 0;
    }
