/************************************************************************/
/*									*/
/*  Rulers, Ted specific functionality.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	"tedRuler.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Allow a user to change paragraph attributes with the top ruler.	*/
/*									*/
/************************************************************************/

static void tedDragVerticalHair(		void *		voided,
						int		from,
						int		to,
						int		asUpper )
    {
    EditDocument *		ed= (EditDocument *)voided;
    AppDrawingData *		add= &(ed->edDrawingData);
    int				ox= ed->edVisibleRect.drX0;

    int				high;

    high= ed->edVisibleRect.drY1- ed->edVisibleRect.drY0+ 1;

    if  ( from >= 0 )
	{ appExposeRectangle( add, from- ox, 0, 1, high ); }

    if  ( to >= 0 )
	{ appDrawFillRectangle( add, to- ox, 0, 1, high ); }

    return;
    }

/************************************************************************/
/*									*/
/*  Obtain the separator positions for a table.				*/
/*									*/
/************************************************************************/

static int tedGetColumns(	BufferItem *			bi,
				const AppDrawingData *		add,
				const BufferItem *		sectBi,
				ColumnSeparator **		pCs,
				int *				pCsCount )
    {
    double			xfac= add->addMagnifiedPixelsPerTwip;
    const DocumentGeometry *	dg;

    static ColumnSeparator *	cs;
    ColumnSeparator *		fresh;

    BufferItem *		rowBi;
    CellProperties *		cp;

    int				i;
    int				x00Pixels;

    dg= &(sectBi->biSectDocumentGeometry);

    x00Pixels= TWIPStoPIXELS( xfac, dg->dgLeftMarginTwips );

    rowBi= bi->biParent->biParent;

    fresh= (ColumnSeparator *)realloc( cs, ( rowBi->biRowCellCount+ 1 )*
					sizeof( ColumnSeparator ) );
    if  ( ! fresh )
	{ LXDEB(rowBi->biRowCellCount,fresh); return -1;	}
    cs= fresh;

    fresh->csX0= rowBi->biRowLeftIndentPixels-
				    rowBi->biRowHalfGapWidthPixels;
    fresh->csX1= rowBi->biRowLeftIndentPixels+
				    rowBi->biRowHalfGapWidthPixels;
    fresh->csX0 += x00Pixels;
    fresh->csX1 += x00Pixels;

    fresh++; cp= rowBi->biRowCells;
    for ( i= 0; i < rowBi->biRowCellCount; fresh++, cp++, i++ )
	{
	fresh->csX0= cp->cpRightBoundaryPixels-
				    rowBi->biRowHalfGapWidthPixels;
	fresh->csX1= cp->cpRightBoundaryPixels+
				    rowBi->biRowHalfGapWidthPixels;

	fresh->csX0 += x00Pixels;
	fresh->csX1 += x00Pixels;
	}

    *pCs= cs; *pCsCount= rowBi->biRowCellCount+ 1; return 0;
    }

static void tedUpdateTableColumns(	EditDocument *		ed,
					BufferItem *		bi,
					double			xfac,
					double			magnification,
					int			csCountNew,
					ColumnSeparator *	csNew )
    {
    AppDrawingData *		add= &(ed->edDrawingData);

    int			csCount;
    ColumnSeparator *	cs;
    int			changed= 0;

    BufferItem *	sectBi;
    BufferItem *	rowBi;

    RowProperties *	rp;
    CellProperties *	cp;

    int			col;
    int			row;
    int			row0;
    int			row1;

    int			i;

    if  ( docDelimitTable( bi, &sectBi, &col, &row0, &row, &row1 ) )
	{ LDEB(1); return;	}

    if  ( tedGetColumns( bi, add, sectBi, &cs, &csCount ) )
	{ LDEB(1); return;	}

    if  ( csCountNew != csCount )
	{ LLDEB(csCountNew,csCount); return;	}

    rowBi= sectBi->biChildren[row0];
    rp= &(rowBi->biRowProperties);

    if  ( csNew[0].csX0 != cs[0].csX0 )
	{
	rp->rpLeftIndentPixels += ( csNew[0].csX0- cs[0].csX0 );
	rp->rpLeftIndentTwips= PIXELStoTWIPS( rp->rpLeftIndentPixels, xfac );
	changed= 1;
	}

    cp= rp->rpCells;
    for ( i= 1; i < csCount; cp++, i++ )
	{
	if  ( csNew[i].csX0 != cs[i].csX0 )
	    {
	    cp->cpRightBoundaryPixels += ( csNew[i].csX0- cs[i].csX0 );
	    cp->cpRightBoundaryTwips=
			    PIXELStoTWIPS( cp->cpRightBoundaryPixels, xfac );
	    changed= 1;
	    }
	}

    if  ( changed )
	{
	int		rowPropertiesAlso= 0;

	tedChangeTableLayout( ed, bi, sectBi,
					rp, rowPropertiesAlso, row0, row1 );

	tedAdaptFormatToolToDocument( ed );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  The user wants something with the mouse on the horizontal ruler	*/
/*									*/
/************************************************************************/

static int tedGetRulerTwips(	const AppDrawingData *	add,
				const BufferItem *	bi,
				ParagraphProperties *	pp,
				int			firstIndentPixels,
				int			leftIndentPixels,
				int			rightIndentPixels,
				int			tabCount,
				const TabStop *		tabStops )
    {
    FormattingFrame		ffPixels;
    double			xfac= add->addMagnifiedPixelsPerTwip;

    int				otab;
    int				ntab;
    int				tab0;
    int				otab1;
    int				ntab1;

    int				pixels;
    int				twips;

    tedParagraphFramePixels( &ffPixels, add, bi );

    leftIndentPixels -= ffPixels.ffX0Geometry;
    pp->ppLeftIndentTwips= PIXELStoTWIPS( leftIndentPixels, xfac );

    firstIndentPixels -= ffPixels.ffX0Geometry;
    firstIndentPixels -= leftIndentPixels;
    pp->ppFirstIndentTwips= PIXELStoTWIPS( firstIndentPixels, xfac );

    rightIndentPixels= ffPixels.ffX1Geometry- rightIndentPixels;
    pp->ppRightIndentTwips= PIXELStoTWIPS( rightIndentPixels, xfac );

    if  ( tabCount > pp->ppTabCount )
	{
	TabStop *	fresh;

	fresh= (TabStop *)realloc( pp->ppTabStops, tabCount* sizeof(TabStop) );
	if  ( ! fresh )
	    { LXDEB(tabCount,fresh); return -1;	}

	pp->ppTabStops= fresh;
	}

    tab0= 0;
    while( tab0 < pp->ppTabCount && tab0 < tabCount )
	{
	twips= pp->ppTabStops[tab0].tsTwips;
	pixels= ffPixels.ffX0Geometry+ TWIPStoPIXELS( xfac, twips );

	if  ( pixels != tabStops[tab0].tsPixels )
	    { break;	}

	pp->ppTabStops[tab0]= tabStops[tab0];
	pp->ppTabStops[tab0].tsTwips= twips;

	tab0++;
	}

    otab1= pp->ppTabCount- 1;
    ntab1= tabCount- 1;
    while( otab1 >= tab0 && ntab1 >= tab0 )
	{
	twips= pp->ppTabStops[otab1].tsTwips;
	pixels= ffPixels.ffX0Geometry+ TWIPStoPIXELS( xfac, twips );

	if  ( pixels != tabStops[ntab1].tsPixels )
	    { break;	}

	/*  No.. Later on
	pp->ppTabStops[otab1]= tabStops[ntab1];
	pp->ppTabStops[otab1].tsTwips= twips;
	*/

	otab1--; ntab1--;
	}

    if  ( pp->ppTabCount < tabCount )
	{
	ntab= tabCount- 1;
	for ( otab= pp->ppTabCount- 1; otab > otab1; ntab--, otab-- )
	    {
	    twips= pp->ppTabStops[otab].tsTwips;

	    pp->ppTabStops[ntab]= tabStops[ntab];
	    pp->ppTabStops[ntab].tsTwips= twips;
	    }
	}
    else{
	ntab= ntab1+ 1;
	for ( otab= otab1+ 1; otab < pp->ppTabCount; ntab++, otab++ )
	    {
	    twips= pp->ppTabStops[otab].tsTwips;

	    pp->ppTabStops[ntab]= tabStops[ntab];
	    pp->ppTabStops[ntab].tsTwips= twips;
	    }
	}

    otab= tab0;
    for ( ntab= tab0; ntab <= ntab1; otab++, ntab++ )
	{
	pixels= tabStops[ntab].tsPixels;
	pixels -= ffPixels.ffX0Geometry;
	twips= pixels/ xfac;

	pp->ppTabStops[otab]= tabStops[ntab];
	pp->ppTabStops[otab].tsTwips= twips;
	}

    pp->ppTabCount= tabCount;

    return 0;
    }

static APP_EVENT_HANDLER( tedHorizontalRulerButtonDown, w, voided, downEvent )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferItem *		bi= td->tdSelection.bsBegin.bpBi;
    AppDrawingData *		add= &(ed->edDrawingData);

    int				leftIndentNew;
    int				firstIndentNew;
    int				rightIndentNew;
    int				tabCountNew= bi->biParaProperties.ppTabCount;
    TabStop *			tabsNew= (TabStop *)0;

    int				csCountNew= 0;
    ColumnSeparator *		csNew= (ColumnSeparator *)0;

    double			xfac= add->addMagnifiedPixelsPerTwip;
    double			magnification= ea->eaMagnification;

    unsigned int		change;
    unsigned int		ppUpdMask= PPupdNONE;

    ParagraphProperties		ppNew;
    TextAttribute		taNew;

    FormattingFrame		ffPixels;

    tedParagraphFramePixels( &ffPixels, add, bi );

    leftIndentNew= ffPixels.ffX0TextLines;
    firstIndentNew= ffPixels.ffX0FirstLine;
    rightIndentNew= ffPixels.ffX1TextLines;

    tedHorizontalRulerTrackMouse(
			    &firstIndentNew, &leftIndentNew, &rightIndentNew,
			    &tabCountNew, &tabsNew,
			    &csCountNew, &csNew, &change,
			    w, ea, downEvent, ed->edTopRuler,
			    (void *)ed, tedDragVerticalHair );

    switch( change )
	{
	case PPupdNONE:
	    return;

	case PPupdLEFT_INDENT:
	case PPupdFIRST_INDENT:
	    ppUpdMask= PPupdLEFT_INDENT | PPupdFIRST_INDENT;
	    break;

	case PPupdRIGHT_INDENT:
	case PPupdTAB_STOPS:
	    ppUpdMask= change;
	    break;

	case PPupdCOLUMNS:
	    tedUpdateTableColumns( ed, bi,
				    xfac, magnification, csCountNew, csNew );
	    return;
	default:
	    LDEB(change); return;
	}

    docInitParagraphProperties( &ppNew );
    docInitTextAttribute( &taNew );

    if  ( docCopyParagraphProperties( &ppNew, &(bi->biParaProperties ) ) )
	{ LDEB(1); return;	}

    if  ( tedGetRulerTwips( add, bi, &ppNew,
			    firstIndentNew, leftIndentNew, rightIndentNew,
			    tabCountNew, tabsNew ) )
	{ LDEB(1); return;	}

    if  ( tedChangeSelectionProperties( ed,
				    TAupdNONE, taNew,
				    ppUpdMask, &ppNew,
				    SPupdNONE, (SectionProperties *)0 ) )
	{ LDEB(1);	}

    docCleanParagraphProperties( &ppNew );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt the horizontal ruler to the current paragraph.		*/
/*									*/
/************************************************************************/

void tedDocAdaptHorizontalRuler(	EditDocument *		ed,
					BufferItem *		bi )
    {
    if  ( ed->edTopRuler )
	{
	AppDrawingData *		add= &(ed->edDrawingData);
	ParagraphProperties *		pp= &(bi->biParaProperties);

	int				leftIndent;
	int				firstIndent;
	int				rightIndent;

	FormattingFrame		ffPixels;

	tedParagraphFramePixels( &ffPixels, add, bi );

	leftIndent= ffPixels.ffX0TextLines;
	firstIndent= ffPixels.ffX0FirstLine;
	rightIndent= ffPixels.ffX1TextLines;

	tedAdaptHorizontalRuler( ed->edTopRuler, ed->edTopRulerWidget,
		    add->addDocRect.drX0, add->addDocRect.drX1,
		    firstIndent, leftIndent, rightIndent,
		    add->addPaperRect.drX1,
		    pp->ppTabCount, pp->ppTabStops );

	if  ( bi->biParaInTable )
	    {
	    int			csCount;
	    ColumnSeparator *	cs;

	    BufferItem *	sectBi;

	    int			col;
	    int			row;
	    int			row0;
	    int			row1;

	    if  ( docDelimitTable( bi, &sectBi, &col, &row0, &row, &row1 ) )
		{ LDEB(1); return;	}

	    if  ( tedGetColumns( bi, add, sectBi, &cs, &csCount ) )
		{ LDEB(1); return;	}

	    tedSetRulerColumns( ed->edTopRulerWidget, ed->edTopRuler,
					ffPixels.ffX0Geometry,
					ffPixels.ffX1Geometry,
					cs, csCount );
	    }
	else{
	    tedSetRulerColumns( ed->edTopRulerWidget, ed->edTopRuler,
					ffPixels.ffX0Geometry,
					ffPixels.ffX1Geometry,
					(ColumnSeparator *)0, 0 );
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make the ruler administration for the top ruler widget of a		*/
/*  document.								*/
/*									*/
/************************************************************************/

int tedDocSetTopRuler(	EditDocument *	ed )
    {
    EditApplication *		ea= ed->edApplication;
    AppDrawingData *		add= &(ed->edDrawingData);

    int				topRulerHeight= ed->edTopRulerHeightPixels;
    double			horPixPerMM= ed->edPixelsPerMM;
    int				unitInt= ea->eaUnitInt;

    ed->edTopRuler= tedMakeTopRuler(
			topRulerHeight,		/*  sizeAcross		*/
			horPixPerMM,		/*  pixPerMM		*/
			add->addMagnification,	/*  magnification	*/

			ed->edLeftRulerWidthPixels,	/*  minUnused	*/
			ed->edRightRulerWidthPixels,	/*  maxUnused	*/

			add->addDocRect.drX0,
			add->addDocRect.drX1,
			ed->edVisibleRect.drX0,
			ed->edVisibleRect.drX1,

			add->addPaperRect.drX1,	/*  rulerC1		*/
			ea->eaRulerFont,
			unitInt );		/*  whatUnit		*/

    appDrawSetConfigureHandler( ed->edTopRulerWidget,
			tedHorizontalRulerConfigure, (void *)ed->edTopRuler );

    appDrawSetRedrawHandler( ed->edTopRulerWidget,
			tedRedrawHorizontalRuler, (void *)ed->edTopRuler );

    appDrawSetButtonPressHandler( ed->edTopRulerWidget,
				tedHorizontalRulerButtonDown, (void *)ed );

    return 0;
    }

int tedDocSetLeftRuler(	EditDocument *	ed )
    {
    EditApplication *		ea= ed->edApplication;
    AppDrawingData *		add= &(ed->edDrawingData);

    int				leftRulerWidth= ed->edLeftRulerWidthPixels;
    double			horPixPerMM= ed->edPixelsPerMM;
    int				unitInt= ea->eaUnitInt;

    ed->edLeftRuler= tedMakeLeftRuler(
			leftRulerWidth,		/*  sizeAcross		*/
			horPixPerMM,		/*  pixPerMM		*/
			add->addMagnification,	/*  magnification	*/

			0, 0,			/*  {min,max}Unused	*/

			add->addDocRect.drY0,
			add->addDocRect.drY1,

			ed->edVisibleRect.drY0,
			ed->edVisibleRect.drY1,

			add->addPaperRect.drY1,	/*  rulerC1		*/
			ea->eaRulerFont,
			unitInt,		/*  whatUnit		*/
			add->addPageStepPixels,	/*  pageStep.		*/
			ea->eaPageNumberFormat );

    appDrawSetConfigureHandler( ed->edLeftRulerWidget,
			tedVerticalRulerConfigure, (void *)ed->edLeftRuler );

    appDrawSetRedrawHandler( ed->edLeftRulerWidget,
			tedRedrawVerticalRuler, (void *)ed->edLeftRuler );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Callbacks for the Copy/Paste ruler menu options.			*/
/*									*/
/************************************************************************/

void tedDocFormatCopyRul(	APP_WIDGET	fontsOption,
				void *		voided,
				void *		voidpbcbs )
    {
    EditDocument *			ed= (EditDocument *)voided;
    TedDocument *			td= (TedDocument *)ed->edPrivateData;
    SimpleOutputStream *		sos;

    if  ( ! td->tdSelection.bsBegin.bpBi )
	{ XDEB(td->tdSelection.bsBegin.bpBi); return;	}

    sos= sioOutMemoryOpen( &(td->tdCopiedRuler) );
    if  ( ! sos )
	{ XDEB(sos); return;	}

    if  ( docRtfSaveRuler( sos,
			&(td->tdSelection.bsBegin.bpBi->biParaProperties) ) )
	{ LDEB(1); sioOutClose( sos ); return;	}

    if  ( sioOutClose( sos ) )
	{ LDEB(1); return;	}

    appDocOwnSelection( ed, "RULER", TedRulerTargets, TedRulerTargetCount );
    }

void tedDocFormatPasteRul(	APP_WIDGET	fontsOption,
				void *		voided,
				void *		voidpbcbs )
    {
    EditDocument *			ed= (EditDocument *)voided;

    appDocAskForPaste( ed, "RULER" );
    }

/************************************************************************/
/*									*/
/*  Merge the paragraphs in the selection.				*/
/*									*/
/************************************************************************/
void tedDocFormatOnePara(	APP_WIDGET	option,
				void *		voided,
				void *		voidpbcs )
    {
    EditDocument *			ed= (EditDocument *)voided;

    tedMergeParagraphsInSelection( ed );

    tedAdaptToolsToSelection( ed );

    appDocumentChanged( ed, 1 );
    }

