/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"

#   include	<sioXprop.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Edit menu actions.							*/
/*									*/
/*  2)  If the beginning of the selection is the beginning of a		*/
/*	kyperlink, try to include the link.				*/
/*  8)  Also put a copied picture on the clipboard that 'xv' implements	*/
/*	on the root window.						*/
/*									*/
/************************************************************************/

static void tedFinishTextCopy(	TedDocument *		td,
				const BufferSelection *	bs )
    {
    td->tdCopiedSelectionClosed= 1;

    if  ( (unsigned)bs->bsEnd.bpStroff < bs->bsEnd.bpBi->biParaStrlen )
	{ td->tdCopiedSelectionClosed= 0;	}

    if  ( bs->bsBegin.bpBi == bs->bsEnd.bpBi		&&
	  bs->bsBegin.bpLine == bs->bsEnd.bpLine	)
	{ td->tdCopiedSelectionClosed= 0;	}

    appCleanBitmapImage( &(td->tdCopiedImage) );
    appInitBitmapImage( &(td->tdCopiedImage) );

    return;
    }

static int tedDocCopySelection(	EditDocument *	ed )
    {
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    SelectionScope *		ss= &(td->tdSelectionScope);
    BufferDocument *		bd= td->tdDocument;

    BufferItem *		bi;
    TextParticule *		tp;
    BufferPosition		bpObject;
    InsertedObject *		io;

    SimpleOutputStream *	sos;

    BufferSelection		bsNew= td->tdSelection;
    const int			saveBookmarks= 0;

    int				startPart;
    int				endPart;

    const char *		fileName= (const char *)0;
    int				fileSize= 0;
    const char *		markName= (const char *)0;
    int				markSize= 0;

    if  ( ! tedHasSelection( td ) || tedHasIBarSelection( td ) )
	{ return -1; }

    /*  2  */
    if  ( ! docGetHyperlinkForPosition( bd, &(bsNew.bsBegin),
				&startPart, &endPart,
				&fileName, &fileSize, &markName, &markSize ) )
	{
	bi= bsNew.bsBegin.bpBi;
	tp= bi->biParaParticules+ bsNew.bsBegin.bpParticule;

	if  ( startPart < bsNew.bsBegin.bpParticule			&&
	      bi->biParaParticules[startPart].tpStroff == tp->tpStroff	)
	    { bsNew.bsBegin.bpParticule= startPart;	}

	if  ( bsNew.bsEnd.bpBi == bi )
	    {
	    tp= bi->biParaParticules+ bsNew.bsEnd.bpParticule;

	    if  ( endPart > bsNew.bsEnd.bpParticule			&&
		  bi->biParaParticules[endPart].tpStroff == tp->tpStroff )
		{ bsNew.bsEnd.bpParticule= endPart;	}
	    }
	}

    sos= sioOutMemoryOpen( &(td->tdCopiedSelection) );
    if  ( ! sos )
	{ XDEB(sos); return -1;    }

    if  ( docRtfSaveDocument( sos, td->tdDocument,
					    ss, &bsNew, saveBookmarks ) )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    if  ( sioOutClose( sos ) )
	{ LDEB(1); return -1;	}

    tedFinishTextCopy( td, &bsNew );

    docInitPosition( &bpObject );

    if  ( ! tedGetObjectSelection( td, &bpObject, &io )		&&
	  ! tedSaveObjectPicture( &(td->tdCopiedImage), io )	)
	{
	/*  8  */
	if  ( appImgPutXvClipboard( &(td->tdCopiedImage.abiBitmap),
		td->tdCopiedImage.abiBuffer, ea->eaToplevel.atTopWidget ) )
	    { LDEB(1);	}
	}

    if  ( appDocOwnSelection( ed, "PRIMARY",
		TedPrimaryTextTargets, TedPrimaryTextTargetCount ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Copy a part of the document, in practice, a bookmark as a link	*/
/*									*/
/************************************************************************/

int tedCopyAsLink(	EditDocument *			ed,
			const BufferItem *		bi,
			const SelectionScope *		ss,
			const BufferSelection *		bs,
			int				asRef,
			int				asPageref,
			const char *			fileName,
			const char *			markName,
			int				markSize )
    {
    SimpleOutputStream *	sos;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    int				fileSize= 0;

    if  ( fileName )
	{ fileSize= strlen( fileName );	}

    sos= sioOutMemoryOpen( &(td->tdCopiedSelection) );
    if  ( ! sos )
	{ XDEB(sos); return -1;    }

    if  ( docRtfSaveSelectionAsLink( sos, td->tdDocument, ss, bs,
				asRef, asPageref,
				(const unsigned char *)fileName, fileSize,
				(const unsigned char *)markName, markSize ) )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    if  ( sioOutClose( sos ) )
	{ LDEB(1); return -1;	}

    tedFinishTextCopy( td, bs );

    if  ( appDocOwnSelection( ed, "PRIMARY",
		    TedPrimaryTextTargets, TedPrimaryTextTargetCount ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

void tedDocCut(			EditDocument *	ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    if  ( tedDocCopySelection( ed ) )
	{ LDEB(1); return;	}

    tedAppReplaceSelection( ed, (const unsigned char *)0, 0 );

    return;
    }

void tedDocCopy(		EditDocument *	ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    if  ( tedDocCopySelection( ed ) )
	{ return;	}

    td->tdVisibleSelectionCopied= 1;

    tedExposeSelection( ed, &(td->tdSelection), /*scrolledX,Y*/ 0,0 );

    return;
    }

/************************************************************************/
/*									*/
/*  Ted, Copy/Paste functionality.					*/
/*									*/
/************************************************************************/

void tedPrimaryLost(	APP_WIDGET			w,
			void *				voided,
			APP_EVENT *			event )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    td->tdVisibleSelectionCopied= 0;

    if  ( tedHasSelection( td ) && ! tedHasIBarSelection( td ) )
	{
	tedExposeSelection( ed, &(td->tdSelection), /*scrolledX,Y*/ 0,0 );
	}
    }

/************************************************************************/
/*									*/
/*  Return the selection to a requestor.				*/
/*									*/
/************************************************************************/

APP_GIVE_COPY( tedCopyPrimaryRtf, w, event, voided )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( td->tdCopiedSelection.mbCapacity == 0 )
	{ LDEB(td->tdCopiedSelection.mbCapacity); return; }

    sos= sioOutOpenCopy( w, event );
    if  ( ! sos )
	{ XDEB(sos); return;	}

    if  ( sioOutWriteBytes( sos, td->tdCopiedSelection.mbBytes,
				    td->tdCopiedSelection.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return;	}

    sioOutClose( sos );

#   if 0
    sos= sioOutStdioOpen( "/tmp/copied.rtf" );
    if  ( sioOutWriteBytes( sos, td->tdCopiedSelection.mbBytes,
				    td->tdCopiedSelection.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return;	}
    sioOutClose( sos );
#   endif

    return;
    }

APP_GIVE_COPY( tedCopyPrimaryString, w, event, voided )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    BufferDocument *		bd;
    SimpleInputStream *		sis;
    int				res;

    if  ( td->tdCopiedSelection.mbCapacity == 0 )
	{ LDEB(td->tdCopiedSelection.mbCapacity); return; }

    sos= sioOutOpenCopy( w, event );
    if  ( ! sos )
	{ XDEB(sos); return;	}

    sis= sioInMemoryOpen( &td->tdCopiedSelection );
    if  ( ! sis )
	{ XDEB(sis); sioOutClose( sos ); return;	}

    bd= docRtfReadFile( sis );

    sioInClose( sis );

    if  ( ! bd )
	{ XDEB(bd); sioOutClose( sos ); return; }

    res= docPlainSaveDocument( sos, bd,
				    (SelectionScope *)0, (BufferSelection *)0,
				    0, td->tdCopiedSelectionClosed );

    docFreeDocument( bd );

    if  ( res )
	{ LDEB(res); sioOutClose( sos ); return; }

    sioOutClose( sos );

    return;
    }

APP_GIVE_COPY( tedCopyPrimaryPng, w, event, voided )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( ! td->tdCopiedImage.abiBuffer )
	{ XDEB(td->tdCopiedImage.abiBuffer); return;	}

    sos= sioOutOpenCopy( w, event );
    if  ( ! sos )
	{ XDEB(sos); return;	}

    if  ( bmPngWritePng( &(td->tdCopiedImage.abiBitmap),
					td->tdCopiedImage.abiBuffer, sos ) )
	{ LDEB(1); sioOutClose( sos ); return;	}

    sioOutClose( sos );

    return;
    }

APP_GIVE_COPY( tedCopyPrimaryPixmap, w, event, voided )
    {
    EditDocument *	ed= (EditDocument *)voided;
    AppDrawingData *	add= &(ed->edDrawingData);
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    APP_BITMAP_IMAGE	pixmapCopied;

    int			wide= td->tdCopiedImage.abiBitmap.bdPixelsWide;
    int			high= td->tdCopiedImage.abiBitmap.bdPixelsHigh;

    if  ( appImgMakePixmap( add,
			    &pixmapCopied, wide, high,
			    &(ed->edColors), &(td->tdCopiedImage) ) )
	{
	appCleanBitmapImage( &(td->tdCopiedImage) );
	appInitBitmapImage( &(td->tdCopiedImage) );
	return;
	}

    appCopyPixmapValue( event, pixmapCopied );

    return;
    }

APP_GIVE_COPY( tedCopyFontTed, w, event, voided )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( td->tdCopiedFont.mbCapacity == 0 )
	{ LDEB(td->tdCopiedFont.mbCapacity); return; }

    sos= sioOutOpenCopy( w, event );
    if  ( ! sos )
	{ XDEB(sos); return;	}

    if  ( sioOutWriteBytes( sos, td->tdCopiedFont.mbBytes,
					td->tdCopiedFont.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return;	}

    sioOutClose( sos );

    return;
    }

APP_GIVE_COPY( tedCopyRulerTed, w, event, voided )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( td->tdCopiedRuler.mbCapacity == 0 )
	{ LDEB(td->tdCopiedRuler.mbCapacity); return; }

    sos= sioOutOpenCopy( w, event );
    if  ( ! sos )
	{ XDEB(sos); return;	}

    if  ( sioOutWriteBytes( sos, td->tdCopiedRuler.mbBytes,
					td->tdCopiedRuler.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return;	}

    sioOutClose( sos );

    return;
    }

/************************************************************************/
/*									*/
/*  Finish a paste action.						*/
/*									*/
/************************************************************************/
typedef BufferDocument * (*TED_READ) (	SimpleInputStream *		sis,
					const DocumentGeometry *	dg );

typedef int	(*TED_INCLUDE) (	APP_WIDGET		w,
					EditDocument *		ed,
					BufferDocument *	bd );

static BufferDocument * tedPasteRtfReadFile( SimpleInputStream *	sis,
					const DocumentGeometry *	dg )
    { return docRtfReadFile( sis );	}

static void tedPastePrimaryGeneric(	APP_WIDGET		w,
					EditDocument *		ed,
					APP_SELECTION_EVENT *	event,
					TED_READ		readDoc,
					TED_INCLUDE		includeDoc )
    {
    EditApplication *		ea= ed->edApplication;

    SimpleInputStream *		sis;

    BufferDocument *		bd;

    sis= sioInOpenPaste( w, event );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    bd= (*readDoc)( sis, &(ea->eaDefaultDocumentGeometry) );

    sioInClose( sis );

    if  ( ! bd )
	{ XDEB( bd ); return; }

    if  ( (*includeDoc)( w, ed, bd ) )
	{ LDEB(1); docFreeDocument( bd ); return;	}

    docFreeDocument( bd );

    appDocumentChanged( ed, 1 );

    return;
    }

APP_PASTE_REPLY( tedPastePrimaryRtf, w, event, voided )
    {
    EditDocument *	ed= (EditDocument *)voided;

    tedPastePrimaryGeneric( w, ed, event,
				tedPasteRtfReadFile, tedIncludeRtfDocument );
    }

APP_PASTE_REPLY( tedPastePrimaryString, w, event, voided )
    {
    EditDocument *	ed= (EditDocument *)voided;

    tedPastePrimaryGeneric( w, ed, event,
				docPlainReadFile, tedIncludePlainDocument );
    }

APP_PASTE_REPLY( tedPastePrimaryPng, w, event, voided )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    SimpleInputStream *	sis;

    AppBitmapImage *	abi;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );
    if  ( ! abi )
	{ XDEB(abi); return;	}
    appInitBitmapImage( abi );

    sis= sioInOpenPaste( w, event );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    if  ( bmPngReadPng( &abi->abiBitmap, &abi->abiBuffer, sis ) )
	{ LDEB(1); return;	}

    tedAppReplaceSelection( ed, (const unsigned char *)0, 0 );

    if  ( tedObjectInsertBitmap( ed, abi ) )
	{ LDEB(1); sioInClose( sis ); return; }

    sioInClose( sis );

    return;
    }

APP_PASTE_REPLY( tedPastePrimaryPixmap, w, event, voided )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    AppBitmapImage *	abi;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );
    if  ( ! abi )
	{ XDEB(abi); return;	}
    appInitBitmapImage( abi );

    if  ( appImgPastePixmap( abi, w, event ) )
	{ LDEB(1); return;	}

    tedAppReplaceSelection( ed, (const unsigned char *)0, 0 );

    if  ( tedObjectInsertBitmap( ed, abi ) )
	{ appCleanBitmapImage( abi ); free( abi ); return; }

    return;
    }

APP_PASTE_REPLY( tedPasteFontTed, w, event, voided )
    {
    EditDocument *	ed= (EditDocument *)voided;

#   define		FONTSIZ	200

    SimpleInputStream *		sis;

    char			attrString[FONTSIZ+1];
    int				l;

    sis= sioInOpenPaste( w, event );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    if  ( ! sioInGetString( attrString, FONTSIZ, sis ) )
	{ LDEB(1); sioInClose( sis ); return; }

    l= strlen( attrString );
    if  ( l > 0 && attrString[l-1] == '\n' )
	{ attrString[l-1]= '\0';	}

    if  ( tedAppChangeSelectionAttributeString( ed, attrString ) )
	{
	SDEB(attrString);
	sioInClose( sis );
	return;
	}

    sioInClose( sis );

    appDocumentChanged( ed, 1 );

    return;
    }

APP_PASTE_REPLY( tedPasteRulerTed, w, event, voided )
    {
    EditDocument *		ed= (EditDocument *)voided;
    SimpleInputStream *		sis;

    ParagraphProperties		ppNew;
    TextAttribute		taNew;

    unsigned int		ppUpdMask;

    docInitParagraphProperties( &ppNew );
    docInitTextAttribute( &taNew );

    sis= sioInOpenPaste( w, event );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    if  ( docRtfReadRuler( sis, &ppNew ) )
	{ LDEB(1); sioInClose( sis ); return; }

    sioInClose( sis );

    ppUpdMask=	PPupdLEFT_INDENT	|
		PPupdFIRST_INDENT	|
		PPupdRIGHT_INDENT	|
		PPupdTAB_STOPS		|
		PPupdALIGNMENT		;

    if  ( tedChangeSelectionProperties( ed,
				    TAupdNONE, taNew,
				    ppUpdMask, &ppNew,
				    SPupdNONE, (SectionProperties *)0 ) )
	{ LDEB(1); docCleanParagraphProperties( &ppNew ); return; }

    docCleanParagraphProperties( &ppNew );

    return;
    }
