/************************************************************************/
/*									*/
/*  A Border Tool. Used on the pages of the format tool.		*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<appDebugon.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Update a 'HasBorder' toggle.					*/
/*									*/
/************************************************************************/

void tedFormatReflectBorder(	BorderTool *			bt,
				const BorderProperties *	bp )
    {
    int		set= 0;

    if  ( bp->bpWidthTwips > 0	&&
	  bp->bpIsSet		)
	{ set= 1;	}

    appGuiSetToggleState( bt->btOnOffToggle, set );

    /*  Border Styles are not for Ted 2.9:
    appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), set );
    */
    appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), 0 );

    if  ( bp->bpIsSet )
	{
	appSetOptionmenu( &(bt->btStyleOptionmenu), bp->bpStyle );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  One of the border on/off toggles has been activated by a user.	*/
/*									*/
/************************************************************************/

void tedFormatToggleBorder(	BorderProperties *	bp,
				BorderTool *		bt,
				int			influenceStyleMenu,
				int			set )
    {
    if  ( set )
	{
	bp->bpIsSet= 1;

	if  ( bp->bpWidthTwips == 0 )
	    { bp->bpWidthTwips= 15;	}
	}
    else{ bp->bpIsSet= 0;		}

    if  ( influenceStyleMenu )
	{
	/*  Border Styles are not for Ted 2.9:
	appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), set );
	*/
	appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), 0 );
	}
    }

/************************************************************************/
/*									*/
/*  Make a BorderTool.							*/
/*									*/
/************************************************************************/

void tedFormatMakeBorderTool(		BorderTool *		bt,
					APP_WIDGET *		pRow,
					APP_WIDGET		page,
					const char *		text,
					APP_TOGGLE_CALLBACK	callback,
					void *			through )
    {
    const int	heightResizable= 0;
    APP_WIDGET	row= appMakeRowInColumn( page, 2, heightResizable );

#   if 1
    bt->btOnOffToggle= appMakeToggleInRow( row, text, callback, through, 0 );
#   else
    appMakeLabelInRow( &(bt->btOnOffToggle), row, 0, 1, text );
#   endif

    appMakeOptionmenuInRow( &(bt->btStyleOptionmenu), row, 1, 1 );

    /*  Border Styles are not for Ted 2.9: */
    appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), 0 );

    *pRow= row; return;
    }

void tedFormatCleanBorderTool(		BorderTool *		bt )
    {
    return;
    }

void tedFormatFillBorderTool(		BorderTool *		bt,
					APP_BUTTON_CALLBACK	callBack,
					void *			target )
    {
    int		i;

    for ( i= 0; i < DOCbs_COUNT; i++ )
	{
	bt->btStyleItems[i]= appAddPixmapItemToOptionmenu(
				&(bt->btStyleOptionmenu), callBack, target );
	}
    }

/************************************************************************/
/*									*/
/*  Set the pixmap for a border style chooser in a format page.		*/
/*									*/
/************************************************************************/

static void tedBorderSetLineSolid(	AppDrawingData *	add,
					int			thick )
    {
#   ifdef USE_MOTIF
    XSetLineAttributes( add->addDisplay, add->addGc,
			thick, LineSolid, CapButt, JoinMiter );
#   endif

#   ifdef USE_GTK
    gdk_gc_set_line_attributes( add->addGc,
			thick, GDK_LINE_SOLID, GDK_CAP_BUTT, GDK_JOIN_MITER );
#   endif
    }

static void tedBorderSetLineDashes(	AppDrawingData *	add,
					const unsigned char *	dashes,
					int			dashCount,
					int			thick )
    {
#   ifdef USE_MOTIF
    XSetLineAttributes( add->addDisplay, add->addGc,
				thick, LineOnOffDash, CapButt, JoinMiter );

    XSetDashes( add->addDisplay, add->addGc, 0,
					(const char *)dashes, dashCount );
#   endif

#   ifdef USE_GTK
    gdk_gc_set_line_attributes( add->addGc,
		thick, GDK_LINE_ON_OFF_DASH, GDK_CAP_BUTT, GDK_JOIN_MITER );

    gdk_gc_set_dashes( add->addGc, 0, (char *)dashes, dashCount );
#   endif
    }

static const unsigned char TED_Border_DOT[]=	{ 1, 2 };
static const unsigned char TED_Border_DASH[]=	{ 3, 3 };
static const unsigned char TED_Border_DASHSM[]=	{ 3, 1 };
static const unsigned char TED_Border_DASHD[]=	{ 4, 2, 2, 2 };
static const unsigned char TED_Border_DASHDD[]=	{ 4, 2, 2, 2, 2, 2 };

static APP_BITMAP_IMAGE
tedFormatToolMakeBorderPixmap(		APP_WIDGET		w,
					TedFormatTool *		tft,
					AppDrawingData *	parent_add,
					int			style )
    {
    int			wide;
    int			high;

    int			x0;
    int			x1;
    int			y0;
    int			y1;

    int			x;
    int			y;

    const int		marg= 4;

    APP_BITMAP_IMAGE	pixmap;
    AppDrawingData	add;

    if  ( tft->tftBorderPixmaps[style] )
	{ return tft->tftBorderPixmaps[style];	}

    appDrawGetSizeOfWidget( &wide, &high, w );

    high= 26;

    wide -= 2* marg;
    high -= 2* marg;

    wide -= 2;

    x0= 0; x1= x0+ wide;
    y0= 0; y1= y0+ high;

    pixmap= appMakePixmap( parent_add, wide, high );
    tft->tftBorderPixmaps[style]= pixmap;

    appInitDrawingData( &add );
    appCloneDrawingEnvironment( &add, parent_add,
		    1.0, parent_add->addMagnifiedPixelsPerTwip, pixmap );

    appDrawSetForegroundWhite( &add );
    appDrawFillRectangle( &add, x0, y0, wide, high );

    appDrawSetForegroundBlack( &add );

    appDrawDrawLine( &add, x0, y0, x1, y0 );
    appDrawDrawLine( &add, x1-1, y0, x1-1, y1 );
    appDrawDrawLine( &add, x1, y1-1, x0, y1-1 );
    appDrawDrawLine( &add, x0, y1, x0, y0 );

    switch( style )
	{
	case DOCbsSH:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDB:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDOT:
	    tedBorderSetLineDashes( &add,
			    TED_Border_DOT, sizeof( TED_Border_DOT ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASH:
	    tedBorderSetLineDashes( &add,
			    TED_Border_DASH, sizeof( TED_Border_DASH ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsHAIR:
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASHSM:
	    tedBorderSetLineDashes( &add,
			TED_Border_DASHSM, sizeof( TED_Border_DASHSM ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASHD:
	    tedBorderSetLineDashes( &add,
			TED_Border_DASHD, sizeof( TED_Border_DASHD ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASHDD:
	    tedBorderSetLineDashes( &add,
			TED_Border_DASHDD, sizeof( TED_Border_DASHDD ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;


	case DOCbsTRIPLE:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHSG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTHTNSG:
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2- 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHTNSG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2+ 0;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHMG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 3 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTHTNMG:
	    tedBorderSetLineSolid( &add, 3 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHTNMG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 3 );
	    y= ( y0+ y1 )/ 2+ 0;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHLG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 4 );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTHTNLG:
	    tedBorderSetLineSolid( &add, 4 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHTNLG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 4;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 4 );
	    y= ( y0+ y1 )/ 2+ 0;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsWAVY:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2;
	    x= x0;
#	    define	W	2
#	    define	W2	4
	    appDrawDrawLine( &add, x, y, x+ W, y+ W ); x += W;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ W, x+ W2, y- W ); x += W2;
		appDrawDrawLine( &add, x, y- W, x+ W2, y+ W ); x += W2;
		}
	    break;

	case DOCbsWAVYDB:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    x= x0;
	    appDrawDrawLine( &add, x, y, x+ W, y+ W ); x += W;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ W, x+ W2, y- W ); x += W2;
		appDrawDrawLine( &add, x, y- W, x+ W2, y+ W ); x += W2;
		}

	    y= ( y0+ y1 )/ 2+ 2;
	    x= x0;
	    appDrawDrawLine( &add, x, y, x+ W, y+ W ); x += W;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ W, x+ W2, y- W ); x += W2;
		appDrawDrawLine( &add, x, y- W, x+ W2, y+ W ); x += W2;
		}
	    break;

	case DOCbsDASHDOTSTR:
	    y= ( y0+ y1 )/ 2;
	    x= x0- 2;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ 1, x+ 3, y- 2 ); x += 2;
		appDrawDrawLine( &add, x, y+ 1, x+ 3, y- 2 ); x += 1;
		appDrawDrawLine( &add, x, y+ 1, x+ 3, y- 2 ); x += 2;
		}
	    break;

	case DOCbsEMBOSS:
	case DOCbsENGRAVE:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	default:
	    LDEB(style);
	    break;
	}

    appCleanDrawingData( &add );

    return pixmap;
    }

void tedFormatFinishBorderTool(	BorderTool *		bt,
				TedFormatTool *		tft )
    {
    int		i;

    appOptionmenuRefreshWidth( &(bt->btStyleOptionmenu) );

    for ( i= 0; i < DOCbs_COUNT; i++ )
	{
	APP_BITMAP_IMAGE	pixmap;

	if  ( ! tft->tftPixmapAddAllocated )
	    {
	    appSetDrawingDataForWidget( bt->btStyleItems[i], 1.0,
						    &(tft->tftPixmapAdd) );
	    tft->tftPixmapAddAllocated= 1;
	    }

	pixmap= tedFormatToolMakeBorderPixmap( bt->btStyleItems[i], tft,
						    &(tft->tftPixmapAdd), i );

#	ifdef USE_MOTIF
	XtVaSetValues( bt->btStyleItems[i],
				    XmNlabelPixmap,		pixmap,
				    NULL );
#	endif
	}

    appPixmapOptionmenuSetButtonMargins( &(bt->btStyleOptionmenu) );

    return;
    }

/************************************************************************/
/*									*/
/*  Retrieve the style from the widget in the callback of a border	*/
/*  tool style option.							*/
/*									*/
/************************************************************************/

int tedBorderToolGetStyle(	const BorderTool *	bt,
				BorderProperties *	bp,
				APP_WIDGET		w )
    {
    int		i;

    for ( i= 0; i < DOCbs_COUNT; i++ )
	{
	if  ( bt->btStyleItems[i] == w )
	    { bp->bpStyle= i; return 0;	}
	}

    return -1;
    }

