/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	<appSymbolPicker.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Change to font attributes of the current selection.			*/
/*									*/
/************************************************************************/

static void tedSetCurrentAttribute(	TedDocument *		td,
					AppDrawingData *	add,
					unsigned int		updMask,
					TextAttribute		taNew )
    {
    BufferDocument *		bd= td->tdDocument;
    DocumentProperties *	dp= &(bd->bdProperties);
    DocumentFontList *		dfl= &(dp->dpFontList);

    unsigned int		changeMask= 0;

    docUpdateTextAttribute( &changeMask, updMask,
				    &(td->tdCurrentTextAttribute), taNew );

    if  ( changeMask || td->tdCurrentPhysicalFont < 0 )
	{
	td->tdCurrentPhysicalFont= appOpenDocumentFont( add, dfl,
						td->tdCurrentTextAttribute );
	}

    return;
    }

static void tedAppChangeSelectionAttribute(	EditDocument *	ed,
						unsigned int	taUpdMask,
						TextAttribute	taNew )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    tedSetCurrentAttribute( td, add, taUpdMask, taNew );

    tedChangeSelectionProperties( ed,
			    taUpdMask, taNew,
			    PPupdNONE, (const ParagraphProperties *)0,
			    SPupdNONE, (const SectionProperties *)0 );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt fonts tool to the current document.				*/
/*									*/
/************************************************************************/

void tedAdaptFontsToolToDocument(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    AppDrawingData *	add= &(ed->edDrawingData);

    char *		familyName= (char *)0;
    int			psFamilyNumber= -1;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	{ return;	}

    appFontSetCurrentFont( ea->eaFontsTool, add->addMagnifiedPixelsPerTwip,
					psFamilyNumber, updMask, taNew );

    if  ( ea->eaSymbolPicker )
	{
	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}

    appFontToolTextReadonly( ea->eaFontsTool, ed->edIsReadonly );

    return;
    }

/************************************************************************/
/*									*/
/*  1)  Adapt fonts tool &c to the current selection.			*/
/*  2)  Adapt fonts tool &c to the current values.			*/
/*									*/
/************************************************************************/

/*  1  */
void tedAdaptFontIndicatorsToSelection(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    char *		familyName= (char *)0;
    int			psFamilyNumber= -1;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	{ return;	}

    tedAdaptFontIndicatorsToValues( ed, familyName, psFamilyNumber,
							    updMask, taNew );

    return;
    }


/*  2  */
void tedAdaptFontIndicatorsToValues(	EditDocument *		ed,
					char *			familyName,
					int			psFamilyNumber,
					unsigned int		updMask,
					TextAttribute		taNew )
    {
    EditApplication *	ea= ed->edApplication;
    AppDrawingData *	add= &(ed->edDrawingData);
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    if  ( ea->eaFontsTool )
	{
	appFontSetCurrentFont( ea->eaFontsTool, add->addMagnifiedPixelsPerTwip,
					    psFamilyNumber, updMask, taNew );
	}

    if  ( ea->eaSymbolPicker )
	{
	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}

    appGuiSetToggleItemState( td->tdFontBoldOption,
	    ( updMask & TAupdFONTBOLD ) && taNew.taFontIsBold );

    appGuiSetToggleItemState( td->tdFontItalicOption,
	    ( updMask & TAupdFONTSLANTED ) && taNew.taFontIsSlanted );

    appGuiSetToggleItemState( td->tdFontUnderlinedOption,
	    ( updMask & TAupdTEXTUNDERLINED ) && taNew.taIsUnderlined );

    appGuiSetToggleItemState( td->tdFontSuperscriptOption,
				    ( updMask & TAupdSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUPERSCRIPT );

    appGuiSetToggleItemState( td->tdFontSubscriptOption,
				    ( updMask & TAupdSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUBSCRIPT );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the text attribute options has been pushed.			*/
/*									*/
/************************************************************************/

static void tedTextAttributePushed(	APP_WIDGET	attributeOption,
					void *		voided,
					void *		voidcbs,
					unsigned int	updMask )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;
    int			set;
    TextAttribute	taNew;

    docInitTextAttribute( &taNew );

    set= appGuiGetMenuToggleStateFromCallback( attributeOption, voidcbs );

    switch( updMask )
	{
	case TAupdFONTBOLD:
	    taNew.taFontIsBold= ( set != 0 );
	    break;
	case TAupdFONTSLANTED:
	    taNew.taFontIsSlanted= ( set != 0 );
	    break;
	case TAupdTEXTUNDERLINED:
	    taNew.taIsUnderlined= ( set != 0 );
	    break;
	default:
	    XDEB(updMask);
	    return;
	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    if  ( ea->eaFontsTool )
	{ tedAdaptFontsToolToDocument( ea, ed );	}

    return;
    }

int tedAppChangeSelectionAttributeString(	EditDocument *	ed,
						char *		attrString )
    {
    char *		familyName;

    TextAttribute	taNew;
    unsigned int	updMask;

    EditApplication *	ea= ed->edApplication;

    if  ( appFontGetAttributes( attrString, &familyName, &updMask, &taNew ) )
	{ SDEB( attrString ); return -1;	}

    if  ( updMask & TAupdFONTFAMILY )
	{
	TedDocument *		td= (TedDocument *)ed->edPrivateData;
	BufferDocument *	bd= td->tdDocument;
	DocumentProperties *	dp= &(bd->bdProperties);
	DocumentFontList *	dfl= &(dp->dpFontList);

	taNew.taFontNumber= docGetFontByName( dfl, familyName );
	if  ( taNew.taFontNumber < 0 )
	    { SLDEB(familyName,taNew.taFontNumber); return -1;	}
	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    tedAdaptFontIndicatorsToSelection( ea, ed );

    return 0;
    }

void tedDocFontBold(		APP_WIDGET	option,
				void *		voided,
				void *		voidcbs	 )
    { tedTextAttributePushed( option, voided, voidcbs, TAupdFONTBOLD ); }

void tedDocFontItalic(	APP_WIDGET	option,
			void *		voided,
			void *		voidcbs	 )
    {
    tedTextAttributePushed( option, voided, voidcbs, TAupdFONTSLANTED );
    }

void tedDocFontUnderlined(	APP_WIDGET	option,
				void *		voided,
				void *		voidcbs	 )
    {
    tedTextAttributePushed( option, voided, voidcbs, TAupdTEXTUNDERLINED );
    }

void tedDocFontSupersub(	APP_WIDGET		option,
				void *			voided,
				void *			voidcbs	 )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    unsigned int	updMask= TAupdSUPERSUB;
    TextAttribute	taNew;
    int			set;

    docInitTextAttribute( &taNew );

    set= appGuiGetToggleStateFromCallback( option, voidcbs );

    if  ( set )
	{
	if  ( option == td->tdFontSubscriptOption )
	    { taNew.taSuperSub= DOCfontSUBSCRIPT;	}

	if  ( option == td->tdFontSuperscriptOption )
	    { taNew.taSuperSub= DOCfontSUPERSCRIPT;	}
	}
    else{ taNew.taSuperSub= DOCfontREGULAR;	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    appGuiSetToggleState( td->tdFontSuperscriptOption,
				    ( updMask & TAupdSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUPERSCRIPT );

    appGuiSetToggleState( td->tdFontSubscriptOption,
				    ( updMask & TAupdSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUBSCRIPT );

    return;
    }

/************************************************************************/
/*  Ted, cope with the fonts tool.					*/
/************************************************************************/
static void tedFontsToolClosed(		void *		voidea	)
    {
    EditApplication *	ea=	(EditApplication *)voidea;

    ea->eaFontsTool= (void *)0;
    }

static void tedFontToolSet(		void *		voidea,
					char *		familyName,
					int		psFamilyNumber,
					int		fontBold,
					int		fontSlanted,
					int		fontSize	)
    {
    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;

    docInitTextAttribute( &taNew );
    updMask= 0;

    if  ( familyName )
	{
	BufferDocument *	bd= td->tdDocument;
	DocumentProperties *	dp= &(bd->bdProperties);
	DocumentFontList *	dfl= &(dp->dpFontList);

	taNew.taFontNumber= docGetFontByName( dfl, familyName );
	if  ( taNew.taFontNumber < 0 )
	    { SLDEB(familyName,taNew.taFontNumber); return;	}

	updMask |= TAupdFONTFAMILY;
	}

    if  ( fontBold >= 0 )
	{
	taNew.taFontIsBold= ( fontBold != 0 );
	updMask |= TAupdFONTBOLD;
	}

    if  ( fontSlanted >= 0 )
	{
	taNew.taFontIsSlanted= ( fontSlanted != 0 );
	updMask |= TAupdFONTSLANTED;
	}

    if  ( fontSize > 0 )
	{
	taNew.taFontSizeHalfPoints= 2* fontSize;
	updMask |= TAupdFONTSIZE;
	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    if  ( fontBold < 0 || fontSlanted < 0 )
	{
	if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	    { LLDEB(fontBold,fontSlanted);	}
	}

    appGuiSetToggleItemState( td->tdFontBoldOption,
	    ( updMask & TAupdFONTBOLD ) && taNew.taFontIsBold );

    appGuiSetToggleItemState( td->tdFontItalicOption,
	    ( updMask & TAupdFONTSLANTED ) && taNew.taFontIsSlanted );

    if  ( ea->eaSymbolPicker )
	{
	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}

    return;
    }


void tedShowFontsTool(		APP_WIDGET		fontsOption,
				EditApplication *	ea,
				void *			voidcbs	 )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ea->eaFontsTool )
	{
	char *			pixmapName= "tedfont";
	APP_BITMAP_IMAGE	iconPixmap= (APP_BITMAP_IMAGE)0;
	APP_BITMAP_MASK		iconMask= (APP_BITMAP_MASK)0;

	if  ( ! ed )
	    { XDEB(ed); return;	}

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap, &iconMask )  )
	    { SDEB(pixmapName); return;	}

	ea->eaFontsTool= appMakeFontsTool( fontsOption, "tedFontTool",
		    iconPixmap, iconMask,
		    tedFontsToolClosed, tedFontToolSet, ea );
	}
    else{ appShowFontsTool( ea->eaFontsTool );	}

    if  ( ed )
	{ tedAdaptFontsToolToDocument( ea, ed );	}

    return;
    }

/************************************************************************/
/*  Show or create a symbol picker.					*/
/************************************************************************/

static void tedSymbolPickerInsert(	void *		voidea,
					int		symbol,
					int		psFamilyNumberSet,
					char *		familyNameSet )
    {
    unsigned char	fresh[2];

    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    AppDrawingData *	add;
    TedDocument *	td;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;
    add= &(ed->edDrawingData);

    fresh[0]= symbol;
    fresh[1]= '\0';

    if  ( tedHasSelection( td )		&&
	  td->tdCanReplaceSelection	)
	{
	char *		familyName= (char *)0;
	int		psFamilyNumber= -1;

	unsigned int	updMask;
	TextAttribute	taNew;

	if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	    { LDEB(1); return;	}

	if  ( ! ( updMask & TAupdFONTFAMILY )		||
	      psFamilyNumberSet != psFamilyNumber	)
	    {
	    BufferDocument *		bd= td->tdDocument;
	    DocumentProperties *	dp= &(bd->bdProperties);
	    DocumentFontList *		dfl= &(dp->dpFontList);

	    taNew.taFontNumber= docGetFontByName( dfl, familyNameSet );
	    if  ( taNew.taFontNumber < 0 )
		{ SLDEB(familyNameSet,taNew.taFontNumber); return;	}

	    td->tdCurrentTextAttribute.taFontNumber= taNew.taFontNumber;
	    td->tdCurrentPhysicalFont= appOpenDocumentFont( add, dfl,
						td->tdCurrentTextAttribute );
	    }

	tedAppReplaceSelection( ed, fresh, 1 );
	}

    return;
    }

static void tedSymbolPickerClosed(	void *		voidea	)
    {
    EditApplication *	ea=	(EditApplication *)voidea;

    ea->eaSymbolPicker= (void *)0;
    }

void tedDocToolInsertSymbol(	APP_WIDGET	symbolOption,
				void *		voided,
				void *		voidcbs	 )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    EditApplication *	ea= ed->edApplication;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    if  ( ! ea->eaSymbolPicker )
	{
	char *			pixmapName= "tedsymbol";
	APP_BITMAP_IMAGE	iconPixmap= (APP_BITMAP_IMAGE)0;
	APP_BITMAP_MASK		iconMask= (APP_BITMAP_MASK)0;

	char *		familyName= (char *)0;
	int		psFamilyNumber= -1;

	unsigned int	updMask;
	TextAttribute	taNew;

	if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	    { return;	}

	if  ( ! ( updMask & TAupdFONTFAMILY ) )
	    { XDEB(updMask); return;	}

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap, &iconMask )  )
	    { SDEB(pixmapName); return;	}

	ea->eaSymbolPicker= appMakeSymbolPicker( symbolOption, ea,
			    "tedSymbolPicker",
			    iconPixmap, iconMask,
			    tedSymbolPickerInsert,
			    tedSymbolPickerClosed,
			    (void *)ea );

	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}
    else{ appShowSymbolPicker( ea->eaSymbolPicker ); }

    return;
    }
