/************************************************************************/
/*									*/
/*  Manipulate iten properties in a document.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Change paragraph properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdParaProperties(	unsigned int *			pPpChgPask,
				BufferItem *			paraBi,
				unsigned int			ppUpdMask,
				const ParagraphProperties *	ppNew )
    {
    unsigned int		ppChgMask= 0;

    ParagraphProperties *	pp= &(paraBi->biParaProperties);

    if  ( ppUpdMask & PPupdFIRST_INDENT )
	{
	if  ( pp->ppFirstIndentTwips != ppNew->ppFirstIndentTwips )
	    {
	    pp->ppFirstIndentTwips= ppNew->ppFirstIndentTwips;
	    ppChgMask |= PPupdFIRST_INDENT;
	    }
	}

    if  ( ppUpdMask & PPupdLEFT_INDENT )
	{
	if  ( pp->ppLeftIndentTwips != ppNew->ppLeftIndentTwips )
	    {
	    pp->ppLeftIndentTwips= ppNew->ppLeftIndentTwips;
	    ppChgMask |= PPupdLEFT_INDENT;
	    }
	}

    if  ( ppUpdMask & PPupdRIGHT_INDENT )
	{
	if  ( pp->ppRightIndentTwips != ppNew->ppRightIndentTwips )
	    {
	    pp->ppRightIndentTwips= ppNew->ppRightIndentTwips;
	    ppChgMask |= PPupdRIGHT_INDENT;
	    }
	}

    if  ( ppUpdMask & PPupdTAB_STOPS )
	{
	if  ( pp->ppTabCount > 0 || ppNew->ppTabCount > 0 )
	    {
	    if  ( pp->ppTabCount != ppNew->ppTabCount )
		{ ppChgMask |= PPupdTAB_STOPS;	}

	    if  ( ppNew->ppTabCount == 0 )
		{ pp->ppTabCount= 0;	}
	    else{
		TabStop *			ts;
		TabStop *			ots= pp->ppTabStops;
		TabStop *			nts= ppNew->ppTabStops;
		int				tab;

		ts= (TabStop *)malloc( ppNew->ppTabCount* sizeof(TabStop) );
		if  ( ! ts )
		    { LXDEB(ppNew->ppTabCount,ts); return -1;	}

		for ( tab= 0; tab < ppNew->ppTabCount; tab++ )
		    {
		    if  ( pp->ppTabCount == ppNew->ppTabCount )
			{
			if  ( nts[tab].tsTwips != ots[tab].tsTwips	||
			      nts[tab].tsKind != ots[tab].tsKind	||
			      nts[tab].tsLeader != ots[tab].tsLeader	)
			    {
			    ppChgMask |= PPupdTAB_STOPS;
			    ts[tab]= nts[tab];
			    }
			else{ ts[tab]= ots[tab];	}
			}
		    else{ ts[tab]= nts[tab];		}
		    }

		pp->ppTabCount= ppNew->ppTabCount;
		if  ( pp->ppTabStops )
		    { free( pp->ppTabStops );	}

		pp->ppTabStops= ts;
		}
	    }
	}

    if  ( ppUpdMask & PPupdALIGNMENT )
	{
	if  ( pp->ppAlignment != ppNew->ppAlignment )
	    {
	    pp->ppAlignment= ppNew->ppAlignment;
	    ppChgMask |= PPupdALIGNMENT;
	    }
	}

    if  ( ppUpdMask & PPupdSPACE_BEFORE )
	{
	if  ( pp->ppSpaceBeforeTwips != ppNew->ppSpaceBeforeTwips )
	    {
	    pp->ppSpaceBeforeTwips= ppNew->ppSpaceBeforeTwips;
	    ppChgMask |= PPupdSPACE_BEFORE;
	    }
	}

    if  ( ppUpdMask & PPupdSPACE_AFTER )
	{
	if  ( pp->ppSpaceAfterTwips != ppNew->ppSpaceAfterTwips )
	    {
	    pp->ppSpaceAfterTwips= ppNew->ppSpaceAfterTwips;
	    ppChgMask |= PPupdSPACE_AFTER;
	    }
	}

    if  ( ppUpdMask & PPupdNEWPAGE )
	{
	if  ( pp->ppStartsOnNewPage != ppNew->ppStartsOnNewPage )
	    {
	    pp->ppStartsOnNewPage= ppNew->ppStartsOnNewPage;
	    ppChgMask |= PPupdNEWPAGE;
	    }
	}

    if  ( ppUpdMask & PPupdLINE_SPACING )
	{
	if  ( pp->ppLineSpacingTwips != ppNew->ppLineSpacingTwips )
	    {
	    pp->ppLineSpacingTwips= ppNew->ppLineSpacingTwips;
	    ppChgMask |= PPupdLINE_SPACING;
	    }
	if  ( pp->ppLineSpacingIsMultiple != ppNew->ppLineSpacingIsMultiple )
	    {
	    pp->ppLineSpacingIsMultiple= ppNew->ppLineSpacingIsMultiple;
	    ppChgMask |= PPupdLINE_SPACING;
	    }
	}

    if  ( ppUpdMask & PPupdTOP_BORDER )
	{
	if  ( ! docEqualBorder( &(pp->ppTopBorder),
						&(ppNew->ppTopBorder ) ) )
	    {
	    docCopyBorderProperties( &(pp->ppTopBorder),
						&(ppNew->ppTopBorder) );
	    ppChgMask |= PPupdTOP_BORDER;
	    }
	}

    if  ( ppUpdMask & PPupdBOTTOM_BORDER )
	{
	if  ( ! docEqualBorder( &(pp->ppBottomBorder),
						&(ppNew->ppBottomBorder ) ) )
	    {
	    docCopyBorderProperties( &(pp->ppBottomBorder),
						&(ppNew->ppBottomBorder) );
	    ppChgMask |= PPupdBOTTOM_BORDER;
	    }
	}

    *pPpChgPask= ppChgMask; return 0;
    }

/************************************************************************/
/*									*/
/*  Change section properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdSectProperties(	unsigned int *			pSpChgMask,
				SectionProperties *		to,
				unsigned int			spUpdMask,
				const SectionProperties *	from )
    {
    unsigned int		spChgMask= SPupdNONE;

    appSetDocumentGeometry( &(to->spDocumentGeometry),
					&(from->spDocumentGeometry),
					&spChgMask, spUpdMask & DGupdALL );

    if  ( spUpdMask & SPupdTITLEPG )
	{
	if  ( to->spHasTitlePage != from->spHasTitlePage )
	    {
	    to->spHasTitlePage= from->spHasTitlePage;
	    spChgMask |= SPupdTITLEPG;
	    }
	}

    if  ( spUpdMask & SPupdNUMBER_STYLE )
	{
	if  ( to->spPageNumberStyle != from->spPageNumberStyle )
	    {
	    to->spPageNumberStyle= from->spPageNumberStyle;
	    spChgMask |= SPupdNUMBER_STYLE;
	    }
	}

    if  ( spUpdMask & SPupdBREAK_KIND )
	{
	if  ( to->spBreakKind != from->spBreakKind )
	    {
	    to->spBreakKind= from->spBreakKind;
	    spChgMask |= SPupdBREAK_KIND;
	    }
	}

    if  ( spUpdMask & SPupdPAGE_RESTART )
	{
	if  ( to->spRestartPageNumbers != from->spRestartPageNumbers )
	    {
	    to->spRestartPageNumbers= from->spRestartPageNumbers;
	    spChgMask |= SPupdPAGE_RESTART;
	    }
	}

    if  ( spUpdMask & SPupdSTART_PAGE )
	{
	if  ( to->spStartPageNumber != from->spStartPageNumber )
	    {
	    to->spStartPageNumber= from->spStartPageNumber;
	    spChgMask |= SPupdSTART_PAGE;
	    }
	}

    if  ( spUpdMask & SPupdCOLUMN_COUNT )
	{
	if  ( to->spColumnCount != from->spColumnCount )
	    {
	    to->spColumnCount= from->spColumnCount;
	    spChgMask |= SPupdCOLUMN_COUNT;
	    }
	}

    if  ( spUpdMask & SPupdCOLUMN_SPACING )
	{
	if  ( to->spColumnSpacingTwips != from->spColumnSpacingTwips )
	    {
	    to->spColumnSpacingTwips= from->spColumnSpacingTwips;
	    spChgMask |= SPupdCOLUMN_SPACING;
	    }
	}

    if  ( spUpdMask & SPupdCOLUMN_WIDTH )
	{
	if  ( to->spColumnWidthTwips != from->spColumnWidthTwips )
	    {
	    to->spColumnWidthTwips= from->spColumnWidthTwips;
	    spChgMask |= SPupdCOLUMN_WIDTH;
	    }
	}

    *pSpChgMask= spChgMask; return 0;
    }

/************************************************************************/
/*									*/
/*  Compare paragraph properties.					*/
/*									*/
/************************************************************************/

unsigned int docParaPropertyDifference(	const ParagraphProperties *	pp1,
					const ParagraphProperties *	pp2,
					unsigned int			updMask)
    {
    unsigned int		changedMask= 0;

    if  ( updMask & PPupdFIRST_INDENT )
	{
	if  ( pp1->ppFirstIndentTwips != pp2->ppFirstIndentTwips )
	    { changedMask |= PPupdFIRST_INDENT; }
	}

    if  ( updMask & PPupdLEFT_INDENT )
	{
	if  ( pp1->ppLeftIndentTwips != pp2->ppLeftIndentTwips )
	    { changedMask |= PPupdLEFT_INDENT; }
	}

    if  ( updMask & PPupdRIGHT_INDENT )
	{
	if  ( pp1->ppRightIndentTwips != pp2->ppRightIndentTwips )
	    { changedMask |= PPupdRIGHT_INDENT; }
	}

    if  ( updMask & PPupdTAB_STOPS )
	{
	if  ( pp1->ppTabCount > 0 || pp2->ppTabCount > 0 )
	    {
	    if  ( pp1->ppTabCount != pp2->ppTabCount )
		{ changedMask |= PPupdTAB_STOPS;	}
	    else{
		TabStop *			ts1= pp1->ppTabStops;
		TabStop *			ts2= pp2->ppTabStops;
		int				tab;

		for ( tab= 0; tab < pp2->ppTabCount; tab++ )
		    {
		    if  ( ts1[tab].tsTwips != ts2[tab].tsTwips		||
			  ts1[tab].tsKind != ts2[tab].tsKind		||
			  ts1[tab].tsLeader != ts2[tab].tsLeader	)
			{ changedMask |= PPupdTAB_STOPS; }
		    }
		}
	    }
	}

    if  ( updMask & PPupdALIGNMENT )
	{
	if  ( pp1->ppAlignment != pp2->ppAlignment )
	    { changedMask |= PPupdALIGNMENT; }
	}

    if  ( updMask & PPupdSPACE_BEFORE )
	{
	if  ( pp1->ppSpaceBeforeTwips != pp2->ppSpaceBeforeTwips )
	    { changedMask |= PPupdSPACE_BEFORE; }
	}

    if  ( updMask & PPupdSPACE_AFTER )
	{
	if  ( pp1->ppSpaceAfterTwips != pp2->ppSpaceAfterTwips )
	    { changedMask |= PPupdSPACE_AFTER; }
	}

    if  ( updMask & PPupdNEWPAGE )
	{
	if  ( pp1->ppStartsOnNewPage != pp2->ppStartsOnNewPage )
	    { changedMask |= PPupdNEWPAGE; }
	}

    if  ( updMask & PPupdLINE_SPACING )
	{
	if  ( pp1->ppLineSpacingTwips != pp2->ppLineSpacingTwips )
	    { changedMask |= PPupdLINE_SPACING; }
	if  ( pp1->ppLineSpacingIsMultiple != pp2->ppLineSpacingIsMultiple )
	    { changedMask |= PPupdLINE_SPACING; }
	}

    if  ( updMask & PPupdTOP_BORDER )
	{
	if  ( ! docEqualBorder( &(pp1->ppTopBorder),
						&(pp2->ppTopBorder ) ) )
	    { changedMask |= PPupdTOP_BORDER; }
	}

    if  ( updMask & PPupdBOTTOM_BORDER )
	{
	if  ( ! docEqualBorder( &(pp1->ppBottomBorder),
						&(pp2->ppBottomBorder ) ) )
	    { changedMask |= PPupdBOTTOM_BORDER; }
	}

    return changedMask;
    }

/************************************************************************/
/*									*/
/*  Change document properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdDocProperties(	unsigned int *			pChgPask,
				DocumentProperties *		dp,
				unsigned int			updMask,
				const DocumentProperties *	dpNew )
    {
    unsigned int		chgMask= DPupdNONE;

    if  ( updMask & DPupdDOCUMENT_GEOMETRY )
	{
	appSetDocumentGeometry( &(dp->dpGeometry),
					&(dpNew->dpGeometry),
					&chgMask, updMask & DGupdALL );
	}

    if  ( updMask & DPupdSTART_PAGE )
	{
	if  ( dp->dpStartPageNumber != dpNew->dpStartPageNumber )
	    {
	    dp->dpStartPageNumber= dpNew->dpStartPageNumber;
	    chgMask |= DPupdSTART_PAGE;
	    }
	}

    if  ( updMask & DPupdFACING_PAGES )
	{
	if  ( dp->dpHasFacingPages != dpNew->dpHasFacingPages )
	    {
	    dp->dpHasFacingPages= dpNew->dpHasFacingPages;
	    chgMask |= DPupdFACING_PAGES;
	    }
	}

    if  ( updMask & DPupdFOOTNOTE_POSITION )
	{
	if  ( dp->dpFootnotePosition != dpNew->dpFootnotePosition )
	    {
	    dp->dpFootnotePosition= dpNew->dpFootnotePosition;
	    chgMask |= DPupdFOOTNOTE_POSITION;
	    }
	}

    if  ( updMask & DPupdFOOTNOTE_RESTART )
	{
	if  ( dp->dpFootnotesRestart != dpNew->dpFootnotesRestart )
	    {
	    dp->dpFootnotesRestart= dpNew->dpFootnotesRestart;
	    chgMask |= DPupdFOOTNOTE_RESTART;
	    }
	}

    if  ( updMask & DPupdFOOTNOTE_STYLE )
	{
	if  ( dp->dpFootnoteNumberStyle != dpNew->dpFootnoteNumberStyle )
	    {
	    dp->dpFootnoteNumberStyle= dpNew->dpFootnoteNumberStyle;
	    chgMask |= DPupdFOOTNOTE_STYLE;
	    }
	}

    if  ( updMask & DPupdFOOTNOTE_STARTNR )
	{
	if  ( dp->dpStartFootnoteNumber != dpNew->dpStartFootnoteNumber )
	    {
	    dp->dpStartFootnoteNumber= dpNew->dpStartFootnoteNumber;
	    chgMask |= DPupdFOOTNOTE_STARTNR;
	    }
	}

    if  ( updMask & DPupdENDNOTE_POSITION )
	{
	if  ( dp->dpEndnotePosition != dpNew->dpEndnotePosition )
	    {
	    dp->dpEndnotePosition= dpNew->dpEndnotePosition;
	    chgMask |= DPupdENDNOTE_POSITION;
	    }
	}

    if  ( updMask & DPupdENDNOTE_RESTART )
	{
	if  ( dp->dpEndnotesRestart != dpNew->dpEndnotesRestart )
	    {
	    dp->dpEndnotesRestart= dpNew->dpEndnotesRestart;
	    chgMask |= DPupdENDNOTE_RESTART;
	    }
	}

    if  ( updMask & DPupdENDNOTE_STYLE )
	{
	if  ( dp->dpEndnoteNumberStyle != dpNew->dpEndnoteNumberStyle )
	    {
	    dp->dpEndnoteNumberStyle= dpNew->dpEndnoteNumberStyle;
	    chgMask |= DPupdENDNOTE_STYLE;
	    }
	}

    if  ( updMask & DPupdENDNOTE_STARTNR )
	{
	if  ( dp->dpStartEndnoteNumber != dpNew->dpStartEndnoteNumber )
	    {
	    dp->dpStartEndnoteNumber= dpNew->dpStartEndnoteNumber;
	    chgMask |= DPupdENDNOTE_STARTNR;
	    }
	}

    if  ( updMask & DPupdDEFTAB )
	{
	if  ( dp->dpTabIntervalTwips != dpNew->dpTabIntervalTwips )
	    {
	    dp->dpTabIntervalTwips= dpNew->dpTabIntervalTwips;
	    chgMask |= DPupdDEFTAB;
	    }
	}

    if  ( updMask & DPupdANSICPG )
	{
	if  ( dp->dpAnsiCodePage != dpNew->dpAnsiCodePage )
	    {
	    dp->dpAnsiCodePage= dpNew->dpAnsiCodePage;
	    chgMask |= DPupdANSICPG;
	    }
	}

    *pChgPask= chgMask; return 0;
    }

