/************************************************************************/
/*									*/
/*  Spell checking utility routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docSpell.h"

#   include	<ind.h>
#   include	<charnames.h>

/************************************************************************/
/*									*/
/*  Find the first misspelling from a certain position in a document.	*/
/*									*/
/************************************************************************/

static int docSpellParaFind(	BufferItem *		bi,
				int			stroff,
				int			part,
				int *			pStart,
				int *			pLength,
				SpellCheckContext *	scc	)
    {
    SpellScanJob	ssj;
    int			acceptedPos= stroff;

    TextParticule *	tp= bi->biParaParticules+ part;

    indInitSpellScanJob( &ssj );

    /*  3  */
    while( part < bi->biParaParticuleCount )
	{
	int			count;
	const unsigned char *	str= bi->biParaString+ stroff;

	while( stroff < tp->tpStroff+ tp->tpStrlen )
	    {
	    int		isWord= 0;

	    while( stroff < tp->tpStroff+ tp->tpStrlen			&&
		   ! ( scc->sccCharKinds[ *str ] & CHARisALNUM )	)
		{
		indAddCharacterToPossibilities( &ssj, *str );
		stroff++; str++;
		}

	    if  ( stroff < tp->tpStroff+ tp->tpStrlen		&&
		  ( scc->sccCharKinds[*str] & CHARisALNUM )	)
		{
		indAddCharacterToPossibilities( &ssj, *str );

		if  ( indNewPossibility( &ssj, stroff, *str ) )
		    { CDEB(*str); return -1;	}

		isWord= 1;
		}
	    else{ isWord= 0;	}

	    stroff++; str++;
	    while( stroff < tp->tpStroff+ tp->tpStrlen	&&
		   ( scc->sccCharKinds[*str] & CHARisALNUM )	)
		{
		indAddCharacterToPossibilities( &ssj, *str );
		stroff++; str++;
		}

	    if  ( isWord )
		{
		count= indCountPossibilities( &ssj, scc,
						    stroff- 1, stroff, *str );

		if  ( count == 0 )
		    {
		    PossibleWord *	maxpw;

		    maxpw= indMaximalPossibility( &ssj );

		    if  ( ! maxpw )
			{ XDEB(maxpw); return -1;	}

		    *pStart= maxpw->pwStartPosition;
		    *pLength= maxpw->pwInsertionPoint;

		    indCleanSpellScanJob( &ssj );

		    return 0;
		    }
		}
	    }

	indRejectPossibilities( &acceptedPos, acceptedPos, &ssj );

	part++; tp++;
	if  ( part < bi->biParaParticuleCount )
	    { stroff= tp->tpStroff;	}
	}

    indCleanSpellScanJob( &ssj );
    return 1;
    }

int docSpellFindNext(	BufferPosition *	bpFrom,
			BufferSelection *	bs,
			SpellCheckContext *	scc	)
    {
    BufferItem *		bi= bpFrom->bpBi;
    int				stroff= bpFrom->bpStroff;
    int				part= bpFrom->bpParticule;
    TextParticule *		tp= bi->biParaParticules+ part;
    const unsigned char *	str= bi->biParaString+ stroff;

    int				ret;
    int				start;
    int				length;

    if  ( bi->biLevel != DOClevPARA )
	{ LLDEB(bi->biLevel,DOClevPARA); return -1;	}

    if  ( stroff > tp->tpStroff )
	{
	while( stroff < tp->tpStroff+ tp->tpStrlen		&&
	       ( scc->sccCharKinds[ *str ] & CHARisALNUM )	)
	    { stroff++; str++; }
	}

    if  ( stroff == tp->tpStroff+ tp->tpStrlen )
	{ tp++; part++;	}

    for (;;)
	{
	ret= docSpellParaFind( bi, stroff, part, &start, &length, scc );

	if  ( ret == 0 )
	    {
	    docSetParaSelection( bs, bi, 1, start, length );

	    return ret;
	    }

	if  ( ret < 0 )
	    { LDEB(ret); return -1;	}

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { return 1;	}

	stroff= 0; part= 0;
	}
    }
