/************************************************************************/
/*									*/
/*  Read a plain text file into a BufferDocument			*/
/*									*/
/************************************************************************/

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>
#   include	<time.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	<sioGeneral.h>

/************************************************************************/
/*									*/
/*  Identifies control words						*/
/*									*/
/************************************************************************/

typedef enum RtfTag
    {
    RTFidRTF,
    RTFidRULER,

    RTFidUPR,
				/****************************************/
				/*  Document group.			*/
				/****************************************/
    RTFidFNIL,
    RTFidFROMAN,
    RTFidFSWISS,
    RTFidFMODERN,
    RTFidFSCRIPT,
    RTFidFDECOR,
    RTFidFTECH,
				/****************************************/
				/*  Kinds of font.			*/
				/****************************************/
    RTFidFCHARSET,
    RTFidFPRQ,
				/****************************************/
				/*  Font properties.			*/
				/****************************************/
    RTFidLIST,
    RTFidLISTID,
    RTFidLISTTEMPLATEID,
    RTFidLISTNAME,
    RTFidLISTSIMPLE,
    RTFidLISTRESTARTHDN,
				/****************************************/
				/*  Lists and their properties.		*/
				/****************************************/
    RTFidFONTTBL,
    RTFidCOLORTBL,
    RTFidPNTEXT,
    RTFidPN,
    RTFidSTYLESHEET,
    RTFidINFO,
    RTFidLISTTABLE,
				/****************************************/
				/*  Groups inside the document.		*/
				/****************************************/
    RTFidF,
    RTFidREVTBL,
				/****************************************/
				/*  Font number.			*/
				/****************************************/

    RTFidANSI,
    RTFidMAC,
    RTFidPC,
    RTFidPCA,
    RTFidUC,
    RTFidANSICPG,
				/****************************************/
				/*  Character sets.			*/
				/****************************************/
    RTFidRED,
    RTFidGREEN,
    RTFidBLUE,
				/****************************************/
				/*  Color references.			*/
				/****************************************/
    RTFidOGUTTER,

    RTFidDEFF,
    RTFidDEFLANGFE,
    RTFidVIEWKIND,
    RTFidVIEWSCALE,
				/****************************************/
				/*  Document properties.		*/
				/****************************************/
    RTFidSECTDEFAULTCL,
    RTFidLYTPRTMET,
				/****************************************/
				/*  Style sheet entries.		*/
				/****************************************/
    RTFidSBASEDON,
    RTFidSNEXT,
    RTFidSAUTOUPD,
    RTFidADDITIVE,
				/****************************************/
				/*  Document Formatting properties.	*/
				/****************************************/
    RTFidAENDDOC,
    RTFidAENDNOTES,
    RTFidAFTNBJ,
    RTFidAFTNNALC,
    RTFidAFTNNAR,
    RTFidAFTNNAUC,
    RTFidAFTNNCHI,
    RTFidAFTNNRLC,
    RTFidAFTNNRUC,
    RTFidAFTNRESTART,
    RTFidAFTNRSTCONT,
    RTFidAFTNSTART,
    RTFidAFTNTJ,
    RTFidALLPROT,
    RTFidANNOTPROT,
    RTFidBRKFRM,
    RTFidCVMME,
    RTFidDEFFORMAT,
    RTFidDEFLANG,
    RTFidDEFTAB,
    RTFidDOCTEMP,
    RTFidENDDOC,
    RTFidENDNOTES,
    RTFidFACINGP,
    RTFidFET,
    RTFidFLDALT,
    RTFidFORMDISP,
    RTFidFORMPROT,
    RTFidFORMSHADE,
    RTFidFRACWIDTH,
    RTFidFTNALT,
    RTFidFTNBJ,
    RTFidFTNNALC,
    RTFidFTNNAR,
    RTFidFTNNAUC,
    RTFidFTNNCHI,
    RTFidFTNNRLC,
    RTFidFTNNRUC,
    RTFidFTNRESTART,
    RTFidFTNRSTCONT,
    RTFidFTNRSTPG,
    RTFidFTNSTART,
    RTFidFTNTJ,
    RTFidGUTTER,
    RTFidHYPHAUTO,
    RTFidHYPHCAPS,
    RTFidHYPHCONSEC,
    RTFidHYPHHOTZ,
    RTFidLANDSCAPE,
    RTFidLINESTART,
    RTFidLINKSTYLES,
    RTFidLTRDOC,
    RTFidMAKEBACKUP,
    RTFidMARGB,
    RTFidMARGL,
    RTFidMARGMIRROR,
    RTFidMARGR,
    RTFidMARGT,
    RTFidNOCOLBAL,
    RTFidNOEXTRASPRL,
    RTFidNOTABIND,
    RTFidOTBLRUL,
    RTFidPAPERH,
    RTFidPAPERW,
    RTFidPGNSTART,
    RTFidPRCOLBL,
    RTFidPRINTDATA,
    RTFidPSOVER,
    RTFidPSZ,
    RTFidREVBAR,
    RTFidREVISIONS,
    RTFidREVPROP,
    RTFidREVPROT,
    RTFidRTLDOC,
    RTFidSPRSLNSP,
    RTFidSPRSSPBF,
    RTFidSPRSTSP,
    RTFidSUBFONTBYSIZE,
    RTFidSWPBDR,
    RTFidTRANSMF,
    RTFidIGHT,
    RTFidWIDOWCTRL,
    RTFidWRAPTRSP,
    RTFidVIEWZK,

    RTFidPGBRDRHEAD,
    RTFidPGBRDRFOOT,
    RTFidPGBRDRT,
    RTFidPGBRDRB,
    RTFidPGBRDRL,
    RTFidPGBRDRR,
    RTFidBRDRART,
    RTFidPGBRDROPT,
    RTFidPGBRDRSNAP,

    RTFidNOXLATTOYEN,
    RTFidEXPSHRTN,
    RTFidNOULTRLSPC,
    RTFidDNTBLNSBDB,
    RTFidNOSPACEFORUL,

    RTFidJCOMPRESS,
    RTFidJEXPAND,

    RTFidHORZDOC,
    RTFidDGHSPACE,
    RTFidDGVSPACE,
    RTFidDGHORIGIN,
    RTFidDGVORIGIN,
    RTFidDGHSHOW,
    RTFidDGVSHOW,
    RTFidDGMARGIN,

    RTFidNOLEAD,
    RTFidSPRSTSM,
    RTFidTRUNCEX,
    RTFidMSMCAP,
    RTFidSPLYTWNINE,
    RTFidFTNLYTWNINE,
    RTFidHTMAUTSP,
    RTFidUSELTBALN,
    RTFidALNTBLIND,
    RTFidLYTCALCTBLWD,
    RTFidLYTTBLRTGR,
    RTFidLNBRKRULE,

    RTFidBDRRLSWSIX,
    RTFidOLDAS,
				/****************************************/
				/*  Section Formatting Properties	*/
				/****************************************/
    RTFidBINFSXN,
    RTFidBINSXN,
    RTFidCOLNO,
    RTFidCOLS,
    RTFidCOLSR,
    RTFidCOLSX,
    RTFidCOLW,
    RTFidDS,
    RTFidENDNHERE,
    RTFidFOOTERY,
    RTFidGUTTERSXN,
    RTFidHEADERY,
    RTFidLINEBETCOL,
    RTFidLINECONT,
    RTFidLINEMOD,
    RTFidLINEPPAGE,
    RTFidLINERESTART,
    RTFidLINESTARTS,
    RTFidLINEX,
    RTFidLNDSCPSXN,
    RTFidLTRSECT,
    RTFidMARGBSXN,
    RTFidMARGLSXN,
    RTFidMARGRSXN,
    RTFidMARGTSXN,
    RTFidPGHSXN,
    RTFidPGNCONT,
    RTFidPGNDEC,
    RTFidPGNHN,
    RTFidPGNHNSC,
    RTFidPGNHNSH,
    RTFidPGNHNSM,
    RTFidPGNHNSN,
    RTFidPGNHNSP,
    RTFidPGNLCLTR,
    RTFidPGNLCRM,
    RTFidPGNRESTART,
    RTFidPGNSTARTS,
    RTFidPGNUCLTR,
    RTFidPGNUCRM,
    RTFidPGNX,
    RTFidPGNY,
    RTFidPGWSXN,
    RTFidRTLSECT,
    RTFidSBKCOL,
    RTFidSBKEVEN,
    RTFidSBKNONE,
    RTFidSBKODD,
    RTFidSBKPAGE,
    RTFidSECTD,
    RTFidSECTUNLOCKED,
    RTFidTITLEPG,
    RTFidVERTALB,
    RTFidVERTALC,
    RTFidVERTALJ,
    RTFidVERTALT,

    RTFidSECTLINEGRID,
				/****************************************/
				/*  Paragraph Formatting Properties	*/
				/****************************************/
    RTFidFI,
    RTFidHYPHPAR,
    RTFidINTBL,
    RTFidKEEP,
    RTFidKEEPN,
    RTFidLEVEL,
    RTFidLI,
    RTFidLTRPAR,
    RTFidNOLINE,
    RTFidNOWIDCTLPAR,
    RTFidPAGEBB,
    RTFidPARD,
    RTFidQC,
    RTFidQJ,
    RTFidQL,
    RTFidQR,
    RTFidRI,
    RTFidRTLPAR,
    RTFidS,
    RTFidSA,
    RTFidSB,
    RTFidSBYS,
    RTFidSL,
    RTFidSLMULT,
    RTFidSUBDOCUMENT,

    RTFidASPALPHA,
    RTFidASPNUM,

    RTFidJCLISTTAB,

    RTFidOUTLINELEVEL,

    RTFidSBAUTO,
    RTFidSAAUTO,

    RTFidNOOVERFLOW,
    RTFidFAROMAN,

    RTFidTQL,			/*  Not in sqec				*/

				/****************************************/
				/*  Paragraph Shading			*/
				/****************************************/
    RTFidBGBDIAG,
    RTFidBGCROSS,
    RTFidBGDCROSS,
    RTFidBGDKBDIAG,
    RTFidBGDKCROSS,
    RTFidBGDKDCROSS,
    RTFidBGDKFDIAG,
    RTFidBGDKHORIZ,
    RTFidBGDKVERT,
    RTFidBGFDIAG,
    RTFidBGHORIZ,
    RTFidBGVERT,
    RTFidCBPAT,
    RTFidCFPAT,
    RTFidSHADING,
				/****************************************/
				/*  Revision marks for paragraph	*/
				/*  numbers.				*/
				/****************************************/
    RTFidPNRAUTH,
    RTFidPNRDATE,
    RTFidPNRNFC,
    RTFidPNRPNBR,
    RTFidPNRRGB,
    RTFidPNRSTART,
    RTFidPNRSTOP,
    RTFidPNRXST,
				/****************************************/
				/*  Multilevel Lists.			*/
				/****************************************/
    RTFidPNSECLVL,

				/****************************************/
				/*  Tabs.				*/
				/****************************************/
    RTFidTB,
    RTFidTLDOT,
    RTFidTLEQ,
    RTFidTLHYPH,
    RTFidTLTH,
    RTFidTLUL,
    RTFidTQC,
    RTFidTQDEC,
    RTFidTQR,
    RTFidTX,

    RTFidADJUSTRIGHT, RTFidADJUSTLEFT,

    RTFidFC,
				/****************************************/
				/*  Paragraph Borders.			*/
				/****************************************/
    RTFidBOX,
    RTFidBRDRB,
    RTFidBRDRBAR,
    RTFidBRDRBTW,
    RTFidBRDRCF,
    RTFidBRDRDASH,
    RTFidBRDRL,
    RTFidBRDRR,
    RTFidBRDRSH,
    RTFidBRDRT,
    RTFidBRDRTH,
    RTFidBRDRW,
    RTFidBRSP,

    RTFidBRDRS,
    RTFidBRDRDB,
    RTFidBRDRDOT,
    RTFidBRDRHAIR,
    RTFidBRDRDASHSM,
    RTFidBRDRDASHD,
    RTFidBRDRDASHDD,
    RTFidBRDRTRIPLE,
    RTFidBRDRTNTHSG,
    RTFidBRDRTHTNSG,
    RTFidBRDRTNTHTNSG,
    RTFidBRDRTNTHMG,
    RTFidBRDRTHTNMG,
    RTFidBRDRTNTHTNMG,
    RTFidBRDRTNTHLG,
    RTFidBRDRTHTNLG,
    RTFidBRDRTNTHTNLG,
    RTFidBRDRWAVY,
    RTFidBRDRWAVYDB,
    RTFidBRDRDASHDOTSTR,
    RTFidBRDREMBOSS,
    RTFidBRDRENGRAVE,
    RTFidBRDROUTSET,
    RTFidBRDRNONE,
				/****************************************/
				/*  Character Formatting Properties	*/
				/****************************************/
    RTFidB,
    RTFidCAPS,
    RTFidCB,
    RTFidCCHS,
    RTFidCF,
    RTFidCS,
    RTFidDELETED,
    RTFidDN,
    RTFidEXPND,
    RTFidEXPNDTW,
    /* RTFidF,	*/
    RTFidFS,
    RTFidI,
    RTFidKERNING,
    RTFidLANG,
    RTFidNOPROOF,
    RTFidLTRCH,
    RTFidNOSUPERSUB,
    RTFidOUTL,
    RTFidPLAIN,
    RTFidREVAUTH,
    RTFidREVAUTHDEL,
    RTFidREVDTTM,
    RTFidREVDTTMDEL,
    RTFidREVISED,
    RTFidRTLCH,
    RTFidSCAPS,
    RTFidSHAD,
    RTFidSTRIKE,
    RTFidSUB,
    RTFidSUPER,
    RTFidUL,
    RTFidULD,
    RTFidULDB,
    RTFidULNONE,
    RTFidULW,
    RTFidUP,
    RTFidV,
    RTFidHIGHLIGHT,

    RTFidCGRID,
    RTFidWIDCTLPAR,
    RTFidCHARSCALEX,

    RTFidCHBGHORIZ,
    RTFidCHBGVERT,
    RTFidCHBGFDIAG,
    RTFidCHBGBDIAG,
    RTFidCHBGCROSS,
    RTFidCHBGDCROSS,
    RTFidCHBGDKHORIZ,
    RTFidCHBGDKVERT,
    RTFidCHBGDKFDIAG,
    RTFidCHBGDKBDIAG,
    RTFidCHBGDKCROSS,
    RTFidCHBGDKDCROSS,

    RTFidCHBRDR,

    RTFidCHCBPAT,
    RTFidCHCFPAT,
    RTFidCHSHDNG,

    RTFidFAAUTO,
				/****************************************/
				/*  Pictures				*/
				/****************************************/
    RTFidPICT,
    RTFidNONSHPPICT,
    RTFidSHPPICT,

    RTFidBIN,
    RTFidDIBITMAP,
    RTFidMACPICT,
    RTFidPICBMP,
    RTFidPICBPP,
    RTFidPICCROPB,
    RTFidPICCROPL,
    RTFidPICCROPR,
    RTFidPICCROPT,
    RTFidPICH,
    RTFidPICHGOAL,
    RTFidPICSCALED,
    RTFidPICSCALEX,
    RTFidPICSCALEY,
    RTFidPICW,
    RTFidPICWGOAL,
    RTFidPMMETAFILE,
    RTFidWBITMAP,
    RTFidWBMBITSPIXEL,
    RTFidWBMPLANES,
    RTFidWBMWIDTHBYTES,
    RTFidWMETAFILE,
    RTFidPNGBLIP,
    RTFidJPEGBLIP,
    RTFidEMFBLIP,

    RTFidBLIPTAG,
    RTFidBLIPUPI,
				/****************************************/
				/*  Pictures, objects			*/
				/****************************************/
    RTFidOBJECT,
    RTFidOBJEMB,
    RTFidOBJCLASS,
    RTFidOBJNAME,
    RTFidOBJDATA,
    RTFidOBJW,
    RTFidOBJH,
    RTFidOBJSCALEX,
    RTFidOBJSCALEY,

    RTFidOBJSETSIZE,
    RTFidRSLTMERGE,
				/****************************************/
				/*  Special characters			*/
				/****************************************/
    RTFidBULLET,
    RTFidCHATN,
    RTFidCHDATE,
    RTFidCHDPA,
    RTFidCHDPL,
    RTFidCHFTN,
    RTFidCHFTNSEP,
    RTFidCHFTNSEPC,
    RTFidCHPGN,
    RTFidCHTIME,
    RTFidCOLUMN,
    RTFidEMDASH,
    RTFidEMSPACE,
    RTFidENDASH,
    RTFidENSPACE,
    RTFidLDBLQUOTE,
    RTFidLINE,
    RTFidLQUOTE,
    RTFidLTRMARK,
    RTFidPAGE,
    RTFidRDBLQUOTE,
    RTFidRQUOTE,
    RTFidRTLMARK,
    RTFidSECTNUM,
    RTFidSOFTCOL,
    RTFidSOFTLHEIGHT,
    RTFidSOFTLINE,
    RTFidSOFTPAGE,
    RTFidTAB,
    RTFidZWJ,
    RTFidZWNJ,

    RTFidU,
				/****************************************/
				/*  Hierarchy.				*/
				/****************************************/
    RTFidPAR,
    RTFidCELL,
    RTFidROW,
    RTFidSECT,
				/****************************************/
				/*  Table definitions			*/
				/****************************************/
    RTFidCELLX,
    RTFidCLBGBDIAG,
    RTFidCLBGCROSS,
    RTFidCLBGDCROSS,
    RTFidCLBGDKBDIAG,
    RTFidCLBGDKCROSS,
    RTFidCLBGDKDCROSS,
    RTFidCLBGDKFDIAG,
    RTFidCLBGDKHOR,
    RTFidCLBGDKVERT,
    RTFidCLBGFDIAG,
    RTFidCLBGHORIZ,
    RTFidCLBGVERT,
    RTFidCLBRDRB,
    RTFidCLBRDRL,
    RTFidCLBRDRR,
    RTFidCLBRDRT,
    RTFidCLCBPAT,
    RTFidCLCFPAT,
    RTFidCLSHDNG,
    RTFidCLMGF,
    RTFidCLMRG,
    RTFidCLVMGF,
    RTFidCLVMRG,
    RTFidLTRROW,
    RTFidRTLROW,
    RTFidTRBRDRB,
    RTFidTRBRDRH,
    RTFidTRBRDRL,
    RTFidTRBRDRR,
    RTFidTRBRDRT,
    RTFidTRBRDRV,
    RTFidTRGAPH,
    RTFidTRHDR,
    RTFidTRKEEP,
    RTFidTRLEFT,
    RTFidTROWD,
    RTFidTRQC,
    RTFidTRQL,
    RTFidTRQR,
    RTFidTRRH,

    RTFidTRPADDL,
    RTFidTRPADDR,
    RTFidTRPADDFL,
    RTFidTRPADDFR,
    RTFidTRWWIDTH,
    RTFidTRFTSWIDTH,

    RTFidCELLD,
    RTFidCLVERTALT,
    RTFidCLVERTALC,
    RTFidCLVERTALB,
    RTFidCLTXLRTB,
    RTFidCLTXTBRL,

    RTFidCLWWIDTH,
    RTFidCLFTSWIDTH,
				/****************************************/
				/*  Positioned objects and frames	*/
				/****************************************/
    RTFidABSH,
    RTFidABSLOCK,
    RTFidABSW,
    RTFidDFRMTXTX,
    RTFidDFRMTXTY,
    RTFidDROPCAPLI,
    RTFidDROPCAPT,
    RTFidDXFRTEXT,
    RTFidNOWRAP,
    RTFidPHCOL,
    RTFidPHMRG,
    RTFidPHPG,
    RTFidPOSNEGX,
    RTFidPOSNEGY,
    RTFidPOSX,
    RTFidPOSXC,
    RTFidPOSXI,
    RTFidPOSXL,
    RTFidPOSXO,
    RTFidPOSXR,
    RTFidPOSY,
    RTFidPOSYB,
    RTFidPOSYC,
    RTFidPOSYIL,
    RTFidPOSYT,
    RTFidPVMRG,
    RTFidPVPARA,
    RTFidPVPG,
				/****************************************/
				/*  Bullets and Numbering.		*/
				/*  (No destinations)			*/
				/****************************************/
    RTFidPNACROSS,
    RTFidPNB,
    RTFidPNCAPS,
    RTFidPNCARD,
    RTFidPNCF,
    RTFidPNDEC,
    RTFidPNF,
    RTFidPNFS,
    RTFidPNHANG,
    RTFidPNI,
    RTFidPNINDENT,
    RTFidPNLCLTR,
    RTFidPNLCRM,
    RTFidPNLVL,
    RTFidPNLVLBLT,
    RTFidPNLVLBODY,
    RTFidPNLVLCONT,
    RTFidPNNUMONCE,
    RTFidPNORD,
    RTFidPNORDT,
    RTFidPNPREV,
    RTFidPNQC,
    RTFidPNQL,
    RTFidPNQR,
    RTFidPNRESTART,
    RTFidPNSCAPS,
    RTFidPNSP,
    RTFidPNSTART,
    RTFidPNSTRIKE,
    RTFidPNUCLTR,
    RTFidPNUCRM,
    RTFidPNUL,
    RTFidPNULD,
    RTFidPNULDB,
    RTFidPNULNONE,
    RTFidPNULW,

    RTFidLS,
    RTFidILVL,
    RTFidPNRNOT,
				/****************************************/
				/*  Fields, Bookmarks.			*/
				/****************************************/
    RTFidDATAFIELD,
    RTFidFIELD,
    RTFidFLDDIRTY,
    RTFidFLDEDIT,
    RTFidFLDINST,
    RTFidFLDLOCK,
    RTFidFLDPRIV,
    RTFidFLDRSLT,

    RTFidBKMKSTART,
    RTFidBKMKEND,
    RTFidBKMKCOLF,
    RTFidBKMKCOLL,
				/****************************************/
				/*  Index entries.			*/
				/*  Table of contents entries.		*/
				/****************************************/
    RTFidXE,
    RTFidTXE,
    RTFidRXE,
    RTFidIXE,
    RTFidBXE,
    RTFidXEF,

    RTFidTC,
    RTFidTCN,
    RTFidTCF,
    RTFidTCL,
				/****************************************/
				/*  Headers and Footers.		*/
				/*  Footnote.				*/
				/*  ( Are destinations ).		*/
				/****************************************/
    RTFidFOOTER,
    RTFidFOOTERF,
    RTFidFOOTERL,
    RTFidFOOTERR,
    RTFidHEADER,
    RTFidHEADERF,
    RTFidHEADERL,
    RTFidHEADERR,

    RTFidFOOTNOTE,
				/****************************************/
				/*  Associated Character Properties	*/
				/****************************************/
    RTFidAB,
    RTFidACAPS,
    RTFidACF,
    RTFidADN,
    RTFidAEXPND,
    RTFidAF,
    RTFidAFS,
    RTFidAI,
    RTFidALANG,
    RTFidAOUTL,
    RTFidASCAPS,
    RTFidASHAD,
    RTFidASTRIKE,
    RTFidAUL,
    RTFidAULD,
    RTFidAULDB,
    RTFidAULNONE,
    RTFidAULW,
    RTFidAUP,

    RTFidLOCH,
    RTFidHICH,
    RTFidDBCH,
				/****************************************/
				/*  About bullet numbering.		*/
				/****************************************/
    RTFidPNTXTA,
    RTFidPNTXTB,
    RTFidLISTTEXT,
				/****************************************/
				/*  Groups inside the 'info' group.	*/
				/****************************************/
    RTFidTITLE,
    RTFidSUBJECT,
    RTFidAUTHOR,
    RTFidKEYWORDS,
    RTFidCOMMENT,
    RTFidHLINKBASE,
    RTFidOPERATOR,
    RTFidCREATIM,
    RTFidREVTIM,
    RTFidPRINTIM,
    RTFidVERSION,
    RTFidEDMINS,
    RTFidNOFPAGES,
    RTFidNOFWORDS,
    RTFidNOFCHARS,
    RTFidNOFCHARSWS,
    RTFidVERN,
				/****************************************/
				/*  Shapes.				*/
				/****************************************/
    RTFidSHP,

    RTFidSHPLEFT,
    RTFidSHPTOP,
    RTFidSHPBOTTOM,
    RTFidSHPRIGHT,
    RTFidSHPLID,
    RTFidSHPZ,
    RTFidSHPFHDR,
    RTFidSHPBXPAGE,
    RTFidSHPBXMARGIN,
    RTFidSHPBXCOLUMN,
    RTFidSHPBXIGNORE,
    RTFidSHPBYPAGE,
    RTFidSHPBYMARGIN,
    RTFidSHPBYCOLUMN,
    RTFidSHPBYIGNORE,
    RTFidSHPBYPARA,
    RTFidSHPWR,
    RTFidSHPWRK,
    RTFidSHPFBLWTXT,
    RTFidSHPLOCKANCHOR,

    RTFidSHPTXT,
    RTFidSHPRSLT,
    RTFidSHPINST,
    RTFidSHPGRP,

    RTFidSP,
    RTFidSV,
				/****************************************/
				/*  Fields in dates and times.		*/
				/****************************************/
    RTFidDY,
    RTFidHR,
    RTFidMIN,
    RTFidMO,
    RTFidYR,
				/****************************************/
				/*  Unknown				*/
				/****************************************/
    RTFidITAP,
    RTFidLIN,
    RTFidRIN,
    RTFidLANGNP,
    RTFidLANGFE,
    RTFidLANGFENP,
    RTFidNOLNHTADJTBL,

    RTFid__COUNT

    } RtfTag;

/************************************************************************/
/*									*/
/*  Context for Reading RTF.						*/
/*									*/
/*  To ensure proper field/bookmark nesting.. A stack op active		*/
/*  is kept to be flushed at the appropriate transitions. (Field end,	*/
/*  field start, paragraph end.)					*/
/*									*/
/************************************************************************/

typedef struct RtfBookmarkLevel
    {
    int				rblFieldNumber;
    struct RtfBookmarkLevel *	rblPrevious;
    } RtfBookmarkLevel;

typedef struct RtfReadingContext
    {
    int				rrcLevel;
    int				rrcSplitLevel;
				/****************************************/
				/*  The depth in the document		*/
				/*  == Type of BufferItem.		*/
				/****************************************/
    int				rrcComplainUnknown;
				/****************************************/
				/*  Complain about unknown control	*/
				/****************************************/
    int				rrcCharacterAhead;
				/****************************************/
				/*  Character that could not be unread	*/
				/*  using ungetc().			*/
				/****************************************/
    int				rrcCurrentLine;
    BufferDocument *		rrcBd;
    BufferItem *		rrcBi;
				/****************************************/
				/*  The current position in the input.	*/
				/****************************************/
    TextAttribute		rrcCurrentTextAttribute;
    int				rrcInDeletedText;
    BorderProperties		rrcTextBorderProperties;
    int				rrcTextShadingPattern;
    int				rrcTextShadingLevel;
    int				rrcTextForeground;
    int				rrcTextBackground;
				/****************************************/
				/*  Text attributes of the current pos.	*/
				/****************************************/
    ParagraphProperties		rrcParagraphProperties;
    CellProperties		rrcCellProperties;
    RowProperties		rrcRowProperties;
    SectionProperties		rrcSectionProperties;
    BorderProperties		rrcBorderProperties;
    ShapeProperties		rrcShapeProperties;
    DrawingShape		rrcShape;
    TabStop			rrcTabStop;
    RGB8Color			rrcColor;
    int				rrcGotComponent;
    struct tm			rrcTm;
    unsigned char *		rrcInfoText;

    ParagraphNumber		rrcParagraphNumber;
    int				rrcWhichPnText;
    ParagraphNumber *		rrcParagraphNumbers;
    int				rrcParagraphNumberCount;

    DocumentList		rrcDocumentList;

				/****************************************/
				/*  Document properties.		*/
				/****************************************/
    DocumentFont		rrcCurrentFont;

    int				rrcStyleNumber;
    int				rrcStyleBasedOn;
    int				rrcStyleNext;
				/****************************************/
				/*  For reading the font table.		*/
				/*  Style sheet.			*/
				/****************************************/
    InsertedObject *		rrcInsertedObject;
    int				rrcFieldNumber;
    unsigned char		rrcBookmarkName[DOCmaxBOOKMARK+1];
    unsigned char		rrcBookmarkSize;
    RtfBookmarkLevel *		rrcTopBookmark;
				/****************************************/
				/*  For reading 'objects' and pictures.	*/
				/*  For reading 'fields'.		*/
				/****************************************/
    int				rrcJustAfterPntext;
    int				rrcPageAfterPntext;
				/****************************************/
				/*  For coping with the way word saves	*/
				/*  {\pntext ... }			*/
				/****************************************/
    unsigned char		rrcInputMapping[256];
    } RtfReadingContext;


/************************************************************************/
/*  Types of shape.							*/
/************************************************************************/

typedef enum ShapeProperty
    {
    RTFSHP_Rotation,
    RTFSHP_fFlipV,
    RTFSHP_fFlipH,
    RTFSHP_shapeType,
    RTFSHP_WzName,
    RTFSHP_pWrapPolygonVertices,
    RTFSHP_dxWrapDistLeft,
    RTFSHP_dyWrapDistTop,
    RTFSHP_dxWrapDistRight,
    RTFSHP_dyWrapDistBottom,
    RTFSHP_fBehindDocument,
    RTFSHP_fIsButton,
    RTFSHP_fHidden,
    RTFSHP_fLockRotation,
    RTFSHP_fLockAspectRatio,
    RTFSHP_fLockAgainstSelect,
    RTFSHP_fLockCropping,
    RTFSHP_fLockVerticies,
    RTFSHP_fLockText,
    RTFSHP_fLockAdjustHandles,
    RTFSHP_fLockAgainstGrouping,
    RTFSHP_dxTextLeft,
    RTFSHP_dyTextTop,
    RTFSHP_dxTextRight,
    RTFSHP_dyTextBottom,
    RTFSHP_WrapText,
    RTFSHP_anchorText,
    RTFSHP_txflTextFlow,
    RTFSHP_gtextUNICODE,
    RTFSHP_gtextAlign,
    RTFSHP_gtextSize,
    RTFSHP_gtextSpacing,
    RTFSHP_gtextFont,
    RTFSHP_fGtext,
    RTFSHP_gtextFVertical,
    RTFSHP_gtextFKern,
    RTFSHP_gtextFTight,
    RTFSHP_gtextFStretch,
    RTFSHP_gtextFShrinkFit,
    RTFSHP_gtextFBestFit,
    RTFSHP_gtextFNormalize,
    RTFSHP_gtextFDxMeasure,
    RTFSHP_gtextFBold,
    RTFSHP_gtextFItalic,
    RTFSHP_gtextFUnderline,
    RTFSHP_gtextFShadow,
    RTFSHP_gtextFSmallcaps,
    RTFSHP_gtextFStrikethrough,
    RTFSHP_cropFromTop,
    RTFSHP_cropFromBottom,
    RTFSHP_cropFromLeft,
    RTFSHP_cropFromRight,
    RTFSHP_pib,
    RTFSHP_pibName,
    RTFSHP_pibFlags,
    RTFSHP_pictureTransparent,
    RTFSHP_pictureContrast,
    RTFSHP_PictureBrightness,
    RTFSHP_pictureGamma,
    RTFSHP_pictureGray,
    RTFSHP_pictureBiLevel,
    RTFSHP_geoLeft,
    RTFSHP_geoTop,
    RTFSHP_geoRight,
    RTFSHP_geoBottom,
    RTFSHP_pVerticies,
    RTFSHP_pSegmentInfo,
    RTFSHP_adjustValue,
    RTFSHP_adjust2Value,
    RTFSHP_adjust3Value,
    RTFSHP_adjust4Value,
    RTFSHP_adjust5Value,
    RTFSHP_adjust6Value,
    RTFSHP_adjust7Value,
    RTFSHP_adjust8Value,
    RTFSHP_adjust9Value,
    RTFSHP_adjust10Value,
    RTFSHP_fillType,
    RTFSHP_fillColor,
    RTFSHP_fillOpacity,
    RTFSHP_fillBackColor,
    RTFSHP_fillBackOpacity,
    RTFSHP_fillBlip,
    RTFSHP_fillBlipName,
    RTFSHP_fillblipflags,
    RTFSHP_fillWidth,
    RTFSHP_fillHeight,
    RTFSHP_fillAngle,
    RTFSHP_fillFocus,
    RTFSHP_fillToLeft,
    RTFSHP_fillToTop,
    RTFSHP_fillToRight,
    RTFSHP_fillToBottom,
    RTFSHP_fillShadeColors,
    RTFSHP_fillOriginX,
    RTFSHP_fillOriginY,
    RTFSHP_fillShapeOriginX,
    RTFSHP_fillShapeOriginY,
    RTFSHP_fillCrMod,
    RTFSHP_fillBlipFlags,
    RTFSHP_fillRectLeft,
    RTFSHP_fillRectTop,
    RTFSHP_fillRectRight,
    RTFSHP_fillRectBottom,
    RTFSHP_fillDztype,
    RTFSHP_fillShadePreset,
    RTFSHP_fFilled,
    RTFSHP_lineColor,
    RTFSHP_lineBackColor,
    RTFSHP_lineType,
    RTFSHP_lineFillBlip,
    RTFSHP_lineblipflags,
    RTFSHP_lineFillWidth,
    RTFSHP_lineFillHeight,
    RTFSHP_lineFillDztype,
    RTFSHP_lineWidth,
    RTFSHP_lineStyle,
    RTFSHP_lineDashing,
    RTFSHP_lineStartArrowhead,
    RTFSHP_lineEndArrowhead,
    RTFSHP_lineStartArrowWidth,
    RTFSHP_lineStartArrowLength,
    RTFSHP_lineEndArrowWidth,
    RTFSHP_lineEndArrowLength,
    RTFSHP_lineCrMod,
    RTFSHP_lineFillBlipFlags,
    RTFSHP_lineMiterLimit,
    RTFSHP_fLine,
    RTFSHP_shadowType,
    RTFSHP_shadowColor,
    RTFSHP_shadowHighlight,
    RTFSHP_shadowOpacity,
    RTFSHP_shadowOffsetX,
    RTFSHP_shadowOffsetY,
    RTFSHP_shadowSecondOffsetX,
    RTFSHP_shadowSecondOffsetY,
    RTFSHP_shadowScaleXToX,
    RTFSHP_shadowScaleYToX,
    RTFSHP_shadowScaleXToY,
    RTFSHP_shadowScaleYToY,
    RTFSHP_shadowPerspectiveX,
    RTFSHP_shadowPerspectiveY,
    RTFSHP_shadowWeight,
    RTFSHP_shadowOriginX,
    RTFSHP_shadowOriginY,
    RTFSHP_shadowCrMod,
    RTFSHP_fShadow,
    RTFSHP_c3DSpecularAmt,
    RTFSHP_c3DDiffuseAmt,
    RTFSHP_c3DShininess,
    RTFSHP_c3DEdgeThickness,
    RTFSHP_c3DExtrudeForward,
    RTFSHP_c3DExtrudeBackward,
    RTFSHP_c3DExtrusionColor,
    RTFSHP_f3D,
    RTFSHP_fc3DMetallic,
    RTFSHP_fc3DUseExtrusionColor,
    RTFSHP_fc3DLightFace,
    RTFSHP_c3DYRotationAngle,
    RTFSHP_c3DXRotationAngle,
    RTFSHP_c3DRotationAxisX,
    RTFSHP_c3DRotationAxisY,
    RTFSHP_c3DRotationAxisZ,
    RTFSHP_c3DRotationAngle,
    RTFSHP_fC3DRotationCenterAut,
    RTFSHP_c3DRotationCenterX,
    RTFSHP_c3DRotationCenterY,
    RTFSHP_c3DRotationCenterZ,
    RTFSHP_c3DRenderMode,
    RTFSHP_c3DXViewpoint,
    RTFSHP_c3DYViewpoint,
    RTFSHP_c3DZViewpoint,
    RTFSHP_c3DOriginX,
    RTFSHP_c3DOriginY,
    RTFSHP_c3DSkewAngle,
    RTFSHP_c3DSkewAmount,
    RTFSHP_c3DAmbientIntensity,
    RTFSHP_c3DKeyX,
    RTFSHP_c3DKeyY,
    RTFSHP_c3DKeyZ,
    RTFSHP_c3DKeyIntensity,
    RTFSHP_c3DFillX,
    RTFSHP_c3DFillY,
    RTFSHP_c3DFillZ,
    RTFSHP_c3DFillIntensity,
    RTFSHP_c3DExtrudePlane,
    RTFSHP_c3DCrMod,
    RTFSHP_c3DTolerance,
    RTFSHP_fc3DParallel,
    RTFSHP_fc3DKeyHarsh,
    RTFSHP_fc3DFillHarsh,
    RTFSHP_fc3DConstrainRotation,	/*  ?  */
    RTFSHP_fc3DRotationCenterAuto,	/*  ?  */
    RTFSHP_spcot,
    RTFSHP_dxyCalloutGap,
    RTFSHP_spcoa,
    RTFSHP_spcod,
    RTFSHP_dxyCalloutDropSpecified,
    RTFSHP_dxyCalloutLengthSpecified,
    RTFSHP_fCallout,
    RTFSHP_fCalloutAccentBar,
    RTFSHP_fCalloutTextBorder,
    RTFSHP_fCalloutDropAuto,
    RTFSHP_fCalloutLengthSpecified,

    RTFSHP_pictureId,
    RTFSHP_pictureActive,
    RTFSHP_fHitTestFill,
    RTFSHP_fillShape,
    RTFSHP_fillUseRect,
    RTFSHP_fNoFillHitTest,
    RTFSHP_fArrowheadsOK,
    RTFSHP_fHitTestLine,
    RTFSHP_lineFillShape,
    RTFSHP_fNoLineDrawDash,
    RTFSHP_fshadowObscured,
    RTFSHP_fEditedWrap,
    RTFSHP_fOnDblClickNotify,
    RTFSHP_fOneD,
    RTFSHP_fPrint,

    RTFSHP_groupLeft,		/* ? */
    RTFSHP_groupTop,		/* ? */
    RTFSHP_groupRight,		/* ? */
    RTFSHP_groupBottom,		/* ? */

    RTFSHP_relLeft,		/* ? */
    RTFSHP_relTop,		/* ? */
    RTFSHP_relRight,		/* ? */
    RTFSHP_relBottom,		/* ? */

    RTFSHP_fRelFlipH,		/* ? */
    RTFSHP_fRelFlipV,		/* ? */

    RTFSHP_pictureDblCrMod,	/* ? */
    RTFSHP_pictureFillCrMod,	/* ? */
    RTFSHP_pictureLineCrMod,	/* ? */
    RTFSHP_fillShadeType,	/* ? */
    RTFSHP_fSelectText,		/* ? */
    RTFSHP_fRotateText,		/* ? */
    RTFSHP_fFitShapeToText,	/* ? */
    RTFSHP_fFitTextToShape,	/* ? */
    RTFSHP_fAutoTextMargin,	/* ? */
    RTFSHP_fCalloutMinusX,	/* ? */
    RTFSHP_fCalloutMinusY,	/* ? */

    RTFSHP_shapePath,		/* ? */
    RTFSHP_fFillOK,		/* ? */
    RTFSHP_lTxid,		/* ? */
    RTFSHP_hspNext,		/* ? */
    RTFSHP_lidRegroup,		/* ? */

    RTFSHP_lineOpacity,		/* ? */
    RTFSHP_lineEndCapStyle,	/* ? */

    RTFSHP_rotation,		/* ? */
    RTFSHP_cdirFont,		/* ? */
    RTFSHP_bWMode,
    RTFSHP_fLayoutInCell,

    RTFSHP__________Terminate_Enum
    } ShapeProperty;

/************************************************************************/
/*  What you can find in an RTF file.					*/
/************************************************************************/
#   define	RTFfiCTRLGROUP	1
#   define	RTFfiWORD	2
#   define	RTFfiCHAR	3
#   define	RTFfiTAB	4
#   define	RTFfiCLOSE	5
#   define	RTFfiSTARGROUP	6
#   define	RTFfiTEXTGROUP	7

/************************************************************************/
/*  Writing context.							*/
/************************************************************************/

typedef struct RtfWritingContext
    {
    TextAttribute	rwcTextAttribute;
    TextAttribute	rwcOutsideLinkAttribute;
    ParagraphProperties	rwcParagraphProperties;
    RowProperties	rwcRowProperties;

    TextAttribute	rwcOutsideTableTextAttribute;
    ParagraphProperties	rwcOutsideTableParagraphProperties;

    int			rwcInFldrslt;
    int			rwcInTable;

    int			rwcHasPrecedingTags;
    int			rwcSaveBookmarks;

    int			rwcSaveAsLink;
    int			rwcSaveAsLinkAsRef;
    int			rwcSaveAsLinkAsPageref;
    DocumentField	rwcSaveAsHyperlinkField;
    DocumentField	rwcSaveAsRefField;
    DocumentField	rwcSaveAsPagerefField;

    unsigned char	rwcOutputMapping[256];
    } RtfWritingContext;

/************************************************************************/
/*  Map control words to functions that handle them.			*/
/************************************************************************/
typedef struct RtfControlWord
    {
    char *		rcwWord;
    RtfTag		rcwId;
    ItemLevel		rcwLevel;
    int			(*rcwApply)( SimpleInputStream *		sis,
				    const struct RtfControlWord *	rcw,
				    int					arg,
				    RtfReadingContext *			rrc );
    int			(*rcwPrepare)( SimpleInputStream *		sis,
				    const struct RtfControlWord *	rcw,
				    int					arg,
				    RtfReadingContext *			rrc );
    struct RtfControlWord *	rcwDetailWords;
    } RtfControlWord;

#   define	TEDszRTFCONTROL		32

typedef int (*RtfAddTextParticule)(	RtfReadingContext *		rrc,
					const unsigned char *		text,
					int				len );

/************************************************************************/
/*  Common data.							*/
/************************************************************************/

extern RtfControlWord	docRtfEmptyTable[];
extern RtfControlWord	docRtfDocumentWords[];
extern RtfControlWord	docRtfDocumentGroups[];
extern RtfControlWord	docRtfPropertyWords[];

/************************************************************************/
/*  Routine declarations.						*/
/************************************************************************/

extern void docRtfInitReadingContext(	RtfReadingContext *		rrc );
extern void docRtfCleanReadingContext(	RtfReadingContext *		rrc );
extern int docRtfCopyReadingContext(	RtfReadingContext *		to,
					const RtfReadingContext *	from );
extern void docRtfCopyReadingContextBack( RtfReadingContext *		to,
					RtfReadingContext *	from );

extern const RtfControlWord * docRtfFindWord(	const char *	controlWord,
					const RtfControlWord *	contolWords,
					int			listOnly );

extern int docRtfApplyControlWord(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			gotArg,
					int			arg,
					RtfReadingContext *	rrc	);

extern int docRtfReadGroup(	SimpleInputStream *	sis,
				int			textLevel,

				const RtfControlWord *	firstApply,
				int			gotArg,
				int			arg,

				RtfReadingContext *	rrc,

				const RtfControlWord *	contolWords,
				const RtfControlWord *	groupWords,
				RtfAddTextParticule	addParticule	);

extern int docRtfFindControl(	SimpleInputStream *	sis,
				RtfReadingContext *	rrc,
				int *			pC,
				char *			controlWord,
				int *			pGotArg,
				int *			pArg		);

extern int docRtfIgnoreWord(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	);

extern int docRtfIgnoreParticule(	RtfReadingContext *	rrc,
					const unsigned char *	text,
					int			len	);

extern int docRtfIgnoreText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	);

extern int docRtfRefuseText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	);

extern int docRtfSkipGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	groupRcw,
				int			textLevel,
				RtfReadingContext *	rrc );

extern int docRtfConsumeGroup(	SimpleInputStream *	sis,
				int			textLevel,

				RtfReadingContext *	internRrc,

				const RtfControlWord *	contolWords,
				const RtfControlWord *	groupWords,
				RtfAddTextParticule	addParticule	);

extern int docRtfReadPict(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadNonshppict(SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadShppict(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadObject(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfAdjustLevel(	RtfReadingContext *	rrc,
				int			toLevel,
				int			textLevel	);

extern int docRtfReadShape(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfTextParticule(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len );

extern int docRtfReadField(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadLookupEntry(SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadHeaderFooter(SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadFootnote(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfChftn(		SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfBkmkStart(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfBkmkEnd(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfSpecialToField(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberProperty(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfFlushBookmarks(	int			fieldNumber,
					BufferItem *		bi,
					RtfReadingContext *	rrc );

extern int docRtfFontTable(		SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfColorTable(		SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRevisionTable(		SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfStylesheet(		SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfListtable(		SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfReadInfo(		SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberDocProperty(	SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

