/************************************************************************/
/*									*/
/*  Postscript printing and formatting related data structures.		*/
/*									*/
/************************************************************************/

#   include	<psFont.h>
#   include	"docBuf.h"
#   include	"docDraw.h"
#   include	"appPs.h"

typedef struct ParticuleData
    {
    int			pdX0;
    int			pdWidth;
    int			pdDecWidth;
    int			pdVisibleWidth;
    int			pdTabNumber;
    int			pdTabKind;
    int			pdTabPosition;
    const AfmFontInfo *	pdAfi;

    int			pdVisiblePixels;
    int			pdWhiteUnits;
    int			pdCorrectBy;
    } ParticuleData;

/************************************************************************/
/*									*/
/*  Pass through information for a layout job.				*/
/*									*/
/************************************************************************/

typedef int (*LAYOUT_SCREEN_LINE)( TextLine *			tl,
				const BufferItem *		bi,
				int				part,
				int				accepted,
				AppDrawingData *		add,
				const FormattingFrame *		ffPixels,
				TextParticule *			tp,
				ParticuleData *			pd );

typedef int (*START_PARAGRAPH)( FormattingFrame *		ff,
				int				bottomTwips,
				int				stripHigh,
				BufferItem *			bi,
				AppDrawingData *		add,
				const DocumentProperties *	dp );

typedef int (*START_SCREEN_PARAGRAPH)(
				FormattingFrame *		ff,
				BufferItem *			bi,
				AppDrawingData *		add,
				const DocumentProperties *	dp );

typedef int (*START_ROW)(	BufferItem *			rowBi,
				AppDrawingData *		add,
				const DocumentProperties *	dp );

typedef struct ScreenLayout
    {
    START_ROW			slStartRow;
    START_SCREEN_PARAGRAPH	slStartParagraph;
    LAYOUT_SCREEN_LINE		slLayoutLine;
    } ScreenLayout;

typedef struct LayoutJob
    {
    LayoutPosition		ljPosition;
    LayoutPosition		ljBottom;

    DocumentRectangle *		ljChangedRectanglePixels;

    int				ljInHeaderFooter;
    ScreenLayout		ljLayoutScreen;
    ScreenLayout		ljPlaceScreen;
    } LayoutJob;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docPsLineBox(	TextLine *			tl,
				const BufferItem *		bi,
				int				part,
				int				tabInterval,
				const DocumentFontList *	dfl,
				AppPhysicalFontList *		apfl,
				const TextParticule *		tp,
				ParticuleData *			pd,
				const FormattingFrame *		ff );

extern AfmFontInfo * docPsPrintGetAfi(	const AppPhysicalFontList *	apfl,
					int				physf );

extern int docPsClaimParticuleData(	const BufferItem *	bi,
					ParticuleData **	pData );

extern int docPsParagraphLineExtents(	const AppPhysicalFontList *	apfl,
					BufferItem *			bi );

extern int docPsPrintGetItemFonts(	const BufferItem *		bi,
					DocumentFontList *		dfl,
					const AppPhysicalFontList *	apfl,
					PostScriptFont **		pFntLst,
					int *				pCount );

extern int docPsPrintDocument(	FILE *			f,
			const char *			title,
			const char *			applicationName,
			const char *			applicationReference,
			AppDrawingData *		add,
			BufferDocument *		bd,
			int				nup,
			int				horizontal,
			int				firstPage,
			int				lastPage,
			const DocumentGeometry *	dgPrinter,
			LAYOUT_EXTERNAL			layoutHeader,
			LAYOUT_EXTERNAL			layoutFooter );

extern int docPsLayoutItemAndParents(	BufferItem *		bi,
					AppDrawingData *	add,
					const BufferDocument *	bd,
					LayoutJob *		lj,
					int			andParents );

extern int docPsAdjustParaLayout(	BufferItem *		bi,
					int			line,
					int			stroffShift,
					int			upto,
					AppDrawingData *	add,
					const BufferDocument *	bd,
					LayoutJob *		lj );

extern void docPsStartPageLayout( int				pageNumber,
				AppDrawingData *		add,
				const SectionProperties *	sp,
				LayoutPosition *		lpTop );

extern int docPsListObjectFonts(	const InsertedObject *	io,
					const char *		afmDirectory,
					const char *		prefix,
					PostScriptFont **	pFontList,
					int *			pCount );

extern int docLayoutHeaderFooter( HeaderFooter *		hf,
				int				pageNumber,
				int				inHeaderFooter,
				BufferDocument *		bd,
				const BufferItem *		sectBi,
				AppDrawingData *		add,
				LAYOUT_EXTERNAL			layoutExternal,
				DocumentRectangle *		drChanged );

