/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Initialise a BufferItem.						*/
/*									*/
/************************************************************************/

void docInitBorderProperties(	BorderProperties *	bp )
    {
    bp->bpColor= 0;
    bp->bpWidthTwips= 15;
    bp->bpSpacingTwips= 0;
    bp->bpStyle= DOCbsHAIR;
    bp->bpIsSet= 0;
    bp->bpThickness= 0;
    }

void docCleanParagraphProperties(	ParagraphProperties *	pp )
    {
    if  ( pp->ppTabStops )
	{ free( pp->ppTabStops );	}
    }

void docCleanSectionProperties(	SectionProperties *	sp )
    {
    if  ( sp->spParagraphNumbers )
	{ free( sp->spParagraphNumbers );	}

    return;
    }

void docInitParagraphProperties(	ParagraphProperties *	pp )
    {
    pp->ppTabCount= 0;
    pp->ppTabStops= (TabStop *)0;

    pp->ppFirstIndentTwips= 0;
    pp->ppLeftIndentTwips= 0;
    pp->ppRightIndentTwips= 0;
    pp->ppSpaceBeforeTwips= 0;
    pp->ppSpaceAfterTwips= 0;
    pp->ppLineSpacingTwips= 0;

    pp->ppOutlineLevel= 0;
    pp->ppShadingLevel= 0;

    pp->ppShadingPattern= DOCspSOLID;

    pp->ppAlignment= DOCiaLEFT;

    pp->ppStartsOnNewPage= 0;
    pp->ppInTable= 0;
    pp->ppLineSpacingIsMultiple= 0;

    pp->ppKeepOnPage= 0;
    pp->ppKeepWithNext= 0;

    pp->ppStyle= 0;

    docInitBorderProperties( &(pp->ppTopBorder) );
    docInitBorderProperties( &(pp->ppLeftBorder) );
    docInitBorderProperties( &(pp->ppRightBorder) );
    docInitBorderProperties( &(pp->ppBottomBorder) );
    docInitBorderProperties( &(pp->ppBoxBorder) );
    docInitBorderProperties( &(pp->ppBetweenBorder) );
    docInitBorderProperties( &(pp->ppBar) );

    return;
    }

int docParaSaveTabs(	ParagraphProperties *		to,
			const ParagraphProperties *	from )
    {
    TabStop *	tabs= (TabStop *)0;

    if  ( from->ppTabCount > 0 )
	{
	int	i;

	tabs= (TabStop *)realloc( to->ppTabStops,
					from->ppTabCount* sizeof(TabStop) );
	if  ( ! tabs )
	    { LXDEB(from->ppTabCount,tabs); return -1;	}

	for ( i= 0; i < from->ppTabCount; i++ )
	    { tabs[i]= from->ppTabStops[i];	}
	}


    to->ppTabStops= tabs;
    to->ppTabCount= from->ppTabCount;

    return 0;
    }

int docCopyParagraphRuler(	ParagraphProperties *		to,
				const ParagraphProperties *	from	)
    {
    if  ( docParaSaveTabs( to, from ) )
	{ LDEB(from->ppTabCount); return -1;	}

    to->ppFirstIndentTwips= from->ppFirstIndentTwips;
    to->ppLeftIndentTwips= from->ppLeftIndentTwips;
    to->ppRightIndentTwips= from->ppRightIndentTwips;

    return 0;
    }

int docCopyParagraphProperties(	ParagraphProperties *		to,
				const ParagraphProperties *	from	)
    {
    TabStop *	tabs;

    if  ( docParaSaveTabs( to, from ) )
	{ LDEB(from->ppTabCount); return -1;	}

    tabs= to->ppTabStops;
    *to= *from;
    to->ppTabStops= tabs;

    return 0;
    }

void docInitSectionProperties(	SectionProperties *	sp )
    {
    appInitDocumentGeometry( &(sp->spDocumentGeometry) );

    sp->spColumnCount= 1;
    sp->spColumnSpacingTwips= 720;
    sp->spColumnWidthTwips= 0;

    sp->spHasTitlePage= 0;
    sp->spBreakKind= DOCsbkPAGE;
    sp->spPageNumberStyle= DOCpgnDEC;
    sp->spRestartPageNumbers= 0;

    sp->spStartPageNumber= 0;

    sp->spParagraphNumbers= (ParagraphNumber *)0;
    sp->spParagraphNumberCount= 0;

    return;
    }

void docInitCellProperties(	CellProperties *	cp )
    {
    cp->cpRightBoundaryTwips= 0;
    cp->cpRightBoundaryPixels= 0;

    cp->cpForegroundColor= -1;
    cp->cpBackgroundColor= -1;

    cp->cpShadingLevel= 0;
    cp->cpShadingPattern= DOCspSOLID;

    cp->cpLeftInMergedRow= 0;
    cp->cpMergedWithLeft= 0;
    cp->cpTopInMergedColumn= 0;
    cp->cpMergedWithAbove= 0;

    cp->cpVerticalTextAlignment= DOCvtaTOP;

    docInitBorderProperties( &(cp->cpTopBorder) );
    docInitBorderProperties( &(cp->cpLeftBorder) );
    docInitBorderProperties( &(cp->cpRightBorder) );
    docInitBorderProperties( &(cp->cpBottomBorder) );
    }

void docCleanInitRowProperties(	RowProperties *	rp )
    {
    docCleanRowProperties( rp );
    docInitRowProperties( rp );
    }

void docCleanRowProperties(	RowProperties *	rp )
    {
    if  ( rp->rpCells )
	{ free( rp->rpCells );	}
    }

void docInitRowProperties(	RowProperties *	rp )
    {
    rp->rpCellCount= 0;
    rp->rpCells= (CellProperties *)0;

    rp->rpHalfGapWidthTwips= 0;
    rp->rpHalfGapWidthPixels= 0;

    rp->rpHeightTwips= 0;

    rp->rpLeftIndentTwips= 0;
    rp->rpLeftIndentPixels= 0;

    rp->rpHasTableParagraphs= 0;

    rp->rpIsTableHeader= 0;
    rp->rpKeepOnPage= 0;

    rp->rpHasHorizontalBorders= 0;
    rp->rpHasVerticalBorders= 0;

    docInitBorderProperties( &rp->rpTopBorder );
    docInitBorderProperties( &rp->rpBottomBorder );
    docInitBorderProperties( &rp->rpLeftBorder );
    docInitBorderProperties( &rp->rpRightBorder );
    docInitBorderProperties( &rp->rpHorizontalBorder );
    docInitBorderProperties( &rp->rpVerticalBorder );
    }

int docInsertRowColumn(	RowProperties *			rp,
			int				n,
			const CellProperties *		cp )
    {
    CellProperties *	fresh;

    fresh= (CellProperties *)realloc( rp->rpCells,
			(rp->rpCellCount+ 1)* sizeof(CellProperties) );
    if  ( ! fresh )
	{ LXDEB(rp->rpCellCount,fresh); return -1;	}
    rp->rpCells= fresh;

    if  ( n < 0 )
	{ n= rp->rpCellCount;	}
    else{
	int		i;

	for ( i= rp->rpCellCount; i > n; i-- )
	    { fresh[i]= fresh[i-1];	}
	}

    fresh[n]= *cp;
    rp->rpCellCount++;

    return 0;
    }

int docCopyRowProperties(	RowProperties *		to,
				const RowProperties *	from	)
    {
    CellProperties *	cp= (CellProperties *)0;

    if  ( from->rpCellCount > 0 )
	{
	int	i;

	cp= (CellProperties *)realloc( to->rpCells,
			    from->rpCellCount* sizeof(CellProperties) );
	if  ( ! cp )
	    { LXDEB(from->rpCellCount,cp); return -1;	}

	for ( i= 0; i < from->rpCellCount; i++ )
	    { cp[i]= from->rpCells[i];	}
	}

    *to= *from; to->rpCells= cp;

    return 0;
    }


/************************************************************************/
/*									*/
/*  Copy SectionProperties.						*/
/*									*/
/*  NOTE that the headers and footers or the paragraph numbers for	*/
/*  bulleted lists etc are not copied.					*/
/*									*/
/************************************************************************/

int docCopySectionProperties(	SectionProperties *		to,
				const SectionProperties *	from	)
    {
    to->spDocumentGeometry= from->spDocumentGeometry;

    to->spColumnCount= from->spColumnCount;

    to->spHasTitlePage= from->spHasTitlePage;
    to->spBreakKind= from->spBreakKind;
    to->spPageNumberStyle= from->spPageNumberStyle;

    to->spRestartPageNumbers= from->spRestartPageNumbers;
    to->spStartPageNumber= from->spStartPageNumber;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Initialise a BufferDocument.					*/
/*									*/
/************************************************************************/

void docInitDocumentProperties(	DocumentProperties *	dp )
    {
    dp->dpContainsTables= 0;
    dp->dpTabIntervalTwips= 720;
    dp->dpDefaultColor= 0;
    dp->dpDefaultFont= -1;
    dp->dpAnsiCodePage= -1;

    dp->dpStartPageNumber= 1;
    dp->dpStartFootnoteNumber= 1;
    dp->dpStartEndnoteNumber= 1;

    dp->dpFootEndNoteType= DPfetFOOT_ONLY;
    dp->dpFootnotePosition= DPftnPOS_PAGE_BOTTOM;
    dp->dpEndnotePosition= DPftnPOS_DOC_END;
    dp->dpFootnotesRestart= DPftnRST_CONTINUOUS;
    dp->dpEndnotesRestart= DPftnRST_CONTINUOUS;
    dp->dpFootnoteNumberStyle= DPftnNAR;
    dp->dpEndnoteNumberStyle= DPftnNAR;

    dp->dpHasFacingPages= 0;

    appInitDocumentGeometry( &(dp->dpGeometry) );

    docInitFontList( &(dp->dpFontList) );

    dp->dpColors= (RGB8Color *)0;
    dp->dpColorCount= 0;

    dp->dpAuthors= (unsigned char **)0;
    dp->dpAuthorCount= 0;

    dp->dpTitle= (unsigned char *)0;
    dp->dpSubject= (unsigned char *)0;
    dp->dpKeywords= (unsigned char *)0;
    dp->dpComment= (unsigned char *)0;
    dp->dpAuthor= (unsigned char *)0;
    dp->dpHlinkbase= (unsigned char *)0;

    appInvalidateTime( &(dp->dpCreatim) );
    appInvalidateTime( &(dp->dpRevtim) );
    appInvalidateTime( &(dp->dpPrintim) );
    }

void docCleanDocumentProperties(	DocumentProperties *	dp )
    {
    int		i;

    docCleanFontList( &(dp->dpFontList) );

    if  ( dp->dpColors )
	{ free( dp->dpColors );	}

    for ( i= 0; i < dp->dpAuthorCount; i++ )
	{ free( dp->dpAuthors[i] );	}
    if  ( dp->dpAuthors )
	{ free( dp->dpAuthors );	}

    appInvalidateTime( &(dp->dpCreatim) );
    appInvalidateTime( &(dp->dpRevtim) );
    appInvalidateTime( &(dp->dpPrintim) );

    if  ( dp->dpTitle )
	{ free( dp->dpTitle );	}
    if  ( dp->dpSubject )
	{ free( dp->dpSubject );	}
    if  ( dp->dpKeywords )
	{ free( dp->dpKeywords );	}
    if  ( dp->dpComment )
	{ free( dp->dpComment );	}
    if  ( dp->dpAuthor )
	{ free( dp->dpAuthor );	}
    if  ( dp->dpHlinkbase )
	{ free( dp->dpHlinkbase );	}

    return;
    }

int docCopyDocumentProperties(	DocumentProperties *		to,
				const DocumentProperties *	from )
    {
    int			i;
    DocumentProperties	copy;

    copy= *from;

    docInitFontList( &(copy.dpFontList) );
    copy.dpColorCount= 0;
    copy.dpColors= (RGB8Color *)0;
    copy.dpAuthorCount= 0;
    copy.dpAuthors= (unsigned char **)0;

    copy.dpTitle= (unsigned char *)0;
    copy.dpSubject= (unsigned char *)0;
    copy.dpKeywords= (unsigned char *)0;
    copy.dpComment= (unsigned char *)0;
    copy.dpAuthor= (unsigned char *)0;
    copy.dpHlinkbase= (unsigned char *)0;

    if  ( docCopyFontList( &(copy.dpFontList), &(from->dpFontList) ) )
	{ LDEB(1); docCleanDocumentProperties( &copy ); return -1;	}

    /**/
    copy.dpColors= (RGB8Color *)
			malloc( from->dpColorCount* sizeof(RGB8Color) );
    if  ( ! copy.dpColors )
	{
	XDEB(copy.dpColors);
	docCleanDocumentProperties( &copy ); return -1;
	}
    for ( i= 0; i < from->dpColorCount; i++ )
	{ copy.dpColors[i]= from->dpColors[i]; }
    copy.dpColorCount= from->dpColorCount;

    /**/
    copy.dpAuthors= (unsigned char **)
		    malloc( from->dpAuthorCount* sizeof(unsigned char *) );
    if  ( ! copy.dpAuthors )
	{
	XDEB(copy.dpAuthors);
	docCleanDocumentProperties( &copy ); return -1;
	}
    for ( i= 0; i < from->dpAuthorCount; i++ )
	{ copy.dpAuthors[i]= (unsigned char *)0; }
    copy.dpAuthorCount= from->dpAuthorCount;
    for ( i= 0; i < from->dpAuthorCount; i++ )
	{
	copy.dpAuthors[i]= (unsigned char *)
				    strdup( (char *)from->dpAuthors[i] );
	if  ( ! copy.dpAuthors[i] )
	    {
	    XDEB(copy.dpAuthors[i]);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}

    if  ( from->dpTitle )
	{
	copy.dpTitle= (unsigned char *)strdup( (char *)from->dpTitle );
	if  ( ! copy.dpTitle )
	    {
	    XDEB(copy.dpTitle);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpSubject )
	{
	copy.dpSubject= (unsigned char *)strdup( (char *)from->dpSubject );
	if  ( ! copy.dpSubject )
	    {
	    XDEB(copy.dpSubject);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpKeywords )
	{
	copy.dpKeywords= (unsigned char *)strdup( (char *)from->dpKeywords );
	if  ( ! copy.dpKeywords )
	    {
	    XDEB(copy.dpKeywords);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpComment )
	{
	copy.dpComment= (unsigned char *)strdup( (char *)from->dpComment );
	if  ( ! copy.dpComment )
	    {
	    XDEB(copy.dpComment);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpAuthor )
	{
	copy.dpAuthor= (unsigned char *)strdup( (char *)from->dpAuthor );
	if  ( ! copy.dpAuthor )
	    {
	    XDEB(copy.dpAuthor);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpHlinkbase )
	{
	copy.dpHlinkbase= (unsigned char *)strdup( (char *)from->dpHlinkbase );
	if  ( ! copy.dpHlinkbase )
	    {
	    XDEB(copy.dpHlinkbase);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}

    docCleanDocumentProperties( to );
    *to= copy;

    return 0;
    }

/************************************************************************/
/*									*/
/*  1) Are the columns in two RowProperties 'the same' (Do they align?)	*/
/*  2) All column properties identical?					*/
/*									*/
/************************************************************************/

int docEqualBorder(	const BorderProperties *	bp1,
			const BorderProperties *	bp2 )
    {
    if  ( ! bp1->bpIsSet && ! bp2->bpIsSet )
	{ return 1;	}

    if  ( bp1->bpIsSet != bp2->bpIsSet )
	{ return 0;	}

    if  ( bp1->bpStyle != bp2->bpStyle )
	{ return 0;	}

    if  ( bp1->bpThickness != bp2->bpThickness )
	{ return 0;	}

    if  ( bp1->bpSpacingTwips != bp2->bpSpacingTwips )
	{ return 0;	}

    if  ( bp1->bpWidthTwips != bp2->bpWidthTwips )
	{ return 0;	}

    if  ( bp1->bpColor != bp2->bpColor )
	{ return 0;	}

    return 1;
    }

int docAlignedColumns(	const RowProperties *	rp1,
			const RowProperties *	rp2 )
    {
    CellProperties *	cp1;
    CellProperties *	cp2;
    int			i;

    if  ( rp1->rpHasTableParagraphs != rp2->rpHasTableParagraphs )
	{ return 0;	}

    if  ( rp1->rpCellCount != rp2->rpCellCount )
	{ return 0;	}

    if  ( rp1->rpHalfGapWidthTwips != rp2->rpHalfGapWidthTwips )
	{ return 0;	}

    if  ( rp1->rpLeftIndentTwips != rp2->rpLeftIndentTwips )
	{ return 0;	}

    cp1= rp1->rpCells;
    cp2= rp2->rpCells;
    for ( i= 0; i < rp1->rpCellCount; cp2++, cp1++, i++ )
	{
	if  ( cp1->cpRightBoundaryTwips != cp2->cpRightBoundaryTwips )
	    { return 0;	}
	}

    return 1;
    }

int docEqualRows(	const RowProperties *	rp1,
			const RowProperties *	rp2 )
    {
    const CellProperties *	cp1;
    const CellProperties *	cp2;
    int				i;

    if  ( rp1->rpCellCount != rp2->rpCellCount )
	{ return 0;	}

    if  ( rp1->rpHalfGapWidthTwips != rp2->rpHalfGapWidthTwips )
	{ return 0;	}

    if  ( rp1->rpLeftIndentTwips != rp2->rpLeftIndentTwips )
	{ return 0;	}

    if  ( rp1->rpHeightTwips != rp2->rpHeightTwips )
	{ return 0;	}

    if  ( rp1->rpIsTableHeader != rp2->rpIsTableHeader )
	{ return 0;	}

    if  ( rp1->rpHasVerticalBorders != rp2->rpHasVerticalBorders )
	{ return 0;	}
    if  ( rp1->rpHasHorizontalBorders != rp2->rpHasHorizontalBorders )
	{ return 0;	}

    if  ( ! docEqualBorder( &rp1->rpTopBorder, &rp2->rpTopBorder )	)
	{ return 0;	}
    if  ( ! docEqualBorder( &rp1->rpLeftBorder, &rp2->rpLeftBorder )	)
	{ return 0;	}
    if  ( ! docEqualBorder( &rp1->rpRightBorder, &rp2->rpRightBorder )	)
	{ return 0;	}
    if  ( ! docEqualBorder( &rp1->rpBottomBorder, &rp2->rpBottomBorder ) )
	{ return 0;	}
    if  ( rp1->rpHasVerticalBorders					&&
	  ! docEqualBorder( &rp1->rpVerticalBorder, &rp2->rpVerticalBorder ) )
	{ return 0;	}
    if  ( rp1->rpHasHorizontalBorders					&&
	  ! docEqualBorder( &rp1->rpHorizontalBorder, &rp2->rpHorizontalBorder))
	{ return 0;	}

    cp1= rp1->rpCells;
    cp2= rp2->rpCells;
    for ( i= 0; i < rp1->rpCellCount; cp2++, cp1++, i++ )
	{
	if  ( cp1->cpRightBoundaryTwips != cp2->cpRightBoundaryTwips )
	    { return 0;	}
	if  ( cp1->cpLeftInMergedRow != cp2->cpLeftInMergedRow )
	    { return 0;	}
	if  ( cp1->cpMergedWithLeft != cp2->cpMergedWithLeft )
	    { return 0;	}

	if  ( ! docEqualBorder( &cp1->cpTopBorder, &cp2->cpTopBorder )	)
	    { return 0;	}
	if  ( ! docEqualBorder( &cp1->cpLeftBorder, &cp2->cpLeftBorder ) )
	    { return 0;	}
	if  ( ! docEqualBorder( &cp1->cpRightBorder, &cp2->cpRightBorder ) )
	    { return 0;	}
	if  ( ! docEqualBorder( &cp1->cpBottomBorder, &cp2->cpBottomBorder ) )
	    { return 0;	}
	}

    return 1;
    }

void docInitTabStop(	TabStop *	ts )
    {
    ts->tsTwips= 0;
    ts->tsPixels= 0;
    ts->tsKind= DOCtkLEFT;
    ts->tsLeader= DOCtlNONE;
    }

/************************************************************************/
/*									*/
/*  Statistics about a document. Used in the 'Document Properties'	*/
/*  dialog.								*/
/*									*/
/************************************************************************/

void docInitDocumentStatistics(		DocumentStatistics *	ds )
    {
    ds->dsPageCount= 0;
    ds->dsParagraphCount= 0;
    ds->dsLineCount= 0;
    ds->dsWordCount= 0;
    ds->dsCharacterCount= 0;

    return;
    }

/************************************************************************/
/*									*/
/*  Paragraph numbering.						*/
/*									*/
/************************************************************************/

void docInitParagraphNumber(	ParagraphNumber*	pn )
    {
    pn->pnLevel= -1;
    pn->pnStyle= DOCpnDEC;

    pn->pnUseHangingIndent= 0;

    pn->pnStartNumber= 0;
    pn->pnIndentTwips= 0;

    docInitTextAttribute( &(pn->pnTextAttribute) );

    pn->pnTextBefore[0]= '\0';
    pn->pnTextAfter[0]= '\0';

    return;
    }

/************************************************************************/
/*									*/
/*  Merge the font list of one document into that of another one.	*/
/*  Update the references accordingly.					*/
/*									*/
/************************************************************************/

int docMergeDocumentFontsIntoList(	DocumentFontList *	dflTo,
					BufferDocument *	bdFrom )
    {
    BufferPosition		bpBeginFrom;
    BufferItem *		bi;

    int *			fontMap= (int *)0;
    int *			fontUsed= (int *)0;

    int				fromFont;
    int				fromFontCount;
    DocumentFont *		fromFonts;

    int				toFont;
    int				toFontCount;
    DocumentFont *		toFonts;

    fromFontCount= bdFrom->bdProperties.dpFontList.dflCount;
    fromFonts= bdFrom->bdProperties.dpFontList.dflFonts;

    toFontCount= dflTo->dflCount;
    toFonts= dflTo->dflFonts;

    toFonts= (DocumentFont *)realloc( toFonts,
		    ( toFontCount+ fromFontCount )* sizeof(DocumentFont) );
    if  ( ! toFonts )
	{ LXDEB(toFontCount+ fromFontCount,toFonts); return -1;	}
    dflTo->dflFonts= toFonts;

    fontMap= (int *)malloc( fromFontCount* sizeof( int ) );
    if  ( ! fontMap )
	{ LXDEB(fromFontCount,fontMap); return -1; }

    fontUsed= (int *)malloc( fromFontCount* sizeof( int ) );
    if  ( ! fontUsed )
	{ LXDEB(fromFontCount,fontUsed); return -1; }

    for ( fromFont= 0; fromFont < fromFontCount; fromFont++ )
	{ fontUsed[fromFont]= 0;	}

    if  ( docFirstPosition( &(bdFrom->bdItem), &bpBeginFrom ) )
	{ LDEB(1); return -1;	}
    bi= bpBeginFrom.bpBi;

    for (;;)
	{
	TextParticule *		tp;
	int			part;

	tp= bi->biParaParticules;

	for ( part= 0; part < bi->biParaParticuleCount; part++, tp++ )
	    { fontUsed[tp->tpTextAttribute.taFontNumber]= 1; }

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { break;	}
	}

    for ( fromFont= 0; fromFont < fromFontCount; fromFont++ )
	{
	if  ( ! fontUsed[fromFont] )
	    { continue;	}

	for ( toFont= 0; toFont < toFontCount; toFont++ )
	    {
	    if  ( toFonts[toFont].dfDocFamilyNumber < 0 )
		{ continue;	} 

	    if  ( ! toFonts[toFont].dfFamilyStyle )
		{ XDEB(toFonts[toFont].dfFamilyStyle); continue;	}

	    if  ( ! strcmp( fromFonts[fromFont].dfFamilyStyle,
					toFonts[toFont].dfFamilyStyle )	&&
		  ! strcmp( fromFonts[fromFont].dfName,
					toFonts[toFont].dfName )	)
		{ break;	}
	    }

	if  ( toFont >= toFontCount )
	    {
	    DocumentFont *	df;

	    df= docInsertFont( dflTo,
				    -1,
				    fromFonts[fromFont].dfFamilyStyle,
				    fromFonts[fromFont].dfName );

	    if  ( ! df )
		{ XDEB(df); return -1;	}

	    toFont= df->dfDocFamilyNumber;

	    toFonts= dflTo->dflFonts;
	    toFontCount= dflTo->dflCount;
	    }

	fontMap[fromFont]= toFont;
	}

    if  ( docFirstPosition( &(bdFrom->bdItem), &bpBeginFrom ) )
	{ LDEB(1); return -1;	}
    bi= bpBeginFrom.bpBi;

    for (;;)
	{
	TextParticule *		tp;
	int			part;

	tp= bi->biParaParticules;

	for ( part= 0; part < bi->biParaParticuleCount; part++, tp++ )
	    {
	    if  ( tp->tpTextAttribute.taFontNumber < 0			||
		  tp->tpTextAttribute.taFontNumber >= fromFontCount	)
		{
		LDEB(part);
		LLDEB(tp->tpTextAttribute.taFontNumber,fromFontCount);
		tp->tpTextAttribute.taFontNumber= 0;
		}
	    tp->tpTextAttribute.taFontNumber=
				    fontMap[tp->tpTextAttribute.taFontNumber];
	    }

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { break;	}
	}

    if  ( fontMap )
	{ free( fontMap );	}
    if  ( fontUsed )
	{ free( fontUsed );	}

    return 0;
    }
