/************************************************************************/
/*									*/
/*  Save a BufferDocument into a plain text file.			*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"docBuf.h"

#   include	<appDebugon.h>

typedef struct PlainWritingContext
    {
    int		pwcFold;
    int		pwcEndClosed;
    } PlainWritingContext;

static void docInitPlainWritingContext(	PlainWritingContext *	pwc )
    {
    pwc->pwcFold= 0;
    pwc->pwcEndClosed= 1;
    }

static int docPlainSaveParaItem(	SimpleOutputStream *	sos,
					const BufferItem *	bi,
					const BufferSelection *	bs,
					PlainWritingContext *	pwc )
    {
    TextParticule *	tp;
    unsigned char *	s;
    int			pos= 0;

    int			lineCount= 0;
    int			paragraphUnderlined= 1;

    int			part= 0;
    int			stroff= 0;
    int			upto= 0;

    if  ( bs && bs->bsBegin.bpBi == bi )
	{
	part= bs->bsBegin.bpParticule;
	stroff= bs->bsBegin.bpStroff;
	}

    tp= bi->biParaParticules+ part;
    s= bi->biParaString+ stroff;

    if  ( bs && bs->bsEnd.bpBi == bi )
	{ upto= bs->bsEnd.bpStroff;	}
    else{ upto= bi->biParaStrlen;	}

    while( stroff < upto && part < bi->biParaParticuleCount )
	{
	switch( tp->tpKind )
	    {
	    case DOCkindTAB:
		sioOutPutCharacter( '\t', sos );
		s++; stroff++;
		pos= 8* ( pos+ 8 )/ 8;
		paragraphUnderlined= 0;
		break;

	    case DOCkindTEXT:
		if  ( pwc->pwcFold && pos > 8 && pos+ tp->tpStrlen >= 72 )
		    {
		    sioOutPutCharacter( '\n', sos );
		    lineCount++; pos= 0;

		    if  ( bi->biParaFirstIndentTwips < 0	&&
			  bi->biParaLeftIndentTwips > 0		)
			{
			sioOutPutCharacter( '\t', sos ); pos= 8;
			paragraphUnderlined= 0;
			}
		    }

		if  ( ! tp->tpTextAttribute.taIsUnderlined )
		    { paragraphUnderlined= 0;	}

		while( stroff < upto && stroff < tp->tpStroff+ tp->tpStrlen )
		    { sioOutPutCharacter( *s, sos ); s++; stroff++; pos++; }

		break;

	    case DOCkindLINEBREAK:
		sioOutPutCharacter( '\r', sos );
		sioOutPutCharacter( '\n', sos );
		pos= 0; paragraphUnderlined= 0;
		s += tp->tpStrlen; stroff += tp->tpStrlen; /* += 1 */
		break;

	    case DOCkindPAGEBREAK:
		sioOutPutCharacter( '\r', sos );
		sioOutPutCharacter( '\n', sos );
		sioOutPutCharacter( '\f', sos );
		pos= 0; paragraphUnderlined= 0;
		s += tp->tpStrlen; stroff += tp->tpStrlen; /* += 1 */
		break;

	    default:
		LDEB(tp->tpKind);
		/*FALLTHROUGH*/
	    case DOCkindOBJECT:
	    case DOCkindFIELDSTART:
	    case DOCkindFIELDEND:
	    case DOCkindXE:
	    case DOCkindTC:
		s += tp->tpStrlen; stroff += tp->tpStrlen; /* += 0 */
		break;
	    }

	 part++; tp++;
	 }

    if  ( pwc->pwcEndClosed && stroff == bi->biParaStrlen )
	{ sioOutPutCharacter( '\n', sos ); lineCount++;	}

    if  ( lineCount == 1	&&
	  pos > 0		&&
	  paragraphUnderlined	)
	{
	stroff= 0;
	if  ( bs && bs->bsBegin.bpBi == bi )
	    { stroff= bs->bsBegin.bpStroff; }

	while( stroff < upto )
	    { sioOutPutCharacter( '-', sos ); stroff++;	}

	sioOutPutCharacter( '\n', sos );
	}

    return 0;
    }

static int docPlainSaveRowItem(	SimpleOutputStream *	sos,
				const BufferItem *	rowBi,
				const BufferSelection *	bs,
				PlainWritingContext *	pwc )
    {
    int			col;

    for ( col= 0; col < rowBi->biChildCount; col++ )
	{
	int		para;
	BufferItem *	cellBi= rowBi->biChildren[col];

	if  ( bs && docCompareItemPositions( cellBi, bs->bsBegin.bpBi ) < 0 )
	    { continue;	}

	if  ( bs && docCompareItemPositions( cellBi, bs->bsEnd.bpBi ) > 0 )
	    { continue;	}

	if  ( ! bs						||
	      ( ( bs->bsCol0 < 0 || col >= bs->bsCol0 )	&&
		( bs->bsCol1 < 0 || col <= bs->bsCol1 )	)	)
	    {
	    for ( para= 0; para < cellBi->biChildCount; para++ )
		{
		BufferItem *	paraBi= cellBi->biChildren[para];

		if  ( bs && docCompareItemPositions( paraBi,
						    bs->bsBegin.bpBi ) < 0 )
		    { continue;	}

		if  ( bs && docCompareItemPositions( paraBi,
						    bs->bsEnd.bpBi ) > 0 )
		    { continue;	}

		if  ( docPlainSaveParaItem( sos, paraBi, bs, pwc ) )
		    { LLDEB(col,para); return -1;	}
		}
	    }
	}

    return 0;
    }

static int docPlainSaveItem(	SimpleOutputStream *	sos,
				const BufferItem *	bi,
				const BufferSelection *	bs,
				PlainWritingContext *	pwc )
    {
    int		i;

    if  ( bs )
	{
	if  ( docCompareItemPositions( bi, bs->bsBegin.bpBi ) < 0	)
	    { return 0;	}

	if  ( docCompareItemPositions( bi, bs->bsEnd.bpBi ) > 0	)
	    { return 0;	}
	}

    switch( bi->biLevel )
	{
	case DOClevDOC:
	case DOClevSECT:
	case DOClevCELL:
	rowAsGroup:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docPlainSaveItem( sos, bi->biChildren[i],
								bs, pwc ) )
		    { LDEB(i); return -1;	}
		}
	    break;
	case DOClevROW:
	    if  ( ! bi->biRowHasTableParagraphs )
		{ goto rowAsGroup;	}

	    if  ( docPlainSaveRowItem( sos, bi, bs, pwc ) )
		{ LDEB(1); return -1;	}
	    break;
	case DOClevPARA:
	    if  ( docPlainSaveParaItem( sos, bi, bs, pwc ) )
		{ LDEB(1); return -1;	}

	    break;
	default:
	    LDEB(bi->biLevel); return -1;
	}

    return 0;
    }


int docPlainSaveDocument(	SimpleOutputStream *	sos,
				BufferDocument *	bd,
				const SelectionScope *	ss,
				const BufferSelection *	bs,
				int			fold,
				int			closed )
    {
    const BufferItem *		bi= &bd->bdItem;

    PlainWritingContext		pwc;

    docInitPlainWritingContext( &pwc );

    pwc.pwcFold= fold;
    pwc.pwcEndClosed= closed;

    if  ( bs )
	{
	const int	nearest= 1;

	bi= docGetSelectionRoot( bd, nearest, ss, bs );
	if  ( ! bi )
	    { XDEB(bi); return -1;	}
	}

    if  ( docPlainSaveItem( sos, bi, bs, &pwc ) )
	{ LDEB(bi->biLevel); return -1; }

    return 0;
    }
