/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Manage inserted objects.						*/
/*									*/
/************************************************************************/

void docCleanObjectData(	ObjectData *	od )
    {
    if  ( od->odBytes )
	{ free( od->odBytes );	}
    }

void docInitObjectData(	ObjectData *	od )
    {
    od->odBytes= (unsigned char *)0;
    od->odSize= 0;
    }

void docCleanObject(	InsertedObject *	io )
    {
    docCleanObjectData( &io->ioObjectData );
    docCleanObjectData( &io->ioResultData );

    if  ( io->ioObjectName )
	{ free( io->ioObjectName );	}
    if  ( io->ioObjectClass )
	{ free( io->ioObjectClass );	}
    
    return;
    }

static void docInitObject(	InsertedObject *	io )
    {
    io->ioKind= DOCokUNKNOWN;
    io->ioResultKind= DOCokUNKNOWN;

    io->ioTwipsWide= 0;
    io->ioTwipsHigh= 0;

    io->ioXExtent= 0;
    io->ioYExtent= 0;

    io->ioPixelsWide= 0;
    io->ioPixelsHigh= 0;
    io->ioScaleX= 100;
    io->ioScaleY= 100;

    io->ioTopCropTwips= 0;
    io->ioBottomCropTwips= 0;
    io->ioLeftCropTwips= 0;
    io->ioRightCropTwips= 0;

    io->ioUnitsPerInch= 0;

    io->ioDragWide= 0;
    io->ioDragHigh= 0;

    docInitObjectData( &io->ioObjectData );
    docInitObjectData( &io->ioResultData );
    
    io->ioObjectName= (unsigned char *)0;
    io->ioObjectClass= (unsigned char *)0;
    io->ioBliptag= 0;

    io->ioPixmap= 0L;
    io->ioPrivate= (void *)0;

    return;
    }

int docSetObjectData(		ObjectData *		od,
				const unsigned char *	bytes,
				int			size )
    {
    unsigned char *	fresh;

    fresh= (unsigned char *)realloc( od->odBytes, size+ 1 );
    if  ( ! fresh )
	{ LXDEB(size,fresh); return -1;	}

    memcpy( fresh, bytes, size );

    od->odBytes= fresh;
    od->odSize= size;
    fresh[od->odSize]= '\0';

    return 0;
    }

int docAddToObjectData(		ObjectData *		od,
				const unsigned char *	bytes,
				int			size )
    {
    unsigned char *	fresh;

    fresh= (unsigned char *)realloc( od->odBytes, od->odSize+ size+ 1 );
    if  ( ! fresh )
	{ LXDEB(size,fresh); return -1;	}

    memcpy( fresh+ od->odSize, bytes, size );

    od->odBytes= fresh;
    od->odSize= od->odSize+ size;
    fresh[od->odSize]= '\0';

    return 0;
    }

int docCopyObjectData(		ObjectData *		odTo,
				const ObjectData *	odFrom )
    {
    if  ( docSetObjectData( odTo, odFrom->odBytes, odFrom->odSize ) )
	{ LDEB(odFrom->odSize); return -1;	}

    return 0;
    }

int docObjectSetData(	InsertedObject *	io,
			const unsigned char *	bytes,
			int			size )
    { return docSetObjectData( &(io->ioObjectData), bytes, size ); }

int docSetResultData(	InsertedObject *	io,
			const unsigned char *	bytes,
			int			size )
    { return docSetObjectData( &(io->ioResultData), bytes, size );	}

int docSetObjectName(	InsertedObject *	io,
			const unsigned char *	name,
			int			len )
    {
    unsigned char *	fresh= (unsigned char *)malloc( len+ 1 );

    if  ( ! fresh )
	{ LXDEB(len,fresh); return -1;	}

    io->ioObjectName= fresh;
    memcpy( fresh, name, len ); fresh[len]= '\0';

    return 0;
    }

int docSetObjectClass(	InsertedObject *	io,
			const unsigned char *	name,
			int			len )
    {
    unsigned char *	fresh= (unsigned char *)malloc( len+ 1 );

    if  ( ! fresh )
	{ LXDEB(len,fresh); return -1;	}

    io->ioObjectClass= fresh;
    memcpy( fresh, name, len ); fresh[len]= '\0';

    return 0;
    }

InsertedObject * docClaimObjectCopy(	BufferItem *		bi,
					int *			pNr,
					const InsertedObject *	ioFrom )
    {
    InsertedObject *	ioTo;
    int			objectNumber;

    ioTo= docClaimObject( &objectNumber, bi );
    if  ( ! ioTo )
	{ XDEB(ioTo); return (InsertedObject *)0;	}

    if  ( ioFrom->ioObjectName						&&
	  docSetObjectName( ioTo, ioFrom->ioObjectName,
			    strlen( (char *)ioFrom->ioObjectName ) )	)
	{ LDEB(1); docCleanObject( ioTo ); return (InsertedObject *)0; }

    if  ( ioFrom->ioObjectClass						&&
	  docSetObjectClass( ioTo, ioFrom->ioObjectClass,
			    strlen( (char *)ioFrom->ioObjectClass ) )	)
	{ LDEB(1); docCleanObject( ioTo ); return (InsertedObject *)0; }

    if  ( docCopyObjectData( &ioTo->ioObjectData, &ioFrom->ioObjectData ) ||
	  docCopyObjectData( &ioTo->ioResultData, &ioFrom->ioResultData ) )
	{
	LDEB(1);
	docCleanObject( ioTo ); docInitObject( ioTo );
	return (InsertedObject *)0;
	}

    ioTo->ioKind= ioFrom->ioKind;
    ioTo->ioResultKind= ioFrom->ioResultKind;
    ioTo->ioTwipsWide= ioFrom->ioTwipsWide;
    ioTo->ioTwipsHigh= ioFrom->ioTwipsHigh;
    ioTo->ioScaleX= ioFrom->ioScaleX;
    ioTo->ioScaleY= ioFrom->ioScaleY;
    ioTo->ioPixelsWide= ioFrom->ioPixelsWide;
    ioTo->ioPixelsHigh= ioFrom->ioPixelsHigh;
    ioTo->ioXExtent= ioFrom->ioXExtent;
    ioTo->ioYExtent= ioFrom->ioYExtent;
    ioTo->ioUnitsPerInch= ioFrom->ioUnitsPerInch;

    ioTo->ioBliptag= ioFrom->ioBliptag; /*?*/

    ioTo->ioDragWide= 0;
    ioTo->ioDragHigh= 0;

    return ioTo;
    }

/************************************************************************/
/*									*/
/*  Do cleanup provoked by the deletion of a particule.			*/
/*									*/
/************************************************************************/
void docCleanParticuleObject(	BufferItem *	bi,
				TextParticule *	tp )
    {
    InsertedObject *	io;

    if  ( tp->tpKind != DOCkindOBJECT	||
	  tp->tpPhysicalFont != 0	)
	{ return;	}

    io= bi->biParaObjects+ tp->tpObjectNumber;

    docCleanObject( io );
    docInitObject( io );

    return;
    }

/************************************************************************/
/*									*/
/*  Management of shapes.						*/
/*									*/
/************************************************************************/

void docCleanShape(	DrawingShape *	ds )
    {
    return;
    }

void docInitShape(	DrawingShape *	ds )
    {
    ds->ds_shapeType= SHPtyFREE;

    return;
    }

DrawingShape * docClaimShape(	int *			pNr,
				BufferItem *		bi )
    {
    int			n;
    DrawingShape *	ds;

    if  ( bi->biLevel != DOClevPARA )
	{ LLDEB(bi->biLevel,DOClevPARA); return (DrawingShape *)0;	}

    ds= (DrawingShape *)realloc( bi->biParaShapes,
			    (bi->biParaShapeCount+ 1)* sizeof(DrawingShape) );
    if  ( ! ds )
	{ XDEB(ds); return (DrawingShape *)0;	}
    bi->biParaShapes= ds;

    for ( n= 0; n < bi->biParaShapeCount; ds++, n++ )
	{
	if  ( ds->ds_shapeType == SHPtyFREE )
	    { break;	}
	}

    docInitShape( ds );

    if  ( n == bi->biParaShapeCount )
	{ bi->biParaShapeCount++;	}

    *pNr= n; return ds;
    }

/************************************************************************/
/*									*/
/*  Insert an object.							*/
/*									*/
/*  NOTE that objects have text attributes. This is for the following	*/
/*  reasons:								*/
/*  *)  The calculation of the descender height below the object.	*/
/*  *)  This makes editing around the object and saving it MUCH easier.	*/
/*									*/
/************************************************************************/

TextParticule *	docInsertObject(	BufferItem *		bi,
					InsertedObject **	pIo,
					int			n,
					int			off,
					TextAttribute		ta )
    {
    TextParticule *	tp;
    InsertedObject *	io;
    int			objectNumber;

    io= docClaimObject( &objectNumber, bi );
    if  ( ! io )
	{ LXDEB(bi->biParaObjectCount+1,io); return (TextParticule *)0; }

    tp= docInsertParticule( bi, n, off, 1, DOCkindOBJECT );
    if  ( ! tp )
	{ return tp;	}

    tp->tpTextAttribute= ta;
    tp->tpObjectNumber= bi->biParaObjectCount++;

    *pIo= io;

    return tp;
    }

InsertedObject *	docClaimObject(	int *			pNr,
					BufferItem *		bi )
    {
    InsertedObject *	io;

    io= (InsertedObject *)realloc( bi->biParaObjects,
		    ( bi->biParaObjectCount+ 1 )* sizeof( InsertedObject ) );
    if  ( ! io )
	{ LXDEB(bi->biParaObjectCount+1,io); return io; }

    bi->biParaObjects= io;
    io += bi->biParaObjectCount;

    docInitObject( io );

    *pNr= bi->biParaObjectCount; return io;
    }

/************************************************************************/
/*									*/
/*  Copy particule data from one paragraph to another.			*/
/*									*/
/*  9)  Not needed, the document is marked as changed, so this can wait	*/
/*	until it is saved.						*/
/*									*/
/************************************************************************/

int docCopyParticuleData(	BufferDocument *	bdTo,
				const BufferDocument *	bdFrom,
				int *			fieldMap,
				unsigned int *		pFieldUpd,
				BufferItem *		biTo,
				const BufferItem *	biFrom,
				TextParticule *		tpTo,
				const TextParticule *	tpFrom )
    {
    int				nr;
    const DocumentFieldList *	dflFrom= &(bdFrom->bdFieldList);

    switch( tpFrom->tpKind )
	{
	case DOCkindTEXT:
	case DOCkindTAB:
	case DOCkindLINEBREAK:
	case DOCkindPAGEBREAK:
	    break;
	case DOCkindOBJECT:
	    {
	    InsertedObject *	io;

	    io= docClaimObjectCopy( biTo, &nr,
			biFrom->biParaObjects+ tpFrom->tpObjectNumber );
	    if  ( ! io )
		{ XDEB(io); return -1;	}

	    tpTo->tpObjectNumber= biTo->biParaObjectCount++;

	    /*  9
	    if  ( io->ioBliptag == 0 )
		{ io->ioBliptag= appGetTimestamp();	}
	    */
	    }
	    break;

	case DOCkindFIELDEND:
	    if  ( tpFrom->tpObjectNumber < 0				||
		  tpFrom->tpObjectNumber >= dflFrom->dflFieldCount	||
		  fieldMap[tpFrom->tpObjectNumber] < 0			)
		{
		LDEB(tpFrom->tpObjectNumber);
		tpTo->tpObjectNumber= -1;
		}
	    else{ tpTo->tpObjectNumber= fieldMap[tpFrom->tpObjectNumber]; }
	    break;

	case DOCkindFIELDSTART:
	case DOCkindXE:
	case DOCkindTC:
	    {
	    const DocumentField *		dfFrom;
	    DocumentField *			dfTo;
	    const FieldKindInformation *	fki;

	    dfFrom= dflFrom->dflFields+ tpFrom->tpObjectNumber;
	    fki= DOC_FieldKinds+ dfFrom->dfKind;

	    dfTo= docClaimFieldCopy( &(bdTo->bdFieldList), &nr, dfFrom );
	    if  ( ! dfTo )
		{ XDEB(dfTo); return -1;	}

	    tpTo->tpObjectNumber= nr;

	    if  ( tpFrom->tpObjectNumber < 0				||
		  tpFrom->tpObjectNumber >= dflFrom->dflFieldCount	)
		{ LDEB(tpFrom->tpObjectNumber); }
	    else{ fieldMap[tpFrom->tpObjectNumber]= nr;		}

	    *pFieldUpd |= fki->fkiCalculateWhen;
	    }

	    break;

	default:
	    LDEB(tpFrom->tpKind); return -1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Allocate a mapping for field numbers.				*/
/*									*/
/************************************************************************/

int *	docAllocateFieldMap(	const BufferDocument *	bdFrom )
    {
    int *	fieldMap;
    int		i;

    fieldMap= malloc( bdFrom->bdFieldList.dflFieldCount* sizeof(int)+ 1 );
    if  ( ! fieldMap )
	{ LXDEB(bdFrom->bdFieldList.dflFieldCount,fieldMap); return (int *)0; }
    for ( i= 0; i < bdFrom->bdFieldList.dflFieldCount; i++ )
	{ fieldMap[i]= -1;	}

    return fieldMap;
    }
