/************************************************************************/
/*									*/
/*  Find utility routines.						*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docFind.h"

#   include	<reg.h>
#   include	<charnames.h>

/************************************************************************/
/*									*/
/*  Find the first occurrence of a regular expression in a paragraph.	*/
/*									*/
/************************************************************************/
static int docFindParaFindNext(	BufferItem *		bi,
				int			stroff,
				int			part,
				int *			pStart,
				int *			pLength,
				regProg *		prog )
    {
    int		res;

    if  (  bi->biParaStrlen == 0 )
	{ return 1;	}

    res= regFindLeftToRight( prog, bi->biParaString+ stroff );

    if  ( ! res )
	{ return 1;	}

    *pStart= prog->rpStartp[0]- bi->biParaString;
    *pLength= prog->rpEndp[0]- prog->rpStartp[0];

    return 0;
    }

static int docFindParaFindPrev(	BufferItem *		bi,
				int			stroff,
				int			part,
				int *			pStart,
				int *			pLength,
				regProg *		prog )
    {
    int		res;

    if  (  bi->biParaStrlen == 0 )
	{ return 1;	}

    res= regFindRightToLeft( prog, bi->biParaString, stroff );

    if  ( ! res )
	{ return 1;	}

    *pStart= prog->rpStartp[0]- bi->biParaString;
    *pLength= prog->rpEndp[0]- prog->rpStartp[0];

    return 0;
    }

int docFindFindNext(	BufferPosition *	bpFrom,
			BufferSelection *	bs,
			regProg *		prog )
    {
    BufferItem *		bi= bpFrom->bpBi;
    int				stroff= bpFrom->bpStroff;
    int				part= bpFrom->bpParticule;

    int				ret;
    int				start;
    int				length;

    if  ( bi->biLevel != DOClevPARA )
	{ LLDEB(bi->biLevel,DOClevPARA); return -1;	}

    for (;;)
	{
	ret= docFindParaFindNext( bi, stroff, part, &start, &length, prog );

	if  ( ret == 0 )
	    {
	    docSetParaSelection( bs, bi, 1, start, length );

	    return ret;
	    }

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { return 1;	}

	stroff= 0; part= 0;
	}
    }

int docFindFindPrev(	BufferPosition *	bpFrom,
			BufferSelection *	bs,
			regProg *		prog )
    {
    BufferItem *		bi= bpFrom->bpBi;
    int				stroff= bpFrom->bpStroff;
    int				part= bpFrom->bpParticule;

    int				ret;
    int				start;
    int				length;

    if  ( bi->biLevel != DOClevPARA )
	{ LLDEB(bi->biLevel,DOClevPARA); return -1;	}

    for (;;)
	{
	if  ( stroff > 0 )
	    {
	    ret= docFindParaFindPrev( bi, stroff- 1,
					    part, &start, &length, prog );

	    if  ( ret == 0 )
		{
		docSetParaSelection( bs, bi, -1, start, length );

		return ret;
		}
	    }

	bi= docPrevParagraph( bi );
	if  ( ! bi )
	    { return 1;	}

	stroff= bi->biParaStrlen- 1; part= bi->biParaParticuleCount- 1;
	}
    }


/************************************************************************/
/*									*/
/*  Find a particular bookmark in a document.				*/
/*									*/
/************************************************************************/

int docFindBookmarkInDocument(	SelectionScope *	ss,
				BufferSelection *	bs,
				BufferDocument *	bd,
				const char *		markName,
				int			markSize )
    {
    SelectionScope	ssNew;
    BufferSelection	bsNew;
    BufferPosition	bp;
    BufferItem *	bi;

    int			foundBegin= 0;
    int			foundEnd= 0;

    int			beginObjectNumber= -1;

    docInitSelectionScope( &ssNew );
    docInitSelection( &bsNew );

    if  ( docFirstPosition( &(bd->bdItem), &bp ) )
	{ return 1;	}

    bi= bp.bpBi;
    while( bi )
	{
	int		part;
	TextParticule *	tp;

	tp= bi->biParaParticules;
	for ( part= 0; part < bi->biParaParticuleCount; tp++, part++ )
	    {
	    DocumentField *	df;
	    const char *	foundName;
	    int			foundSize;


	    if  ( tp->tpKind == DOCkindFIELDSTART )
		{
		df= bd->bdFieldList.dflFields+ tp->tpObjectNumber;

		if  ( df->dfKind == DOCfkBOOKMARK			&&
		      ! docFieldGetBookmark( df,
					&foundName, &foundSize )	&&
		      foundSize == markSize				&&
		      ! memcmp( foundName, markName, markSize )		)
		    {
		    foundBegin= 1;
		    beginObjectNumber= tp->tpObjectNumber;
		    bsNew.bsBegin.bpBi= bi;
		    bsNew.bsBegin.bpStroff= tp->tpStroff;
		    }
		}

	    if  ( tp->tpKind == DOCkindFIELDEND				&&
		  tp->tpObjectNumber == beginObjectNumber		)
		{
		foundEnd= 1;
		bsNew.bsEnd.bpBi= bi;
		bsNew.bsEnd.bpStroff= tp->tpStroff;
		}
	    }

	bi= docNextParagraph( bi );
	}

    if  ( ! foundBegin || ! foundEnd )
	{ return 1;	}

    *ss= ssNew; *bs= bsNew; return 0;
    }
