/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Manage fields.							*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  Make a copy of a field.						*/
/*									*/
/************************************************************************/

DocumentField *	docClaimFieldCopy(	DocumentFieldList *	dfl,
					int *			pNr,
					const DocumentField *	dfFrom )
    {
    DocumentField *	dfTo;
    int			fieldNumber;

    dfTo= docClaimField( &fieldNumber, dfl );
    if  ( ! dfTo )
	{ XDEB(dfTo); return (DocumentField *)0;	}

    dfTo->dfKind= dfFrom->dfKind;

    if  ( docCopyObjectData( &dfTo->dfData, &dfFrom->dfData ) 		||
	  docCopyObjectData( &dfTo->dfInstructions, &dfFrom->dfInstructions ) )
	{
	LDEB(1);
	docCleanField( (BufferDocument *)0, dfTo );
	docInitField( dfTo );
	return (DocumentField *)0;
	}

    *pNr= fieldNumber; return dfTo;
    }

/************************************************************************/
/*									*/
/*  Management of links.						*/
/*									*/
/************************************************************************/

void docCleanField(	BufferDocument *	bd,
			DocumentField *		df )
    {
    docCleanObjectData( &df->dfData );
    docCleanObjectData( &df->dfInstructions );

    if  ( df->dfReferencedItem )
	{ docFreeItem( bd, df->dfReferencedItem );	}

    return;
    }

void docInitField(	DocumentField *	df )
    {
    docInitObjectData( &df->dfData );
    docInitObjectData( &df->dfInstructions );

    df->dfPage= -1;
    df->dfKind= DOCfkFREE;

    df->dfReferencedItem= (BufferItem *)0;

    return;
    }

int docSetFieldInst(	DocumentField *		df,
			const unsigned char *	bytes,
			int			size )
    { return docSetObjectData( &(df->dfInstructions), bytes, size ); }

int docAddToFieldInst(	DocumentField *		df,
			const unsigned char *	bytes,
			int			size )
    { return docAddToObjectData( &df->dfInstructions, bytes, size ); }

DocumentField * docClaimField(	int *			pNr,
				DocumentFieldList *	dfl )
    {
    int			n;
    DocumentField *	df;

    df= (DocumentField *)realloc( dfl->dflFields,
			    (dfl->dflFieldCount+ 1)* sizeof(DocumentField) );
    if  ( ! df )
	{ XDEB(df); return (DocumentField *)0;	}
    dfl->dflFields= df;

    for ( n= 0; n < dfl->dflFieldCount; df++, n++ )
	{
	if  ( df->dfKind == DOCfkFREE )
	    { break;	}
	}

    docInitField( df );

    if  ( n == dfl->dflFieldCount )
	{ dfl->dflFieldCount++;	}

    *pNr= n; return df;
    }

void docInitFieldList(	DocumentFieldList *	dfl )
    {
    dfl->dflFields= (DocumentField *)0;
    dfl->dflFieldCount= 0;

    return;
    }

void docCleanFieldList(	BufferDocument *	bd,
			DocumentFieldList *	dfl )
    {
    int			i;
    DocumentField *	df;

    df= dfl->dflFields;
    for ( i= 0; i < dfl->dflFieldCount; df++, i++ )
	{
	if  ( df->dfKind == DOCfkFREE )
	    { continue;	}

	docCleanField( bd, df );
	}

    if  ( dfl->dflFields )
	{ free( dfl->dflFields );	}

    return;
    }

/************************************************************************/
/*									*/
/*  Split field instructions in a vector of arguments.			*/
/*									*/
/************************************************************************/

int docSplitFieldInstructions(	const ObjectData *		od,
				FieldInstructionsComponent *	fic,
				int				maxComponent )
    {
    unsigned char *	bytes= od->odBytes;

    int			offset= 0;
    int			n= 0;

    for (;;)
	{
	int		size= 0;

	while( offset < od->odSize && *bytes == ' ' )
	    { offset++; bytes++;	}

	if  ( offset >= od->odSize )
	    { break;	}

	if  ( n >= maxComponent )
	    { LLDEB(n,maxComponent); return 0;	}

	if  ( bytes[0] == '"' )
	    {
	    offset++; bytes++;

	    fic->ficOffset= offset;
	    while( offset < od->odSize && *bytes != '"' )
		{ size++; offset++; bytes++;	}

	    if  ( offset >= od->odSize )
		{ SDEB((char *)od->odBytes); return 0;	}

	    offset++; bytes++;
	    }
	else{
	    fic->ficOffset= offset;
	    while( offset < od->odSize && *bytes != ' ' )
		{ size++; offset++; bytes++;	}
	    }

	fic->ficSize= size;
	n++; fic++;
	}

    return n;
    }

/************************************************************************/
/*									*/
/*  Bring a bookmark in a generally accepted format.			*/
/*									*/
/************************************************************************/

void docAdaptBookmarkName(	int *		pLength,
				char *		markName )
    {
    int		len= 0;

    while( *markName )
	{
	if  ( len >= DOCmaxBOOKMARK )
	    { *markName= '\0'; break;	}

	if  ( ! isalnum( *markName ) )
	    { *markName= '_';	}

	len++; markName++;
	}

    *pLength= len; return;
    }

