#   ifndef	DOC_DRAW_H
#   define	DOC_DRAW_H

#   include	"docBuf.h"
#   include	<appDraw.h>

/************************************************************************/
/*									*/
/*  The different resources needed for drawing.				*/
/*									*/
/************************************************************************/

typedef struct DrawingContext
    {
    int				dcCurrentPhysicalFont;

    AppDrawingData *		dcDrawingData;
    BufferDocument *		dcDocument;
    const DocumentRectangle *	dcClipRect;
    const BufferSelection *	dcSelection;
    int				dcFirstPage;
    int				dcLastPage;
    int				dcDrawHeadersFooters;

    int				dcDrawTableGrid;

    int				(*dcDrawTextLine)(
				    const BufferItem *		bi,
				    int				line,
				    const FormattingFrame *	ffTwips,
				    const FormattingFrame *	ffPixels,
				    void *			through,
				    struct DrawingContext *	dc );

    int				(*dcDrawParaTop)(
				    const BufferItem *		bi,
				    const BorderProperties *	bp,
				    const FormattingFrame *	ffTwips,
				    const FormattingFrame *	ffPixels,
				    void *			through,
				    struct DrawingContext *	dc );

    int				(*dcDrawParaBottom)(
				    const BufferItem *		bi,
				    const BorderProperties *	bp,
				    const FormattingFrame *	ffTwips,
				    const FormattingFrame *	ffPixels,
				    void *			through,
				    struct DrawingContext *	dc );

    int 			(*dcDrawCellTop)(
				    const BorderProperties *	bp,
				    int				asGrid,
				    int				x0Twips,
				    int				x0Pixels,
				    int				x1Twips,
				    int				x1Pixels,
				    void *			through,
				    struct DrawingContext *	dc,
				    const LayoutPosition *	lpTop );

    int 			(*dcDrawCellBottom)(
				    const BorderProperties *	bp,
				    int				asGrid,
				    int				x0Twips,
				    int				x0Pixels,
				    int				x1Twips,
				    int				x1Pixels,
				    void *			through,
				    struct DrawingContext *	dc,
				    const LayoutPosition *	lpBottom );

    int				(*dcDrawCellLeft)(
				    const BorderProperties *	bp,
				    int				asGrid,
				    void *			through,
				    struct DrawingContext *	dc,
				    int				x0Twips,
				    int				x0Pixels,
				    const LayoutPosition *	lpTop,
				    const LayoutPosition *	lpBelow );

    int				(*dcDrawCellRight)(
				    const BorderProperties *	bp,
				    int				asGrid,
				    void *			through,
				    struct DrawingContext *	dc,
				    int				x1Twips,
				    int				x1Pixels,
				    const LayoutPosition *	lpTop,
				    const LayoutPosition *	lpBelow );

    int				(*dcFinishPage)(
				    void *			through,
				    struct DrawingContext *	dc,
				    int				page,
				    int				asLast );

    int				(*dcStartPage)(
				    void *			through,
				    const DocumentGeometry *	dg,
				    struct DrawingContext *	dc,
				    int				page );

    void			(*dcParaSidesPixels)(
				    FormattingFrame *		ffPixels,
				    const AppDrawingData *	add,
				    const BufferItem *		bi );

    int 			(*dcLayoutHeader)(
				    BufferItem *		bi,
				    int				page,
				    int				inHeaderFooter,
				    const SectionProperties *	sp,
				    const BufferDocument *	bd,
				    AppDrawingData *		add,
				    DocumentRectangle *		drChanged );

    int 			(*dcLayoutFooter)(
				    BufferItem *		bi,
				    int				page,
				    int				inHeaderFooter,
				    const SectionProperties *	sp,
				    const BufferDocument *	bd,
				    AppDrawingData *		add,
				    DocumentRectangle *		drChanged );

    } DrawingContext;

typedef int (*DRAW_TEXT_LINE)(	const BufferItem *		bi,
				int				line,
				const FormattingFrame *		ffTwips,
				const FormattingFrame *		ffPixels,
				void *				through,
				struct DrawingContext *		dc );

typedef int (*DRAW_PARA_TOP)(	const BufferItem *		bi,
				const BorderProperties *	bp,
				const FormattingFrame *		ffTwips,
				const FormattingFrame *		ffPixels,
				void *				through,
				DrawingContext *		dc );

typedef int (*DRAW_PARA_BOTTOM)( const BufferItem *		bi,
				const BorderProperties *	bp,
				const FormattingFrame *		ffTwips,
				const FormattingFrame *		ffPixels,
				void *				through,
				DrawingContext *		dc );

typedef int (*DRAW_CELL_TOP)(	const BorderProperties *	bp,
				int				asGrid,
				int				x0Twips,
				int				x0Pixels,
				int				x1Twips,
				int				x1Pixels,
				void *				through,
				DrawingContext *		dc,
				const LayoutPosition *		lpTop );

typedef int (*DRAW_CELL_BOTTOM)( const BorderProperties *	bp,
				int				asGrid,
				int				x0Twips,
				int				x0Pixels,
				int				x1Twips,
				int				x1Pixels,
				void *				through,
				DrawingContext *		dc,
				const LayoutPosition *		lpBottom );

typedef int (*DRAW_CELL_LEFT)(	const BorderProperties *	bp,
				int				asGrid,
				void *				through,
				DrawingContext *		dc,
				int				x0Twips,
				int				x0Pixels,
				const LayoutPosition *		lpTop,
				const LayoutPosition *		lpBelow );

typedef int (*DRAW_CELL_RIGHT)(	const BorderProperties *	bp,
				int				asGrid,
				void *				through,
				DrawingContext *		dc,
				int				x1Twips,
				int				x1Pixels,
				const LayoutPosition *		lpTop,
				const LayoutPosition *		lpBelow );

typedef int (*FINISH_PAGE)(	void *				through,
				DrawingContext *		dc,
				int				page,
				int				asLast );

typedef int (*START_PAGE)(	void *				through,
				const DocumentGeometry *	dg,
				DrawingContext *		dc,
				int				page );

typedef void (*PARA_SIDES_PIXELS)( FormattingFrame *	ff,
				const AppDrawingData *	add,
				const BufferItem *	bi );

typedef int (*LAYOUT_EXTERNAL)(	BufferItem *			bi,
				int				page,
				int				inHeaderFooter,
				const SectionProperties *	sp,
				const BufferDocument *		bd,
				AppDrawingData *		add,
				DocumentRectangle *		drChanged );

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitDrawingContext(	DrawingContext *	dc );

extern int docDrawItem(	BufferItem *			bi,
			void *				through,
			DrawingContext *		dc );

extern int docDrawPageHeader(	BufferItem *			sectBi,
				void *				through,
				DrawingContext *		dc,
				int				page );

extern int docDrawPageFooter(	BufferItem *			sectBi,
				void *				through,
				DrawingContext *		dc,
				int				page );

#   endif
