#   include <appUtilConfig.h>

#   include <utilJenkinsHash.h>

#   include "docRtf.h"

#   define ub4 UtilUint32
#   define ub2 UtilUint16
#   define ub1 unsigned char

#   define CHECKSTATE 8

/* smax= 1024, blen= 256 */

/* small adjustments to _a_ to make values distinct */
static const ub2 tab[] = {
188,674,331,192,674,0,0,331,192,515,295,311,253,334,334,0,
165,674,331,0,0,0,331,331,165,0,331,0,381,165,674,98,
670,677,77,0,0,331,0,170,0,409,24,311,334,677,340,98,
409,373,370,742,581,238,529,50,340,331,549,331,496,311,165,723,
127,331,58,14,258,331,0,331,0,529,515,331,549,0,370,484,
549,381,258,370,258,674,618,0,253,14,742,253,295,180,0,253,
50,258,0,14,331,165,258,0,331,409,340,0,159,14,0,165,
409,674,0,515,116,529,253,0,0,14,118,670,677,0,165,549,
0,516,165,77,670,358,58,348,709,502,14,432,0,118,0,258,
63,42,295,409,340,381,248,574,334,515,165,358,163,331,0,515,
487,0,485,370,386,15,204,258,0,0,0,77,0,670,701,0,
549,0,358,165,311,742,287,345,358,15,118,641,77,311,340,515,
128,50,381,14,741,258,311,288,334,571,258,674,169,74,98,50,
258,123,331,635,581,471,340,548,433,128,192,739,742,311,741,0,
485,170,0,669,334,515,0,608,381,258,116,381,165,608,14,533,
137,188,527,369,285,670,165,0,331,0,203,381,50,381,0,14,
};

/* map back array */

static int mapBack[]=
    {
     359L,	/*     0: "margtsxn" */
     234L,	/*     1: "trowd" */
      87L,	/*     2: "keep" */
     209L,	/*     3: "clcbpat" */
     338L,	/*     4: "nospaceforul" */
     470L,	/*     5: "formshade" */
     224L,	/*     6: "clwWidth" */
     103L,	/*     7: "bgdkhoriz" */
     370L,	/*     8: "pgndec" */
      97L,	/*     9: "bgcross" */
     143L,	/*    10: "posyb" */
     187L,	/*    11: "dbch" */
     577L,	/*    12: "pngblip" */
     414L,	/*    13: "ftntj" */
     568L,	/*    14: "fscript" */
     582L,	/*    15: "pmmetafile" */
     424L,	/*    16: "ftnrstpg" */
     296L,	/*    17: "pgbrdrsnap" */
      20L,	/*    18: "pnscaps" */
     372L,	/*    19: "pgnlcrm" */
     375L,	/*    20: "pgncont" */
     539L,	/*    21: "leveltemplateid" */
     104L,	/*    22: "bgdkvert" */
      39L,	/*    23: "revised" */
     524L,	/*    24: "charrsid" */
     475L,	/*    25: "hyphhotz" */
     261L,	/*    26: "trpaddl" */
      44L,	/*    27: "ulw" */
     545L,	/*    28: "listid" */
     282L,	/*    29: "trbgfdiag" */
     267L,	/*    30: "trpaddft" */
     472L,	/*    31: "hyphauto" */
     133L,	/*    32: "posxr" */
     437L,	/*    33: "aftnnrlc" */
     537L,	/*    34: "levelpicture" */
     367L,	/*    35: "sbkpage" */
       9L,	/*    36: "nosupersub" */
     596L,	/*    37: "objcropr" */
     550L,	/*    38: "liststyleid" */
       3L,	/*    39: "cf" */
      42L,	/*    40: "uld" */
      94L,	/*    41: "hyphpar" */
     436L,	/*    42: "aftnnauc" */
     488L,	/*    43: "psover" */
     171L,	/*    44: "af" */
     583L,	/*    45: "objw" */
     602L,	/*    46: "wbmbitspixel" */
     395L,	/*    47: "vertalj" */
     182L,	/*    48: "aulnone" */
     216L,	/*    49: "cltxbtlr" */
     456L,	/*    50: "langnp" */
      64L,	/*    51: "chbrdr" */
     530L,	/*    52: "levelnfcn" */
     304L,	/*    53: "widowctrl" */
     528L,	/*    54: "styrsid" */
     417L,	/*    55: "aenddoc" */
     259L,	/*    56: "trspdft" */
     572L,	/*    57: "cpg" */
     294L,	/*    58: "brdrart" */
     519L,	/*    59: "mo" */
      45L,	/*    60: "v" */
     346L,	/*    61: "pnordt" */
      48L,	/*    62: "expnd" */
     265L,	/*    63: "trpaddfl" */
     591L,	/*    64: "picw" */
     560L,	/*    65: "tlhyph" */
      74L,	/*    66: "pard" */
     487L,	/*    67: "printdata" */
     603L,	/*    68: "wbmplanes" */
     225L,	/*    69: "clftsWidth" */
     590L,	/*    70: "picscaley" */
     341L,	/*    71: "pnucltr" */
      46L,	/*    72: "webhidden" */
     465L,	/*    73: "deflang" */
      67L,	/*    74: "chshdng" */
     240L,	/*    75: "trkeepfollow" */
     351L,	/*    76: "pnuldb" */
     543L,	/*    77: "levelindent" */
     479L,	/*    78: "ltrdoc" */
     400L,	/*    79: "binsxn" */
     592L,	/*    80: "pich" */
     403L,	/*    81: "linemod" */
      96L,	/*    82: "bgbdiag" */
     161L,	/*    83: "pnrstart" */
     193L,	/*    84: "clbrdrb" */
     467L,	/*    85: "fldalt" */
     310L,	/*    86: "dgvspace" */
     167L,	/*    87: "acaps" */
     201L,	/*    88: "clbgdkdcross" */
     379L,	/*    89: "colsx" */
     485L,	/*    90: "otblrul" */
     419L,	/*    91: "aftnbj" */
     248L,	/*    92: "trbrdrr" */
     215L,	/*    93: "cltxtbrl" */
     546L,	/*    94: "listtemplateid" */
      59L,	/*    95: "chbgdkvert" */
     317L,	/*    96: "deff" */
     262L,	/*    97: "trpaddr" */
      12L,	/*    98: "strike" */
     416L,	/*    99: "aendnotes" */
     561L,	/*   100: "tlth" */
      79L,	/*   101: "ri" */
     172L,	/*   102: "afs" */
     432L,	/*   103: "ftnnruc" */
     109L,	/*   104: "cbpat" */
     156L,	/*   105: "pnrdate" */
      71L,	/*   106: "faroman" */
     144L,	/*   107: "posyc" */
     315L,	/*   108: "dgmargin" */
      83L,	/*   109: "qc" */
     166L,	/*   110: "ab" */
      19L,	/*   111: "pncaps" */
     464L,	/*   112: "defformat" */
     377L,	/*   113: "pgnstarts" */
     494L,	/*   114: "sprslnsp" */
     445L,	/*   115: "sautoupd" */
      25L,	/*   116: "up" */
     452L,	/*   117: "ansicpg" */
     334L,	/*   118: "noxlattoyen" */
     540L,	/*   119: "levelold" */
     218L,	/*   120: "cltxtbrlv" */
     180L,	/*   121: "auld" */
     393L,	/*   122: "vertalb" */
     406L,	/*   123: "linestarts" */
     402L,	/*   124: "linecont" */
     136L,	/*   125: "posxo" */
     466L,	/*   126: "doctemp" */
     192L,	/*   127: "clbrdrt" */
     307L,	/*   128: "jexpand" */
     284L,	/*   129: "trbgvert" */
      99L,	/*   130: "bgdkbdiag" */
     423L,	/*   131: "ftnrestart" */
     230L,	/*   132: "clpadft" */
     410L,	/*   133: "sectunlocked" */
     121L,	/*   134: "saauto" */
       2L,	/*   135: "fs" */
      38L,	/*   136: "revdttmdel" */
     376L,	/*   137: "pgnrestart" */
     322L,	/*   138: "msmcap" */
     336L,	/*   139: "noultrlspc" */
     553L,	/*   140: "listoverrideformat" */
     595L,	/*   141: "objcropl" */
     469L,	/*   142: "formprot" */
     132L,	/*   143: "posxl" */
     460L,	/*   144: "allprot" */
     149L,	/*   145: "dxfrtext" */
     522L,	/*   146: "rsidroot" */
     450L,	/*   147: "pc" */
     562L,	/*   148: "tleq" */
     105L,	/*   149: "bgfdiag" */
     158L,	/*   150: "pnrnfc" */
     404L,	/*   151: "lineppage" */
     274L,	/*   152: "trbgcross" */
     409L,	/*   153: "rtlsect" */
      37L,	/*   154: "revdttm" */
     275L,	/*   155: "trbgdcross" */
     125L,	/*   156: "absw" */
     131L,	/*   157: "posnegx" */
     134L,	/*   158: "posxc" */
     185L,	/*   159: "loch" */
     439L,	/*   160: "aftnnchi" */
     502L,	/*   161: "viewzk" */
     598L,	/*   162: "piccropb" */
     514L,	/*   163: "subdocument" */
     363L,	/*   164: "ds" */
     368L,	/*   165: "sbkeven" */
     169L,	/*   166: "adn" */
      55L,	/*   167: "chbgbdiag" */
     111L,	/*   168: "brdrb" */
     204L,	/*   169: "clbgdkvert" */
     380L,	/*   170: "colw" */
     585L,	/*   171: "picwgoal" */
     313L,	/*   172: "dghshow" */
     504L,	/*   173: "viewscale" */
     508L,	/*   174: "uc" */
     297L,	/*   175: "margl" */
     448L,	/*   176: "ansi" */
     371L,	/*   177: "pgnucrm" */
      91L,	/*   178: "sl" */
     189L,	/*   179: "rtlrow" */
      78L,	/*   180: "fi" */
     478L,	/*   181: "linkstyles" */
     236L,	/*   182: "trleft" */
     573L,	/*   183: "fprq" */
     567L,	/*   184: "fmodern" */
     181L,	/*   185: "auldb" */
     116L,	/*   186: "brdrbar" */
      62L,	/*   187: "chbgdkcross" */
     499L,	/*   188: "transmf" */
     278L,	/*   189: "trbgdkdcross" */
     411L,	/*   190: "fet" */
     107L,	/*   191: "bgvert" */
     386L,	/*   192: "pgnhnsm" */
     115L,	/*   193: "brdrbtw" */
     318L,	/*   194: "facingp" */
     200L,	/*   195: "clbgdkcross" */
     177L,	/*   196: "ashad" */
     333L,	/*   197: "sprstsm" */
      22L,	/*   198: "lang" */
     575L,	/*   199: "macpict" */
     412L,	/*   200: "endnotes" */
     302L,	/*   201: "paperw" */
     113L,	/*   202: "brdrr" */
     405L,	/*   203: "linerestart" */
     308L,	/*   204: "horzdoc" */
     565L,	/*   205: "froman" */
      47L,	/*   206: "kerning" */
      36L,	/*   207: "revauthdel" */
     457L,	/*   208: "langfe" */
     220L,	/*   209: "clmrg" */
     609L,	/*   210: "objsetsize" */
     366L,	/*   211: "sbkcol" */
     174L,	/*   212: "alang" */
     231L,	/*   213: "clpadfb" */
     544L,	/*   214: "levelspace" */
     589L,	/*   215: "picscalex" */
      72L,	/*   216: "favar" */
     129L,	/*   217: "phcol" */
     453L,	/*   218: "itap" */
     552L,	/*   219: "listoverridestartat" */
     345L,	/*   220: "pnord" */
      63L,	/*   221: "chbgdkdcross" */
      31L,	/*   222: "ltrch" */
      81L,	/*   223: "qr" */
     482L,	/*   224: "nocolbal" */
     151L,	/*   225: "dfrmtxty" */
      18L,	/*   226: "pnul" */
     517L,	/*   227: "sec" */
      43L,	/*   228: "uldb" */
     197L,	/*   229: "clbgcross" */
       7L,	/*   230: "sub" */
     326L,	/*   231: "useltbaln" */
     579L,	/*   232: "emfblip" */
      75L,	/*   233: "s" */
       8L,	/*   234: "super" */
     325L,	/*   235: "htmautsp" */
     492L,	/*   236: "revprot" */
     233L,	/*   237: "clpadfr" */
     268L,	/*   238: "trpaddfb" */
     221L,	/*   239: "clvmgf" */
      11L,	/*   240: "scaps" */
     316L,	/*   241: "pgnstart" */
     518L,	/*   242: "dy" */
     455L,	/*   243: "rin" */
     301L,	/*   244: "paperh" */
      98L,	/*   245: "bgdcross" */
      53L,	/*   246: "chbgvert" */
     148L,	/*   247: "overlay" */
     246L,	/*   248: "trbrdrb" */
     495L,	/*   249: "sprsspbf" */
     269L,	/*   250: "trwWidthB" */
      90L,	/*   251: "sa" */
     389L,	/*   252: "pgny" */
     407L,	/*   253: "lndscpsxn" */
     383L,	/*   254: "pgnhnsh" */
     206L,	/*   255: "clbghoriz" */
     210L,	/*   256: "clshdng" */
     355L,	/*   257: "footery" */
     415L,	/*   258: "ftnbj" */
     214L,	/*   259: "cltxlrtb" */
     194L,	/*   260: "clbrdrl" */
     314L,	/*   261: "dgvshow" */
     578L,	/*   262: "jpegblip" */
     357L,	/*   263: "pghsxn" */
       6L,	/*   264: "ul" */
     473L,	/*   265: "hyphcaps" */
      95L,	/*   266: "shading" */
     426L,	/*   267: "aftnrestart" */
     394L,	/*   268: "vertalc" */
     438L,	/*   269: "aftnnruc" */
     114L,	/*   270: "box" */
     581L,	/*   271: "wbitmap" */
      92L,	/*   272: "slmult" */
     260L,	/*   273: "trspdfb" */
     289L,	/*   274: "pgbrdrfoot" */
     399L,	/*   275: "binfsxn" */
     330L,	/*   276: "lnbrkrule" */
      60L,	/*   277: "chbgdkfdiag" */
     291L,	/*   278: "pgbrdrb" */
     223L,	/*   279: "clNoWrap" */
     264L,	/*   280: "trpaddb" */
      30L,	/*   281: "dn" */
     418L,	/*   282: "aftntj" */
     293L,	/*   283: "pgbrdrr" */
     124L,	/*   284: "aspnum" */
     299L,	/*   285: "margt" */
     344L,	/*   286: "pnlcrm" */
     331L,	/*   287: "bdrrlswsix" */
     443L,	/*   288: "snext" */
     515L,	/*   289: "hr" */
     239L,	/*   290: "trkeep" */
     356L,	/*   291: "pgwsxn" */
     242L,	/*   292: "trql" */
     430L,	/*   293: "ftnnauc" */
     154L,	/*   294: "ilvl" */
     160L,	/*   295: "pnrrgb" */
     238L,	/*   296: "trhdr" */
     549L,	/*   297: "listrestarthdn" */
     123L,	/*   298: "aspalpha" */
     290L,	/*   299: "pgbrdrt" */
      10L,	/*   300: "caps" */
     141L,	/*   301: "posnegy" */
      68L,	/*   302: "faauto" */
      16L,	/*   303: "pnb" */
     606L,	/*   304: "picbpp" */
     476L,	/*   305: "landscape" */
     272L,	/*   306: "trftsWidthA" */
      32L,	/*   307: "outl" */
     440L,	/*   308: "ftnalt" */
     536L,	/*   309: "levelnorestart" */
     493L,	/*   310: "rtldoc" */
     276L,	/*   311: "trbgdkbdiag" */
     483L,	/*   312: "noextrasprl" */
     343L,	/*   313: "pnlcltr" */
     205L,	/*   314: "clbgfdiag" */
     328L,	/*   315: "lytcalctblwd" */
     421L,	/*   316: "aftnstart" */
     396L,	/*   317: "vertalt" */
     600L,	/*   318: "piccropr" */
     516L,	/*   319: "min" */
     361L,	/*   320: "margbsxn" */
     425L,	/*   321: "aftnrstcont" */
      88L,	/*   322: "keepn" */
     535L,	/*   323: "levellegal" */
     303L,	/*   324: "gutter" */
     454L,	/*   325: "lin" */
     127L,	/*   326: "phmrg" */
     211L,	/*   327: "clvertalt" */
      86L,	/*   328: "widctlpar" */
     444L,	/*   329: "cs" */
     170L,	/*   330: "aexpnd" */
     468L,	/*   331: "formdisp" */
     101L,	/*   332: "bgdkdcross" */
     257L,	/*   333: "trspdfl" */
     397L,	/*   334: "sectlinegrid" */
     520L,	/*   335: "yr" */
     263L,	/*   336: "trpaddt" */
      40L,	/*   337: "rtlch" */
     281L,	/*   338: "trbgdkvert" */
     484L,	/*   339: "notabind" */
     179L,	/*   340: "aul" */
     489L,	/*   341: "revbar" */
     471L,	/*   342: "fracwidth" */
     100L,	/*   343: "bgdkcross" */
     447L,	/*   344: "spersonal" */
     128L,	/*   345: "phpg" */
     249L,	/*   346: "trbrdrh" */
     433L,	/*   347: "ftnnchi" */
      65L,	/*   348: "chcbpat" */
     571L,	/*   349: "fcharset" */
     273L,	/*   350: "trbgbdiag" */
     459L,	/*   351: "nolnhtadjtbl" */
     431L,	/*   352: "ftnnrlc" */
     184L,	/*   353: "aup" */
      82L,	/*   354: "qj" */
     135L,	/*   355: "posxi" */
     190L,	/*   356: "cellx" */
     186L,	/*   357: "hich" */
      17L,	/*   358: "pni" */
     461L,	/*   359: "annotprot" */
     241L,	/*   360: "trautofit" */
     309L,	/*   361: "dghspace" */
     126L,	/*   362: "absh" */
     538L,	/*   363: "fbias" */
     451L,	/*   364: "pca" */
     250L,	/*   365: "trbrdrv" */
     391L,	/*   366: "colno" */
     531L,	/*   367: "levelnfc" */
     384L,	/*   368: "pgnhnsp" */
     117L,	/*   369: "intbl" */
     306L,	/*   370: "jcompress" */
     112L,	/*   371: "brdrl" */
     559L,	/*   372: "tlul" */
     564L,	/*   373: "fnil" */
     219L,	/*   374: "clmgf" */
     319L,	/*   375: "deftab" */
     155L,	/*   376: "pnrauth" */
     523L,	/*   377: "delrsid" */
     342L,	/*   378: "pnucrm" */
     196L,	/*   379: "clbgbdiag" */
     503L,	/*   380: "viewkind" */
     521L,	/*   381: "insrsid" */
     232L,	/*   382: "clpadfl" */
     329L,	/*   383: "lyttblrtgr" */
     382L,	/*   384: "pgnhn" */
     556L,	/*   385: "tqc" */
     569L,	/*   386: "fdecor" */
     506L,	/*   387: "ogutter" */
     526L,	/*   388: "pararsid" */
     188L,	/*   389: "ltrrow" */
      85L,	/*   390: "nowidctlpar" */
     348L,	/*   391: "pnindent" */
     271L,	/*   392: "trftsWidthB" */
     178L,	/*   393: "astrike" */
     287L,	/*   394: "trshdng" */
     491L,	/*   395: "revprop" */
     511L,	/*   396: "noline" */
     387L,	/*   397: "pgnhnsn" */
     388L,	/*   398: "pgnx" */
      70L,	/*   399: "facenter" */
     428L,	/*   400: "ftnnar" */
     570L,	/*   401: "ftech" */
      93L,	/*   402: "outlinelevel" */
     390L,	/*   403: "linex" */
     168L,	/*   404: "acf" */
     496L,	/*   405: "sprstsp" */
     527L,	/*   406: "tblrsid" */
     137L,	/*   407: "pvmrg" */
     285L,	/*   408: "trcfpat" */
     558L,	/*   409: "tldot" */
     392L,	/*   410: "colsr" */
     498L,	/*   411: "swpbdr" */
     574L,	/*   412: "objemb" */
      34L,	/*   413: "crauth" */
     300L,	/*   414: "margb" */
      13L,	/*   415: "pnf" */
     191L,	/*   416: "celld" */
     212L,	/*   417: "clvertalc" */
     270L,	/*   418: "trwWidthA" */
     339L,	/*   419: "pncard" */
      50L,	/*   420: "charscalex" */
     563L,	/*   421: "jclisttab" */
     378L,	/*   422: "cols" */
     120L,	/*   423: "sbauto" */
     162L,	/*   424: "pnrstop" */
     243L,	/*   425: "trqr" */
     292L,	/*   426: "pgbrdrl" */
     608L,	/*   427: "blipupi" */
     442L,	/*   428: "sbasedon" */
     311L,	/*   429: "dghorigin" */
     347L,	/*   430: "pnstart" */
     594L,	/*   431: "objcropb" */
     500L,	/*   432: "ight" */
     533L,	/*   433: "leveljc" */
     605L,	/*   434: "picbmp" */
     145L,	/*   435: "posyil" */
     554L,	/*   436: "tql" */
     337L,	/*   437: "dntblnsbdb" */
     360L,	/*   438: "margrsxn" */
     607L,	/*   439: "pictscaled" */
     398L,	/*   440: "endnhere" */
     213L,	/*   441: "clvertalb" */
     118L,	/*   442: "adjustright" */
     258L,	/*   443: "trspdfr" */
       0L,	/*   444: "plain" */
     555L,	/*   445: "tqr" */
     207L,	/*   446: "clbgvert" */
     497L,	/*   447: "subfontbysize" */
      58L,	/*   448: "chbgdkhoriz" */
     566L,	/*   449: "fswiss" */
     323L,	/*   450: "splytwnine" */
     335L,	/*   451: "expshrtn" */
     163L,	/*   452: "pnrxst" */
      23L,	/*   453: "noproof" */
     227L,	/*   454: "clpadb" */
     441L,	/*   455: "additive" */
     422L,	/*   456: "ftnrstcont" */
     140L,	/*   457: "posy" */
     252L,	/*   458: "trftsWidth" */
      41L,	/*   459: "shad" */
     586L,	/*   460: "pichgoal" */
      76L,	/*   461: "ls" */
     551L,	/*   462: "listoverridecount" */
      61L,	/*   463: "chbgdkbdiag" */
      84L,	/*   464: "pagebb" */
      57L,	/*   465: "chbgdcross" */
      49L,	/*   466: "expndtw" */
     480L,	/*   467: "makebackup" */
     420L,	/*   468: "ftnstart" */
     222L,	/*   469: "clvmrg" */
     381L,	/*   470: "sectdefaultcl" */
     203L,	/*   471: "clbgdkhor" */
     312L,	/*   472: "dgvorigin" */
     427L,	/*   473: "aftnrstpg" */
     226L,	/*   474: "clpadt" */
     542L,	/*   475: "levelprevspace" */
      66L,	/*   476: "chcfpat" */
     176L,	/*   477: "ascaps" */
     247L,	/*   478: "trbrdrl" */
     320L,	/*   479: "truncex" */
     208L,	/*   480: "clcfpat" */
      21L,	/*   481: "pnstrike" */
     150L,	/*   482: "dfrmtxtx" */
     108L,	/*   483: "cfpat" */
     106L,	/*   484: "bghoriz" */
      52L,	/*   485: "chbghoriz" */
      69L,	/*   486: "fahang" */
     477L,	/*   487: "linestart" */
     305L,	/*   488: "psz" */
     195L,	/*   489: "clbrdrr" */
     286L,	/*   490: "trcbpat" */
     601L,	/*   491: "bliptag" */
     152L,	/*   492: "dropcapli" */
      28L,	/*   493: "cchs" */
      51L,	/*   494: "highlight" */
     235L,	/*   495: "trgaph" */
     458L,	/*   496: "langfenp" */
      29L,	/*   497: "deleted" */
     604L,	/*   498: "wbmwidthbytes" */
     164L,	/*   499: "tx" */
     245L,	/*   500: "trbrdrt" */
     228L,	/*   501: "clpadl" */
     505L,	/*   502: "lytprtmet" */
     102L,	/*   503: "bgdkfdiag" */
     349L,	/*   504: "pnhang" */
     529L,	/*   505: "levelstartat" */
     374L,	/*   506: "pgnlcltr" */
     481L,	/*   507: "margmirror" */
     401L,	/*   508: "linebetcol" */
     507L,	/*   509: "deflangfe" */
      24L,	/*   510: "ulnone" */
     362L,	/*   511: "guttersxn" */
     588L,	/*   512: "objscaley" */
     173L,	/*   513: "ai" */
     449L,	/*   514: "mac" */
     202L,	/*   515: "clbgdkfdiag" */
      27L,	/*   516: "cb" */
     153L,	/*   517: "dropcapt" */
     501L,	/*   518: "wraptrsp" */
     446L,	/*   519: "shidden" */
     324L,	/*   520: "ftnlytwnine" */
     283L,	/*   521: "trbghoriz" */
     557L,	/*   522: "tqdec" */
     295L,	/*   523: "pgbrdropt" */
     584L,	/*   524: "objh" */
     580L,	/*   525: "dibitmap" */
     266L,	/*   526: "trpaddfr" */
     541L,	/*   527: "levelprev" */
       5L,	/*   528: "i" */
     122L,	/*   529: "nooverflow" */
     229L,	/*   530: "clpadr" */
     199L,	/*   531: "clbgdkbdiag" */
     576L,	/*   532: "wmetafile" */
     244L,	/*   533: "trqc" */
     198L,	/*   534: "clbgdcross" */
     327L,	/*   535: "alntblind" */
     510L,	/*   536: "ltrpar" */
     288L,	/*   537: "pgbrdrhead" */
     365L,	/*   538: "sbknone" */
     350L,	/*   539: "pnuld" */
      80L,	/*   540: "ql" */
     429L,	/*   541: "ftnnalc" */
     175L,	/*   542: "aoutl" */
      54L,	/*   543: "chbgfdiag" */
     159L,	/*   544: "pnrpnbr" */
      26L,	/*   545: "cgrid" */
     548L,	/*   546: "listhybrid" */
     165L,	/*   547: "tb" */
     353L,	/*   548: "sectd" */
     532L,	/*   549: "leveljcn" */
     435L,	/*   550: "aftnnalc" */
     119L,	/*   551: "adjustleft" */
     277L,	/*   552: "trbgdkcross" */
     280L,	/*   553: "trbgdkhor" */
     256L,	/*   554: "trspdb" */
     512L,	/*   555: "rtlpar" */
     587L,	/*   556: "objscalex" */
     463L,	/*   557: "cvmme" */
     138L,	/*   558: "pvpara" */
     142L,	/*   559: "abslock" */
     217L,	/*   560: "cltxlrtbv" */
     474L,	/*   561: "hyphconsec" */
     279L,	/*   562: "trbgdkfdiag" */
     354L,	/*   563: "headery" */
     534L,	/*   564: "levelfollow" */
     373L,	/*   565: "pgnucltr" */
      33L,	/*   566: "revauth" */
     110L,	/*   567: "brdrt" */
      56L,	/*   568: "chbgcross" */
      15L,	/*   569: "pbcf" */
     253L,	/*   570: "trspdl" */
      73L,	/*   571: "fafixed" */
     298L,	/*   572: "margr" */
     369L,	/*   573: "sbkodd" */
      77L,	/*   574: "li" */
     237L,	/*   575: "trrh" */
     599L,	/*   576: "piccropl" */
     130L,	/*   577: "posx" */
     509L,	/*   578: "level" */
     413L,	/*   579: "enddoc" */
     340L,	/*   580: "pndec" */
     486L,	/*   581: "prcolbl" */
     255L,	/*   582: "trspdt" */
     254L,	/*   583: "trspdr" */
     434L,	/*   584: "aftnnar" */
     139L,	/*   585: "pvpg" */
     364L,	/*   586: "titlepg" */
     547L,	/*   587: "listsimple" */
     352L,	/*   588: "pnulnone" */
     332L,	/*   589: "oldas" */
     147L,	/*   590: "nowrap" */
     321L,	/*   591: "nolead" */
     462L,	/*   592: "brkfrm" */
     525L,	/*   593: "sectrsid" */
     490L,	/*   594: "revisions" */
     157L,	/*   595: "pnrnot" */
       1L,	/*   596: "f" */
       4L,	/*   597: "b" */
     251L,	/*   598: "trwWidth" */
     597L,	/*   599: "piccropt" */
     358L,	/*   600: "marglsxn" */
      35L,	/*   601: "crdate" */
     408L,	/*   602: "ltrsect" */
      14L,	/*   603: "pnfs" */
     183L,	/*   604: "aulw" */
      89L,	/*   605: "sb" */
     593L,	/*   606: "objcropt" */
     385L,	/*   607: "pgnhnsc" */
     610L,	/*   608: "rsltmerge" */
     146L,	/*   609: "posyt" */
     513L,	/*   610: "sbys" */
    };

/* The hash function */

unsigned long docRtfTagHash(const unsigned char * key, int len )
{
    const ub4 initlev= 0x736ae311;
    ub4 rsl= 0;
    ub4 val = utilJenkinsHash( key, len, initlev );
    rsl = ((val>>24)^tab[val&0xff]);
    return rsl;
}

int docRtfTagIndex( const unsigned char * key, int len )
{
    ub4 rsl= docRtfTagHash( key, len );

    if  ( rsl >= sizeof(mapBack)/sizeof(int) )
	{ return -1;	}

    return mapBack[rsl];
}

