#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	"bmintern.h"

#   include	<appPs.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  We do our best to print anything.					*/
/*									*/
/************************************************************************/

int bmCanWriteEpsFile(	const BitmapDescription *	bd,
			int				PrivateFormat,
			double				CompressionFactor )
    {
    switch( bd->bdBitsPerSample )
	{
	case 1: case 2: case 4: case 8:
	    return 0;
	default:
	    /* LDEB(bd->bdBitsPerSample); */ return -1;	
	}
    }

/************************************************************************/
/*									*/
/*  Print Black/White/Color data in hexadecimal format.			*/
/*									*/
/************************************************************************/

int bmPsWriteBitmapData(	    FILE *			f,
				    int				x0,
				    int				y0,
				    int				wide,
				    int				high,
				    const BitmapDescription *	bd,
				    const unsigned char *	inputBuffer )
    {
    int				row;
    int				col;
    int				pos;

    int				originBit;
    int				originByte;
    int				rightShift;

    int				bytesPerRow;

    const unsigned char *	from;

    originBit=   ( x0*   bd->bdBitsPerPixel )% 8;
    originByte=  ( x0*   bd->bdBitsPerPixel )/ 8;
    bytesPerRow= ( wide* bd->bdBitsPerPixel+ 7 )/ 8;
    rightShift= 8- originBit;

    pos= 0;

    if  ( originBit == 0					&&
	  ( bd->bdColorEncoding == BMcoWHITEBLACK	||
	    bd->bdColorEncoding == BMcoRGB		)	)
	{
	for ( row= 0; row < high; row++ )
	    {
	    from= inputBuffer+ ( row+ y0 )* bd->bdBytesPerRow+ originByte;

	    for ( col= 0; col < bytesPerRow; col++ )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		fprintf( f, "%02x", *(from++) );
		pos++;
		}
	    }

	fprintf( f, "\n" );
	return 0;
	}

    if  ( originBit == 0				&&
	  bd->bdColorEncoding == BMcoBLACKWHITE		)
	{
	for ( row= 0; row < high; row++ )
	    {
	    from= inputBuffer+ ( row+ y0 )* bd->bdBytesPerRow+ originByte;

	    for ( col= 0; col < bytesPerRow; col++ )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		fprintf( f, "%02x", ( ~*(from++) ) & 0xff );
		pos++;
		}
	    }

	fprintf( f, "\n" );
	return 0;
	}

    if  ( bd->bdColorEncoding == BMcoWHITEBLACK )
	{
	for ( row= 0; row < high; row++ )
	    {
	    from= inputBuffer+ ( row+ y0 )* bd->bdBytesPerRow+ originByte;

	    for ( col= 1; col < bytesPerRow; col++ )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		fprintf( f, "%02x",
				( from[0] << originBit )	|
				( from[1] >> rightShift )	);

		from++; pos++;
		}

	    if  ( pos && ! ( pos % 36 ) )
		{ putc( '\n', f );	}

	    fprintf( f, "%02x", from[0] << originBit );
	    }

	fprintf( f, "\n" );
	return 0;
	}

    if  ( bd->bdColorEncoding == BMcoBLACKWHITE )
	{
	for ( row= 0; row < high; row++ )
	    {
	    from= inputBuffer+ ( row+ y0 )* bd->bdBytesPerRow+ originByte;

	    for ( col= 1; col < bytesPerRow; col++ )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		fprintf( f, "%02x",
		    ( ~( ( from[0] << originBit )	|
		         ( from[1] >> rightShift )	) ) &0xff );

		from++; pos++;
		}

	    if  ( pos && ! ( pos % 36 ) )
		{ putc( '\n', f );	}

	    fprintf( f, "%02x", ( ~( from[0] << originBit ) ) &0xff );
	    }

	fprintf( f, "\n" );
	return 0;
	}

    if  ( bd->bdColorEncoding == BMcoRGB8PALETTE	&&
	  bd->bdBitsPerPixel == 8			)
	{
	for ( row= 0; row < high; row++ )
	    {
	    from= inputBuffer+ ( row+ y0 )* bd->bdBytesPerRow+ originByte;

	    for ( col= 0; col < bytesPerRow; col++ )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		fprintf( f, "%02x", bd->bdRGB8Palette[*from].rgb8Red );
		fprintf( f, "%02x", bd->bdRGB8Palette[*from].rgb8Green );
		fprintf( f, "%02x", bd->bdRGB8Palette[*from].rgb8Blue );

		from++; pos++;
		}
	    }

	fprintf( f, "\n" );
	return 0;
	}

    if  ( bd->bdColorEncoding == BMcoRGB8PALETTE	&&
	  bd->bdBitsPerPixel == 4			&&
	  originBit == 0				)
	{
	for ( row= 0; row < high; row++ )
	    {
	    int		val;

	    from= inputBuffer+ ( row+ y0 )* bd->bdBytesPerRow+ originByte;

	    for ( col= 0; col+ 1 < wide; col += 2 )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		val= ( *from >> 4 ) & 0x0f;

		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Red );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Green );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Blue );

		val= *from & 0x0f;

		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Red );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Green );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Blue );

		from++; pos += 6;
		}

	    if  ( wide % 2 )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		val= ( *from >> 4 ) & 0x0f;

		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Red );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Green );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Blue );
		}
	    }

	fprintf( f, "\n" );
	return 0;
	}

    if  ( bd->bdColorEncoding == BMcoRGB8PALETTE	&&
	  bd->bdBitsPerPixel == 4			&&
	  originBit == 4				)
	{
	for ( row= 0; row < high; row++ )
	    {
	    int		val;

	    from= inputBuffer+ ( row+ y0 )* bd->bdBytesPerRow+ originByte;

	    val= *from & 0x0f;

	    fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Red );
	    fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Green );
	    fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Blue );

	    from++;

	    for ( col= 1; col < bytesPerRow; col++ )
		{
		if  ( pos && ! ( pos % 36 ) )
		    { putc( '\n', f );	}

		val= ( *from >> 4 ) & 0x0f;

		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Red );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Green );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Blue );

		val= *from & 0x0f;

		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Red );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Green );
		fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Blue );

		from++; pos += 6;
		}

	    val= ( *from >> 4 ) & 0x0f;

	    fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Red );
	    fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Green );
	    fprintf( f, "%02x", bd->bdRGB8Palette[val].rgb8Blue );
	    }

	fprintf( f, "\n" );
	return 0;
	}

    LDEB(bd->bdBitsPerPixel);
    LLDEB(originBit,bd->bdColorEncoding); return -1;
    }

/************************************************************************/
/*									*/
/*  Emit code for the emulation of color images on gray scale printers.	*/
/*									*/
/*  I do not understand this either but it works.			*/
/*									*/
/************************************************************************/

static void bmEpsColorEmulation( FILE *	f )
    {
    fputs( "\
	/bwproc {\n\
	    rgbproc\n\
	    dup length 3 idiv string 0 3 0\n\
	    5 -1 roll {\n\
		add 2 1 roll 1 sub dup 0 eq {\n\
		    pop 3 idiv\n\
		    3 -1 roll\n\
		    dup 4 -1 roll\n\
		    dup 3 1 roll\n\
		    5 -1 roll put\n\
		    1 add 3 0\n\
		} { 2 1 roll } ifelse\n\
	    } forall\n\
	    pop pop pop\n\
	} def\n\
	/colorimage where {pop} {\n\
	    /colorimage {pop pop /rgbproc exch def {bwproc} image} bind def\n\
	} ifelse\n", f );
    }

/************************************************************************/
/*									*/
/*  Return the size of a PostScript string that can hold one row of	*/
/*  data for the bitmap.						*/
/*									*/
/************************************************************************/

int bmPsRowStringSize(		const BitmapDescription *	bd,
				int				pixelsWide )
    {
    switch( bd->bdColorEncoding )
	{
	case	BMcoWHITEBLACK:
	case	BMcoBLACKWHITE:
	    return ( pixelsWide* bd->bdBitsPerPixel+ 7 )/ 8;

	case	BMcoRGB:
	    return ( pixelsWide* bd->bdBitsPerPixel+ 7 )/ 8;

	case	BMcoRGB8PALETTE:
	    return ( pixelsWide* 24+ 7 )/ 8;

	default:
	    LDEB(bd->bdColorEncoding); return -1;
	}
    }

/************************************************************************/
/*									*/
/*  Print one Encapsulated postsctipt page.				*/
/*									*/
/************************************************************************/

int bmPsPrintBitmap(	FILE *				f,
			int				level,
			double				xscale,
			double				yscale,
			int				ox,
			int				oy,
			int				x0,
			int				y0,
			int				wide,
			int				high,
			const BitmapDescription *	bd,
			const unsigned char *		buffer	)
    {
    switch( bd->bdUnit )
	{
	case	BMunCM:
	    xscale= ( xscale* POINTS_PER_CM* wide )/ bd->bdXResolution;
	    yscale= ( yscale* POINTS_PER_CM* high )/ bd->bdYResolution;
	    break;
	case	BMunINCH:
	    xscale= ( xscale* 72.0* wide )/ bd->bdXResolution;
	    yscale= ( yscale* 72.0* high )/ bd->bdYResolution;
	    break;
	case	BMunPOINT:
	    xscale= ( xscale* 1.0* wide )/ bd->bdXResolution;
	    yscale= ( yscale* 1.0* high )/ bd->bdYResolution;
	    break;
	default:
	    xscale= ( xscale* 1.0* wide );
	    yscale= ( yscale* 1.0* high );
	    break;
	}

    return bmPsPrintBitmapImage( f, level, xscale, yscale, ox, oy,
					    x0, y0, wide, high, bd, buffer );
    }

void bmPsWriteImageInstructions(	FILE *				f,
					const BitmapDescription *	bd,
					int				wide,
					int				high,
					const char *			proc )
    {
    switch( bd->bdColorEncoding )
	{
	case	BMcoWHITEBLACK:
	case	BMcoBLACKWHITE:
	    if  ( bd->bdBitsPerSample == 1 )
		{ fprintf( f, "0 setgray\n" );	}

	    fprintf( f, "%u %u", wide, high );

	    if  ( bd->bdBitsPerSample == 1 )
		{ fprintf( f, " false\n" );			}
	    else{ fprintf( f, " %d\n", bd->bdBitsPerSample );	}

	    fprintf( f, "[ %u 0 0 -%u 0 %u ]\n", wide, high, high );
	    fprintf( f, "{ %s } bind\n", proc );

	    if  ( bd->bdBitsPerSample == 1 )
		{ fprintf( f, "imagemask\n" );		}
	    else{ fprintf( f, "image\n" );		}

	    break;
	
	case	BMcoRGB:
	case	BMcoRGB8PALETTE:
	    bmEpsColorEmulation( f );

	    fprintf( f, "%u %u %d\n", wide, high, bd->bdBitsPerSample );

	    fprintf( f, "[ %u 0 0 -%u 0 %u ]\n", wide, high, high );
	    fprintf( f, "{ %s } bind\n", proc );
	    fprintf( f, "false %d colorimage\n", 3 );

	    break;

	default:
	    LDEB(bd->bdColorEncoding);
	}

    return;
    }

int bmPsPrintBitmapImage(	FILE *				f,
				int				level,
				double				xscale,
				double				yscale,
				int				ox,
				int				oy,
				int				x0,
				int				y0,
				int				wide,
				int				high,
				const BitmapDescription *	bd,
				const unsigned char *		buffer	)
    {
    int		bytesPerRow;

    fprintf( f, "gsave\n" );
    fprintf( f, "100 dict begin\n");

    if  ( ox != 0 || oy != 0 )
	{ fprintf( f, "%d %d translate\n", ox, oy );	}

    if  ( xscale != 1.0 || yscale != 1.0 )
	{ fprintf( f, "%f %f scale\n", xscale, yscale ); }

    bytesPerRow= bmPsRowStringSize( bd, wide );
    if  ( bytesPerRow < 0 )
	{ LDEB(bytesPerRow); return -1;	}

    fprintf( f, "/line %d string def\n", bytesPerRow );

    bmPsWriteImageInstructions( f, bd, wide, high,
					"currentfile line readhexstring pop" );

    bmPsWriteBitmapData( f, x0, y0, wide, high, bd, buffer );

    fprintf( f, "end\n");
    fprintf( f, "grestore\n");

    return 0;
    }

/************************************************************************/
/*									*/
/*  Calculate the page state parameters.				*/
/*									*/
/************************************************************************/

static void bmPsPageExtent(	const BitmapDescription *	bd,
				float *				pPointsWide,
				float *				pPointsHigh,
				int				pixelsWide,
				int				pixelsHigh )
    {
    float	xResolution;
    float	yResolution;

    switch( bd->bdUnit )
	{
	case	BMunCM:
	    xResolution= bd->bdXResolution/ POINTS_PER_CM;
	    yResolution= bd->bdYResolution/ POINTS_PER_CM;
	    break;
	case	BMunINCH:
	    xResolution= bd->bdXResolution/ 72.0;
	    yResolution= bd->bdYResolution/ 72.0;
	    break;
	case	BMunPOINT:
	    xResolution= bd->bdXResolution;
	    yResolution= bd->bdYResolution;
	    break;
	default:
	    LDEB(bd->bdUnit); return;
	}

    *pPointsWide= pixelsWide/ xResolution;
    *pPointsHigh= pixelsHigh/ yResolution;

    return;
    }

/************************************************************************/
/*									*/
/*  Save a bitmap image to Encapsulated PostScript (EPS) Format.	*/
/*									*/
/*  1)  Only 1,2,4,8 bits per sample images are supported.		*/
/*  2)  Open the output file.						*/
/*  3)  Determine the bounding box of the image.			*/
/*  4)  Issue the EPS header comments.					*/
/*  5)  Issue the Image contents.					*/
/*  6)  Include a 'showpage' command.					*/
/*  7)  Finish with a general header.					*/
/*									*/
/************************************************************************/

int bmWriteEpsFile(	const char *			filename,
			const unsigned char *		buffer,
			const BitmapDescription *	bd,
			int				privateFormat,
			double				compressionFactor )
    {
    FILE *			f;
    float			pointsWide;
    float			pointsHigh;

    /*  1  */
    switch( bd->bdBitsPerSample )
	{
	case 1:
	case 2:
	case 4:
	case 8:
	    break;
	default:
	    LDEB(bd->bdBitsPerSample); return -1;	
	}

    /*  2  */
    f= fopen( filename, "w" );
    if  ( ! f )
	{ SXDEB(filename,f); return -1;	}

    /*  3  */
    bmPsPageExtent( bd, &pointsWide, &pointsHigh,
					bd->bdPixelsWide, bd->bdPixelsHigh );

    /*  4  */
    appPsWriteEpsHeader( f, 
		    "Scan, Mark de Does, M.de.Does@inter.nl.net",
		    filename, 
		    (int)ceil( pointsWide ), (int)ceil( pointsHigh )	);

    /*  5  */
    if  ( bmPsPrintBitmap( f, privateFormat, 1.0, 1.0, 0, 0,
				0, 0, bd->bdPixelsWide, bd->bdPixelsHigh,
				bd, buffer ) )
	{ LDEB(1); fclose( f ); return -1;	}

    /*  6  */
    fprintf( f, "showpage\n");

    /*  7  */
    fprintf( f, "%%%%Trailer\n" );
    fprintf( f, "%%%%EOF\n" );

    fclose( f ); return 0;
    }
