/************************************************************************/
/*									*/
/*  Manage an array of data bytes and its size.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>

#   include	<utilMemoryBuffer.h>
#   include	<appDebugon.h>

void utilInitMemoryBuffer(	MemoryBuffer *	mb )
    {
    mb->mbSize= 0;
    mb->mbBytes= (unsigned char *)0;
    return;
    }

void utilCleanMemoryBuffer(	MemoryBuffer *	mb )
    {
    if  ( mb->mbBytes )
	{ free( mb->mbBytes );	}

    mb->mbSize= 0;
    mb->mbBytes= (unsigned char *)0;

    return;
    }

int utilSetMemoryBuffer(	MemoryBuffer *		mb,
				const unsigned char *	bytes,
				int			size )
    {
    unsigned char *	fresh;

    fresh= (unsigned char *)realloc( mb->mbBytes, size+ 1 );
    if  ( ! fresh )
	{ LXDEB(size,fresh); return -1;	}

    memcpy( fresh, bytes, size );

    mb->mbBytes= fresh;
    mb->mbSize= size;
    fresh[mb->mbSize]= '\0';

    return 0;
    }

int utilAddToMemoryBuffer(	MemoryBuffer *		mb,
				const unsigned char *	bytes,
				int			size )
    {
    unsigned char *	fresh;

    fresh= (unsigned char *)realloc( mb->mbBytes, mb->mbSize+ size+ 1 );
    if  ( ! fresh )
	{ LXDEB(size,fresh); return -1;	}

    memcpy( fresh+ mb->mbSize, bytes, size );

    mb->mbBytes= fresh;
    mb->mbSize= mb->mbSize+ size;
    fresh[mb->mbSize]= '\0';

    return 0;
    }

int utilCopyMemoryBuffer(	MemoryBuffer *		mbTo,
				const MemoryBuffer *	mbFrom )
    {
    if  ( utilSetMemoryBuffer( mbTo, mbFrom->mbBytes, mbFrom->mbSize ) )
	{ LDEB(mbFrom->mbSize); return -1;	}

    return 0;
    }

