/************************************************************************/
/*									*/
/*  sioHttp.[ch]:	Retrieve an URL.				*/
/*									*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include     <string.h>
#   include     <stdlib.h>

#   include     <errno.h>
#   include     <unistd.h>

#   include     <sioHttp.h>
#   include     <appDebugon.h>

typedef struct HttpConnection
    {
    int		hcFd;
    int		hcInBody;
    } HttpConnection;

static int sioHttpClose(       void *  voidhc )
    {
    int			rval= 0;
    HttpConnection *	hc= (HttpConnection *)voidhc;

    if  ( close( hc->hcFd ) )
	{ LSDEB(hc->hcFd,strerror(errno)); rval= -1;	}

    free( voidhc );

    return rval;
    }

static int siohttpSeek(		void *			voidhc,
				long			pos )
    { LDEB(pos); return -1;	}

static int sioInHttpReadBytes(	void *		voidhc,
				unsigned char *	buffer,
				int		count )
    {
    HttpConnection *	hc= (HttpConnection *)voidhc;
    int			done;

    done= read( hc->hcFd, buffer, count );

    if  ( done < 0 )
	{ LSDEB(hc->hcFd,strerror(errno));	}

    return done;
    }

SimpleInputStream * sioInHttpOpen(	const char *	host,
					const char *	port,
					const char *	uri,
					void *		through,
					APP_COMPLAIN	complain )
    {
    int			fd= -1;
    char *		request= (char *)0;
    HttpConnection *	hc= (HttpConnection *)0;

    SimpleInputStream *	sis;
    int			requestLength;

    if  ( ! port )
	{ port= "http";	}

    fd= appOpenSocket( host, port, through, complain );
    if  ( fd < 0 )
	{ LDEB(fd); goto failure;	}

    requestLength= 0;
    requestLength += 4;				/*  "GET "		*/
    requestLength += strlen( uri );		/*  uri			*/
    requestLength += 9;				/*  " HTTP/1.0"		*/
    requestLength += 5;				/*  "\r\n\r\n\0"	*/

    request= malloc( requestLength );
    if  ( ! request )
	{ XDEB(request); goto failure;	}

    sprintf( request, "GET %s HTTP/1.0\r\n\r\n", uri );

    if  ( write( fd, request, requestLength ) != requestLength )
	{ LSDEB(requestLength,strerror(errno)); goto failure;	}

    hc= (HttpConnection *)malloc( sizeof(HttpConnection) );
    if  ( ! hc )
	{ XDEB(hc); goto failure;	}

    hc->hcFd= fd;
    hc->hcInBody= 0;

    sis= sioInOpen( (void *)hc, sioInHttpReadBytes, siohttpSeek, sioHttpClose );
    if  ( ! sis )
	{ XDEB(sis); goto failure;	}

    return sis;

  failure:
    LDEB(1);

    if  ( hc )
	{ free( hc );	}

    if  ( request )
	{ free( request );	}

    if  ( fd >= 0 && close( fd ) )
	{ LSDEB(fd,strerror(errno));	}

    return (SimpleInputStream *)0;
    }
