/************************************************************************/
/*									*/
/*  'Table' page of the format tool.					*/
/*									*/
/************************************************************************/

#   ifndef	TED_TABLE_TOOL_H
#   define	TED_TABLE_TOOL_H

/************************************************************************/
/*									*/
/*  Resources for the 'Table' page.					*/
/*									*/
/************************************************************************/

typedef struct TablePageResources
    {
    char *		tprCellMargin;
    char *		tprLeftIndent;
    } TablePageResources;

/************************************************************************/
/*									*/
/*  A table tool, i.e. the 'Table' page of the format tool.		*/
/*									*/
/************************************************************************/

typedef struct TableTool
    {
    EditApplication *		ttApplication;
    AppInspector *		ttInspector;

    RowProperties		ttPropertiesSet;
    RowProperties		ttPropertiesChosen;

    TableRectangle		ttTableRectangle;

    int				ttPageRight;
    int				ttPageLeftMargin;

    APP_WIDGET			ttCellMarginText;
    APP_WIDGET			ttLeftIndentText;
    } TableTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

#   endif	/*  TED_TABLE_TOOL_H */
