/************************************************************************/
/*									*/
/*  A Format Tool.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Resources for the format tool.					*/
/*									*/
/************************************************************************/

typedef struct TedFormatToolResources
    {
    InspectorSubjectResources	tttrSubjectResources[TEDtsiCOUNT];

    TablePageResources		tttrTablePageResources;
    RowPageResources		tttrRowPageResources;
    ColumnPageResources		tttrColumnPageResources;
    CellPageResources		tttrCellPageResources;
    ParagraphPageResources	tttrParaPageResources;
    SectionPageResources	tttrSectPageResources;
    PageLayoutPageResources	tttrPageLayoutPageResources;
    HeaderFooterPageResources	tttrHeadFootPageResources;
    NotesPageResources		tttrNotesPageResources;
    } TedFormatToolResources;

static AppConfigurableResource TED_TedFormatToolResourceTable[]=
    {
	/****************************************************************/
	/*  'Table' page.						*/
	/****************************************************************/
	APP_RESOURCE( "tableToolTable",
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].isrSubjectName),
		    "Table" ),
	APP_RESOURCE( "tableToolChangeTable",
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].isrApplyToSubject),
		    "Apply to Table" ),
	APP_RESOURCE( "tableToolRevert",
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].isrRevert),
		    "Revert" ),
	/*  no Next Table */
	/*  no Prev Table */
	APP_RESOURCE( "tableToolSelectTable",
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].isrSelectButtonText),
		    "Select Table" ),
	APP_RESOURCE( "tableToolDeleteTable",
		    offsetof(TedFormatToolResources,
		    tttrSubjectResources[TEDtsiTABLE].isrDeleteButtonText),
		    "Delete Table" ),
	/*  no Insert Table */
	/*  no Append Table */
	/**/
	APP_RESOURCE( "tableToolCellMargin",
		    offsetof(TedFormatToolResources,
		    tttrTablePageResources.tprCellMargin),
		    "Cell Margin" ),
	APP_RESOURCE( "tableToolLeftIndent",
		    offsetof(TedFormatToolResources,
		    tttrTablePageResources.tprLeftIndent),
		    "Left Margin" ),
    };

/************************************************************************/
/*									*/
/*  Validate a dimension						*/
/*									*/
/************************************************************************/

int tedFormatValidateDimension(		int *		pNewValue,
					int *		pChanged,
					APP_WIDGET	w,
					int		oldValue )
    {
    int				changed;

    const int			minValue= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    if  ( ! appGetLengthFromTextWidget( w, &oldValue, &changed, UNITtyPOINTS,
				minValue, adaptToMin, maxValue, adaptToMax ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, oldValue, UNITtyPOINTS );
	appStringToTextWidget( w, scratch );

	if  ( changed )
	    { *pNewValue= oldValue;	}

	*pChanged= changed; return 0;
	}

    return -1;
    }

int tedFormatToolGetGapWidth(		const RowProperties *	rp,
					int *			pValue,
					APP_WIDGET		w )
    {
    int				value;
    int				changed;

    int				minWidth;
    const CellProperties *	cp;
    int				col;

    const int			minValue= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    value= rp->rpHalfGapWidthTwips;
    if  ( appGetLengthFromTextWidget( w, &value, &changed, UNITtyPOINTS,
				minValue, adaptToMin, maxValue, adaptToMax ) )
	{ return -1;	}

    cp= rp->rpCells;
    minWidth= cp->cpRightBoundaryTwips- rp->rpLeftIndentTwips;

    for ( col= 1; col < rp->rpCellCount; cp++, col++ )
	{
	int	cellWidth;

	cellWidth= cp[1].cpRightBoundaryTwips- cp[0].cpRightBoundaryTwips;

	if  ( minWidth > cellWidth )
	    { minWidth=  cellWidth;	}
	}

    if  ( 2* value >= minWidth )
	{
	char		scratch[50];

	value= minWidth/3;

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	appStringToTextWidget( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    *pValue= value;
    return 0;
    }

int tedFormatToolGetRowLeftIndent(	const RowProperties *	rp,
					const int		pageLeftMargin,
					int *			pValue,
					APP_WIDGET		w )
    {
    int				value;
    int				changed;

    char			scratch[50];

    const int			minValue= INT_MIN;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    value= rp->rpLeftIndentTwips;
    if  ( appGetLengthFromTextWidget( w, &value, &changed, UNITtyPOINTS,
				minValue, adaptToMin, maxValue, adaptToMax ) )
	{ return -1;	}

    if  ( value < -pageLeftMargin )
	{
	value= -pageLeftMargin+ 10;

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	appStringToTextWidget( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    if  ( value+ 2* rp->rpHalfGapWidthTwips >=
					rp->rpCells[0].cpRightBoundaryTwips )
	{
	value= rp->rpCells[0].cpRightBoundaryTwips- 3* rp->rpHalfGapWidthTwips;

	if  ( value < -pageLeftMargin )
	    { appRefuseTextValue( w ); return -1;	}

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	appStringToTextWidget( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    *pValue= value; return 0;
    }

static void tedFormatFillPages(	const TedFormatToolResources *	tftr,
				TedFormatTool *			tft,
				AppInspector *			ai )
    {
    tedFormatFillTablePage( &(tft->tftTableTool),
			    &(tftr->tttrTablePageResources),
			    &(ai->aiSubjects[TEDtsiTABLE]),
			    ai->aiSubjects[TEDtsiTABLE].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiTABLE]) );

    tedFormatFillRowPage( &(tft->tftRowTool),
			    &(tftr->tttrRowPageResources),
			    &(ai->aiSubjects[TEDtsiROW]),
			    ai->aiSubjects[TEDtsiROW].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiROW]) );

    tedFormatFillColumnPage( &(tft->tftColumnTool),
			    &(tftr->tttrColumnPageResources),
			    &(ai->aiSubjects[TEDtsiCOLUMN]),
			    ai->aiSubjects[TEDtsiCOLUMN].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiCOLUMN]) );

    tedFormatFillCellPage( &(tft->tftCellTool),
			    &(tftr->tttrCellPageResources),
			    &(ai->aiSubjects[TEDtsiCELL]),
			    ai->aiSubjects[TEDtsiCELL].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiCELL]) );

    tedFormatFillParagraphPage( &(tft->tftParagraphTool),
			    &(tftr->tttrParaPageResources),
			    &(ai->aiSubjects[TEDtsiPARA]),
			    ai->aiSubjects[TEDtsiPARA].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiPARA]) );

    tedFormatFillSectionPage( &(tft->tftSectionTool),
			    &(tftr->tttrSectPageResources),
			    &(ai->aiSubjects[TEDtsiSECT]),
			    ai->aiSubjects[TEDtsiSECT].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiSECT]) );

    tedFormatFillPageLayoutPage( &(tft->tftPageLayoutTool),
			    &(tftr->tttrPageLayoutPageResources),
			    &(ai->aiSubjects[TEDtsiPAGE]),
			    ai->aiSubjects[TEDtsiPAGE].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiPAGE]) );

    tedFormatFillHeaderFooterPage( &(tft->tftHeaderFooterTool),
			    &(tftr->tttrHeadFootPageResources),
			    &(ai->aiSubjects[TEDtsiHEADFOOT]),
			    ai->aiSubjects[TEDtsiHEADFOOT].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiHEADFOOT]) );

    tedFormatFillNotesPage( &(tft->tftNotesTool),
			    &(tftr->tttrNotesPageResources),
			    &(ai->aiSubjects[TEDtsiNOTES]),
			    ai->aiSubjects[TEDtsiNOTES].isPage,
			    &(tftr->tttrSubjectResources[TEDtsiNOTES]) );

    return;
    }

/************************************************************************/
/*									*/
/*  The user destroys the format tool.					*/
/*									*/
/************************************************************************/

static void tedDestroyFormatTool(	void *	voidtft )
    {
    int			i;

    TedFormatTool *	tft= (TedFormatTool *)voidtft;

    ParagraphTool *	pt= &(tft->tftParagraphTool);
    RowTool *		rt= &(tft->tftRowTool);
    ColumnTool *	cot= &(tft->tftColumnTool);
    CellTool *		clt= &(tft->tftCellTool);
    TableTool *		tt= &(tft->tftTableTool);
    SectionTool *	st= &(tft->tftSectionTool);
    PageLayoutTool *	plt= &(tft->tftPageLayoutTool);
    HeaderFooterTool *	hft= &(tft->tftHeaderFooterTool);
    NotesTool *		nt= &(tft->tftNotesTool);

    EditApplication *	ea= tft->tftApplication;
    TedAppResources *	tar= (TedAppResources *)ea->eaResourceData;

    docCleanParagraphProperties( &(pt->ptPropertiesSet) );
    docCleanParagraphProperties( &(pt->ptPropertiesChosen) );
#   if 0
    tedFormatCleanShadingTool( &(pt->ptShadingTool) );
#   endif
    tedFormatCleanBorderTool( &(pt->ptTopBorderTool) );
    tedFormatCleanBorderTool( &(pt->ptBottomBorderTool) );

    docCleanRowProperties( &(rt->rtPropertiesSet) );
    docCleanRowProperties( &(rt->rtPropertiesChosen) );
    tedFormatCleanBorderTool( &(rt->rtTopBorderTool) );
    tedFormatCleanBorderTool( &(rt->rtBottomBorderTool) );

    docCleanRowProperties( &(cot->ctPropertiesSet) );
    docCleanRowProperties( &(cot->ctPropertiesChosen) );
    tedFormatCleanBorderTool( &(cot->ctLeftBorderTool) );
    tedFormatCleanBorderTool( &(cot->ctRightBorderTool) );

    docCleanCellProperties( &(clt->ctPropertiesSet) );
    docCleanCellProperties( &(clt->ctPropertiesChosen) );
#   if 0
    tedFormatCleanShadingTool( &(clt->ctShadingTool) );
#   endif
    tedFormatCleanBorderTool( &(clt->ctTopBorderTool) );
    tedFormatCleanBorderTool( &(clt->ctBottomBorderTool) );
    tedFormatCleanBorderTool( &(clt->ctLeftBorderTool) );
    tedFormatCleanBorderTool( &(clt->ctRightBorderTool) );

    docCleanRowProperties( &(tt->ttPropertiesSet) );
    docCleanRowProperties( &(tt->ttPropertiesChosen) );

    docCleanSectionProperties( &(st->stPropertiesSet) );
    docCleanSectionProperties( &(st->stPropertiesChosen) );

    appCleanPaperChooser( &(plt->pltPaperChooser) );
    appCleanDrawingData( &(plt->pltDrawingData) );

    docCleanDocumentProperties( &(nt->ntPropertiesSet) );
    docCleanDocumentProperties( &(nt->ntPropertiesChosen) );

    docCleanDocumentProperties( &(hft->hftDocPropertiesChosen) );
    docCleanDocumentProperties( &(hft->hftDocPropertiesSet) );
    docCleanSectionProperties( &(hft->hftSectPropertiesChosen) );
    docCleanSectionProperties( &(hft->hftSectPropertiesSet) );

    for ( i= 0; i < DOCsp_COUNT; i++ )
	{
	if  ( tft->tftShadingPixmaps[i] )
	    {
	    appDrawFreePixmap( &(tft->tftPixmapAdd),
					    tft->tftShadingPixmaps[i] );
	    }
	}
    for ( i= 0; i < DOCbs_COUNT; i++ )
	{
	if  ( tft->tftBorderPixmaps[i] )
	    {
	    appDrawFreePixmap( &(tft->tftPixmapAdd),
					    tft->tftBorderPixmaps[i] );
	    }
	}

    appCleanDrawingData( &(tft->tftPixmapAdd) );

    free( tft );

    tar->tarInspector= (void *)0;

    return;
    }

/************************************************************************/
/*									*/
/*  make/show the format tool.						*/
/*									*/
/************************************************************************/

void tedShowFormatTool(	APP_WIDGET		option,
			EditApplication *	ea,
			const char *		widgetName,
			const char *		pixmapName )
    {
    AppInspector *			ai;
    TedFormatTool *			tft;
    int					i;
   	 
    static TedFormatToolResources	tftr;
    static int				gotResources;

    TedAppResources *			tar;

    tar= (TedAppResources *)ea->eaResourceData;

    if  ( tar->tarInspector )
	{
	ai= tar->tarInspector;

	appShowShellWidget( ai->aiTopWidget );

	return;
	}

    if  ( ! gotResources )
	{
	tedFormatToolGetRowResourceTable( ea,
				&(tftr.tttrRowPageResources),
				&(tftr.tttrSubjectResources[TEDtsiROW]) );

	tedFormatToolGetColumnResourceTable( ea,
				&(tftr.tttrColumnPageResources),
				&(tftr.tttrSubjectResources[TEDtsiCOLUMN]) );

	tedFormatToolGetCellResourceTable( ea,
				&(tftr.tttrCellPageResources),
				&(tftr.tttrSubjectResources[TEDtsiCELL]) );

	tedFormatToolGetParaResourceTable( ea,
				&(tftr.tttrParaPageResources),
				&(tftr.tttrSubjectResources[TEDtsiPARA]) );

	tedFormatToolGetSectResourceTable( ea,
				&(tftr.tttrSectPageResources),
				&(tftr.tttrSubjectResources[TEDtsiSECT]) );

	tedFormatToolGetPageResourceTable( ea,
				&(tftr.tttrPageLayoutPageResources),
				&(tftr.tttrSubjectResources[TEDtsiPAGE]) );

	tedFormatToolGetHeaderFooterResourceTable( ea,
				&(tftr.tttrHeadFootPageResources),
				&(tftr.tttrSubjectResources[TEDtsiHEADFOOT]) );

	tedFormatToolGetNotesResourceTable( ea,
				&(tftr.tttrNotesPageResources),
				&(tftr.tttrSubjectResources[TEDtsiNOTES]) );

	appGuiGetResourceValues( ea, (void *)&tftr,
				TED_TedFormatToolResourceTable,
				sizeof(TED_TedFormatToolResourceTable)/
				sizeof(AppConfigurableResource) );

	gotResources= 1;
	}

    tft= (TedFormatTool *)malloc( sizeof(TedFormatTool) );
    if  ( ! tft )
	{ XDEB(tft); return;	}

    tft->tftApplication= ea;

    tft->tftSectionTool.stApplication= ea;
    tft->tftPageLayoutTool.pltApplication= ea;
    tft->tftHeaderFooterTool.hftApplication= ea;
    tft->tftParagraphTool.ptApplication= ea;
    tft->tftColumnTool.ctApplication= ea;
    tft->tftRowTool.rtApplication= ea;
    tft->tftTableTool.ttApplication= ea;
    tft->tftNotesTool.ntApplication= ea;

    appInitDrawingData( &(tft->tftPixmapAdd) );
    tft->tftPixmapAddAllocated= 0;

    for ( i= 0; i < DOCsp_COUNT; i++ )
	{ tft->tftShadingPixmaps[i]= (APP_BITMAP_IMAGE)0; }
    for ( i= 0; i < DOCbs_COUNT; i++ )
	{ tft->tftBorderPixmaps[i]= (APP_BITMAP_IMAGE)0; }

    ai= appMakeInspector( ea, option, pixmapName, widgetName,
				    tftr.tttrSubjectResources, TEDtsiCOUNT,
				    tedDestroyFormatTool, (void *)tft );

    tft->tftInspector= ai;

    tft->tftSectionTool.stInspector= ai;
    tft->tftPageLayoutTool.pltInspector= ai;
    tft->tftHeaderFooterTool.hftInspector= ai;
    tft->tftParagraphTool.ptInspector= ai;
    tft->tftColumnTool.ctInspector= ai;
    tft->tftRowTool.rtInspector= ai;
    tft->tftTableTool.ttInspector= ai;
    tft->tftNotesTool.ntInspector= ai;

    tedFormatFillPages( &tftr, tft, ai );

    tedFormatFillRowChoosers( &(tft->tftRowTool),
					    &(tftr.tttrRowPageResources) );
    tedFormatFillParagraphChoosers( &(tft->tftParagraphTool),
					    &(tftr.tttrParaPageResources) );
    tedFormatFillSectionChoosers( &(tft->tftSectionTool),
					    &(tftr.tttrSectPageResources) );
    tedFormatFillPageLayoutChoosers( &(tft->tftPageLayoutTool),
					&(tftr.tttrPageLayoutPageResources) );
    tedFormatFillHeaderFooterChoosers( &(tft->tftHeaderFooterTool),
					&(tftr.tttrHeadFootPageResources) );
    tedFormatFillNotesChoosers( &(tft->tftNotesTool),
					&(tftr.tttrNotesPageResources) );
    tedFormatFillColumnChoosers( &(tft->tftColumnTool),
					&(tftr.tttrColumnPageResources) );
    tedFormatFillCellChoosers( &(tft->tftCellTool),
					&(tftr.tttrCellPageResources) );

    appFinishInspector( ai );

    tedFormatFinishRowPage( &(tft->tftRowTool), tft,
					    &(tftr.tttrRowPageResources) );
    tedFormatFinishParagraphPage( &(tft->tftParagraphTool), tft,
					    &(tftr.tttrParaPageResources) );
    tedFormatFinishSectionPage( &(tft->tftSectionTool), tft,
					    &(tftr.tttrSectPageResources) );
    tedFormatFinishPageLayoutPage( &(tft->tftPageLayoutTool), tft,
					&(tftr.tttrPageLayoutPageResources) );
    tedFormatFinishHeaderFooterPage( &(tft->tftHeaderFooterTool), tft,
					&(tftr.tttrHeadFootPageResources) );
    tedFormatFinishNotesPage( &(tft->tftNotesTool), tft,
					&(tftr.tttrNotesPageResources) );
    tedFormatFinishColumnPage( &(tft->tftColumnTool), tft,
					&(tftr.tttrColumnPageResources) );
    tedFormatFinishCellPage( &(tft->tftCellTool), tft,
					&(tftr.tttrCellPageResources) );

    tar->tarInspector= ai;

    return;
    }

/************************************************************************/
/*									*/
/*  Ask the table tool to adapt itself to the selection.		*/
/*									*/
/************************************************************************/

void tedFormatShowPagePage(	EditApplication *	ea )
    {
    TedAppResources *		tar= (TedAppResources *)ea->eaResourceData;

    if  ( ! tar->tarInspector )
	{ XDEB(tar->tarInspector); return;	}

    appEnableInspectorSubject( tar->tarInspector, TEDtsiPAGE, 1 );

    appInspectorSelectSubject( tar->tarInspector, TEDtsiPAGE );

    return;
    }

void tedFormatToolAdaptToSelection( AppInspector *		ai,
				const BufferDocument *		bd,
				const SelectionScope *		ss,
				const BufferSelection *		bs,
				int				fileReadonly )
    {
    TedFormatTool *		tft= (TedFormatTool *)ai->aiTarget;

    TableRectangle		tr;

    int				tableRectangle= 0;

    int				subject;

    if  ( ! bs->bsBegin.bpBi )
	{ appEnableInspector( ai, 0 ); return; }
    else{
	ParagraphTool *		pt= &(tft->tftParagraphTool);
	SectionTool *		st= &(tft->tftSectionTool);
	PageLayoutTool *	plt= &(tft->tftPageLayoutTool);
	HeaderFooterTool *	hft= &(tft->tftHeaderFooterTool);
	NotesTool *		nt= &(tft->tftNotesTool);

	tedFormatToolRefreshParagraphTool( pt,
					ai->aiSubjects+ TEDtsiPARA, bs );

	tedFormatToolRefreshSectionTool( st,
					ai->aiSubjects+ TEDtsiSECT, bs );

	tedFormatToolRefreshPageLayoutTool( plt,
					ai->aiSubjects+ TEDtsiPAGE,
					bs, &(bd->bdProperties) );

	tedFormatToolRefreshHeaderFooterTool( hft,
					ai->aiSubjects+ TEDtsiHEADFOOT,
					bs, &(bd->bdProperties) );

	tedFormatToolRefreshNotesTool( nt,
					ai->aiSubjects+ TEDtsiNOTES,
					&(bd->bdProperties) );

	if  ( fileReadonly )
	    { appEnableInspector( ai, 0 );	}
	else{ appEnableInspector( ai, 1 );	}
	}

    for ( subject= 0; subject < TEDtsiCOUNT; subject++ )
	{ appInspectorEnablePage( ai, subject, fileReadonly == 0 ); }

    /*  NotesTool is NOT for 2.9 */
    appEnableInspectorSubject( ai, TEDtsiNOTES, 0 );

    if  ( ! tedGetTableRectangle( &tr, ss, bs ) )
	{ tableRectangle= 1;	}

    if  ( tableRectangle )
	{
	TableTool *	tt= &(tft->tftTableTool);
	CellTool *	clt= &(tft->tftCellTool);
	ColumnTool *	cot= &(tft->tftColumnTool);
	RowTool *	rt= &(tft->tftRowTool);

	tedFormatToolRefreshTableTool( tt, ai->aiSubjects+ TEDtsiTABLE,
								    &tr, bs );

	appEnableInspectorSubject( ai, TEDtsiTABLE, 1 );

	if  ( tr.trCol1 == tr.trCol0 )
	    {
	    tedFormatToolRefreshColumnTool( cot,
				    ai->aiSubjects+ TEDtsiCOLUMN, &tr, bs );

	    appEnableInspectorSubject( ai, TEDtsiCOLUMN, 1 );
	    }
	else{
	    appEnableInspectorSubject( ai, TEDtsiCOLUMN, 0 );
	    }

	if  ( tr.trRow1 == tr.trRow0 )
	    {
	    appEnableInspectorSubject( ai, TEDtsiROW, 1 );

	    tedFormatToolRefreshRowTool( rt, ai->aiSubjects+ TEDtsiROW,
								    &tr, bs );
	    }
	else{
	    appEnableInspectorSubject( ai, TEDtsiROW, 0 );
	    }

	if  ( tr.trCol1 == tr.trCol0 && tr.trRow1 == tr.trRow0 )
	    {
	    tedFormatToolRefreshCellTool( clt,
					ai->aiSubjects+ TEDtsiCELL, &tr, bs );

	    appEnableInspectorSubject( ai, TEDtsiCELL, 1 );

	    /*  CellTool is NOT for 2.9
	    appEnableInspectorSubject( ai, TEDtsiCELL, 0 );
	    */
	    }
	else{
	    appEnableInspectorSubject( ai, TEDtsiCELL, 0 );
	    }
	}
    else{
	docInitTableRectangle( &(tft->tftTableTool.ttTableRectangle) );
	docInitTableRectangle( &(tft->tftCellTool.ctTableRectangle) );
	docInitTableRectangle( &(tft->tftColumnTool.ctTableRectangle) );
	docInitTableRectangle( &(tft->tftRowTool.rtTableRectangle) );

	appEnableInspectorSubject( ai, TEDtsiTABLE, 0 );
	appEnableInspectorSubject( ai, TEDtsiROW, 0 );
	appEnableInspectorSubject( ai, TEDtsiCOLUMN, 0 );
	appEnableInspectorSubject( ai, TEDtsiCELL, 0 );
	}

    if  ( ss->ssInHeaderFooter != DOCinBODY )
	{
	appEnableInspectorSubject( ai, TEDtsiSECT, 0 );
	appEnableInspectorSubject( ai, TEDtsiPAGE, 0 );
	}
    else{
	appEnableInspectorSubject( ai, TEDtsiSECT, 1 );
	appEnableInspectorSubject( ai, TEDtsiPAGE, 1 );
	}

    if  ( ai->aiCurrentSubject < 0				||
	  ! ai->aiSubjects[ai->aiCurrentSubject].isEnabled	)
	{
	for ( subject= 0; subject < ai->aiSubjectCount; subject++ )
	    {
	    if  ( ai->aiSubjects[subject].isEnabled )
		{
		appInspectorSelectSubject( ai, subject );
		break;
		}
	    }
	}
    }

