/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Get font properties of the current position.			*/
/*									*/
/************************************************************************/

void tedGetPositionAttributes(	TedDocument *		td,
				const BufferPosition *	bp,
				char **			pFamilyName,
				int *			pPsFamilyNumber,
				unsigned int *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    BufferDocument *		bd= td->tdDocument;
    DocumentFontList *		dfl= &(bd->bdProperties.dpFontList);
    BufferItem *		bi= bp->bpBi;
    int				part= bp->bpParticule;
    TextParticule *		tp= bi->biParaParticules+ part;
    DocumentFont *		df;

    df= dfl->dflFonts+ tp->tpTextAttribute.taFontNumber;

    *pFamilyName= df->dfName;
    *pPsFamilyNumber= df->dfPsFamilyNumber;

    *pTaNew= tp->tpTextAttribute;
    *pUpdMask= TAupdALL;

    return;
    }

/************************************************************************/
/*									*/
/*  Get the common text properties of the current selection.		*/
/*									*/
/************************************************************************/

void tedGetSelectionAttributes(	TedDocument *		td,
				char **			pFamilyName,
				int *			pPsFamilyNumber,
				unsigned int *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    BufferDocument *		bd= td->tdDocument;
    DocumentFontList *		dfl= &(bd->bdProperties.dpFontList);
    const BufferSelection *	bs= &(td->tdSelection);
    BufferItem *		bi= bs->bsBegin.bpBi;
    int				part= bs->bsBegin.bpParticule;
    TextParticule *		tp= bi->biParaParticules+ part;


    char *			familyName= (char *)0;
    int				psFamilyNumber= -1;

    TextAttribute	taNew;
    unsigned int	updMask;

    taNew= tp->tpTextAttribute;
    updMask= 0;

    for (;;)
	{
	int	col;

	col= bi->biParent->biNumberInParent;

	if  ( bs->bsCol0 < 0					||
	      bs->bsCol1 < 0					||
	      ( col >= bs->bsCol0 && col <= bs->bsCol1 )	)
	    {
	    while( part < bi->biParaParticuleCount )
		{
		if  ( bi == bs->bsEnd.bpBi			&&
		      tp->tpStroff >= bs->bsEnd.bpStroff	)
		    { break;	}

		updMask |= docAttributeDifference( taNew,
					    tp->tpTextAttribute, TAupdALL );

		tp++; part++;
		}
	    }

	if  ( bi == bs->bsEnd.bpBi )
	    { break;	}

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { break;	}

	part= 0; tp= bi->biParaParticules;
	}

    updMask= ~updMask & TAupdALL;

    if  ( PROPmaskISSET( updMask, TApropFONTFAMILY ) )
	{
	DocumentFont *		df; df= dfl->dflFonts+ taNew.taFontNumber;

	familyName= df->dfName;
	psFamilyNumber= df->dfPsFamilyNumber;
	}
    else{
	familyName= (char *)0;
	psFamilyNumber= -1;
	}

    *pFamilyName= familyName;
    *pPsFamilyNumber= psFamilyNumber;
    *pUpdMask= updMask;
    *pTaNew= taNew;

    return;
    }

/************************************************************************/
/*									*/
/*  Get font properties of the current position or selection.		*/
/*									*/
/************************************************************************/

int tedGetDocumentAttributes(	TedDocument *		td,
				char **			pFamilyName,
				int *			pPsFamilyNumber,
				unsigned int *		pUpdMask,
				TextAttribute *		pTaNew )
    {
    if  ( tedHasIBarSelection( td ) )
	{
	BufferDocument *	bd= td->tdDocument;
	DocumentFontList *	dfl= &(bd->bdProperties.dpFontList);
	TextAttribute		ta= td->tdCurrentTextAttribute;
	DocumentFont *		df= dfl->dflFonts+ ta.taFontNumber;

	if  ( ta.taFontNumber < 0 || ta.taFontNumber >= dfl->dflCount )
	    { LLDEB(ta.taFontNumber,dfl->dflCount); return -1; }

	*pFamilyName= df->dfName;
	*pPsFamilyNumber= df->dfPsFamilyNumber;

	*pTaNew= ta;
	*pUpdMask= TAupdALL;

	return 0;
	}

    if  ( td->tdSelection.bsBegin.bpBi )
	{
	tedGetSelectionAttributes( td, pFamilyName, pPsFamilyNumber,
							pUpdMask, pTaNew );

	return 0;
	}

    return 1;
    }

int tedGetDocumentAttributeString(	char *		scratch,
					TedDocument *	td )
    {
    char *		familyName= (char *)0;
    int			psFamilyNumber= -1;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	{ return -1;	}

    appFontAttributeString( scratch, familyName, updMask, taNew );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Change the attributes of a particule.				*/
/*									*/
/************************************************************************/

int tedChangeParticuleAttribute( AppDrawingData *	add,
				TextParticule *		tp,
				DocumentFontList *	dfl,
				unsigned int		updMask,
				TextAttribute		taNew )
    {
    TextAttribute	ta;

    unsigned int	changeMask= 0;

    ta= tp->tpTextAttribute;

    docUpdateTextAttribute( &changeMask, updMask, &ta, taNew );

    if  ( changeMask || tp->tpPhysicalFont < 0 )
	{
	int	physicalFont= appOpenDocumentFont( add, dfl, ta );

	if  ( physicalFont < 0 )
	    { LLDEB(ta.taFontIsBold,ta.taFontIsSlanted); return -1; }

	tp->tpTextAttribute= ta;
	tp->tpPhysicalFont= physicalFont;
	}

    return 0;
    }
