/************************************************************************/
/*									*/
/*  Cell tool:								*/
/*									*/
/************************************************************************/

#   ifndef	TED_CELL_TOOL_H
#   define	TED_CELL_TOOL_H

#   include	"tedBorderTool.h"
#   include	"tedShadingTool.h"

/************************************************************************/
/*									*/
/*  Resources for the 'Cell' page.					*/
/*									*/
/************************************************************************/

typedef struct CellPageResources
    {
    char *		cprRow;
    char *		cprColumn;

    char *		cprWidth;
    char *		cprLeftBorder;
    char *		cprRightBorder;

    char *		cprTopBorder;
    char *		cprBottomBorder;
    char *		cprColumnSpan;
    char *		cprShadingPattern;
    char *		cprVerticalAlignment;
    } CellPageResources;

/************************************************************************/
/*									*/
/*  A Cell tool, i.e. the 'Cell' page of the format tool.		*/
/*									*/
/************************************************************************/

typedef struct CellTool
    {
    EditApplication *		ctApplication;

    TableRectangle		ctTableRectangle;

    CellProperties		ctPropertiesSet;
    CellProperties		ctPropertiesChosen;

    APP_WIDGET			ctRowText;
    APP_WIDGET			ctColumnText;

    BorderTool			ctTopBorderTool;
    BorderTool			ctBottomBorderTool;
    BorderTool			ctLeftBorderTool;
    BorderTool			ctRightBorderTool;

#   if 0
    ShadingTool			ctShadingTool;
#   endif
    } CellTool;

#   endif	/*  TED_CELL_TOOL_H */
