#   include	<appFrame.h>
#   include	<appImage.h>

#   include	<appGeo.h>
#   include	<appDraw.h>
#   include	"docBuf.h"
#   include	<sioMemory.h>

#   ifndef	TED_APP_H
#   define	TED_APP_H

#   define	RESIZE_BLOCK	10

/************************************************************************/
/*									*/
/*  Private data for a document.					*/
/*									*/
/************************************************************************/

typedef struct TedDocument
    {
    BufferDocument *	tdDocument;
    TextAttribute	tdCurrentTextAttribute;
    int			tdCurrentPhysicalFont;

    BufferSelection	tdSelection;
    SelectionScope	tdSelectionScope;
    DocumentRectangle	tdSelectedRectangle;

    APP_WIDGET		tdCopyWidget;
    APP_WIDGET		tdCutWidget;
    APP_WIDGET		tdPasteWidget;

    APP_WIDGET		tdInsertMenu;
    APP_WIDGET		tdInsertMenuButton;
    APP_WIDGET		tdInsPictOption;
    APP_WIDGET		tdInsFileOption;
    APP_WIDGET		tdInsSymbolOption;
    APP_WIDGET		tdInsHyperlinkOption;
    APP_WIDGET		tdInsBookmarkOption;
    APP_WIDGET		tdInsInsertTableOption;
    APP_WIDGET		tdInsInsertPageNumberOption;
    APP_WIDGET		tdInsInsertLineBreakOption;
    APP_WIDGET		tdInsInsertPageBreakOption;
    APP_WIDGET		tdInsInsertSectBreakOption;

    APP_WIDGET		tdTableMenu;
    APP_WIDGET		tdTableMenuButton;
    APP_WIDGET		tdTabInsertTableOption;
    APP_WIDGET		tdTabAddRowOption;
    APP_WIDGET		tdTabAddColumnOption;

    APP_WIDGET		tdFormatMenu;
    APP_WIDGET		tdFormatMenuButton;
    APP_WIDGET		tdFormatOneParaOption;

    APP_WIDGET		tdSelectTableWidget;
    APP_WIDGET		tdSelectRowWidget;
    APP_WIDGET		tdSelectColumnOption;
    APP_WIDGET		tdDrawTableGridOption;

    APP_WIDGET		tdFontMenu;
    APP_WIDGET		tdFontMenuButton;
    APP_WIDGET		tdFontBoldOption;
    APP_WIDGET		tdFontItalicOption;
    APP_WIDGET		tdFontUnderlinedOption;
    APP_WIDGET		tdFontSuperscriptOption;
    APP_WIDGET		tdFontSubscriptOption;

    APP_WIDGET		tdToolsMenu;
    APP_WIDGET		tdToolsMenuButton;
    APP_WIDGET		tdToolsFormatToolOption;

    APP_COLOR_RGB	tdSelColor;
    APP_COLOR_RGB	tdXSelColor;
    APP_COLOR_RGB	tdFieldColor;
    APP_COLOR_RGB	tdTableColor;

    int			tdVisibleSelectionCopied;
    int			tdCanReplaceSelection;
    int			tdCopiedSelectionClosed;
    MemoryBuffer	tdCopiedSelection;
    MemoryBuffer	tdCopiedFont;
    MemoryBuffer	tdCopiedRuler;
    AppBitmapImage	tdCopiedImage;

#   ifdef USE_MOTIF
    XtIntervalId	tdHideIBarId;
    XtIntervalId	tdShowIBarId;
#   endif

#   ifdef USE_GTK
    guint		tdHideIBarId;
    guint		tdShowIBarId;
#   endif

    APP_WINDOW		tdObjectWindow;
    APP_WINDOW		tdObjectBottomWindow;
    APP_WINDOW		tdObjectRightWindow;
    APP_WINDOW		tdObjectCornerWindow;
    int			tdObjectSelected;

    int			tdDrawTableGrid;
    } TedDocument;

/************************************************************************/
/*									*/
/*  Ted specific resources.						*/
/*									*/
/*  Also: Some global data items.					*/
/*									*/
/************************************************************************/

typedef struct TedAppResources
    {
				/****************************************/
				/*  Texts.				*/
				/****************************************/

    char *			tarFileNotRtf;
    char *			tarHeadFootNotReachable;

    char *			tarAppFileMenuText;
    char *			tarAppWinMenuText;
    char *			tarDocFileMenuText;
    char *			tarDocEditMenuText;
    char *			tarDocInsertMenuText;
    char *			tarDocWinMenuText;
    char *			tarDocFontMenuText;
    char *			tarDocFormatMenuText;
    char *			tarDocToolMenuText;
    char *			tarDocTableMenuText;
    char *			tarHelpMenuText;
    char *			tarAppHelpFileName;

    char *			tarSelectionColor;
    char *			tarCopiedSelectionColor;

				/****************************************/
				/*  Defaults.				*/
				/****************************************/
    char *			tarDefaultAnsicpgString;
    int				tarDefaultAnsicpgInt;

				/****************************************/
				/*  Global data.			*/
				/****************************************/

    AppInspector *		tarInspector;
    EditDocument *		tarManualDocument;
    } TedAppResources;

/************************************************************************/
/*									*/
/*  Used on 'Hyperlink' and 'Bookmark' dialogs.				*/
/*									*/
/************************************************************************/

typedef enum LinkKind
    {
    LINKkindHYPERLINK,
    LINKkindPAGE_NUMBER,
    LINKkindBOOKMARK_TEXT,
    LINKkindTEXT_PLUS_PAGE,

    LINKkind_COUNT
    } LinkKind;

/************************************************************************/
/*									*/
/*  Supported document formats.						*/
/*  Match an array in tedMain.c.					*/
/*									*/
/************************************************************************/

typedef enum TedDocumentKind
    {
    TEDdockindRTF= 0,
    TEDdockindTEXT_OPEN,
    TEDdockindTEXT_SAVE_FOLDED,
    TEDdockindTEXT_SAVE_WIDE,
    TEDdockindHTML_FILES,
    TEDdockindALL_FILES,

    TEDdockind_COUNT
    } TedDocumentKind;

/************************************************************************/
/*									*/
/*  Shared resources.							*/
/*									*/
/************************************************************************/

extern const int TedPrimaryTextTargetCount;
extern AppSelectionTargetType TedPrimaryTextTargets[];

extern const int TedPrimaryPictureTargetCount;
extern AppSelectionTargetType TedPrimaryPictureTargets[];

extern const int TedRulerTargetCount;
extern AppSelectionTargetType TedRulerTargets[];

/************************************************************************/
/*									*/
/*  Geometry calculations.						*/
/*									*/
/************************************************************************/

extern int tedLayoutItem(	BufferItem *		bi,
				const BufferDocument *	bd,
				int			inHeaderFooter,
				AppDrawingData *	add,
				DocumentRectangle *	drChanged );

extern int tedLayoutExternal(	HeaderFooter *			hf,
				int				page,
				const SectionProperties *	sp,
				const BufferDocument *		bd,
				AppDrawingData *		add,
				DocumentRectangle *		drChanged );

extern int tedRedoHeaderFooterLayout( int *			pDone,
				HeaderFooter *			hf,
				int				page,
				const BufferItem *		sectBi,
				BufferDocument *		bd,
				AppDrawingData *		add,
				DocumentRectangle *		drChanged );

extern int tedFindPosition(	BufferItem *		rootBi,
				const AppDrawingData *	add,
				int			x,
				int			y,
				BufferPosition *	bp );

extern int tedCalculateX(	const BufferItem *	bi,
				const TextParticule *	tp,
				const AppDrawingData *	add,
				int			stroff	);

extern int tedFindParticule(	TextLine *	tl,
				TextParticule *	tp,
				int		x,
				int		y	);

extern int tedFindStringOffset(	const TextParticule *	tp,
				const unsigned char *	paraString,
				const AppDrawingData *	add,
				int *			pBarX,
				int			x,
				int			y	);

extern int tedHasSelection(	const TedDocument *   td );
extern int tedHasIBarSelection(	const TedDocument *   td );

extern int tedReplaceSelection(	DocumentRectangle *	drChanged,
				BufferSelection *	bsRep,
				EditDocument *		ed,
				const unsigned char *	addedText,
				int			addedLength );

extern int tedFirstPosition(	const AppDrawingData *	add,
				BufferDocument *	bd,
				BufferPosition *	bp	);

extern int tedLastPosition(	const AppDrawingData *	add,
				BufferDocument *	bd,
				BufferPosition *	bp	);

extern int tedPrevPosition(	const AppDrawingData *	add,
				BufferPosition *	bp,
				int			lastOne );
extern int tedNextPosition(	const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedBeginOfLine(	const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedEndOfLine(	const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedNextLine(		const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedPrevLine(		const AppDrawingData *	add,
				BufferPosition *	bp	);

extern int tedPageUp(	BufferPosition *	bp,
			BufferDocument *	bd,
			const AppDrawingData *	add,
			int			pageHeight );

extern int tedPageDown(	BufferPosition *	bp,
			BufferDocument *	bd,
			const AppDrawingData *	add,
			int			docHeight,
			int			pageHeight );

extern APP_EVENT_HANDLER( tedObserveFocus, w, voided, event );

extern void tedSplitParagraph(		EditDocument *		ed,
					int			onNewPage );

extern void tedSetTab(			EditDocument *		ed );

extern int tedChangeSelectionProperties(
				EditDocument *			ed,
				unsigned int			taUpdMask,
				TextAttribute			taNew,
				unsigned int			ppUpdMask,
				const ParagraphProperties *	ppNew,
				unsigned int			spUpdMask,
				const SectionProperties *	spNew );

extern void tedRedrawRectangle(	APP_WIDGET		w,
				TedDocument *		td,
				DocumentRectangle *	drClip,
				AppDrawingData *	add,
				AppColors *		ac,
				int			ox,
				int			oy );

extern void tedDelimitCurrentSelection(	TedDocument *		td,
					AppDrawingData *	add );

extern void tedDocToolFind(		APP_WIDGET	findOption,
					void *		voided,
					void *		voidcbs );

extern void tedDocToolSpell(		APP_WIDGET	spellOption,
					void *		voided,
					void *		voidcbs );

extern int tedIncludePlainDocument(	APP_WIDGET		w,
					EditDocument *		ed,
					BufferDocument *	bdFrom );

extern int tedIncludeRtfDocument(	APP_WIDGET		w,
					EditDocument *		ed,
					BufferDocument *	bdFrom );

extern int tedGetDocumentAttributeString(	char *		scratch,
						TedDocument *	td );

extern int tedGetDocumentAttributes(	TedDocument *	td,
					char **		pFamilyName,
					int *		pPsFamilyNumber,
					unsigned int *	pUpdMask,
					TextAttribute *	pTaNew );

extern void tedGetSelectionAttributes(	TedDocument *	td,
					char **		pFamilyName,
					int *		pPsFamilyNumber,
					unsigned int *	pUpdMask,
					TextAttribute *	pTaNew );

extern void tedGetPositionAttributes(	TedDocument *		td,
					const BufferPosition *	bp,
					char **			pFamilyName,
					int *			pPsFamilyNumber,
					unsigned int *		pUpdMask,
					TextAttribute *		pTaNew );

extern void tedDocCopy(		EditDocument *	ed );
extern void tedDocCut(		EditDocument *	ed );

extern void tedDocSelAll(	EditDocument *	ed );

extern void tedSetSelection(	EditDocument *		ed,
				const SelectionScope *	ssSet,
				const BufferSelection *	bsSet,
				int *			pScrolledX,
				int *			pScrolledY );

extern void tedAppReplaceSelection(	EditDocument *		ed,
					const unsigned char *	word,
					int			len	);

extern void tedSetSelectedPosition(	EditDocument *		ed,
					const SelectionScope *	ss,
					const BufferPosition *	bp,
					int *			pScrolledX,
					int *			pScrolledY );

extern void tedShowFontsTool(		APP_WIDGET		fontsOption,
					EditApplication *	ea,
					void *			voidcbs	 );

extern void tedAdaptFontIndicatorsToSelection(	EditApplication *	ea,
						EditDocument *		ed );

extern void tedAdaptFontsToolToDocument(	EditApplication *	ea,
						EditDocument *		ed );

extern void tedAdaptToolsToSelection(	EditDocument *		ed );

extern int tedExtendSelectionToXY(	EditDocument *		ed,
					BufferItem *		rootBi,
					const BufferPosition *	bpAnchor,
					const SelectionScope *	ss,
					int			mouseX,
					int			mouseY );

extern int tedExtendSelectionToPosition(EditDocument *		ed,
					const SelectionScope *	ss,
					const BufferPosition *	bpAnchor,
					const BufferPosition *	bpFound );

extern void tedScrollToSelection(	EditDocument *		ed,
					int *			pScrolledX,
					int *			pScrolledY );

extern void tedDocFontBold(		APP_WIDGET	boldOption,
					void *		voided,
					void *		voidcbs	 );

extern void tedDocFontItalic(	APP_WIDGET	italicOption,
					void *		voided,
					void *		voidcbs	 );

extern void tedDocFontUnderlined(	APP_WIDGET	underlineOption,
					void *		voided,
					void *		voidcbs	 );

extern void tedDocFontSupersub(		APP_WIDGET	option,
					void *		voided,
					void *		voidcbs	 );

extern int tedLayoutDocumentTree(	TedDocument *		td,
					AppDrawingData *	add );

extern void tedScreenRectangles(	AppDrawingData *		add,
					const DocumentGeometry *	dg );

extern void tedAdaptPageToolToDocument(	EditApplication *	ea,
					EditDocument *		ed );

extern void tedAppReplace(	void *			voidea,
				const unsigned char *	word	);

extern void tedGetNamedPictures(	EditApplication *	ea );

extern int tedAppChangeSelectionAttributeString( EditDocument *	ed,
					char *		attributeString );

extern void tedAdaptFontIndicatorsToValues( EditDocument *	ed,
					char *			familyName,
					int			psFamilyNumber,
					unsigned int		updMask,
					TextAttribute		taNew );

extern int tedDocSetTopRuler(	EditDocument *	ed );
extern int tedDocSetLeftRuler(	EditDocument *	ed );

extern void tedDocAdaptHorizontalRuler(	EditDocument *		ed,
					BufferItem *		bi );

extern void tedAdaptToolsToPosition(	EditDocument *		ed );

extern void tedRedrawIBar(	TedDocument *		td,
				int			ox,
				int			oy,
				AppDrawingData *	add );

extern void tedUndrawIBar(	const EditDocument *	ed );

extern void tedStartCursorBlink(	EditDocument *	ed );
extern void tedStopCursorBlink(		EditDocument *	ed );
extern void tedCleanCursorBlink(	TedDocument *	td );

extern int tedOpenItemObjects(	BufferItem *		bi,
				AppColors *		ac,
				AppDrawingData *	add );

extern int tedDrawObject(	const BufferItem *	bi,
				const TextParticule *	tp,
				int			baseline,
				int			ox,
				int			oy,
				AppDrawingData *	add );

extern void tedCloseObject(		BufferDocument *	bd,
					BufferItem *		bi,
					TextParticule *		tp,
					void *			voidadd );

extern void tedDocInsertPicture(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void tedDocInsertFile(		APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void tedDocInsertLink(	APP_WIDGET	option,
				void *		voided,
				void *		voidpbcs	 );

extern void tedDocInsertBookmark(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void tedDocInsertPageNumber(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void tedDocInsertLineBreak(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void tedDocInsertPageBreak(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void tedDocInsertSectBreak(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void TEDmiDocInsertInsSectBreak(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs	 );

extern void tedDocFormatOnePara(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcs );

extern int tedInsertNewObject(		APP_WIDGET		w,
					InsertedObject *	io,
					EditDocument *		ed );

extern APP_PASTE_REPLY( tedPastePrimaryRtf, w, event, voided );
extern APP_PASTE_REPLY( tedPastePrimaryString, w, event, voided );
extern APP_PASTE_REPLY( tedPasteRulerTed, w, event, voided );
extern APP_PASTE_REPLY( tedPasteFontTed, w, event, voided );
extern APP_PASTE_REPLY( tedPastePrimaryPixmap, w, event, voided );
extern APP_PASTE_REPLY( tedPastePrimaryPng, w, event, voided );

extern APP_GIVE_COPY( tedCopyPrimaryRtf, w, event, voided );
extern APP_GIVE_COPY( tedCopyPrimaryString, w, event, voided );
extern APP_GIVE_COPY( tedCopyPrimaryPng, w, event, voided );
extern APP_GIVE_COPY( tedCopyPrimaryPixmap, w, event, voided );
extern APP_GIVE_COPY( tedCopyFontTed, w, event, voided );
extern APP_GIVE_COPY( tedCopyRulerTed, w, event, voided );

extern int tedCopyAsLink(	EditDocument *		ed,
				const BufferItem *	bi,
				const SelectionScope *	ss,
				const BufferSelection *	bs,
				int			asRef,
				int			asPageref,
				const char *		file,
				const char *		markName,
				int			markSize );

extern void tedPrimaryLost(	APP_WIDGET			w,
				void *				voided,
				APP_EVENT *			clrEvent );

extern int tedObjectInsertBitmap(	EditDocument *		ed,
					AppBitmapImage *	abi );

extern int tedGetObjectSelection(	TedDocument *   	td,
					BufferPosition *	bp,
					InsertedObject **	pIo	);

extern void tedSetObjectWindows(	EditDocument *		ed,
					const BufferPosition *	bp,
					int			ox,
					int			oy );

extern void tedMoveObjectWindows(	APP_WIDGET		w,
					EditDocument *		ed );

extern int tedResizeObject(		EditDocument *		ed,
					const BufferPosition *	bp );

extern int tedReopenObject(	BufferDocument *	bd,
				BufferItem *		bi,
				TextParticule *		tp,
				AppColors *		ac,
				DocumentFontList *	dfl,
				AppDrawingData *	add );

extern int tedSaveObjectPicture(	AppBitmapImage *	abiTo,
					InsertedObject *	io );

extern void tedExposeSelection(	const EditDocument *	ed,
				const BufferSelection *	bs,
				int			scrolledX,
				int			scrolledY );

extern void tedPositionCoordinates(	BufferPosition *	bp,
					const AppDrawingData *	add );

extern void tedSelectionCoordinates(	BufferSelection *	bs,
					const AppDrawingData *	add );

extern void tedSelectionRectangle(	DocumentRectangle *		drClip,
					const AppDrawingData *		add,
					const DocumentProperties *	dp,
					const BufferSelection *		bs );

extern void tedDrawRectangle(	APP_WIDGET		w,
				EditDocument *		ed,
				DocumentRectangle *	drClip,
				int			ox,
				int			oy );

extern void tedDocHorizontalScrollbarCallback(	APP_WIDGET	w,
						void *		voided,
						void *		voidscbs );

extern void tedDocVerticalScrollbarCallback(	APP_WIDGET	w,
						void *		voided,
						void *		voidscbs );

extern int tedFinishDocumentSetup(	EditApplication *	ea,
					EditDocument *		ed );

extern void tedDocFormatCopyRul(	APP_WIDGET	fontsOption,
					void *		voided,
					void *		voidpbcbs	 );

extern void tedDocFormatPasteRul(	APP_WIDGET	fontsOption,
					void *		voided,
					void *		voidpbcbs	 );

extern int tedLayoutDocument(	void *				privateData,
				int				format,
				AppDrawingData *		add,
				const DocumentGeometry *	defDg );

extern int tedMakeDocumentWidget(	EditApplication *	ea,
					EditDocument *		ed );

extern int tedChangeParticuleAttribute( AppDrawingData *	add,
					TextParticule *		tp,
					DocumentFontList *	dfl,
					unsigned int		updMask,
					TextAttribute		taNew );

extern int tedInsertTable(	EditDocument *		ed,
				int			rows,
				int			columns );

extern void tedParaScreenGeometry(	const BufferItem *		bi,
					const DocumentProperties *	dp,
					const AppDrawingData *		add );

extern int tedInsertRowsInTable(	BufferItem *		sectBi,
					const RowProperties *	rp,
					EditDocument *		ed,
					int			row,
					int			rows );

extern int tedInsertColumnInTable(	EditDocument *		ed );
extern int tedAppendColumnToTable(	EditDocument *		ed );
extern int tedInsertRowInTable(		EditDocument *		ed );
extern int tedAppendRowToTable(		EditDocument *		ed );

extern void tedDocTableSelectTable(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcbs );

extern void tedDocTableSelectRow(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcbs );

extern void tedDocTableSelectColumn(	APP_WIDGET	option,
					void *		voided,
					void *		voidpbcbs );

extern void tedDocToolInsertSymbol(	APP_WIDGET	symbolOption,
					void *		voided,
					void *		voidcbs );

extern int tedSplitParaContents(	BufferItem **		pNewBi,
					BufferItem *		bi,
					DocumentRectangle *	drChanged,
					EditDocument *		ed,
					int			splitLevel,
					int			onNewPage );

extern int tedEditFinishIBarSelection(	EditDocument *		ed,
				BufferItem *			bi,
				const DocumentRectangle *	drChanged,
				int				oldBackY1,
				int				stroff );

extern void tedDeleteItems(		BufferDocument *	bd,
					BufferItem *		bi,
					int			first,
					int			count,
					AppDrawingData *	add );

extern void tedAppSetTableProperties(	EditApplication *	ea,
					const TableRectangle *	tr,
					const RowProperties *	rp );

extern int tedGetTableRectangle(	TableRectangle *	tr,
					const SelectionScope *	ss,
					const BufferSelection *	bs );

extern void tedAdaptFormatToolToDocument(	EditDocument *	ed );

extern void tedAppSetTableSelection(	EditDocument *		ed,
					const SelectionScope *	ss,
					const TableRectangle *	tr );

extern void tedDocTableSelectTableRectangle(	EditDocument *		ed,
						const SelectionScope *	ss,
						const TableRectangle *	tr );

extern void tedChangeTableLayout(	EditDocument *		ed,
					BufferItem *		bi,
					BufferItem *		sectBi,
					const RowProperties *	rp,
					int			rowHeightAlso,
					int			row0,
					int			row1 );

extern void tedDocTableDrawGrid(	APP_WIDGET	option,
					void *		voided,
					void *		voidcbs	 );

extern void tedMergeParagraphsInSelection(	EditDocument *	ed );

extern int tedDeleteRowsFromTable(	EditDocument *		ed,
					int			delRow0,
					int			delRow1 );

extern int tedDeleteColumnsFromRows(	EditDocument *	ed,
					int		delRow0,
					int		delRow1,
					int		delCol0,
					int		delCol1 );

extern void tedExposeRectangle(	const EditDocument *			ed,
				const DocumentRectangle *	drChanged,
				int				scrolledX,
				int				scrolledY );

extern int tedRunPropertyDialog( EditDocument *			ed,
				const DocumentStatistics *	ds,
				APP_WIDGET			option,
				const char *			pixmapName );

extern int tedBorderThick(		int *				pWide,
					const BorderProperties *	bp,
					const AppDrawingData *		add );

extern int tedSetHyperlink(	EditDocument *		ed,
				const char *		file,
				const char *		mark,
				int			asRef,
				int			asPageref );

extern int tedSetBookmark(	EditDocument *		ed,
				const char *		mark );

extern int tedRemoveHyperlink(	EditDocument *		ed );

extern int tedRemoveBookmark(	EditDocument *		ed );

extern int tedCopyBookmarkAsLink(	EditDocument *	ed,
					int		asRef,
					int		asPageref,
					const char *	link );

extern void tedRunLinkDialog(	EditApplication *	ea,
				EditDocument *		ed,
				APP_WIDGET		option,
				const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize );

extern void tedRunBookmarkDialog(	EditApplication *	ea,
					EditDocument *		ed,
					APP_WIDGET		option,
					int			nameProposed,
					const char *		markName,
					int			markSize );

extern int tedGoToBookmark(	EditDocument *		ed,
				const char *		markName,
				int			markSize );

extern int tedSaveDocument(	const void *			privateData,
				int				format,
				const char *			applicationId,
				const char *			documentTitle,
				const char *			filename );

extern void * tedMakePrivateData( void );

extern void tedMakeDocumentReadonly(	EditDocument *	ed );

extern int tedFollowLink(	APP_WIDGET		relative,
				APP_WIDGET		option,
				EditDocument *		edFrom,
				const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize );

extern int tedSelectWholeParagraph(	EditApplication *	ea,
					int			direction );

extern int tedSelectWholeSection(	EditApplication *	ea,
					int			direction );

extern int tedDeleteCurrentParagraph(	EditApplication *	ea );
extern int tedDeleteCurrentSection(	EditApplication *	ea );

extern int tedInsertParagraph(	EditApplication *	ea,
				int			after );

extern int tedInsertSection(	EditApplication *	ea,
				int			after );

extern int tedGetParaLineHeight(	int *			pLineHeight,
					EditDocument *		ed );


extern void tedShowFormatTool(	APP_WIDGET		toolOption,
				EditApplication *	ea,
				const char *		widgetName,
				const char *		pixmapName );

extern void tedFormatToolAdaptToSelection( AppInspector *	ai,
				const BufferDocument *		bd,
				const SelectionScope *		ss,
				const BufferSelection *		bs,
				int				fileReadonly );

extern int tedNewDocument(	EditApplication *	ea,
				EditDocument *		ed,
				const char *		filename );

extern int tedPrintDocument(	FILE *				f,
				const void *			privateData,
				int				format,
				AppDrawingData *		add,
				const char *			title,
				EditApplication *		ea,
				const DocumentGeometry *	dgPaper,
				int				nup,
				int				horizontal,
				int				firstPage,
				int				lastPage );

extern int tedAdjustParagraphLayout( BufferItem *		bi,
				int				line,
				int				stroffShift,
				int				upto,
				AppDrawingData *		add,
				const BufferDocument *		bd,
				DocumentRectangle *		drChanged );

extern void tedFreeDocument(		void *			voidtd,
					int			format,
					AppDrawingData *	add );

extern void tedRedoDocumentLayout(	EditDocument *		ed );

extern void tedParagraphFramePixels( 	FormattingFrame *	ffPixels,
					const AppDrawingData *	add,
					const BufferItem *	bi );

extern void tedFormatShowPagePage( EditApplication *		ea );

extern void tedSetPageLayout(	EditDocument *			ed,
				unsigned int			spUpdMask,
				const DocumentGeometry *	dg );

extern void tedSetDocumentProperties( EditApplication *		ea,
				const DocumentProperties *	dpNew,
				unsigned int			updMask );

extern APP_EVENT_HANDLER( tedKeyPressed, w, voided, keyEvent );
extern APP_EVENT_HANDLER( tedMouseButtonPressed, w, voided, downEvent );

extern void tedHideObjectWindows(	EditDocument *	ed );

extern int tedAppChangeSectionProperties( EditApplication *	ea,
				unsigned int			spUpdMask,
				const SectionProperties *	spNew );

extern int tedAppChangeParagraphProperties( EditApplication *		ea,
				unsigned int			ppUpdMask,
				const ParagraphProperties *	ppNew );

extern void tedAppDeleteHeaderFooter(	EditApplication *	ea,
					int			which );

extern void tedAppEditHeaderFooter(	EditApplication *	ea,
					APP_WIDGET		relative,
					APP_WIDGET		option,
					int			which );

extern int tedGetSelection(	SelectionScope *	ss,
				BufferSelection *	bs,
				TedDocument *		td );

extern int tedGetHeaderFooterBox( DocumentRectangle *		dr,
				BufferItem *			sectBi,
				const DocumentProperties *	dp,
				AppDrawingData *		add,
				int				page,
				int				inHdFt );

extern void tedFillBookmarkList(	APP_WIDGET		list,
					DocumentFieldList *	dfl );

#   endif	/*  TED_APP_H	*/
