/************************************************************************/
/*									*/
/*  Read the various document tables of an RTF text file into a		*/
/*  BufferDocument.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docRtf.h"

/************************************************************************/
/*                                                                      */
/*  Consume the 'revision table' of a document                          */
/*    added by davina 6-2-00                                            */
/*                                                                      */
/************************************************************************/

static int docRtfSaveRevisionTable(	RtfReadingContext *	rrc,
					const unsigned char *	text,
					int			len )
    {
    unsigned char **		newAuthorArray;
    unsigned char *		newAuthor;
    DocumentProperties *	dp= &(rrc->rrcBd->bdProperties);

    newAuthorArray = (unsigned char**)realloc( dp->dpAuthors, 
			   (dp->dpAuthorCount+1) * sizeof(unsigned char *));
    if  ( ! newAuthorArray )
	{ XDEB(newAuthorArray); return -1;	}

    dp->dpAuthors= newAuthorArray;
    newAuthor= (unsigned char*)strdup( (char *)text );

    if  ( ! newAuthor )
	{ XDEB(newAuthor); return -1; }
    dp->dpAuthors[dp->dpAuthorCount++]= newAuthor;

    return 0;
    }

int docRtfRevisionTable(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    if  ( docRtfReadGroup(sis, rcw->rcwLevel, (RtfControlWord*)0, 0, 0, rrc,
                          docRtfDocumentWords, docRtfDocumentGroups,
                          docRtfSaveRevisionTable))
	{ SLDEB(rcw->rcwWord, arg); return -1; }

    return 0;
    }

/************************************************************************/
/*									*/
/*  Read the info group.						*/
/*									*/
/************************************************************************/

static int docRtfInfoText(	RtfReadingContext *	rrc,
				unsigned char **	pText,
				const unsigned char *	text,
				int			len	)
    {
    char *	saved= (char *)malloc( len+ 1 );
    char *	to;

    if  ( ! saved )
	{ XDEB(saved); return -1;	}

    to= saved;
    while( len > 0 )
	{ *(to++)= rrc->rrcInputMapping[*(text++)]; len--;	}
    *to= '\0';

    if  ( *pText )
	{ free( *pText );	}

    *pText= (unsigned char *)saved;

    return 0;
    }

static int docRtfTitleText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	)
    {
    return docRtfInfoText( rrc, &(rrc->rrcBd->bdProperties.dpTitle),
								text, len );
    }

static int docRtfAuthorText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	)
    {
    return docRtfInfoText( rrc, &(rrc->rrcBd->bdProperties.dpAuthor),
								text, len );
    }

static int docRtfSubjectText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	)
    {
    return docRtfInfoText( rrc, &(rrc->rrcBd->bdProperties.dpSubject),
								text, len );
    }

static int docRtfKeywordsText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	)
    {
    return docRtfInfoText( rrc, &(rrc->rrcBd->bdProperties.dpKeywords),
								text, len );
    }

static int docRtfCommentText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	)
    {
    return docRtfInfoText( rrc, &(rrc->rrcBd->bdProperties.dpComment),
								text, len );
    }

static int docRtfHlinkbaseText(	RtfReadingContext *	rrc,
				const unsigned char *	text,
				int			len	)
    {
    return docRtfInfoText( rrc, &(rrc->rrcBd->bdProperties.dpHlinkbase),
								text, len );
    }

static int docRtfTitleGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfTitleText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfAuthorGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfAuthorText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfSubjectGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfSubjectText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfKeywordsGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfKeywordsText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfCommentGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfCommentText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfHlinkbaseGroup( SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfHlinkbaseText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfCreatimGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    appInvalidateTime( &(rrc->rrcTm) );

    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfRefuseText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    rrc->rrcBd->bdProperties.dpCreatim= rrc->rrcTm;

    return 0;
    }

static int docRtfRevtimGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    appInvalidateTime( &(rrc->rrcTm) );

    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfRefuseText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    rrc->rrcBd->bdProperties.dpRevtim= rrc->rrcTm;

    return 0;
    }

static int docRtfPrintimGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    appInvalidateTime( &(rrc->rrcTm) );

    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfRefuseText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    rrc->rrcBd->bdProperties.dpPrintim= rrc->rrcTm;

    return 0;
    }

static RtfControlWord	docRtfInfoGroups[]=
    {
	{ "title",	RTFidTITLE,	DOClevDOC, docRtfTitleGroup, },
	{ "author",	RTFidAUTHOR,	DOClevDOC, docRtfAuthorGroup, },
	{ "subject",	RTFidSUBJECT,	DOClevDOC, docRtfSubjectGroup, },
	{ "keywords",	RTFidKEYWORDS,	DOClevDOC, docRtfKeywordsGroup, },
	{ "comment",	RTFidCOMMENT,	DOClevDOC, docRtfCommentGroup, },
	{ "hlinkbase",	RTFidHLINKBASE,	DOClevDOC, docRtfHlinkbaseGroup, },

	{ "creatim",	RTFidCREATIM,	DOClevDOC, docRtfCreatimGroup, },
	{ "revtim",	RTFidREVTIM,	DOClevDOC, docRtfRevtimGroup, },
	{ "printim",	RTFidPRINTIM,	DOClevDOC, docRtfPrintimGroup, },

	{ "operator",	RTFidOPERATOR,	DOClevDOC, docRtfSkipGroup, },
	{ "version",	RTFidVERSION,	DOClevDOC, docRtfSkipGroup, },
	{ "edmins",	RTFidEDMINS,	DOClevDOC, docRtfSkipGroup, },
	{ "nofpages",	RTFidNOFPAGES,	DOClevDOC, docRtfSkipGroup, },
	{ "nofwords",	RTFidNOFWORDS,	DOClevDOC, docRtfSkipGroup, },
	{ "nofchars",	RTFidNOFCHARS,	DOClevDOC, docRtfSkipGroup, },
	{ "nofcharsws",	RTFidNOFCHARSWS,DOClevDOC, docRtfSkipGroup, },
	{ "vern",	RTFidVERN,	DOClevDOC, docRtfSkipGroup, },

	{ 0, 0, 0 }
    };

int docRtfReadInfo(		SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    int		res;

    res= docRtfReadGroup( sis, DOClevPARA,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfEmptyTable, docRtfInfoGroups,
				docRtfIgnoreText );
    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    return res;
    }

/************************************************************************/
/*									*/
/*  Consume the 'listtable' of a document				*/
/*									*/
/************************************************************************/

static int docRtfListNameText(	RtfReadingContext *	rrc,
				const unsigned char *	name,
				int			len )
    {
    char *		fresh;

    fresh= (char *)realloc( rrc->rrcDocumentList.dlListName, len+ 1 );
    if  ( ! fresh )
	{ XDEB(fresh); return -1;	}
    rrc->rrcDocumentList.dlListName= fresh;
    strncpy( rrc->rrcDocumentList.dlListName,
				    (const char *)name, len )[len]= '\0';

    if  ( len > 0 && rrc->rrcDocumentList.dlListName[len-1] == ';' )
	{ rrc->rrcDocumentList.dlListName[len-1]= '\0';	}

    return 0;
    }

static int docRtfListName(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfEmptyTable, docRtfEmptyTable,
				docRtfListNameText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfListProperty(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    switch( rcw->rcwId )
	{
	case RTFidLISTID:
	    rrc->rrcDocumentList.dlListId= arg;
	    break;
	case RTFidLISTTEMPLATEID:
	    rrc->rrcDocumentList.dlListTemplateId= arg;
	    break;
	case RTFidLISTSIMPLE:
	    rrc->rrcDocumentList.dlListIsSimple= arg != 0;
	    break;
	case RTFidLISTRESTARTHDN:
	    rrc->rrcDocumentList.dlRestartForEverySection= arg != 0;
	    break;
	default:
	    break;
	}

    return 0;
    }

static RtfControlWord	docRtfListGroups[]=
    {
	{ "listname",	RTFidLISTNAME,	DOClevDOC, docRtfListName, },

	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfListWords[]=
    {
	{ "listid",	RTFidLISTID,	DOClevDOC,	docRtfListProperty, },
	{ "listsimple",	RTFidLISTSIMPLE, DOClevDOC,	docRtfListProperty, },
	{ "listrestarthdn",
			RTFidLISTRESTARTHDN,
					DOClevDOC,	docRtfListProperty, },
	{ "listtemplateid",
			RTFidLISTTEMPLATEID,
					DOClevDOC,	docRtfListProperty, },

	{ 0, 0, 0 }
    };

static int docRtfList(		SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfListWords, docRtfListGroups,
				docRtfIgnoreText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static RtfControlWord	docRtfListtableGroups[]=
    {
	{ "list",	RTFidLIST,	DOClevDOC, docRtfList, },

	{ 0, 0, 0 }
    };

int docRtfListtable(		SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfEmptyTable, docRtfListtableGroups,
				docRtfIgnoreText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }
