/************************************************************************/
/*									*/
/*  List the fonts in a document.					*/
/*  Manage resources for layout.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	<appImage.h>
#   include	"docPs.h"
#   include	<sioHex.h>
#   include	<sioMemory.h>
#   include	<appWinMeta.h>
#   include	<appMacPict.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Translate text attributes to AfmFontInfo.				*/
/*									*/
/************************************************************************/

AfmFontInfo * docPsPrintGetAfi(	const AppPhysicalFontList *	apfl,
				int				physf )
    {
    AppFontFamily *			aff;
    int					affCount;
    AppFontTypeface *			aft;

    AppPhysicalFont *			apf;

    if  ( psFontCatalog( apfl->apflAfmDirectory, &aff, &affCount ) )
	{ SDEB(apfl->apflAfmDirectory); return (AfmFontInfo *)0;	}

    if  ( physf < 0 || physf >= apfl->apflCount )
	{ LLDEB(physf,apfl->apflCount); return (AfmFontInfo *)0;	}

    apf= apfl->apflFonts+ physf;

    if  ( apf->apfPsFamilyNumber < 0		||
	  apf->apfPsFamilyNumber >= affCount	)
	{ LLDEB(apf->apfPsFamilyNumber,affCount); return (AfmFontInfo *)0; }

    aff += apf->apfPsFamilyNumber;
    aft= aff->affFaces;

    if  ( apf->apfPsFaceNumber < 0			||
	  apf->apfPsFaceNumber >=  aff->affFaceCount	)
	{
	LLDEB(apf->apfPsFaceNumber,aff->affFaceCount);
	return (AfmFontInfo *)0;
	}

    aft += apf->apfPsFaceNumber;

    if  ( ! aft->aftPrintingData )
	{ XDEB(aft->aftPrintingData);	}

    return (AfmFontInfo *)aft->aftPrintingData;
    }

int docPsClaimParticuleData(	const BufferItem *	bi,
				ParticuleData **	pParticuleData )
    {
    static ParticuleData *	PSPrintGeometry;
    static int			PSPrintGeometryCount;

    if  ( bi->biParaParticuleCount > PSPrintGeometryCount )
	{
	ParticuleData *	fresh;
	unsigned int	size;

	size= ( bi->biParaParticuleCount+ 1 )* sizeof( ParticuleData );

	fresh= (ParticuleData *)realloc( PSPrintGeometry,
			bi->biParaParticuleCount* sizeof( ParticuleData ) );
	if  ( ! fresh )
	    { LXDEB(bi->biParaParticuleCount,fresh); return -1;	}

	PSPrintGeometry= fresh;
	}

    *pParticuleData= PSPrintGeometry; return 0;
    }


/************************************************************************/
/*									*/
/*  Find the fonts of an image.						*/
/*									*/
/************************************************************************/

typedef int (*LIST_FONTS_PS)(	SimpleInputStream *	sis,
				const char *		afmDirectory,
				const char *		prefix,
				PostScriptFont **	pFontList,
				int *			pCount,
				int			xExt,
				int			yExt,
				int			twipsWide,
				int			twipsHigh );

int docPsListObjectFonts(	const InsertedObject *	io,
				const char *		afmDirectory,
				const char *		prefix,
				PostScriptFont **	pFontList,
				int *			pCount )
    {
    LIST_FONTS_PS	listFontsPs;

    SimpleInputStream *	sisMem;
    SimpleInputStream *	sisMeta;

    const MemoryBuffer *	mb;

    switch( io->ioKind )
	{
	case DOCokPICTWMETAFILE:
	    mb= &(io->ioObjectData);
	    listFontsPs= appMetaListFontsPs;
	    break;

	case DOCokMACPICT:
	    mb= &(io->ioObjectData);
	    listFontsPs= appMacPictListFontsPs;
	    break;

	case DOCokPICTJPEGBLIP:
	case DOCokPICTPNGBLIP:
	    return 0;

	case DOCokOLEOBJECT:
	    if  ( io->ioResultKind == DOCokPICTWMETAFILE )
		{
		mb= &(io->ioResultData);
		listFontsPs= appMetaListFontsPs;
		break;
		}
	    else{ LDEB(io->ioResultKind); return 0;	}

	case DOCokINCLUDEPICTURE:
	    return 0;

	default:
	    LDEB(io->ioKind); return 0;
	}

    sisMem= sioInMemoryOpen( mb );
    if  ( ! sisMem )
	{ XDEB(sisMem); return -1;	}

    sisMeta= sioInHexOpen( sisMem );
    if  ( ! sisMeta )
	{ XDEB(sisMem); return -1;	}

    if  ( (*listFontsPs)( sisMeta, afmDirectory, prefix,
					pFontList, pCount,
					io->ioXExtent, io->ioYExtent,
					io->ioTwipsWide, io->ioTwipsHigh ) )
	{ SDEB(afmDirectory); return -1;	}

    sioInClose( sisMeta );
    sioInClose( sisMem );

    return 0;
    }


/************************************************************************/
/*									*/
/*  Recursively retrieve the list of PostScriptFonts that is used in	*/
/*  a document.								*/
/*									*/
/************************************************************************/

static int docPsPrintGetHeaderFooterFonts( const HeaderFooter *	hf,
				DocumentFontList *		dfl,
				const AppPhysicalFontList *	apfl,
				PostScriptFont **		pFontList,
				int *				pCount )
    {
    if  ( ! hf->hfItem )
	{ return 0;	}

    return docPsPrintGetItemFonts( hf->hfItem, dfl, apfl, pFontList, pCount );
    }

int docPsPrintGetItemFonts(	const BufferItem *		bi,
				DocumentFontList *		dfl,
				const AppPhysicalFontList *	apfl,
				PostScriptFont **		pFontList,
				int *				pCount )
    {
    int			part= 0;
    TextParticule *	tp;
    int			privateFont;
    AfmFontInfo *	afi;

    InsertedObject *	io;

    int			i;

    switch( bi->biLevel )
	{
	case DOClevDOC:
	case DOClevROW:
	case DOClevCELL:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docPsPrintGetItemFonts( bi->biChildren[i],
					    dfl, apfl, pFontList, pCount ) )
		    { LDEB(1); return -1;	}
		}
	    break;

	case DOClevSECT:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docPsPrintGetItemFonts( bi->biChildren[i],
					dfl, apfl, pFontList, pCount ) )
		    { LDEB(1); return -1;	}
		}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectHeader),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectFirstPageHeader),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectLeftPageHeader),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectRightPageHeader),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectFooter),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectFirstPageFooter),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectLeftPageFooter),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    if  ( docPsPrintGetHeaderFooterFonts( &(bi->biSectRightPageFooter),
					dfl, apfl, pFontList, pCount )	)
		{ LDEB(1); return -1;	}

	    break;

	case DOClevPARA:
	    tp= bi->biParaParticules; part= 0;

	    while( part < bi->biParaParticuleCount )
		{
		const int	appearsInText= 1;

		switch( tp->tpKind )
		    {
		    case DOCkindTEXT:
		    case DOCkindTAB:
			privateFont= tp->tpPhysicalFont;
			if  ( tp->tpPhysicalFont >= 0 )
			    {
			    afi= docPsPrintGetAfi( apfl, tp->tpPhysicalFont );
			    if  ( ! afi )
				{ XDEB(afi); return -1;	}

			    if  ( appPsRememberAfi( afi, tp->tpTextAttribute,
				    "f", appearsInText, pFontList, pCount ) )
				{ LDEB(1); return -1;	}
			    }

			while( part+ 1 < bi->biParaParticuleCount )
			    {
			    if  ( tp[1].tpKind != DOCkindTEXT	&&
				  tp[1].tpKind != DOCkindTAB	)
				{ break;	}
			    if  ( tp[1].tpPhysicalFont != privateFont	)
				{ break;	}

			    part++; tp++;
			    }
			part++; tp++; break;
		    case DOCkindOBJECT:
			io= bi->biParaObjects+ tp->tpObjectNumber;

			if  ( docPsListObjectFonts( io,
						apfl->apflAfmDirectory,
						"f", pFontList, pCount ) )
			    { LDEB(tp->tpKind); return -1;	}

			part++; tp++; break;
		    case DOCkindFIELDSTART:
		    case DOCkindFIELDEND:
		    case DOCkindXE:
		    case DOCkindTC:
		    case DOCkindLINEBREAK:
		    case DOCkindPAGEBREAK:
			part++; tp++; break;
		    default:
			LDEB(tp->tpKind); return -1;
		    }
		}
	    break;
	default:
	    LDEB(bi->biLevel); return -1;
	}

    return 0;
    }

